/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.PfamToGoMapping;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogenyinference.BasicCharacterStateMatrix;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.phylogenyinference.NeighborJoining;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.BasicDomain;
import org.forester.surfacing.BasicProtein;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainLengths;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.PrintableDomainSimilarity;
import org.forester.surfacing.Protein;
import org.forester.surfacing.Species;
import org.forester.surfacing.SurfacingConstants;
import org.forester.util.AsciiHistogram;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class SurfacingUtil {
    private static final NumberFormat FORMATTER = new DecimalFormat("0.0E0");
    private static final NumberFormat FORMATTER_3 = new DecimalFormat("0.000");
    private static final Comparator<Domain> ASCENDING_CONFIDENCE_VALUE_ORDER = new Comparator<Domain>(){

        @Override
        public int compare(Domain d1, Domain d2) {
            if (d1.getPerSequenceEvalue() < d2.getPerSequenceEvalue()) {
                return -1;
            }
            if (d1.getPerSequenceEvalue() > d2.getPerSequenceEvalue()) {
                return 1;
            }
            return d1.compareTo(d2);
        }
    };
    public static final Pattern PATTERN_SP_STYLE_TAXONOMY = Pattern.compile("^[A-Z0-9]{3,5}$");

    private SurfacingUtil() {
    }

    public static void addAllBinaryDomainCombinationToSet(GenomeWideCombinableDomains genome, SortedSet<BinaryDomainCombination> binary_domain_combinations) {
        SortedMap<DomainId, CombinableDomains> all_cd = genome.getAllCombinableDomainsIds();
        for (DomainId domain_id : all_cd.keySet()) {
            binary_domain_combinations.addAll(((CombinableDomains)all_cd.get(domain_id)).toBinaryDomainCombinations());
        }
    }

    public static void addAllDomainIdsToSet(GenomeWideCombinableDomains genome, SortedSet<DomainId> domain_ids) {
        SortedSet<DomainId> domains = genome.getAllDomainIds();
        for (DomainId domain : domains) {
            domain_ids.add(domain);
        }
    }

    public static void addHtmlHead(Writer w, String title) throws IOException {
        w.write(SurfacingConstants.NL);
        w.write("<head>");
        w.write("<title>");
        w.write(title);
        w.write("</title>");
        w.write(SurfacingConstants.NL);
        w.write("<style>");
        w.write(SurfacingConstants.NL);
        w.write("a:visited { color : #6633FF; text-decoration : none; }");
        w.write(SurfacingConstants.NL);
        w.write("a:link { color : #6633FF; text-decoration : none; }");
        w.write(SurfacingConstants.NL);
        w.write("a:active { color : #99FF00; text-decoration : none; }");
        w.write(SurfacingConstants.NL);
        w.write("a:hover { color : #FFFFFF; background-color : #99FF00; text-decoration : none; }");
        w.write(SurfacingConstants.NL);
        w.write("td { text-align: left; vertical-align: top; font-family: Verdana, Arial, Helvetica; font-size: 8pt}");
        w.write(SurfacingConstants.NL);
        w.write("h1 { color : #0000FF; font-family: Verdana, Arial, Helvetica; font-size: 18pt; font-weight: bold }");
        w.write(SurfacingConstants.NL);
        w.write("h2 { color : #0000FF; font-family: Verdana, Arial, Helvetica; font-size: 16pt; font-weight: bold }");
        w.write(SurfacingConstants.NL);
        w.write("</style>");
        w.write(SurfacingConstants.NL);
        w.write("</head>");
        w.write(SurfacingConstants.NL);
    }

    public static DescriptiveStatistics calculateDescriptiveStatisticsForMeanValues(Set<DomainSimilarity> similarities) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (DomainSimilarity similarity : similarities) {
            stats.addValue(similarity.getMeanSimilarityScore());
        }
        return stats;
    }

    public static int calculateOverlap(Domain domain, List<Boolean> covered_positions) {
        int overlap_count = 0;
        int i = domain.getFrom();
        while (i <= domain.getTo()) {
            if (i < covered_positions.size() && covered_positions.get(i).booleanValue()) {
                ++overlap_count;
            }
            ++i;
        }
        return overlap_count;
    }

    public static void checkForOutputFileWriteability(File outfile) {
        String error = ForesterUtil.isWritableFile(outfile);
        if (!ForesterUtil.isEmpty(error)) {
            ForesterUtil.fatalError("surfacing", error);
        }
    }

    private static SortedSet<String> collectAllDomainsChangedOnSubtree(PhylogenyNode subtree_root, boolean get_gains) {
        TreeSet<String> domains = new TreeSet<String>();
        for (PhylogenyNode descendant : PhylogenyMethods.getAllDescendants(subtree_root)) {
            BinaryCharacters chars = descendant.getNodeData().getBinaryCharacters();
            if (get_gains) {
                domains.addAll(chars.getGainedCharacters());
                continue;
            }
            domains.addAll(chars.getLostCharacters());
        }
        return domains;
    }

    public static void collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> matrix, BinaryDomainCombination.DomainCombinationType dc_type, List<BinaryDomainCombination> all_binary_domains_combination_gained, boolean get_gains) {
        TreeSet<String> sorted_ids = new TreeSet<String>();
        int i = 0;
        while (i < matrix.getNumberOfIdentifiers()) {
            sorted_ids.add(matrix.getIdentifier(i));
            ++i;
        }
        for (String id : sorted_ids) {
            int c = 0;
            while (c < matrix.getNumberOfCharacters()) {
                if (get_gains && matrix.getState(id, c) == CharacterStateMatrix.GainLossStates.GAIN || !get_gains && matrix.getState(id, c) == CharacterStateMatrix.GainLossStates.LOSS) {
                    if (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) {
                        all_binary_domains_combination_gained.add(AdjactantDirectedBinaryDomainCombination.createInstance(matrix.getCharacter(c)));
                    } else if (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED) {
                        all_binary_domains_combination_gained.add(DirectedBinaryDomainCombination.createInstance(matrix.getCharacter(c)));
                    } else {
                        all_binary_domains_combination_gained.add(BasicBinaryDomainCombination.createInstance(matrix.getCharacter(c)));
                    }
                }
                ++c;
            }
        }
    }

    private static File createBaseDirForPerNodeDomainFiles(String base_dir, boolean domain_combinations, CharacterStateMatrix.GainLossStates state, String outfile) {
        File per_node_go_mapped_domain_gain_loss_files_base_dir = new File(String.valueOf(new File(outfile).getParent()) + ForesterUtil.FILE_SEPARATOR + base_dir);
        if (!per_node_go_mapped_domain_gain_loss_files_base_dir.exists()) {
            per_node_go_mapped_domain_gain_loss_files_base_dir.mkdir();
        }
        if (!(per_node_go_mapped_domain_gain_loss_files_base_dir = domain_combinations ? new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "DC") : new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "DOMAINS")).exists()) {
            per_node_go_mapped_domain_gain_loss_files_base_dir.mkdir();
        }
        if (!(per_node_go_mapped_domain_gain_loss_files_base_dir = state == CharacterStateMatrix.GainLossStates.GAIN ? new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "GAINS") : (state == CharacterStateMatrix.GainLossStates.LOSS ? new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "LOSSES") : new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + "PRESENT"))).exists()) {
            per_node_go_mapped_domain_gain_loss_files_base_dir.mkdir();
        }
        return per_node_go_mapped_domain_gain_loss_files_base_dir;
    }

    public static Map<DomainId, List<GoId>> createDomainIdToGoIdMap(List<PfamToGoMapping> pfam_to_go_mappings) {
        HashMap<DomainId, List<GoId>> domain_id_to_go_ids_map = new HashMap<DomainId, List<GoId>>(pfam_to_go_mappings.size());
        for (PfamToGoMapping pfam_to_go : pfam_to_go_mappings) {
            if (!domain_id_to_go_ids_map.containsKey(pfam_to_go.getKey())) {
                domain_id_to_go_ids_map.put(pfam_to_go.getKey(), new ArrayList());
            }
            ((List)domain_id_to_go_ids_map.get(pfam_to_go.getKey())).add(pfam_to_go.getValue());
        }
        return domain_id_to_go_ids_map;
    }

    public static Map<DomainId, Set<String>> createDomainIdToSecondaryFeaturesMap(File secondary_features_map_file) throws IOException {
        BasicTable<String> primary_table = BasicTableParser.parse(secondary_features_map_file, "\t");
        TreeMap<DomainId, Set<String>> map = new TreeMap<DomainId, Set<String>>();
        int r = 0;
        while (r < primary_table.getNumberOfRows()) {
            DomainId domain_id = new DomainId(primary_table.getValue(0, r));
            if (!map.containsKey(domain_id)) {
                map.put(domain_id, new HashSet());
            }
            ((Set)map.get(domain_id)).add(primary_table.getValue(1, r));
            ++r;
        }
        return map;
    }

    public static Phylogeny createNjTreeBasedOnMatrixToFile(File nj_tree_outfile, DistanceMatrix distance) {
        SurfacingUtil.checkForOutputFileWriteability(nj_tree_outfile);
        NeighborJoining nj2 = NeighborJoining.createInstance();
        Phylogeny phylogeny = nj2.execute(distance);
        phylogeny.setName(nj_tree_outfile.getName());
        SurfacingUtil.writePhylogenyToFile(phylogeny, nj_tree_outfile.toString());
        return phylogeny;
    }

    private static SortedSet<BinaryDomainCombination> createSetOfAllBinaryDomainCombinationsPerGenome(GenomeWideCombinableDomains gwcd) {
        SortedMap<DomainId, CombinableDomains> cds = gwcd.getAllCombinableDomainsIds();
        TreeSet<BinaryDomainCombination> binary_combinations = new TreeSet<BinaryDomainCombination>();
        for (DomainId domain_id : cds.keySet()) {
            CombinableDomains cd = (CombinableDomains)cds.get(domain_id);
            binary_combinations.addAll(cd.toBinaryDomainCombinations());
        }
        return binary_combinations;
    }

    public static void decoratePrintableDomainSimilarities(SortedSet<DomainSimilarity> domain_similarities, DomainSimilarityCalculator.Detailedness detailedness, DomainSimilarityCalculator.GoAnnotationOutput go_annotation_output, Map<GoId, GoTerm> go_id_to_term_map, GoNameSpace go_namespace_limit) {
        if (go_namespace_limit != null && (go_id_to_term_map == null || go_id_to_term_map.isEmpty())) {
            throw new IllegalArgumentException("attempt to use a GO namespace limit without a GO id to term map");
        }
        for (DomainSimilarity domain_similarity : domain_similarities) {
            if (!(domain_similarity instanceof PrintableDomainSimilarity)) continue;
            PrintableDomainSimilarity printable_domain_similarity = (PrintableDomainSimilarity)domain_similarity;
            printable_domain_similarity.setDetailedness(detailedness);
            printable_domain_similarity.setGoAnnotationOutput(go_annotation_output);
            printable_domain_similarity.setGoIdToTermMap(go_id_to_term_map);
            printable_domain_similarity.setGoNamespaceLimit(go_namespace_limit);
        }
    }

    public static void executeDomainLengthAnalysis(String[][] input_file_properties, int number_of_genomes, DomainLengthsTable domain_lengths_table, File outfile) throws IOException {
        DecimalFormat df = new DecimalFormat("#.00");
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
        out.write("MEAN BASED STATISTICS PER SPECIES");
        out.write(ForesterUtil.LINE_SEPARATOR);
        out.write(domain_lengths_table.createMeanBasedStatisticsPerSpeciesTable().toString());
        out.write(ForesterUtil.LINE_SEPARATOR);
        out.write(ForesterUtil.LINE_SEPARATOR);
        List<DomainLengths> domain_lengths_list = domain_lengths_table.getDomainLengthsList();
        out.write("OUTLIER SPECIES PER DOMAIN (Z>=1.5)");
        out.write(ForesterUtil.LINE_SEPARATOR);
        for (DomainLengths domain_lengths : domain_lengths_list) {
            List<Species> species_list = domain_lengths.getMeanBasedOutlierSpecies(1.5);
            if (species_list.size() <= 0) continue;
            out.write(domain_lengths.getDomainId() + "\t");
            for (Species species : species_list) {
                out.write(species + "\t");
            }
            out.write(ForesterUtil.LINE_SEPARATOR);
        }
        out.write(ForesterUtil.LINE_SEPARATOR);
        out.write(ForesterUtil.LINE_SEPARATOR);
        out.write("OUTLIER SPECIES (Z 1.0)");
        out.write(ForesterUtil.LINE_SEPARATOR);
        DescriptiveStatistics stats_for_all_species = domain_lengths_table.calculateMeanBasedStatisticsForAllSpecies();
        out.write(stats_for_all_species.asSummary());
        out.write(ForesterUtil.LINE_SEPARATOR);
        AsciiHistogram histo = new AsciiHistogram(stats_for_all_species);
        out.write(histo.toStringBuffer(40, '=', 60, 4).toString());
        out.write(ForesterUtil.LINE_SEPARATOR);
        double population_sd = stats_for_all_species.sampleStandardDeviation();
        double population_mean = stats_for_all_species.arithmeticMean();
        for (Species species : domain_lengths_table.getSpecies()) {
            double x = domain_lengths_table.calculateMeanBasedStatisticsForSpecies(species).arithmeticMean();
            double z = (x - population_mean) / population_sd;
            out.write(species + "\t" + z);
            out.write(ForesterUtil.LINE_SEPARATOR);
        }
        out.write(ForesterUtil.LINE_SEPARATOR);
        for (Species species : domain_lengths_table.getSpecies()) {
            DescriptiveStatistics stats_for_species = domain_lengths_table.calculateMeanBasedStatisticsForSpecies(species);
            double x = stats_for_species.arithmeticMean();
            double z = (x - population_mean) / population_sd;
            if (!(z <= -1.0) && !(z >= 1.0)) continue;
            out.write(species + "\t" + df.format(z) + "\t" + stats_for_species.asSummary());
            out.write(ForesterUtil.LINE_SEPARATOR);
        }
        out.close();
        System.gc();
    }

    public static void executeParsimonyAnalysis(long random_number_seed_for_fitch_parsimony, boolean radomize_fitch_parsimony, String outfile_name, DomainParsimonyCalculator domain_parsimony, Phylogeny phylogeny, Map<DomainId, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, GoNameSpace go_namespace_limit, String parameters_str, Map<DomainId, Set<String>>[] domain_id_to_secondary_features_maps, SortedSet<DomainId> positive_filter, boolean output_binary_domain_combinations_for_graphs, List<BinaryDomainCombination> all_binary_domains_combination_gained_fitch, List<BinaryDomainCombination> all_binary_domains_combination_lost_fitch, BinaryDomainCombination.DomainCombinationType dc_type) {
        String sep = String.valueOf(ForesterUtil.LINE_SEPARATOR) + "###################" + ForesterUtil.LINE_SEPARATOR;
        String date_time = ForesterUtil.getCurrentDateTime();
        TreeSet<String> all_pfams_encountered = new TreeSet<String>();
        TreeSet<String> all_pfams_gained_as_domains = new TreeSet<String>();
        TreeSet<String> all_pfams_lost_as_domains = new TreeSet<String>();
        TreeSet<String> all_pfams_gained_as_dom_combinations = new TreeSet<String>();
        TreeSet<String> all_pfams_lost_as_dom_combinations = new TreeSet<String>();
        SurfacingUtil.writeToNexus(outfile_name, domain_parsimony, phylogeny);
        Phylogeny local_phylogeny_l = phylogeny.copy();
        if (positive_filter != null && positive_filter.size() > 0) {
            domain_parsimony.executeDolloParsimonyOnDomainPresence(positive_filter);
        } else {
            domain_parsimony.executeDolloParsimonyOnDomainPresence();
        }
        SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossMatrix(), String.valueOf(outfile_name) + "_dollo_gl_d", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossCountsMatrix(), String.valueOf(outfile_name) + "_dollo_glc_d", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, String.valueOf(outfile_name) + "_dollo_gains_d", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, String.valueOf(outfile_name) + "_dollo_losses_d", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), null, String.valueOf(outfile_name) + "_dollo_present_d", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, false, domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, String.valueOf(outfile_name) + "_dollo_gains_d.html", sep, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Gains | Domains", "+", domain_id_to_secondary_features_maps, all_pfams_encountered, all_pfams_gained_as_domains, "_dollo_gains_d");
        SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, false, domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, String.valueOf(outfile_name) + "_dollo_losses_d.html", sep, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Losses | Domains", "-", domain_id_to_secondary_features_maps, all_pfams_encountered, all_pfams_lost_as_domains, "_dollo_losses_d");
        SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, false, domain_parsimony.getGainLossMatrix(), null, String.valueOf(outfile_name) + "_dollo_present_d.html", sep, ForesterUtil.LINE_SEPARATOR, "Dollo Parsimony | Present | Domains", "", domain_id_to_secondary_features_maps, all_pfams_encountered, null, "_dollo_present_d");
        SurfacingUtil.preparePhylogeny(local_phylogeny_l, domain_parsimony, date_time, "Dollo parsimony on domain presence/absence", "dollo_on_domains_" + outfile_name, parameters_str);
        SurfacingUtil.writePhylogenyToFile(local_phylogeny_l, String.valueOf(outfile_name) + "_d_dollo.xml");
        try {
            SurfacingUtil.writeAllDomainsChangedOnAllSubtrees(local_phylogeny_l, true, outfile_name, "_dollo_all_gains_d");
            SurfacingUtil.writeAllDomainsChangedOnAllSubtrees(local_phylogeny_l, false, outfile_name, "_dollo_all_losses_d");
        }
        catch (IOException e) {
            e.printStackTrace();
            ForesterUtil.fatalError("surfacing", e.getLocalizedMessage());
        }
        if (domain_parsimony.calculateNumberOfBinaryDomainCombination() > 0) {
            local_phylogeny_l = phylogeny.copy();
            String randomization = "no";
            if (radomize_fitch_parsimony) {
                domain_parsimony.executeFitchParsimonyOnBinaryDomainCombintion(random_number_seed_for_fitch_parsimony);
                randomization = "yes, seed = " + random_number_seed_for_fitch_parsimony;
            } else {
                domain_parsimony.executeFitchParsimonyOnBinaryDomainCombintion(false);
            }
            SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossMatrix(), String.valueOf(outfile_name) + "_fitch_gl_dc", CharacterStateMatrix.Format.FORESTER);
            SurfacingUtil.writeMatrixToFile(domain_parsimony.getGainLossCountsMatrix(), String.valueOf(outfile_name) + "_fitch_glc_dc", CharacterStateMatrix.Format.FORESTER);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, String.valueOf(outfile_name) + "_fitch_gains_dc", sep, ForesterUtil.LINE_SEPARATOR, null);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, String.valueOf(outfile_name) + "_fitch_losses_dc", sep, ForesterUtil.LINE_SEPARATOR, null);
            SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), null, String.valueOf(outfile_name) + "_fitch_present_dc", sep, ForesterUtil.LINE_SEPARATOR, null);
            if (all_binary_domains_combination_gained_fitch != null) {
                SurfacingUtil.collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), dc_type, all_binary_domains_combination_gained_fitch, true);
            }
            if (all_binary_domains_combination_lost_fitch != null) {
                SurfacingUtil.collectChangedDomainCombinationsFromBinaryStatesMatrixAsListToFile(domain_parsimony.getGainLossMatrix(), dc_type, all_binary_domains_combination_lost_fitch, false);
            }
            if (output_binary_domain_combinations_for_graphs) {
                SurfacingUtil.writeBinaryStatesMatrixAsListToFileForBinaryCombinationsForGraphAnalysis(domain_parsimony.getGainLossMatrix(), null, String.valueOf(outfile_name) + "_fitch_present_dc.dot", sep, ForesterUtil.LINE_SEPARATOR, BinaryDomainCombination.OutputFormat.DOT);
            }
            SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, true, domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, String.valueOf(outfile_name) + "_fitch_gains_dc.html", sep, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Gains | Domain Combinations", "+", null, all_pfams_encountered, all_pfams_gained_as_dom_combinations, "_fitch_gains_dc");
            SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, true, domain_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, String.valueOf(outfile_name) + "_fitch_losses_dc.html", sep, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Losses | Domain Combinations", "-", null, all_pfams_encountered, all_pfams_lost_as_dom_combinations, "_fitch_losses_dc");
            SurfacingUtil.writeBinaryStatesMatrixToList(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, true, domain_parsimony.getGainLossMatrix(), null, String.valueOf(outfile_name) + "_fitch_present_dc.html", sep, ForesterUtil.LINE_SEPARATOR, "Fitch Parsimony | Present | Domain Combinations", "", null, all_pfams_encountered, null, "_fitch_present_dc");
            SurfacingUtil.writeAllEncounteredPfamsToFile(domain_id_to_go_ids_map, go_id_to_term_map, outfile_name, all_pfams_encountered);
            SurfacingUtil.writePfamsToFile(String.valueOf(outfile_name) + "_all_pfams_gained_as_domains", all_pfams_gained_as_domains);
            SurfacingUtil.writePfamsToFile(String.valueOf(outfile_name) + "_all_pfams_lost_as_domains", all_pfams_lost_as_domains);
            SurfacingUtil.writePfamsToFile(String.valueOf(outfile_name) + "_all_pfams_gained_as_dc", all_pfams_gained_as_dom_combinations);
            SurfacingUtil.writePfamsToFile(String.valueOf(outfile_name) + "_all_pfams_lost_as_dc", all_pfams_lost_as_dom_combinations);
            SurfacingUtil.preparePhylogeny(local_phylogeny_l, domain_parsimony, date_time, "Fitch parsimony on binary domain combination presence/absence randomization: " + randomization, "fitch_on_binary_domain_combinations_" + outfile_name, parameters_str);
            SurfacingUtil.writePhylogenyToFile(local_phylogeny_l, String.valueOf(outfile_name) + "_dc_fitch.xml");
        }
    }

    public static void executeParsimonyAnalysisForSecondaryFeatures(String outfile_name, DomainParsimonyCalculator secondary_features_parsimony, Phylogeny phylogeny, String parameters_str, Map<Species, MappingResults> mapping_results_map) {
        String sep = String.valueOf(ForesterUtil.LINE_SEPARATOR) + "###################" + ForesterUtil.LINE_SEPARATOR;
        String date_time = ForesterUtil.getCurrentDateTime();
        System.out.println();
        SurfacingUtil.writeToNexus(String.valueOf(outfile_name) + "_secondary_features.nex", secondary_features_parsimony.createMatrixOfSecondaryFeaturePresenceOrAbsence(null), phylogeny);
        Phylogeny local_phylogeny_copy = phylogeny.copy();
        secondary_features_parsimony.executeDolloParsimonyOnSecondaryFeatures(mapping_results_map);
        SurfacingUtil.writeMatrixToFile(secondary_features_parsimony.getGainLossMatrix(), String.valueOf(outfile_name) + "_dollo_gl_secondary_features", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(secondary_features_parsimony.getGainLossCountsMatrix(), String.valueOf(outfile_name) + "_dollo_glc_secondary_features", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(secondary_features_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, String.valueOf(outfile_name) + "_dollo_gains_secondary_features", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(secondary_features_parsimony.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, String.valueOf(outfile_name) + "_dollo_losses_secondary_features", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(secondary_features_parsimony.getGainLossMatrix(), null, String.valueOf(outfile_name) + "_dollo_present_secondary_features", sep, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.preparePhylogeny(local_phylogeny_copy, secondary_features_parsimony, date_time, "Dollo parsimony on secondary feature presence/absence", "dollo_on_secondary_features_" + outfile_name, parameters_str);
        SurfacingUtil.writePhylogenyToFile(local_phylogeny_copy, String.valueOf(outfile_name) + "_secondary_features_dollo.xml");
    }

    public static void extractProteinNames(List<Protein> proteins, List<DomainId> query_domain_ids_nc_order, Writer out, String separator) throws IOException {
        for (Protein protein : proteins) {
            if (!protein.contains(query_domain_ids_nc_order, true)) continue;
            out.write(protein.getSpecies().getSpeciesId());
            out.write(separator);
            out.write(protein.getProteinId().getId());
            out.write(separator);
            out.write("[");
            HashSet<DomainId> visited_domain_ids = new HashSet<DomainId>();
            boolean first = true;
            for (Domain domain : protein.getProteinDomains()) {
                if (visited_domain_ids.contains(domain.getDomainId())) continue;
                visited_domain_ids.add(domain.getDomainId());
                if (first) {
                    first = false;
                } else {
                    out.write(" ");
                }
                out.write(domain.getDomainId().getId());
                out.write(" {");
                out.write("" + domain.getTotalCount());
                out.write("}");
            }
            out.write("]");
            out.write(separator);
            if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                out.write(protein.getDescription());
            }
            out.write(separator);
            if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                out.write(protein.getAccession());
            }
            out.write(SurfacingConstants.NL);
        }
        out.flush();
    }

    public static void extractProteinNames(SortedMap<Species, List<Protein>> protein_lists_per_species, DomainId domain_id, Writer out, String separator) throws IOException {
        for (Species species : protein_lists_per_species.keySet()) {
            for (Protein protein : (List)protein_lists_per_species.get(species)) {
                List<Domain> domains = protein.getProteinDomains(domain_id);
                if (domains.size() <= 0) continue;
                BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
                for (Domain domain : domains) {
                    stats.addValue(domain.getPerSequenceEvalue());
                }
                out.write(protein.getSpecies().getSpeciesId());
                out.write(separator);
                out.write(protein.getProteinId().getId());
                out.write(separator);
                out.write("[" + FORMATTER.format(stats.median()) + "]");
                out.write(separator);
                if (!ForesterUtil.isEmpty(protein.getDescription()) && !protein.getDescription().equals("[none]")) {
                    out.write(protein.getDescription());
                }
                out.write(separator);
                if (!ForesterUtil.isEmpty(protein.getAccession()) && !protein.getAccession().equals("[none]")) {
                    out.write(protein.getAccession());
                }
                out.write(SurfacingConstants.NL);
            }
        }
        out.flush();
    }

    public static SortedSet<DomainId> getAllDomainIds(List<GenomeWideCombinableDomains> gwcd_list) {
        TreeSet<DomainId> all_domains_ids = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains gwcd : gwcd_list) {
            SortedSet<DomainId> all_domains = gwcd.getAllDomainIds();
            all_domains_ids.addAll(all_domains);
        }
        return all_domains_ids;
    }

    public static SortedMap<String, Integer> getDomainCounts(List<Protein> protein_domain_collections) {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (Protein protein_domain_collection : protein_domain_collections) {
            for (Domain name : protein_domain_collection.getProteinDomains()) {
                BasicDomain protein_domain = (BasicDomain)name;
                String id = protein_domain.getDomainId().getId();
                if (map.containsKey(id)) {
                    map.put(id, (Integer)map.get(id) + 1);
                    continue;
                }
                map.put(id, 1);
            }
        }
        return map;
    }

    public static int getNumberOfNodesLackingName(Phylogeny p, StringBuilder names) {
        PhylogenyNodeIterator it = p.iteratorPostorder();
        int c = 0;
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!ForesterUtil.isEmpty(n.getNodeName())) continue;
            if (n.getParent() != null) {
                names.append(" ");
                names.append(n.getParent().getNodeName());
            }
            ++c;
        }
        return c;
    }

    public static boolean isEngulfed(Domain domain, List<Boolean> covered_positions) {
        int i = domain.getFrom();
        while (i <= domain.getTo()) {
            if (i >= covered_positions.size() || !covered_positions.get(i).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void preparePhylogeny(Phylogeny p, DomainParsimonyCalculator domain_parsimony, String date_time, String method, String name, String parameters_str) {
        domain_parsimony.decoratePhylogenyWithDomains(p);
        StringBuilder desc = new StringBuilder();
        desc.append("[Method: " + method + "] [Date: " + date_time + "] ");
        desc.append("[Cost: " + domain_parsimony.getCost() + "] ");
        desc.append("[Gains: " + domain_parsimony.getTotalGains() + "] ");
        desc.append("[Losses: " + domain_parsimony.getTotalLosses() + "] ");
        desc.append("[Unchanged: " + domain_parsimony.getTotalUnchanged() + "] ");
        desc.append("[Parameters: " + parameters_str + "]");
        p.setName(name);
        p.setDescription(desc.toString());
        p.setConfidence(new Confidence(domain_parsimony.getCost(), "parsimony"));
        p.setRerootable(false);
        p.setRooted(true);
    }

    public static Protein removeOverlappingDomains(int max_allowed_overlap, boolean remove_engulfed_domains, Protein protein) {
        BasicProtein pruned_protein = new BasicProtein(protein.getProteinId().getId(), protein.getSpecies().getSpeciesId());
        List<Domain> sorted = SurfacingUtil.sortDomainsWithAscendingConfidenceValues(protein);
        ArrayList<Boolean> covered_positions = new ArrayList<Boolean>();
        for (Domain domain : sorted) {
            int covered_positions_size;
            if (max_allowed_overlap >= 0 && SurfacingUtil.calculateOverlap(domain, covered_positions) > max_allowed_overlap || remove_engulfed_domains && SurfacingUtil.isEngulfed(domain, covered_positions)) continue;
            int i = covered_positions_size = covered_positions.size();
            while (i < domain.getFrom()) {
                covered_positions.add(false);
                ++i;
            }
            int new_covered_positions_size = covered_positions.size();
            int i2 = domain.getFrom();
            while (i2 <= domain.getTo()) {
                if (i2 < new_covered_positions_size) {
                    covered_positions.set(i2, true);
                } else {
                    covered_positions.add(true);
                }
                ++i2;
            }
            pruned_protein.addProteinDomain(domain);
        }
        return pruned_protein;
    }

    static List<Domain> sortDomainsWithAscendingConfidenceValues(Protein protein) {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        for (Domain d : protein.getProteinDomains()) {
            domains.add(d);
        }
        Collections.sort(domains, ASCENDING_CONFIDENCE_VALUE_ORDER);
        return domains;
    }

    public static void writeAllDomainsChangedOnAllSubtrees(Phylogeny p, boolean get_gains, String outdir, String suffix_for_filename) throws IOException {
        CharacterStateMatrix.GainLossStates state = CharacterStateMatrix.GainLossStates.GAIN;
        if (!get_gains) {
            state = CharacterStateMatrix.GainLossStates.LOSS;
        }
        File base_dir = SurfacingUtil.createBaseDirForPerNodeDomainFiles("PER_SUBTREE_EVENTS", false, state, outdir);
        PhylogenyNodeIterator it = p.iteratorPostorder();
        while (it.hasNext()) {
            SortedSet<String> domains;
            PhylogenyNode node = it.next();
            if (node.isExternal() || (domains = SurfacingUtil.collectAllDomainsChangedOnSubtree(node, get_gains)).size() <= 0) continue;
            BufferedWriter writer = ForesterUtil.createBufferedWriter(base_dir + ForesterUtil.FILE_SEPARATOR + node.getNodeName() + suffix_for_filename);
            for (String domain : domains) {
                writer.write(domain);
                writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)writer).close();
        }
    }

    private static void writeAllEncounteredPfamsToFile(Map<DomainId, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, String outfile_name, SortedSet<String> all_pfams_encountered) {
        File all_pfams_encountered_file = new File(String.valueOf(outfile_name) + "_all_encountered_pfams");
        File all_pfams_encountered_with_go_annotation_file = new File(String.valueOf(outfile_name) + "_all_encountered_pfams_with_go_annotation");
        File encountered_pfams_summary_file = new File(String.valueOf(outfile_name) + "_encountered_pfams_summary");
        int biological_process_counter = 0;
        int cellular_component_counter = 0;
        int molecular_function_counter = 0;
        int pfams_with_mappings_counter = 0;
        int pfams_without_mappings_counter = 0;
        int pfams_without_mappings_to_bp_or_mf_counter = 0;
        int pfams_with_mappings_to_bp_or_mf_counter = 0;
        try {
            BufferedWriter all_pfams_encountered_writer = new BufferedWriter(new FileWriter(all_pfams_encountered_file));
            BufferedWriter all_pfams_encountered_with_go_annotation_writer = new BufferedWriter(new FileWriter(all_pfams_encountered_with_go_annotation_file));
            BufferedWriter summary_writer = new BufferedWriter(new FileWriter(encountered_pfams_summary_file));
            summary_writer.write("# Pfam to GO mapping summary");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Actual summary is at the end of this file.");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Encountered Pfams without a GO mapping:");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            for (String pfam : all_pfams_encountered) {
                all_pfams_encountered_writer.write(pfam);
                all_pfams_encountered_writer.write(ForesterUtil.LINE_SEPARATOR);
                DomainId domain_id = new DomainId(pfam);
                if (domain_id_to_go_ids_map.containsKey(domain_id)) {
                    ++pfams_with_mappings_counter;
                    all_pfams_encountered_with_go_annotation_writer.write(pfam);
                    all_pfams_encountered_with_go_annotation_writer.write(ForesterUtil.LINE_SEPARATOR);
                    List<GoId> go_ids = domain_id_to_go_ids_map.get(domain_id);
                    boolean maps_to_bp = false;
                    boolean maps_to_cc = false;
                    boolean maps_to_mf = false;
                    for (GoId go_id : go_ids) {
                        GoTerm go_term = go_id_to_term_map.get(go_id);
                        if (go_term.getGoNameSpace().isBiologicalProcess()) {
                            maps_to_bp = true;
                            continue;
                        }
                        if (go_term.getGoNameSpace().isCellularComponent()) {
                            maps_to_cc = true;
                            continue;
                        }
                        if (!go_term.getGoNameSpace().isMolecularFunction()) continue;
                        maps_to_mf = true;
                    }
                    if (maps_to_bp) {
                        ++biological_process_counter;
                    }
                    if (maps_to_cc) {
                        ++cellular_component_counter;
                    }
                    if (maps_to_mf) {
                        ++molecular_function_counter;
                    }
                    if (maps_to_bp || maps_to_mf) {
                        ++pfams_with_mappings_to_bp_or_mf_counter;
                        continue;
                    }
                    ++pfams_without_mappings_to_bp_or_mf_counter;
                    continue;
                }
                ++pfams_without_mappings_to_bp_or_mf_counter;
                ++pfams_without_mappings_counter;
                summary_writer.write(pfam);
                summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)all_pfams_encountered_writer).close();
            ((Writer)all_pfams_encountered_with_go_annotation_writer).close();
            ForesterUtil.programMessage("surfacing", "Wrote all [" + all_pfams_encountered.size() + "] encountered Pfams to: \"" + all_pfams_encountered_file + "\"");
            ForesterUtil.programMessage("surfacing", "Wrote all [" + pfams_with_mappings_counter + "] encountered Pfams with GO mappings to: \"" + all_pfams_encountered_with_go_annotation_file + "\"");
            ForesterUtil.programMessage("surfacing", "Wrote summary (including all [" + pfams_without_mappings_counter + "] encountered Pfams without GO mappings) to: \"" + encountered_pfams_summary_file + "\"");
            ForesterUtil.programMessage("surfacing", "Sum of Pfams encountered                : " + all_pfams_encountered.size());
            ForesterUtil.programMessage("surfacing", "Pfams without a mapping                 : " + pfams_without_mappings_counter + " [" + 100 * pfams_without_mappings_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams without mapping to proc. or func. : " + pfams_without_mappings_to_bp_or_mf_counter + " [" + 100 * pfams_without_mappings_to_bp_or_mf_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with a mapping                    : " + pfams_with_mappings_counter + " [" + 100 * pfams_with_mappings_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with a mapping to proc. or func.  : " + pfams_with_mappings_to_bp_or_mf_counter + " [" + 100 * pfams_with_mappings_to_bp_or_mf_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to biological process: " + biological_process_counter + " [" + 100 * biological_process_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to molecular function: " + molecular_function_counter + " [" + 100 * molecular_function_counter / all_pfams_encountered.size() + "%]");
            ForesterUtil.programMessage("surfacing", "Pfams with mapping to cellular component: " + cellular_component_counter + " [" + 100 * cellular_component_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Sum of Pfams encountered                : " + all_pfams_encountered.size());
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams without a mapping                 : " + pfams_without_mappings_counter + " [" + 100 * pfams_without_mappings_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams without mapping to proc. or func. : " + pfams_without_mappings_to_bp_or_mf_counter + " [" + 100 * pfams_without_mappings_to_bp_or_mf_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with a mapping                    : " + pfams_with_mappings_counter + " [" + 100 * pfams_with_mappings_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with a mapping to proc. or func.  : " + pfams_with_mappings_to_bp_or_mf_counter + " [" + 100 * pfams_with_mappings_to_bp_or_mf_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with mapping to biological process: " + biological_process_counter + " [" + 100 * biological_process_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with mapping to molecular function: " + molecular_function_counter + " [" + 100 * molecular_function_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            summary_writer.write("# Pfams with mapping to cellular component: " + cellular_component_counter + " [" + 100 * cellular_component_counter / all_pfams_encountered.size() + "%]");
            summary_writer.write(ForesterUtil.LINE_SEPARATOR);
            ((Writer)summary_writer).close();
        }
        catch (IOException e) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + e);
        }
    }

    public static void writeBinaryDomainCombinationsFileForGraphAnalysis(String[][] input_file_properties, File output_dir, GenomeWideCombinableDomains gwcd, int i, GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder dc_sort_order) {
        File dc_outfile_dot = new File(String.valueOf(input_file_properties[i][0]) + "_dc.dot");
        if (output_dir != null) {
            dc_outfile_dot = new File(output_dir + ForesterUtil.FILE_SEPARATOR + dc_outfile_dot);
        }
        SurfacingUtil.checkForOutputFileWriteability(dc_outfile_dot);
        SortedSet<BinaryDomainCombination> binary_combinations = SurfacingUtil.createSetOfAllBinaryDomainCombinationsPerGenome(gwcd);
        try {
            BufferedWriter out_dot = new BufferedWriter(new FileWriter(dc_outfile_dot));
            for (BinaryDomainCombination bdc : binary_combinations) {
                out_dot.write(bdc.toGraphDescribingLanguage(BinaryDomainCombination.OutputFormat.DOT, null, null).toString());
                out_dot.write(SurfacingConstants.NL);
            }
            out_dot.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote binary domain combination for \"" + input_file_properties[i][0] + "\" (" + input_file_properties[i][1] + ", " + input_file_properties[i][2] + ") to: \"" + dc_outfile_dot + "\"");
    }

    public static void writeBinaryStatesMatrixAsListToFile(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> matrix, CharacterStateMatrix.GainLossStates state, String filename, String indentifier_characters_separator, String character_separator, Map<String, String> descriptions) {
        File outfile = new File(filename);
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        TreeSet<String> sorted_ids = new TreeSet<String>();
        int i = 0;
        while (i < matrix.getNumberOfIdentifiers()) {
            sorted_ids.add(matrix.getIdentifier(i));
            ++i;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            for (String id : sorted_ids) {
                out.write(indentifier_characters_separator);
                out.write("#" + id);
                out.write(indentifier_characters_separator);
                int c = 0;
                while (c < matrix.getNumberOfCharacters()) {
                    if (matrix.getState(id, c) == state || state == null && (matrix.getState(id, c) == CharacterStateMatrix.GainLossStates.GAIN || matrix.getState(id, c) == CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT)) {
                        out.write(matrix.getCharacter(c));
                        if (descriptions != null && !descriptions.isEmpty() && descriptions.containsKey(matrix.getCharacter(c))) {
                            out.write("\t");
                            out.write(descriptions.get(matrix.getCharacter(c)));
                        }
                        out.write(character_separator);
                    }
                    ++c;
                }
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters list: \"" + filename + "\"");
    }

    public static void writeBinaryStatesMatrixAsListToFileForBinaryCombinationsForGraphAnalysis(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> matrix, CharacterStateMatrix.GainLossStates state, String filename, String indentifier_characters_separator, String character_separator, BinaryDomainCombination.OutputFormat bc_output_format) {
        File outfile = new File(filename);
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        TreeSet<String> sorted_ids = new TreeSet<String>();
        int i = 0;
        while (i < matrix.getNumberOfIdentifiers()) {
            sorted_ids.add(matrix.getIdentifier(i));
            ++i;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            for (String id : sorted_ids) {
                out.write(indentifier_characters_separator);
                out.write("#" + id);
                out.write(indentifier_characters_separator);
                int c = 0;
                while (c < matrix.getNumberOfCharacters()) {
                    if (matrix.getState(id, c) == state || state == null && (matrix.getState(id, c) == CharacterStateMatrix.GainLossStates.GAIN || matrix.getState(id, c) == CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT)) {
                        BinaryDomainCombination bdc = null;
                        try {
                            bdc = BasicBinaryDomainCombination.createInstance(matrix.getCharacter(c));
                        }
                        catch (Exception e) {
                            ForesterUtil.fatalError("surfacing", e.getLocalizedMessage());
                        }
                        out.write(bdc.toGraphDescribingLanguage(bc_output_format, null, null).toString());
                        out.write(character_separator);
                    }
                    ++c;
                }
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters list: \"" + filename + "\"");
    }

    public static void writeBinaryStatesMatrixToList(Map<DomainId, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, GoNameSpace go_namespace_limit, boolean domain_combinations, CharacterStateMatrix<CharacterStateMatrix.GainLossStates> matrix, CharacterStateMatrix.GainLossStates state, String filename, String indentifier_characters_separator, String character_separator, String title_for_html, String prefix_for_html, Map<DomainId, Set<String>>[] domain_id_to_secondary_features_maps, SortedSet<String> all_pfams_encountered, SortedSet<String> pfams_gained_or_lost, String suffix_for_per_node_events_file) {
        if (go_namespace_limit != null && (go_id_to_term_map == null || go_id_to_term_map.size() < 1)) {
            throw new IllegalArgumentException("attempt to use GO namespace limit without a GO-id to term map");
        }
        if (domain_id_to_go_ids_map == null || domain_id_to_go_ids_map.size() < 1) {
            throw new IllegalArgumentException("attempt to output detailed HTML without a Pfam to GO map");
        }
        if (go_id_to_term_map == null || go_id_to_term_map.size() < 1) {
            throw new IllegalArgumentException("attempt to output detailed HTML without a GO-id to term map");
        }
        File outfile = new File(filename);
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        TreeSet<String> sorted_ids = new TreeSet<String>();
        int i = 0;
        while (i < matrix.getNumberOfIdentifiers()) {
            sorted_ids.add(matrix.getIdentifier(i));
            ++i;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            File per_node_go_mapped_domain_gain_loss_files_base_dir = SurfacingUtil.createBaseDirForPerNodeDomainFiles("PER_NODE_EVENTS", domain_combinations, state, filename);
            Writer per_node_go_mapped_domain_gain_loss_outfile_writer = null;
            File per_node_go_mapped_domain_gain_loss_outfile = null;
            int per_node_counter = 0;
            out.write("<html>");
            out.write(SurfacingConstants.NL);
            SurfacingUtil.addHtmlHead(out, title_for_html);
            out.write(SurfacingConstants.NL);
            out.write("<body>");
            out.write(SurfacingConstants.NL);
            out.write("<h1>");
            out.write(SurfacingConstants.NL);
            out.write(title_for_html);
            out.write(SurfacingConstants.NL);
            out.write("</h1>");
            out.write(SurfacingConstants.NL);
            out.write("<table>");
            out.write(SurfacingConstants.NL);
            for (String id : sorted_ids) {
                out.write("<tr>");
                out.write("<td>");
                out.write("<a href=\"#" + id + "\">" + id + "</a>");
                SurfacingUtil.writeTaxonomyLinks(out, id);
                out.write("</td>");
                out.write("</tr>");
                out.write(SurfacingConstants.NL);
            }
            out.write("</table>");
            out.write(SurfacingConstants.NL);
            for (String id : sorted_ids) {
                out.write(SurfacingConstants.NL);
                out.write("<h2>");
                out.write("<a name=\"" + id + "\">" + id + "</a>");
                SurfacingUtil.writeTaxonomyLinks(out, id);
                out.write("</h2>");
                out.write(SurfacingConstants.NL);
                out.write("<table>");
                out.write(SurfacingConstants.NL);
                out.write("<tr>");
                out.write("<td><b>");
                out.write("Pfam domain(s)");
                out.write("</b></td><td><b>");
                out.write("GO term acc");
                out.write("</b></td><td><b>");
                out.write("GO term");
                out.write("</b></td><td><b>");
                out.write("Penultimate GO term");
                out.write("</b></td><td><b>");
                out.write("GO namespace");
                out.write("</b></td>");
                out.write("</tr>");
                out.write(SurfacingConstants.NL);
                out.write("</tr>");
                out.write(SurfacingConstants.NL);
                per_node_counter = 0;
                if (matrix.getNumberOfCharacters() > 0) {
                    per_node_go_mapped_domain_gain_loss_outfile = new File(per_node_go_mapped_domain_gain_loss_files_base_dir + ForesterUtil.FILE_SEPARATOR + id + suffix_for_per_node_events_file);
                    SurfacingUtil.checkForOutputFileWriteability(per_node_go_mapped_domain_gain_loss_outfile);
                    per_node_go_mapped_domain_gain_loss_outfile_writer = ForesterUtil.createBufferedWriter(per_node_go_mapped_domain_gain_loss_outfile);
                } else {
                    per_node_go_mapped_domain_gain_loss_outfile = null;
                    per_node_go_mapped_domain_gain_loss_outfile_writer = null;
                }
                int c = 0;
                while (c < matrix.getNumberOfCharacters()) {
                    if (matrix.getState(id, c) == state || state == null && (matrix.getState(id, c) == CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT || matrix.getState(id, c) == CharacterStateMatrix.GainLossStates.GAIN)) {
                        String character = matrix.getCharacter(c);
                        String domain_0 = "";
                        String domain_1 = "";
                        if (character.indexOf("=") > 0) {
                            String[] s = character.split("=");
                            if (s.length != 2) {
                                throw new AssertionError((Object)("this should not have happened: unexpected format for domain combination: [" + character + "]"));
                            }
                            domain_0 = s[0];
                            domain_1 = s[1];
                        } else {
                            domain_0 = character;
                        }
                        SurfacingUtil.writeDomainData(domain_id_to_go_ids_map, go_id_to_term_map, go_namespace_limit, out, domain_0, domain_1, prefix_for_html, character_separator, domain_id_to_secondary_features_maps, null);
                        all_pfams_encountered.add(domain_0);
                        if (pfams_gained_or_lost != null) {
                            pfams_gained_or_lost.add(domain_0);
                        }
                        if (!ForesterUtil.isEmpty(domain_1)) {
                            all_pfams_encountered.add(domain_1);
                            if (pfams_gained_or_lost != null) {
                                pfams_gained_or_lost.add(domain_1);
                            }
                        }
                        if (per_node_go_mapped_domain_gain_loss_outfile_writer != null) {
                            SurfacingUtil.writeDomainsToIndividualFilePerTreeNode(per_node_go_mapped_domain_gain_loss_outfile_writer, domain_0, domain_1);
                            ++per_node_counter;
                        }
                    }
                    ++c;
                }
                if (per_node_go_mapped_domain_gain_loss_outfile_writer != null) {
                    per_node_go_mapped_domain_gain_loss_outfile_writer.close();
                    if (per_node_counter < 1) {
                        per_node_go_mapped_domain_gain_loss_outfile.delete();
                    }
                    per_node_counter = 0;
                }
                out.write("</table>");
                out.write(SurfacingConstants.NL);
                out.write("<hr>");
                out.write(SurfacingConstants.NL);
            }
            out.write("</body>");
            out.write(SurfacingConstants.NL);
            out.write("</html>");
            out.write(SurfacingConstants.NL);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote characters detailed HTML list: \"" + filename + "\"");
    }

    public static void writeDomainCombinationsCountsFile(String[][] input_file_properties, File output_dir, Writer per_genome_domain_promiscuity_statistics_writer, GenomeWideCombinableDomains gwcd, int i, GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder dc_sort_order) {
        File dc_outfile = new File(String.valueOf(input_file_properties[i][0]) + ".dcc");
        if (output_dir != null) {
            dc_outfile = new File(output_dir + ForesterUtil.FILE_SEPARATOR + dc_outfile);
        }
        SurfacingUtil.checkForOutputFileWriteability(dc_outfile);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(dc_outfile));
            out.write(gwcd.toStringBuilder(dc_sort_order).toString());
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        DescriptiveStatistics stats = gwcd.getPerGenomeDomainPromiscuityStatistics();
        try {
            per_genome_domain_promiscuity_statistics_writer.write(String.valueOf(input_file_properties[i][0]) + "\t");
            per_genome_domain_promiscuity_statistics_writer.write(String.valueOf(FORMATTER_3.format(stats.arithmeticMean())) + "\t");
            if (stats.getN() < 2) {
                per_genome_domain_promiscuity_statistics_writer.write("n/a\t");
            } else {
                per_genome_domain_promiscuity_statistics_writer.write(String.valueOf(FORMATTER_3.format(stats.sampleStandardDeviation())) + "\t");
            }
            per_genome_domain_promiscuity_statistics_writer.write(String.valueOf(FORMATTER_3.format(stats.median())) + "\t");
            per_genome_domain_promiscuity_statistics_writer.write(String.valueOf((int)stats.getMin()) + "\t");
            per_genome_domain_promiscuity_statistics_writer.write(String.valueOf((int)stats.getMax()) + "\t");
            per_genome_domain_promiscuity_statistics_writer.write(String.valueOf(stats.getN()) + "\t");
            SortedSet<DomainId> mpds = gwcd.getMostPromiscuosDomain();
            for (DomainId mpd : mpds) {
                per_genome_domain_promiscuity_statistics_writer.write(String.valueOf(mpd.getId()) + " ");
            }
            per_genome_domain_promiscuity_statistics_writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        if (input_file_properties[i].length == 3) {
            ForesterUtil.programMessage("surfacing", "Wrote domain combination counts for \"" + input_file_properties[i][0] + "\" (" + input_file_properties[i][1] + ", " + input_file_properties[i][2] + ") to: \"" + dc_outfile + "\"");
        } else {
            ForesterUtil.programMessage("surfacing", "Wrote domain combination counts for \"" + input_file_properties[i][0] + "\" (" + input_file_properties[i][1] + ") to: \"" + dc_outfile + "\"");
        }
    }

    private static void writeDomainData(Map<DomainId, List<GoId>> domain_id_to_go_ids_map, Map<GoId, GoTerm> go_id_to_term_map, GoNameSpace go_namespace_limit, Writer out, String domain_0, String domain_1, String prefix_for_html, String character_separator_for_non_html_output, Map<DomainId, Set<String>>[] domain_id_to_secondary_features_maps, Set<GoId> all_go_ids) throws IOException {
        boolean any_go_annotation_present = false;
        boolean first_has_no_go = false;
        int domain_count = 2;
        if (ForesterUtil.isEmpty(domain_1)) {
            domain_count = 1;
        }
        int d = 0;
        while (d < domain_count) {
            DomainId domain_id;
            List<GoId> go_ids = null;
            boolean go_annotation_present = false;
            if (d == 0) {
                domain_id = new DomainId(domain_0);
                if (domain_id_to_go_ids_map.containsKey(domain_id)) {
                    go_annotation_present = true;
                    any_go_annotation_present = true;
                    go_ids = domain_id_to_go_ids_map.get(domain_id);
                } else {
                    first_has_no_go = true;
                }
            } else {
                domain_id = new DomainId(domain_1);
                if (domain_id_to_go_ids_map.containsKey(domain_id)) {
                    go_annotation_present = true;
                    any_go_annotation_present = true;
                    go_ids = domain_id_to_go_ids_map.get(domain_id);
                }
            }
            if (go_annotation_present) {
                boolean first = d == 0 || d == 1 && first_has_no_go;
                for (GoId go_id : go_ids) {
                    out.write("<tr>");
                    if (first) {
                        first = false;
                        SurfacingUtil.writeDomainIdsToHtml(out, domain_0, domain_1, prefix_for_html, domain_id_to_secondary_features_maps);
                    } else {
                        out.write("<td></td>");
                    }
                    if (!go_id_to_term_map.containsKey(go_id)) {
                        throw new IllegalArgumentException("GO-id [" + go_id + "] not found in GO-id to GO-term map");
                    }
                    GoTerm go_term = go_id_to_term_map.get(go_id);
                    if (go_namespace_limit == null || go_namespace_limit.equals(go_term.getGoNameSpace())) {
                        String top = GoUtils.getPenultimateGoTerm(go_term, go_id_to_term_map).getName();
                        String go_id_str = go_id.getId();
                        out.write("<td>");
                        out.write("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + go_id_str + "\" target=\"amigo_window\">" + go_id_str + "</a>");
                        out.write("</td><td>");
                        out.write(go_term.getName());
                        if (domain_count == 2) {
                            out.write(" (" + d + ")");
                        }
                        out.write("</td><td>");
                        out.write(top);
                        out.write("</td><td>");
                        out.write("[");
                        out.write(go_term.getGoNameSpace().toShortString());
                        out.write("]");
                        out.write("</td>");
                        if (all_go_ids != null) {
                            all_go_ids.add(go_id);
                        }
                    } else {
                        out.write("<td>");
                        out.write("</td><td>");
                        out.write("</td><td>");
                        out.write("</td><td>");
                        out.write("</td>");
                    }
                    out.write("</tr>");
                    out.write(SurfacingConstants.NL);
                }
            }
            ++d;
        }
        if (!any_go_annotation_present) {
            out.write("<tr>");
            SurfacingUtil.writeDomainIdsToHtml(out, domain_0, domain_1, prefix_for_html, domain_id_to_secondary_features_maps);
            out.write("<td>");
            out.write("</td><td>");
            out.write("</td><td>");
            out.write("</td><td>");
            out.write("</td>");
            out.write("</tr>");
            out.write(SurfacingConstants.NL);
        }
    }

    private static void writeDomainIdsToHtml(Writer out, String domain_0, String domain_1, String prefix_for_detailed_html, Map<DomainId, Set<String>>[] domain_id_to_secondary_features_maps) throws IOException {
        out.write("<td>");
        if (!ForesterUtil.isEmpty(prefix_for_detailed_html)) {
            out.write(prefix_for_detailed_html);
            out.write(" ");
        }
        out.write("<a href=\"http://pfam.sanger.ac.uk/family?id=" + domain_0 + "\">" + domain_0 + "</a>");
        if (ForesterUtil.isEmpty(domain_1)) {
            out.write(" <a href=\"http://scholar.google.com/scholar?q=" + domain_0 + "&as_subj=bio&as_subj=med&as_subj=chm&num=100" + "\">[gs]</a>");
        }
        if (!ForesterUtil.isEmpty(domain_1)) {
            out.write("=");
            out.write("<a href=\"http://pfam.sanger.ac.uk/family?id=" + domain_1 + "\">" + domain_1 + "</a>");
        } else if (domain_id_to_secondary_features_maps != null && domain_id_to_secondary_features_maps.length > 0) {
            out.write(" [");
            boolean first = true;
            Map<DomainId, Set<String>>[] mapArray = domain_id_to_secondary_features_maps;
            int n = domain_id_to_secondary_features_maps.length;
            int n2 = 0;
            while (n2 < n) {
                Map<DomainId, Set<String>> domain_id_to_secondary_features_map = mapArray[n2];
                Set<String> sec_features = domain_id_to_secondary_features_map.get(new DomainId(domain_0));
                if (sec_features != null && sec_features.size() > 0) {
                    for (String sec_feature : sec_features) {
                        if (first) {
                            first = false;
                        } else {
                            out.write(", ");
                        }
                        if ("http://scop.mrc-lmb.cam.ac.uk/scop/search.cgi?key=" != null) {
                            out.write("<a href=\"http://scop.mrc-lmb.cam.ac.uk/scop/search.cgi?key=" + sec_feature + "\" target=\"scop_window\">" + sec_feature + "</a>");
                            continue;
                        }
                        out.write(sec_feature);
                    }
                }
                ++n2;
            }
            out.write("]");
        }
        out.write("</td>");
    }

    public static DescriptiveStatistics writeDomainSimilaritiesToFile(StringBuilder html_desc, StringBuilder html_title, Writer w, SortedSet<DomainSimilarity> similarities, boolean treat_as_binary, List<Species> species_order, PrintableDomainSimilarity.PRINT_OPTION print_option, DomainSimilarity.DomainSimilaritySortField sort_field, DomainSimilarity.DomainSimilarityScoring scoring, boolean verbose) throws IOException {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        String histogram_title = null;
        switch (sort_field) {
            case ABS_MAX_COUNTS_DIFFERENCE: {
                if (treat_as_binary) {
                    histogram_title = "absolute counts difference:";
                    break;
                }
                histogram_title = "absolute (maximal) counts difference:";
                break;
            }
            case MAX_COUNTS_DIFFERENCE: {
                if (treat_as_binary) {
                    histogram_title = "counts difference:";
                    break;
                }
                histogram_title = "(maximal) counts difference:";
                break;
            }
            case DOMAIN_ID: {
                histogram_title = "score mean:";
                break;
            }
            case MIN: {
                histogram_title = "score minimum:";
                break;
            }
            case MAX: {
                histogram_title = "score maximum:";
                break;
            }
            case MAX_DIFFERENCE: {
                if (treat_as_binary) {
                    histogram_title = "difference:";
                    break;
                }
                histogram_title = "(maximal) difference:";
                break;
            }
            case MEAN: {
                histogram_title = "score mean:";
                break;
            }
            case SD: {
                histogram_title = "score standard deviation:";
                break;
            }
            case SPECIES_COUNT: {
                histogram_title = "species number:";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown sort field: " + (Object)((Object)sort_field)));
            }
        }
        for (DomainSimilarity similarity : similarities) {
            switch (sort_field) {
                case ABS_MAX_COUNTS_DIFFERENCE: {
                    stats.addValue(Math.abs(similarity.getMaximalDifferenceInCounts()));
                    break;
                }
                case MAX_COUNTS_DIFFERENCE: {
                    stats.addValue(similarity.getMaximalDifferenceInCounts());
                    break;
                }
                case DOMAIN_ID: {
                    stats.addValue(similarity.getMeanSimilarityScore());
                    break;
                }
                case MIN: {
                    stats.addValue(similarity.getMinimalSimilarityScore());
                    break;
                }
                case MAX: {
                    stats.addValue(similarity.getMaximalSimilarityScore());
                    break;
                }
                case MAX_DIFFERENCE: {
                    stats.addValue(similarity.getMaximalDifference());
                    break;
                }
                case MEAN: {
                    stats.addValue(similarity.getMeanSimilarityScore());
                    break;
                }
                case SD: {
                    stats.addValue(similarity.getStandardDeviationOfSimilarityScore());
                    break;
                }
                case SPECIES_COUNT: {
                    stats.addValue(similarity.getSpecies().size());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown sort field: " + (Object)((Object)sort_field)));
                }
            }
        }
        AsciiHistogram histo = null;
        if (stats.getMin() < stats.getMin()) {
            histo = new AsciiHistogram(stats, histogram_title);
        }
        if (verbose) {
            if (histo != null) {
                System.out.println(histo.toStringBuffer(20, '|', 40, 5));
            }
            System.out.println();
            System.out.println("N                   : " + stats.getN());
            System.out.println("Min                 : " + stats.getMin());
            System.out.println("Max                 : " + stats.getMax());
            System.out.println("Mean                : " + stats.arithmeticMean());
            if (stats.getN() > 1) {
                System.out.println("SD                  : " + stats.sampleStandardDeviation());
            } else {
                System.out.println("SD                  : n/a");
            }
            System.out.println("Median              : " + stats.median());
            if (stats.getN() > 1) {
                System.out.println("Pearsonian skewness : " + stats.pearsonianSkewness());
            } else {
                System.out.println("Pearsonian skewness : n/a");
            }
        }
        switch (print_option) {
            case SIMPLE_TAB_DELIMITED: {
                break;
            }
            case HTML: {
                w.write("<html>");
                w.write(SurfacingConstants.NL);
                SurfacingUtil.addHtmlHead(w, "SURFACING :: " + html_title);
                w.write(SurfacingConstants.NL);
                w.write("<body>");
                w.write(SurfacingConstants.NL);
                w.write(html_desc.toString());
                w.write(SurfacingConstants.NL);
                w.write("<hr>");
                w.write("<br>");
                w.write(SurfacingConstants.NL);
                w.write("<tt><pre>");
                w.write(SurfacingConstants.NL);
                if (histo != null) {
                    w.write(histo.toStringBuffer(20, '|', 40, 5).toString());
                    w.write(SurfacingConstants.NL);
                }
                w.write("</pre></tt>");
                w.write(SurfacingConstants.NL);
                w.write("<table>");
                w.write(SurfacingConstants.NL);
                w.write("<tr><td>N: </td><td>" + stats.getN() + "</td></tr>");
                w.write(SurfacingConstants.NL);
                w.write("<tr><td>Min: </td><td>" + stats.getMin() + "</td></tr>");
                w.write(SurfacingConstants.NL);
                w.write("<tr><td>Max: </td><td>" + stats.getMax() + "</td></tr>");
                w.write(SurfacingConstants.NL);
                w.write("<tr><td>Mean: </td><td>" + stats.arithmeticMean() + "</td></tr>");
                w.write(SurfacingConstants.NL);
                if (stats.getN() > 1) {
                    w.write("<tr><td>SD: </td><td>" + stats.sampleStandardDeviation() + "</td></tr>");
                } else {
                    w.write("<tr><td>SD: </td><td>n/a</td></tr>");
                }
                w.write(SurfacingConstants.NL);
                w.write("<tr><td>Median: </td><td>" + stats.median() + "</td></tr>");
                w.write(SurfacingConstants.NL);
                if (stats.getN() > 1) {
                    w.write("<tr><td>Pearsonian skewness: </td><td>" + stats.pearsonianSkewness() + "</td></tr>");
                } else {
                    w.write("<tr><td>Pearsonian skewness: </td><td>n/a</td></tr>");
                }
                w.write(SurfacingConstants.NL);
                w.write("</table>");
                w.write(SurfacingConstants.NL);
                w.write("<br>");
                w.write(SurfacingConstants.NL);
                w.write("<hr>");
                w.write(SurfacingConstants.NL);
                w.write("<br>");
                w.write(SurfacingConstants.NL);
                w.write("<table>");
                w.write(SurfacingConstants.NL);
            }
        }
        w.write(SurfacingConstants.NL);
        for (DomainSimilarity similarity : similarities) {
            if (species_order != null && !species_order.isEmpty()) {
                ((PrintableDomainSimilarity)similarity).setSpeciesOrder(species_order);
            }
            w.write(similarity.toStringBuffer(print_option).toString());
            w.write(SurfacingConstants.NL);
        }
        switch (print_option) {
            case HTML: {
                w.write(SurfacingConstants.NL);
                w.write("</table>");
                w.write(SurfacingConstants.NL);
                w.write("</font>");
                w.write(SurfacingConstants.NL);
                w.write("</body>");
                w.write(SurfacingConstants.NL);
                w.write("</html>");
                w.write(SurfacingConstants.NL);
            }
        }
        w.flush();
        w.close();
        return stats;
    }

    private static void writeDomainsToIndividualFilePerTreeNode(Writer individual_files_writer, String domain_0, String domain_1) throws IOException {
        individual_files_writer.write(domain_0);
        individual_files_writer.write(ForesterUtil.LINE_SEPARATOR);
        if (!ForesterUtil.isEmpty(domain_1)) {
            individual_files_writer.write(domain_1);
            individual_files_writer.write(ForesterUtil.LINE_SEPARATOR);
        }
    }

    public static void writeMatrixToFile(CharacterStateMatrix<?> matrix, String filename, CharacterStateMatrix.Format format) {
        File outfile = new File(filename);
        SurfacingUtil.checkForOutputFileWriteability(outfile);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            matrix.toWriter(out, format);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote matrix: \"" + filename + "\"");
    }

    public static void writeMatrixToFile(File matrix_outfile, List<DistanceMatrix> matrices) {
        SurfacingUtil.checkForOutputFileWriteability(matrix_outfile);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(matrix_outfile));
            for (DistanceMatrix distance_matrix : matrices) {
                out.write(distance_matrix.toStringBuffer(DistanceMatrix.Format.PHYLIP).toString());
                out.write(ForesterUtil.LINE_SEPARATOR);
                out.flush();
            }
            out.close();
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
        ForesterUtil.programMessage("surfacing", "Wrote distance matrices to \"" + matrix_outfile + "\"");
    }

    private static void writePfamsToFile(String outfile_name, SortedSet<String> pfams) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outfile_name)));
            for (String pfam : pfams) {
                writer.write(pfam);
                writer.write(ForesterUtil.LINE_SEPARATOR);
            }
            ((Writer)writer).close();
            ForesterUtil.programMessage("surfacing", "Wrote " + pfams.size() + " pfams to [" + outfile_name + "]");
        }
        catch (IOException e) {
            ForesterUtil.printWarningMessage("surfacing", "Failure to write: " + e);
        }
    }

    public static void writePhylogenyToFile(Phylogeny phylogeny, String filename) {
        PhylogenyWriter writer = new PhylogenyWriter();
        try {
            writer.toPhyloXML(new File(filename), phylogeny, 1);
        }
        catch (IOException e) {
            ForesterUtil.printWarningMessage("surfacing", "failed to write phylogeny to \"" + filename + "\": " + e);
        }
        ForesterUtil.programMessage("surfacing", "Wrote phylogeny to \"" + filename + "\"");
    }

    public static void writeTaxonomyLinks(Writer writer, String species) throws IOException {
        if (species.length() > 1 && species.indexOf(95) < 1) {
            Matcher matcher = PATTERN_SP_STYLE_TAXONOMY.matcher(species);
            writer.write(" [");
            if (matcher.matches()) {
                writer.write("<a href=\"http://beta.uniprot.org/taxonomy/?query=" + species + "\" target=\"taxonomy_window\">uniprot</a>");
            } else {
                writer.write("<a href=\"http://www.eol.org/search?q=" + species + "\" target=\"taxonomy_window\">eol</a>");
                writer.write("|");
                writer.write("<a href=\"http://www.googlesyndicatedsearch.com/u/TreeofLife?q=" + species + "\" target=\"taxonomy_window\">tol</a>");
                writer.write("|");
                writer.write("<a href=\"http://wikipedia.org/wiki/" + species + "\" target=\"taxonomy_window\">wikipedia</a>");
                writer.write("|");
                writer.write("<a href=\"http://scholar.google.com/scholar?q=" + species + "\" target=\"taxonomy_window\">gs</a>");
            }
            writer.write("]");
        }
    }

    private static void writeToNexus(String outfile_name, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix) {
        if (!(matrix instanceof BasicCharacterStateMatrix)) {
            throw new IllegalArgumentException("can only write matrices of type [" + BasicCharacterStateMatrix.class + "] to nexus");
        }
        BasicCharacterStateMatrix my_matrix = (BasicCharacterStateMatrix)matrix;
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(outfile_name));
            w.write("#NEXUS");
            w.write(ForesterUtil.LINE_SEPARATOR);
            my_matrix.writeNexusTaxaBlock(w);
            my_matrix.writeNexusBinaryChractersBlock(w);
            w.flush();
            w.close();
            ForesterUtil.programMessage("surfacing", "Wrote Nexus file: \"" + outfile_name + "\"");
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
    }

    private static void writeToNexus(String outfile_name, CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix, Phylogeny phylogeny) {
        if (!(matrix instanceof BasicCharacterStateMatrix)) {
            throw new IllegalArgumentException("can only write matrices of type [" + BasicCharacterStateMatrix.class + "] to nexus");
        }
        BasicCharacterStateMatrix my_matrix = (BasicCharacterStateMatrix)matrix;
        ArrayList<Phylogeny> phylogenies = new ArrayList<Phylogeny>(1);
        phylogenies.add(phylogeny);
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(outfile_name));
            w.write("#NEXUS");
            w.write(ForesterUtil.LINE_SEPARATOR);
            my_matrix.writeNexusTaxaBlock(w);
            my_matrix.writeNexusBinaryChractersBlock(w);
            PhylogenyWriter.writeNexusTreesBlock(w, phylogenies);
            w.flush();
            w.close();
            ForesterUtil.programMessage("surfacing", "Wrote Nexus file: \"" + outfile_name + "\"");
        }
        catch (IOException e) {
            ForesterUtil.fatalError("surfacing", e.getMessage());
        }
    }

    private static void writeToNexus(String outfile_name, DomainParsimonyCalculator domain_parsimony) {
        SurfacingUtil.writeToNexus(String.valueOf(outfile_name) + "_dom.nex", domain_parsimony.createMatrixOfDomainPresenceOrAbsence());
        SurfacingUtil.writeToNexus(String.valueOf(outfile_name) + "_dc.nex", domain_parsimony.createMatrixOfBinaryDomainCombinationPresenceOrAbsence());
    }

    private static void writeToNexus(String outfile_name, DomainParsimonyCalculator domain_parsimony, Phylogeny phylogeny) {
        SurfacingUtil.writeToNexus(String.valueOf(outfile_name) + "_dom.nex", domain_parsimony.createMatrixOfDomainPresenceOrAbsence(), phylogeny);
        SurfacingUtil.writeToNexus(String.valueOf(outfile_name) + "_dc.nex", domain_parsimony.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(), phylogeny);
    }
}

