/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.HmmPfamOutputParser;
import org.forester.io.parsers.nexus.PaupLogParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogenyinference.BasicCharacterStateMatrix;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.surfacing.AdjactantDirectedBinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.BasicDomain;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.BasicGenomeWideCombinableDomains;
import org.forester.surfacing.BasicProtein;
import org.forester.surfacing.BasicSpecies;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DirectedBinaryDomainCombination;
import org.forester.surfacing.DirectedCombinableDomains;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainArchitectureBasedGenomeSimilarityCalculator;
import org.forester.surfacing.DomainCountsBasedPairwiseSimilarityCalculator;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.Protein;
import org.forester.surfacing.ProteinCountsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.ProteinId;
import org.forester.surfacing.SimpleDomain;
import org.forester.surfacing.SpeciesSpecificDomainSimilariyData;
import org.forester.surfacing.SurfacingUtil;
import org.forester.test.Test;
import org.forester.util.ForesterUtil;

public class TestSurfacing {
    private static final double ZERO_DIFF = 1.0E-9;

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    private static StringBuffer mapToStringBuffer(Map<PhylogenyNode, CharacterStateMatrix.BinaryStates> map) {
        StringBuffer sb = new StringBuffer();
        for (PhylogenyNode key : map.keySet()) {
            if (key.isExternal()) continue;
            sb.append(key.getNodeName());
            sb.append(" : ");
            sb.append(map.get(key).toString());
            sb.append(ForesterUtil.getLineSeparator());
        }
        return sb;
    }

    public static boolean test(File test_dir) {
        System.out.print("  Domain id: ");
        if (!TestSurfacing.testDomainId()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Protein id: ");
        if (!TestSurfacing.testProteinId()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Species: ");
        if (!TestSurfacing.testSpecies()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain: ");
        if (!TestSurfacing.testBasicDomain()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic protein: ");
        if (!TestSurfacing.testBasicProtein()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Combinable domains: ");
        if (!TestSurfacing.testCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directed combinable domains: ");
        if (!TestSurfacing.testDirectedCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Genome wide specific combinable domains: ");
        if (!TestSurfacing.testGenomeWideCombinableDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain architecture based genome similarity calculator: ");
        if (!TestSurfacing.testDomainArchitectureBasedGenomeSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Hmmpfam output parser: ");
        if (!TestSurfacing.testHmmPfamOutputParser(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Hmmpfam output parser with filter: ");
        if (!TestSurfacing.testHmmPfamOutputParserWithFilter(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Combinations based pairwise similarity calculator: ");
        if (!TestSurfacing.testCombinationsBasedPairwiseSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Copy number based pairwise similarity calculator: ");
        if (!TestSurfacing.testCopyNumberBasedPairwiseSimilarityCalculator()) {
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain combination counting: ");
        if (!TestSurfacing.testDomainCombinationCounting(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculator()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator not ignoring species specific domains: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculatorNotIgnoringSpeciesSpeficDomains()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic domain similarity calculator removal of singles: ");
        if (!TestSurfacing.testBasicDomainSimilarityCalculatorRemovalOfSingles()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Domain sorting: ");
        if (!TestSurfacing.testDomainSorting()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Overlap removal: ");
        if (!TestSurfacing.testOverlapRemoval()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Engulfing overlap removal: ");
        if (!TestSurfacing.testEngulfingOverlapRemoval()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Binary domain combination: ");
        if (!TestSurfacing.testBinaryDomainCombination()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Parsimony: ");
        if (!TestSurfacing.testParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directedness: ");
        if (!TestSurfacing.testDirectedness()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Directedness and adjacency: ");
        if (!TestSurfacing.testDirectednessAndAdjacency()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo parsimony on secodary features: ");
        if (!TestSurfacing.testParsimonyOnSecondaryFeatures()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Paup log parser: ");
        if (!TestSurfacing.testPaupLogParser(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Binary state matrix to gain loss matrix: ");
        if (!TestSurfacing.testBinaryStateMatrixToGainLossMatrix(test_dir)) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static boolean testBasicDomain() {
        BasicDomain a3;
        BasicDomain a1;
        block27: {
            BasicDomain a2;
            block26: {
                BasicDomain a1_equal;
                block25: {
                    BasicDomain a1_copy;
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                BasicDomain pd;
                                                block17: {
                                                    block16: {
                                                        block15: {
                                                            try {
                                                                pd = new BasicDomain("id", 23, 25, 1, 4, 0.1, -12.0);
                                                                if (pd.getDomainId().getId().equals("id")) break block15;
                                                                return false;
                                                            }
                                                            catch (Exception e) {
                                                                e.printStackTrace(System.out);
                                                                return false;
                                                            }
                                                        }
                                                        if (pd.getNumber() == 1) break block16;
                                                        return false;
                                                    }
                                                    if (pd.getTotalCount() == 4) break block17;
                                                    return false;
                                                }
                                                if (((Object)pd).equals(new BasicDomain("id", 22, 111, 1, 4, 0.2, -12.0))) break block18;
                                                return false;
                                            }
                                            a1 = new BasicDomain("a", 1, 10, 1, 4, 0.1, -12.0);
                                            a1_copy = new BasicDomain("a", 1, 10, 1, 4, 0.1, -12.0);
                                            a1_equal = new BasicDomain("a", 524, 743994, 1, 300, 3.0005, 230.0);
                                            a2 = new BasicDomain("a", 1, 10, 2, 4, 0.1, -12.0);
                                            a3 = new BasicDomain("A", 1, 10, 1, 4, 0.1, -12.0);
                                            if (((Object)a1).equals(a1)) break block19;
                                            return false;
                                        }
                                        if (((Object)a1).equals(a1_copy)) break block20;
                                        return false;
                                    }
                                    if (((Object)a1).equals(a1_equal)) break block21;
                                    return false;
                                }
                                if (((Object)a1).equals(a2)) break block22;
                                return false;
                            }
                            if (!((Object)a1).equals(a3)) break block23;
                            return false;
                        }
                        if (a1.compareTo(a1) == 0) break block24;
                        return false;
                    }
                    if (a1.compareTo(a1_copy) == 0) break block25;
                    return false;
                }
                if (a1.compareTo(a1_equal) == 0) break block26;
                return false;
            }
            if (a1.compareTo(a2) == 0) break block27;
            return false;
        }
        return a1.compareTo(a3) == 0;
    }

    private static boolean testBasicDomainSimilarityCalculator() {
        DomainSimilarity sa6_p;
        block299: {
            block298: {
                block297: {
                    block296: {
                        block295: {
                            block294: {
                                block293: {
                                    BasicSpecies ciona;
                                    block292: {
                                        block291: {
                                            block290: {
                                                block289: {
                                                    block288: {
                                                        block287: {
                                                            ArrayList<GenomeWideCombinableDomains> cdc_list6;
                                                            BasicDomainSimilarityCalculator calc4;
                                                            block286: {
                                                                DomainSimilarity sa6_d;
                                                                block285: {
                                                                    block284: {
                                                                        block283: {
                                                                            block282: {
                                                                                block281: {
                                                                                    block280: {
                                                                                        block279: {
                                                                                            BasicSpecies ciona6;
                                                                                            block278: {
                                                                                                block277: {
                                                                                                    block276: {
                                                                                                        block275: {
                                                                                                            block274: {
                                                                                                                block273: {
                                                                                                                    DomainSimilarity sa5_d;
                                                                                                                    block272: {
                                                                                                                        SpeciesSpecificDomainSimilariyData ssdsd6;
                                                                                                                        block271: {
                                                                                                                            block270: {
                                                                                                                                block269: {
                                                                                                                                    block268: {
                                                                                                                                        block267: {
                                                                                                                                            block266: {
                                                                                                                                                ArrayList<Protein> protein_list_nemve;
                                                                                                                                                ArrayList<Protein> protein_list_ciona;
                                                                                                                                                ArrayList<Protein> protein_list_rabbit;
                                                                                                                                                ArrayList<Protein> protein_list_mouse;
                                                                                                                                                block265: {
                                                                                                                                                    DomainSimilarity sa5_p;
                                                                                                                                                    block264: {
                                                                                                                                                        block263: {
                                                                                                                                                            block262: {
                                                                                                                                                                block261: {
                                                                                                                                                                    block260: {
                                                                                                                                                                        block259: {
                                                                                                                                                                            block258: {
                                                                                                                                                                                block257: {
                                                                                                                                                                                    block256: {
                                                                                                                                                                                        block255: {
                                                                                                                                                                                            block254: {
                                                                                                                                                                                                block253: {
                                                                                                                                                                                                    block252: {
                                                                                                                                                                                                        ArrayList<GenomeWideCombinableDomains> cdc_list5;
                                                                                                                                                                                                        block251: {
                                                                                                                                                                                                            block250: {
                                                                                                                                                                                                                block249: {
                                                                                                                                                                                                                    block248: {
                                                                                                                                                                                                                        block247: {
                                                                                                                                                                                                                            block246: {
                                                                                                                                                                                                                                block245: {
                                                                                                                                                                                                                                    block244: {
                                                                                                                                                                                                                                        block243: {
                                                                                                                                                                                                                                            block242: {
                                                                                                                                                                                                                                                block241: {
                                                                                                                                                                                                                                                    block240: {
                                                                                                                                                                                                                                                        block239: {
                                                                                                                                                                                                                                                            block238: {
                                                                                                                                                                                                                                                                block237: {
                                                                                                                                                                                                                                                                    SpeciesSpecificDomainSimilariyData ssdsd5;
                                                                                                                                                                                                                                                                    block236: {
                                                                                                                                                                                                                                                                        block235: {
                                                                                                                                                                                                                                                                            block234: {
                                                                                                                                                                                                                                                                                block233: {
                                                                                                                                                                                                                                                                                    block232: {
                                                                                                                                                                                                                                                                                        block231: {
                                                                                                                                                                                                                                                                                            block230: {
                                                                                                                                                                                                                                                                                                DomainSimilarity sa4_p;
                                                                                                                                                                                                                                                                                                block229: {
                                                                                                                                                                                                                                                                                                    block228: {
                                                                                                                                                                                                                                                                                                        block227: {
                                                                                                                                                                                                                                                                                                            block226: {
                                                                                                                                                                                                                                                                                                                block225: {
                                                                                                                                                                                                                                                                                                                    block224: {
                                                                                                                                                                                                                                                                                                                        block223: {
                                                                                                                                                                                                                                                                                                                            block222: {
                                                                                                                                                                                                                                                                                                                                block221: {
                                                                                                                                                                                                                                                                                                                                    block220: {
                                                                                                                                                                                                                                                                                                                                        ArrayList<GenomeWideCombinableDomains> cdc_list4;
                                                                                                                                                                                                                                                                                                                                        block219: {
                                                                                                                                                                                                                                                                                                                                            DomainSimilarity sa4_d;
                                                                                                                                                                                                                                                                                                                                            block218: {
                                                                                                                                                                                                                                                                                                                                                block217: {
                                                                                                                                                                                                                                                                                                                                                    block216: {
                                                                                                                                                                                                                                                                                                                                                        block215: {
                                                                                                                                                                                                                                                                                                                                                            block214: {
                                                                                                                                                                                                                                                                                                                                                                block213: {
                                                                                                                                                                                                                                                                                                                                                                    SpeciesSpecificDomainSimilariyData ssdsd4;
                                                                                                                                                                                                                                                                                                                                                                    block212: {
                                                                                                                                                                                                                                                                                                                                                                        block211: {
                                                                                                                                                                                                                                                                                                                                                                            block210: {
                                                                                                                                                                                                                                                                                                                                                                                block209: {
                                                                                                                                                                                                                                                                                                                                                                                    block208: {
                                                                                                                                                                                                                                                                                                                                                                                        DomainSimilarity sa4;
                                                                                                                                                                                                                                                                                                                                                                                        block207: {
                                                                                                                                                                                                                                                                                                                                                                                            block206: {
                                                                                                                                                                                                                                                                                                                                                                                                SpeciesSpecificDomainSimilariyData ssdsd;
                                                                                                                                                                                                                                                                                                                                                                                                block205: {
                                                                                                                                                                                                                                                                                                                                                                                                    block204: {
                                                                                                                                                                                                                                                                                                                                                                                                        block203: {
                                                                                                                                                                                                                                                                                                                                                                                                            block202: {
                                                                                                                                                                                                                                                                                                                                                                                                                DomainSimilarity sa3;
                                                                                                                                                                                                                                                                                                                                                                                                                block201: {
                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain X;
                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain G;
                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain F;
                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain B;
                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain A;
                                                                                                                                                                                                                                                                                                                                                                                                                    block200: {
                                                                                                                                                                                                                                                                                                                                                                                                                        DomainSimilarity sa2;
                                                                                                                                                                                                                                                                                                                                                                                                                        block199: {
                                                                                                                                                                                                                                                                                                                                                                                                                            block198: {
                                                                                                                                                                                                                                                                                                                                                                                                                                block197: {
                                                                                                                                                                                                                                                                                                                                                                                                                                    block196: {
                                                                                                                                                                                                                                                                                                                                                                                                                                        block195: {
                                                                                                                                                                                                                                                                                                                                                                                                                                            block194: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                block193: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    block192: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        block191: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            block190: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                block189: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block188: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block187: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            DomainSimilarity sc;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block186: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block185: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block184: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block183: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block182: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block181: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block180: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block179: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block178: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block177: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block176: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Iterator sims_it;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block175: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            DomainSimilarity sb;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block174: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block173: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block172: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block171: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block170: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block169: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block168: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block167: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block166: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block165: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block164: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        DomainSimilarity sa;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block163: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block162: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block161: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block160: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block159: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block158: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block157: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block156: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block155: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block154: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block153: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block152: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicDomain E;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicDomain D;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicDomain C;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block151: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            try {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                A = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                B = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                C = new BasicDomain("C", 1, 2, 1, 1, 0.3, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                D = new BasicDomain("D", 1, 2, 1, 1, 0.5, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                E = new BasicDomain("E", 1, 2, 1, 1, 0.5, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                F = new BasicDomain("F", 1, 2, 1, 1, 0.01, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                G = new BasicDomain("G", 1, 2, 1, 1, 0.001, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                X = new BasicDomain("X", 1, 2, 1, 1, 1.0E-4, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestSurfacing.isEqual(X.getPerSequenceScore(), -12.0)) break block151;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicProtein mouse_1 = new BasicProtein("1", "mouse");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicProtein rabbit_1 = new BasicProtein("1", "rabbit");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicProtein ciona_1 = new BasicProtein("1", "ciona");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicProtein nemve_1 = new BasicProtein("1", "nemve");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        mouse_1.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        mouse_1.addProteinDomain(B);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        mouse_1.addProteinDomain(C);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        mouse_1.addProteinDomain(D);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        mouse_1.addProteinDomain(E);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(C);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(E);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        rabbit_1.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ciona_1.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ciona_1.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ciona_1.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ciona_1.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ciona_1.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ciona_1.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ciona_1.addProteinDomain(G);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ciona_1.addProteinDomain(X);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        nemve_1.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        nemve_1.addProteinDomain(B);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        nemve_1.addProteinDomain(C);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        nemve_1.addProteinDomain(D);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        nemve_1.addProteinDomain(E);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        nemve_1.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        nemve_1.addProteinDomain(G);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        protein_list_mouse = new ArrayList<Protein>();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        protein_list_rabbit = new ArrayList<Protein>();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        protein_list_ciona = new ArrayList<Protein>();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        protein_list_nemve = new ArrayList<Protein>();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        protein_list_mouse.add(mouse_1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        protein_list_rabbit.add(rabbit_1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        protein_list_ciona.add(ciona_1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        protein_list_nemve.add(nemve_1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ArrayList<GenomeWideCombinableDomains> cdc_list = new ArrayList<GenomeWideCombinableDomains>();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicDomainSimilarityCalculator calc = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        SortedSet<DomainSimilarity> sims = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, true, true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        sims_it = sims.iterator();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        sa = (DomainSimilarity)sims_it.next();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sa.getDomainId().getId().equals("A")) break block152;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sa.getSpeciesData().size() == 4) break block153;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sa.getSpecies().contains(new BasicSpecies("ciona"))) break block154;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sa.getSpecies().contains(new BasicSpecies("mouse"))) break block155;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sa.getSpecies().contains(new BasicSpecies("nemve"))) break block156;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sa.getSpecies().contains(new BasicSpecies("rabbit"))) break block157;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestSurfacing.isEqual(sa.getMeanSimilarityScore(), 0.342063492063492)) break block158;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestSurfacing.isEqual(sa.getStandardDeviationOfSimilarityScore(), 0.23410788192183737)) break block159;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestSurfacing.isEqual(sa.getMaximalSimilarityScore(), 0.6666666666666666)) break block160;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestSurfacing.isEqual(sa.getMinimalSimilarityScore(), 0.0)) break block161;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sa.getN() == 6) break block162;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sa.getMaximalDifference() == 7) break block163;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sa.getMaximalDifferenceInCounts() == 3) break block164;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    sb = (DomainSimilarity)sims_it.next();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sb.getDomainId().getId().equals("B")) break block165;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sb.getSpeciesData().size() == 2) break block166;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sb.getSpecies().contains(new BasicSpecies("mouse"))) break block167;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sb.getSpecies().contains(new BasicSpecies("nemve"))) break block168;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestSurfacing.isEqual(sb.getMeanSimilarityScore(), 0.6666666666666666)) break block169;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestSurfacing.isEqual(sb.getStandardDeviationOfSimilarityScore(), 0.0)) break block170;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestSurfacing.isEqual(sb.getMaximalSimilarityScore(), 0.6666666666666666)) break block171;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestSurfacing.isEqual(sb.getMinimalSimilarityScore(), 0.6666666666666666)) break block172;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sb.getN() == 1) break block173;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sb.getMaximalDifference() == 2) break block174;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sb.getMaximalDifferenceInCounts() == 2) break block175;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        sc = (DomainSimilarity)sims_it.next();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sc.getDomainId().getId().equals("C")) break block176;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sc.getSpeciesData().size() == 3) break block177;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sc.getSpecies().contains(new BasicSpecies("mouse"))) break block178;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sc.getSpecies().contains(new BasicSpecies("rabbit"))) break block179;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sc.getSpecies().contains(new BasicSpecies("nemve"))) break block180;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestSurfacing.isEqual(sc.getMeanSimilarityScore(), 0.5222222222222223)) break block181;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestSurfacing.isEqual(sc.getStandardDeviationOfSimilarityScore(), 0.13471506281091264)) break block182;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestSurfacing.isEqual(sc.getMaximalSimilarityScore(), 0.6666666666666666)) break block183;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestSurfacing.isEqual(sc.getMinimalSimilarityScore(), 0.4)) break block184;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sc.getN() == 3) break block185;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sc.getMaximalDifference() == 3) break block186;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sc.getMaximalDifferenceInCounts() == 3) break block187;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ArrayList<GenomeWideCombinableDomains> cdc_list2 = new ArrayList<GenomeWideCombinableDomains>();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, false, new BasicSpecies("mouse")));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, false, new BasicSpecies("rabbit")));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, false, new BasicSpecies("ciona")));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, false, new BasicSpecies("nemve")));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicDomainSimilarityCalculator calc2 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        SortedSet<DomainSimilarity> sims2 = calc2.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list2, false, true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Iterator sims_it2 = sims2.iterator();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        sa2 = (DomainSimilarity)sims_it2.next();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sa2.getDomainId().getId().equals("A")) break block188;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sa2.getSpeciesData().size() == 4) break block189;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (sa2.getSpecies().contains(new BasicSpecies("ciona"))) break block190;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (sa2.getSpecies().contains(new BasicSpecies("mouse"))) break block191;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (sa2.getSpecies().contains(new BasicSpecies("nemve"))) break block192;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (sa2.getSpeciesData().keySet().contains(new BasicSpecies("rabbit"))) break block193;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (TestSurfacing.isEqual(sa2.getMeanSimilarityScore(), 0.33055555555555555)) break block194;
                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (TestSurfacing.isEqual(sa2.getStandardDeviationOfSimilarityScore(), 0.2404663678647683)) break block195;
                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (TestSurfacing.isEqual(sa2.getMaximalSimilarityScore(), 0.6666666666666666)) break block196;
                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (TestSurfacing.isEqual(sa2.getMinimalSimilarityScore(), 0.0)) break block197;
                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                if (sa2.getN() == 6) break block198;
                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                            if (sa2.getMaximalDifference() == 8) break block199;
                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                        if (sa2.getMaximalDifferenceInCounts() == 3) break block200;
                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                    BasicProtein ciona_2 = new BasicProtein("2", "ciona");
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(B);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(B);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(B);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(F);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(G);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_2.addProteinDomain(X);
                                                                                                                                                                                                                                                                                                                                                                                                                    BasicProtein ciona_3 = new BasicProtein("3", "ciona");
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_3.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_3.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_3.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_3.addProteinDomain(A);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_3.addProteinDomain(B);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_3.addProteinDomain(B);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_3.addProteinDomain(X);
                                                                                                                                                                                                                                                                                                                                                                                                                    ciona_3.addProteinDomain(X);
                                                                                                                                                                                                                                                                                                                                                                                                                    protein_list_ciona.add(ciona_2);
                                                                                                                                                                                                                                                                                                                                                                                                                    protein_list_ciona.add(ciona_3);
                                                                                                                                                                                                                                                                                                                                                                                                                    ArrayList<GenomeWideCombinableDomains> cdc_list3 = new ArrayList<GenomeWideCombinableDomains>();
                                                                                                                                                                                                                                                                                                                                                                                                                    cdc_list3.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
                                                                                                                                                                                                                                                                                                                                                                                                                    cdc_list3.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
                                                                                                                                                                                                                                                                                                                                                                                                                    cdc_list3.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
                                                                                                                                                                                                                                                                                                                                                                                                                    cdc_list3.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomainSimilarityCalculator calc3 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false);
                                                                                                                                                                                                                                                                                                                                                                                                                    SortedSet<DomainSimilarity> sims3 = calc3.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list3, false, true);
                                                                                                                                                                                                                                                                                                                                                                                                                    Iterator sims_it3 = sims3.iterator();
                                                                                                                                                                                                                                                                                                                                                                                                                    sa3 = (DomainSimilarity)sims_it3.next();
                                                                                                                                                                                                                                                                                                                                                                                                                    if (sa3.getDomainId().getId().equals("A")) break block201;
                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                ssdsd = (SpeciesSpecificDomainSimilariyData)sa3.getSpeciesData().get(new BasicSpecies("ciona"));
                                                                                                                                                                                                                                                                                                                                                                                                                if (ssdsd.getCombinableDomainIdToCountsMap().size() == 4) break block202;
                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                            if (ssdsd.getNumberOfProteinsExhibitingCombinationWith(new DomainId("B")) == 2) break block203;
                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                        if (ssdsd.getNumberOfProteinsExhibitingCombinationWith(new DomainId("F")) == 2) break block204;
                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                    if (ssdsd.getNumberOfProteinsExhibitingCombinationWith(new DomainId("G")) == 2) break block205;
                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                if (ssdsd.getNumberOfProteinsExhibitingCombinationWith(new DomainId("X")) == 3) break block206;
                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            cdc_list4 = new ArrayList<GenomeWideCombinableDomains>();
                                                                                                                                                                                                                                                                                                                                                                                            cdc_list4.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, false, new BasicSpecies("mouse")));
                                                                                                                                                                                                                                                                                                                                                                                            cdc_list4.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, false, new BasicSpecies("rabbit")));
                                                                                                                                                                                                                                                                                                                                                                                            cdc_list4.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, false, new BasicSpecies("ciona")));
                                                                                                                                                                                                                                                                                                                                                                                            cdc_list4.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, false, new BasicSpecies("nemve")));
                                                                                                                                                                                                                                                                                                                                                                                            calc4 = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, true, false);
                                                                                                                                                                                                                                                                                                                                                                                            SortedSet<DomainSimilarity> sims4 = calc4.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list4, false, true);
                                                                                                                                                                                                                                                                                                                                                                                            Iterator sims_it4 = sims4.iterator();
                                                                                                                                                                                                                                                                                                                                                                                            sa4 = (DomainSimilarity)sims_it4.next();
                                                                                                                                                                                                                                                                                                                                                                                            if (sa4.getDomainId().getId().equals("A")) break block207;
                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        ssdsd4 = (SpeciesSpecificDomainSimilariyData)sa4.getSpeciesData().get(new BasicSpecies("ciona"));
                                                                                                                                                                                                                                                                                                                                                                                        if (ssdsd4.getCombinableDomainIdToCountsMap().size() == 5) break block208;
                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith(new DomainId("A")) == 3) break block209;
                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith(new DomainId("B")) == 2) break block210;
                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith(new DomainId("F")) == 2) break block211;
                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith(new DomainId("G")) == 2) break block212;
                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    if (ssdsd4.getNumberOfProteinsExhibitingCombinationWith(new DomainId("X")) == 3) break block213;
                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                SortedSet<DomainSimilarity> sims4_d = calc4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), cdc_list4, false, true);
                                                                                                                                                                                                                                                                                                                                                                Iterator sims_it4_d = sims4_d.iterator();
                                                                                                                                                                                                                                                                                                                                                                sa4_d = (DomainSimilarity)sims_it4_d.next();
                                                                                                                                                                                                                                                                                                                                                                if (sa4_d.getDomainId().getId().equals("A")) break block214;
                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (sa4_d.getCombinableDomainIds(new BasicSpecies("ciona")).size() == 5) break block215;
                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (TestSurfacing.isEqual(sa4_d.getMeanSimilarityScore(), 0.5769230769230769)) break block216;
                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (TestSurfacing.isEqual(sa4_d.getMaximalSimilarityScore(), 1.0)) break block217;
                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (TestSurfacing.isEqual(sa4_d.getMinimalSimilarityScore(), 0.15384615384615385)) break block218;
                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (sa4_d.getN() == 6) break block219;
                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        SortedSet<DomainSimilarity> sims4_p = calc4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), cdc_list4, false, true);
                                                                                                                                                                                                                                                                                                                                        Iterator sims_it4_p = sims4_p.iterator();
                                                                                                                                                                                                                                                                                                                                        sa4_p = (DomainSimilarity)sims_it4_p.next();
                                                                                                                                                                                                                                                                                                                                        if (sa4_p.getDomainId().getId().equals("A")) break block220;
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).size() == 5) break block221;
                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains(new DomainId("A"))) break block222;
                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains(new DomainId("B"))) break block223;
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains(new DomainId("F"))) break block224;
                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains(new DomainId("G"))) break block225;
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (sa4_p.getCombinableDomainIds(new BasicSpecies("ciona")).contains(new DomainId("X"))) break block226;
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (TestSurfacing.isEqual(sa4_p.getMeanSimilarityScore(), 0.75)) break block227;
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (TestSurfacing.isEqual(sa4_p.getMaximalSimilarityScore(), 1.0)) break block228;
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (TestSurfacing.isEqual(sa4_p.getMinimalSimilarityScore(), 0.5)) break block229;
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (sa4_p.getN() == 6) break block230;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            cdc_list5 = new ArrayList<GenomeWideCombinableDomains>();
                                                                                                                                                                                                                                                                                            cdc_list5.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
                                                                                                                                                                                                                                                                                            cdc_list5.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
                                                                                                                                                                                                                                                                                            cdc_list5.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
                                                                                                                                                                                                                                                                                            cdc_list5.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
                                                                                                                                                                                                                                                                                            SortedSet<DomainSimilarity> sims5_d = calc4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), cdc_list5, false, true);
                                                                                                                                                                                                                                                                                            Iterator sims_it5_d = sims5_d.iterator();
                                                                                                                                                                                                                                                                                            sa5_d = (DomainSimilarity)sims_it5_d.next();
                                                                                                                                                                                                                                                                                            if (sa5_d.getSpecies().size() == 4) break block231;
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (sa5_d.getSpecies().last().equals(new BasicSpecies("rabbit"))) break block232;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    ssdsd5 = (SpeciesSpecificDomainSimilariyData)sa5_d.getSpeciesData().get(new BasicSpecies("ciona"));
                                                                                                                                                                                                                                                                                    if (ssdsd5.getCombinableDomainIdToCountsMap().size() == 4) break block233;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (ssdsd5.getNumberOfProteinsExhibitingCombinationWith(new DomainId("B")) == 2) break block234;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (ssdsd5.getNumberOfProteinsExhibitingCombinationWith(new DomainId("F")) == 2) break block235;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (ssdsd5.getNumberOfProteinsExhibitingCombinationWith(new DomainId("G")) == 2) break block236;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (ssdsd5.getNumberOfProteinsExhibitingCombinationWith(new DomainId("X")) == 3) break block237;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (sa5_d.getDomainId().getId().equals("A")) break block238;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            ciona = new BasicSpecies("ciona");
                                                                                                                                                                                                                                                            if (sa5_d.getCombinableDomainIds(ciona).size() == 4) break block239;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (!sa5_d.getCombinableDomainIds(ciona).contains(new DomainId("A"))) break block240;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (sa5_d.getCombinableDomainIds(ciona).contains(new DomainId("B"))) break block241;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (sa5_d.getCombinableDomainIds(ciona).contains(new DomainId("F"))) break block242;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (sa5_d.getCombinableDomainIds(ciona).contains(new DomainId("G"))) break block243;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (sa5_d.getCombinableDomainIds(ciona).contains(new DomainId("X"))) break block244;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (TestSurfacing.isEqual(sa5_d.getMeanSimilarityScore(), 0.5769230769230769)) break block245;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (TestSurfacing.isEqual(sa5_d.getMaximalSimilarityScore(), 1.0)) break block246;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (TestSurfacing.isEqual(sa5_d.getMinimalSimilarityScore(), 0.15384615384615385)) break block247;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (sa5_d.getN() == 6) break block248;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (sa5_d.getMaximalDifference() == sa5_d.getMaximalDifferenceInCounts()) break block249;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (sa5_d.getMaximalDifference() == 11) break block250;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (sa5_d.getMaximalDifferenceInCounts() == 11) break block251;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        SortedSet<DomainSimilarity> sims5_p = calc4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), cdc_list5, false, true);
                                                                                                                                                                                                        Iterator sims_it5_p = sims5_p.iterator();
                                                                                                                                                                                                        sa5_p = (DomainSimilarity)sims_it5_p.next();
                                                                                                                                                                                                        if (sa5_p.getDomainId().getId().equals("A")) break block252;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (sa5_p.getCombinableDomainIds(ciona).size() == 4) break block253;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (!sa5_p.getCombinableDomainIds(ciona).contains(new DomainId("A"))) break block254;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (sa5_p.getCombinableDomainIds(ciona).contains(new DomainId("B"))) break block255;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (sa5_p.getCombinableDomainIds(ciona).contains(new DomainId("F"))) break block256;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (sa5_p.getCombinableDomainIds(ciona).contains(new DomainId("G"))) break block257;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (sa5_p.getCombinableDomainIds(ciona).contains(new DomainId("X"))) break block258;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (TestSurfacing.isEqual(sa5_p.getMeanSimilarityScore(), 0.75)) break block259;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (TestSurfacing.isEqual(sa5_p.getMaximalSimilarityScore(), 1.0)) break block260;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (TestSurfacing.isEqual(sa5_p.getMinimalSimilarityScore(), 0.5)) break block261;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (sa5_p.getN() == 6) break block262;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (sa5_p.getMaximalDifference() == sa5_p.getMaximalDifferenceInCounts()) break block263;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (sa5_p.getMaximalDifference() == 2) break block264;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (sa5_p.getMaximalDifferenceInCounts() == 2) break block265;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                cdc_list6 = new ArrayList<GenomeWideCombinableDomains>();
                                                                                                                                                cdc_list6.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, false, new BasicSpecies("mouse")));
                                                                                                                                                cdc_list6.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, false, new BasicSpecies("rabbit")));
                                                                                                                                                cdc_list6.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, false, new BasicSpecies("ciona")));
                                                                                                                                                cdc_list6.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, false, new BasicSpecies("nemve")));
                                                                                                                                                SortedSet<DomainSimilarity> sims6_d = calc4.calculateSimilarities(new DomainCountsBasedPairwiseSimilarityCalculator(), cdc_list6, false, true);
                                                                                                                                                Iterator sims_it6_d = sims6_d.iterator();
                                                                                                                                                sa6_d = (DomainSimilarity)sims_it6_d.next();
                                                                                                                                                if (sa6_d.getSpecies().size() == 4) break block266;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (sa6_d.getSpecies().last().equals(new BasicSpecies("rabbit"))) break block267;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        ssdsd6 = (SpeciesSpecificDomainSimilariyData)sa6_d.getSpeciesData().get(new BasicSpecies("ciona"));
                                                                                                                                        if (ssdsd6.getCombinableDomainIdToCountsMap().size() == 5) break block268;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (ssdsd6.getNumberOfProteinsExhibitingCombinationWith(new DomainId("B")) == 2) break block269;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (ssdsd6.getNumberOfProteinsExhibitingCombinationWith(new DomainId("F")) == 2) break block270;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (ssdsd6.getNumberOfProteinsExhibitingCombinationWith(new DomainId("G")) == 2) break block271;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (ssdsd6.getNumberOfProteinsExhibitingCombinationWith(new DomainId("X")) == 3) break block272;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (sa5_d.getDomainId().getId().equals("A")) break block273;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                ciona6 = new BasicSpecies("ciona");
                                                                                                                if (sa6_d.getCombinableDomainIds(ciona6).size() == 5) break block274;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (sa6_d.getCombinableDomainIds(ciona6).contains(new DomainId("A"))) break block275;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (sa6_d.getCombinableDomainIds(ciona6).contains(new DomainId("B"))) break block276;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (sa6_d.getCombinableDomainIds(ciona6).contains(new DomainId("F"))) break block277;
                                                                                                    return false;
                                                                                                }
                                                                                                if (sa6_d.getCombinableDomainIds(ciona6).contains(new DomainId("G"))) break block278;
                                                                                                return false;
                                                                                            }
                                                                                            if (sa6_d.getCombinableDomainIds(ciona6).contains(new DomainId("X"))) break block279;
                                                                                            return false;
                                                                                        }
                                                                                        if (TestSurfacing.isEqual(sa6_d.getMeanSimilarityScore(), 0.5769230769230769)) break block280;
                                                                                        return false;
                                                                                    }
                                                                                    if (TestSurfacing.isEqual(sa6_d.getMaximalSimilarityScore(), 1.0)) break block281;
                                                                                    return false;
                                                                                }
                                                                                if (TestSurfacing.isEqual(sa6_d.getMinimalSimilarityScore(), 0.15384615384615385)) break block282;
                                                                                return false;
                                                                            }
                                                                            if (sa6_d.getN() == 6) break block283;
                                                                            return false;
                                                                        }
                                                                        if (sa6_d.getMaximalDifference() == sa6_d.getMaximalDifferenceInCounts()) break block284;
                                                                        return false;
                                                                    }
                                                                    if (sa6_d.getMaximalDifference() == 11) break block285;
                                                                    return false;
                                                                }
                                                                if (sa6_d.getMaximalDifferenceInCounts() == 11) break block286;
                                                                return false;
                                                            }
                                                            SortedSet<DomainSimilarity> sims6_p = calc4.calculateSimilarities(new ProteinCountsBasedPairwiseDomainSimilarityCalculator(), cdc_list6, false, true);
                                                            Iterator sims_it6_p = sims6_p.iterator();
                                                            sa6_p = (DomainSimilarity)sims_it6_p.next();
                                                            if (sa6_p.getDomainId().getId().equals("A")) break block287;
                                                            return false;
                                                        }
                                                        if (sa6_p.getCombinableDomainIds(ciona).size() == 5) break block288;
                                                        return false;
                                                    }
                                                    if (sa6_p.getCombinableDomainIds(ciona).contains(new DomainId("A"))) break block289;
                                                    return false;
                                                }
                                                if (sa6_p.getCombinableDomainIds(ciona).contains(new DomainId("B"))) break block290;
                                                return false;
                                            }
                                            if (sa6_p.getCombinableDomainIds(ciona).contains(new DomainId("F"))) break block291;
                                            return false;
                                        }
                                        if (sa6_p.getCombinableDomainIds(ciona).contains(new DomainId("G"))) break block292;
                                        return false;
                                    }
                                    if (sa6_p.getCombinableDomainIds(ciona).contains(new DomainId("X"))) break block293;
                                    return false;
                                }
                                if (TestSurfacing.isEqual(sa6_p.getMeanSimilarityScore(), 0.75)) break block294;
                                return false;
                            }
                            if (TestSurfacing.isEqual(sa6_p.getMaximalSimilarityScore(), 1.0)) break block295;
                            return false;
                        }
                        if (TestSurfacing.isEqual(sa6_p.getMinimalSimilarityScore(), 0.5)) break block296;
                        return false;
                    }
                    if (sa6_p.getN() == 6) break block297;
                    return false;
                }
                if (sa6_p.getMaximalDifference() == sa6_p.getMaximalDifferenceInCounts()) break block298;
                return false;
            }
            if (sa6_p.getMaximalDifference() == 2) break block299;
            return false;
        }
        return sa6_p.getMaximalDifferenceInCounts() == 2;
    }

    private static boolean testBasicDomainSimilarityCalculatorNotIgnoringSpeciesSpeficDomains() {
        DomainSimilarity sa2;
        block31: {
            BasicDomainSimilarityCalculator calc;
            ArrayList<GenomeWideCombinableDomains> cdc_list;
            block30: {
                DomainSimilarity sb;
                block29: {
                    block28: {
                        Iterator sims_it;
                        block27: {
                            DomainSimilarity sa;
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                BasicDomain X;
                                                                BasicDomain G;
                                                                BasicDomain F;
                                                                BasicDomain E;
                                                                BasicDomain D;
                                                                BasicDomain B;
                                                                BasicDomain A;
                                                                block17: {
                                                                    try {
                                                                        A = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
                                                                        B = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
                                                                        D = new BasicDomain("D", 1, 2, 1, 1, 0.5, -12.0);
                                                                        E = new BasicDomain("E", 1, 2, 1, 1, 0.5, -12.0);
                                                                        F = new BasicDomain("F", 1, 2, 1, 1, 0.01, -12.0);
                                                                        G = new BasicDomain("G", 1, 2, 1, 1, 0.001, -12.0);
                                                                        X = new BasicDomain("X", 1, 2, 1, 1, 1.0E-4, -12.0);
                                                                        if (TestSurfacing.isEqual(X.getPerSequenceScore(), -12.0)) break block17;
                                                                        return false;
                                                                    }
                                                                    catch (Exception e) {
                                                                        e.printStackTrace(System.out);
                                                                        return false;
                                                                    }
                                                                }
                                                                BasicProtein mouse_1 = new BasicProtein("1", "mouse");
                                                                BasicProtein rabbit_1 = new BasicProtein("1", "rabbit");
                                                                BasicProtein ciona_1 = new BasicProtein("1", "ciona");
                                                                BasicProtein nemve_1 = new BasicProtein("1", "nemve");
                                                                mouse_1.addProteinDomain(A);
                                                                mouse_1.addProteinDomain(D);
                                                                mouse_1.addProteinDomain(E);
                                                                rabbit_1.addProteinDomain(B);
                                                                rabbit_1.addProteinDomain(E);
                                                                rabbit_1.addProteinDomain(F);
                                                                rabbit_1.addProteinDomain(F);
                                                                rabbit_1.addProteinDomain(F);
                                                                rabbit_1.addProteinDomain(F);
                                                                rabbit_1.addProteinDomain(F);
                                                                rabbit_1.addProteinDomain(F);
                                                                ciona_1.addProteinDomain(F);
                                                                ciona_1.addProteinDomain(G);
                                                                ciona_1.addProteinDomain(X);
                                                                nemve_1.addProteinDomain(D);
                                                                nemve_1.addProteinDomain(E);
                                                                nemve_1.addProteinDomain(F);
                                                                nemve_1.addProteinDomain(G);
                                                                ArrayList<Protein> protein_list_mouse = new ArrayList<Protein>();
                                                                ArrayList<Protein> protein_list_rabbit = new ArrayList<Protein>();
                                                                ArrayList<Protein> protein_list_ciona = new ArrayList<Protein>();
                                                                ArrayList<Protein> protein_list_nemve = new ArrayList<Protein>();
                                                                protein_list_mouse.add(mouse_1);
                                                                protein_list_rabbit.add(rabbit_1);
                                                                protein_list_ciona.add(ciona_1);
                                                                protein_list_nemve.add(nemve_1);
                                                                cdc_list = new ArrayList<GenomeWideCombinableDomains>();
                                                                cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
                                                                cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
                                                                cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
                                                                cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
                                                                calc = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false);
                                                                SortedSet<DomainSimilarity> sims = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, true, false);
                                                                sims_it = sims.iterator();
                                                                sa = (DomainSimilarity)sims_it.next();
                                                                if (sa.getDomainId().getId().equals("A")) break block18;
                                                                return false;
                                                            }
                                                            if (sa.getSpeciesData().size() == 1) break block19;
                                                            return false;
                                                        }
                                                        if (sa.getSpecies().contains(new BasicSpecies("mouse"))) break block20;
                                                        return false;
                                                    }
                                                    if (TestSurfacing.isEqual(sa.getMeanSimilarityScore(), 1.0)) break block21;
                                                    return false;
                                                }
                                                if (TestSurfacing.isEqual(sa.getStandardDeviationOfSimilarityScore(), 0.0)) break block22;
                                                return false;
                                            }
                                            if (TestSurfacing.isEqual(sa.getMaximalSimilarityScore(), 1.0)) break block23;
                                            return false;
                                        }
                                        if (TestSurfacing.isEqual(sa.getMinimalSimilarityScore(), 1.0)) break block24;
                                        return false;
                                    }
                                    if (sa.getN() == 0) break block25;
                                    return false;
                                }
                                if (sa.getMaximalDifference() == 0) break block26;
                                return false;
                            }
                            if (sa.getMaximalDifferenceInCounts() == 0) break block27;
                            return false;
                        }
                        sb = (DomainSimilarity)sims_it.next();
                        if (sb.getDomainId().getId().equals("B")) break block28;
                        return false;
                    }
                    if (sb.getSpeciesData().size() == 1) break block29;
                    return false;
                }
                if (sb.getSpecies().contains(new BasicSpecies("rabbit"))) break block30;
                return false;
            }
            SortedSet<DomainSimilarity> sims2 = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, true, true);
            Iterator sims_it2 = sims2.iterator();
            sa2 = (DomainSimilarity)sims_it2.next();
            if (sa2.getDomainId().getId().equals("D")) break block31;
            return false;
        }
        return sa2.getSpeciesData().size() == 2;
    }

    private static boolean testBasicDomainSimilarityCalculatorRemovalOfSingles() {
        BasicDomainSimilarityCalculator calc;
        BasicDomain B;
        BasicDomain A;
        block17: {
            ArrayList<GenomeWideCombinableDomains> cdc_list;
            block16: {
                DomainSimilarity sa;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    SortedSet<DomainSimilarity> sims;
                                    block10: {
                                        try {
                                            A = new BasicDomain("A", 1, 2, 1, 1, 0.15, -12.0);
                                            B = new BasicDomain("B", 1, 2, 1, 1, 0.2, -12.0);
                                            BasicProtein mouse_1 = new BasicProtein("1", "mouse");
                                            BasicProtein rabbit_1 = new BasicProtein("1", "rabbit");
                                            BasicProtein ciona_1 = new BasicProtein("1", "ciona");
                                            BasicProtein nemve_1 = new BasicProtein("1", "nemve");
                                            mouse_1.addProteinDomain(A);
                                            rabbit_1.addProteinDomain(A);
                                            ciona_1.addProteinDomain(A);
                                            ciona_1.addProteinDomain(A);
                                            ciona_1.addProteinDomain(A);
                                            ciona_1.addProteinDomain(A);
                                            ciona_1.addProteinDomain(A);
                                            nemve_1.addProteinDomain(A);
                                            ArrayList<Protein> protein_list_mouse = new ArrayList<Protein>();
                                            ArrayList<Protein> protein_list_rabbit = new ArrayList<Protein>();
                                            ArrayList<Protein> protein_list_ciona = new ArrayList<Protein>();
                                            ArrayList<Protein> protein_list_nemve = new ArrayList<Protein>();
                                            protein_list_mouse.add(mouse_1);
                                            protein_list_rabbit.add(rabbit_1);
                                            protein_list_ciona.add(ciona_1);
                                            protein_list_nemve.add(nemve_1);
                                            cdc_list = new ArrayList<GenomeWideCombinableDomains>();
                                            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse, true, new BasicSpecies("mouse")));
                                            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit, true, new BasicSpecies("rabbit")));
                                            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona, true, new BasicSpecies("ciona")));
                                            cdc_list.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve, true, new BasicSpecies("nemve")));
                                            calc = new BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, false, false);
                                            sims = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, false, true);
                                            if (sims.size() == 1) break block10;
                                            return false;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace(System.out);
                                            return false;
                                        }
                                    }
                                    Iterator sims_it = sims.iterator();
                                    sa = (DomainSimilarity)sims_it.next();
                                    if (sa.getDomainId().getId().equals("A")) break block11;
                                    return false;
                                }
                                if (sa.getSpeciesData().size() == 4) break block12;
                                return false;
                            }
                            if (sa.getSpecies().contains(new BasicSpecies("ciona"))) break block13;
                            return false;
                        }
                        if (sa.getSpecies().contains(new BasicSpecies("mouse"))) break block14;
                        return false;
                    }
                    if (sa.getSpecies().contains(new BasicSpecies("nemve"))) break block15;
                    return false;
                }
                if (sa.getSpecies().contains(new BasicSpecies("rabbit"))) break block16;
                return false;
            }
            SortedSet<DomainSimilarity> sims_ns = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list, true, true);
            if (sims_ns.size() == 0) break block17;
            return false;
        }
        BasicProtein mouse_2 = new BasicProtein("1", "mouse");
        BasicProtein rabbit_2 = new BasicProtein("1", "rabbit");
        BasicProtein ciona_2 = new BasicProtein("1", "ciona");
        BasicProtein nemve_2 = new BasicProtein("1", "nemve");
        mouse_2.addProteinDomain(A);
        rabbit_2.addProteinDomain(A);
        ciona_2.addProteinDomain(A);
        ciona_2.addProteinDomain(A);
        ciona_2.addProteinDomain(B);
        ciona_2.addProteinDomain(A);
        ciona_2.addProteinDomain(A);
        ciona_2.addProteinDomain(A);
        nemve_2.addProteinDomain(A);
        ArrayList<Protein> protein_list_mouse2 = new ArrayList<Protein>();
        ArrayList<Protein> protein_list_rabbit2 = new ArrayList<Protein>();
        ArrayList<Protein> protein_list_ciona2 = new ArrayList<Protein>();
        ArrayList<Protein> protein_list_nemve2 = new ArrayList<Protein>();
        protein_list_mouse2.add(mouse_2);
        protein_list_rabbit2.add(rabbit_2);
        protein_list_ciona2.add(ciona_2);
        protein_list_nemve2.add(nemve_2);
        ArrayList<GenomeWideCombinableDomains> cdc_list2 = new ArrayList<GenomeWideCombinableDomains>();
        cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_mouse2, true, new BasicSpecies("mouse")));
        cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_rabbit2, true, new BasicSpecies("rabbit")));
        cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_ciona2, true, new BasicSpecies("ciona")));
        cdc_list2.add(BasicGenomeWideCombinableDomains.createInstance(protein_list_nemve2, true, new BasicSpecies("nemve")));
        SortedSet<DomainSimilarity> sims2 = calc.calculateSimilarities(new CombinationsBasedPairwiseDomainSimilarityCalculator(), cdc_list2, true, true);
        return sims2.size() == 1;
    }

    private static boolean testBasicProtein() {
        ArrayList<DomainId> domains_ids;
        BasicProtein p;
        block63: {
            block62: {
                block61: {
                    block60: {
                        block59: {
                            block58: {
                                block57: {
                                    block56: {
                                        block55: {
                                            block54: {
                                                block53: {
                                                    block52: {
                                                        block51: {
                                                            block50: {
                                                                block49: {
                                                                    block48: {
                                                                        block47: {
                                                                            block46: {
                                                                                block45: {
                                                                                    block44: {
                                                                                        block43: {
                                                                                            block42: {
                                                                                                block41: {
                                                                                                    block40: {
                                                                                                        block39: {
                                                                                                            block38: {
                                                                                                                block37: {
                                                                                                                    block36: {
                                                                                                                        block35: {
                                                                                                                            block34: {
                                                                                                                                block33: {
                                                                                                                                    try {
                                                                                                                                        BasicDomain A0 = new BasicDomain("A", 0, 25, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain A10 = new BasicDomain("A", 10, 11, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain B15 = new BasicDomain("B", 11, 16, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain A20 = new BasicDomain("A", 20, 100, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain B25 = new BasicDomain("B", 25, 26, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain A30 = new BasicDomain("A", 30, 31, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain B35 = new BasicDomain("B", 31, 40, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain B40 = new BasicDomain("B", 40, 600, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain C50 = new BasicDomain("C", 50, 59, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain A60 = new BasicDomain("A", 60, 395, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain C70 = new BasicDomain("C", 70, 71, 1, 4, 0.1, -12.0);
                                                                                                                                        BasicDomain D80 = new BasicDomain("D", 80, 81, 1, 4, 0.1, -12.0);
                                                                                                                                        p = new BasicProtein("p", "owl");
                                                                                                                                        p.addProteinDomain(B15);
                                                                                                                                        p.addProteinDomain(C50);
                                                                                                                                        p.addProteinDomain(A60);
                                                                                                                                        p.addProteinDomain(A30);
                                                                                                                                        p.addProteinDomain(C70);
                                                                                                                                        p.addProteinDomain(B35);
                                                                                                                                        p.addProteinDomain(B40);
                                                                                                                                        p.addProteinDomain(A0);
                                                                                                                                        p.addProteinDomain(A10);
                                                                                                                                        p.addProteinDomain(A20);
                                                                                                                                        p.addProteinDomain(B25);
                                                                                                                                        p.addProteinDomain(D80);
                                                                                                                                        domains_ids = new ArrayList<DomainId>();
                                                                                                                                        domains_ids.add(new DomainId("A"));
                                                                                                                                        domains_ids.add(new DomainId("B"));
                                                                                                                                        domains_ids.add(new DomainId("C"));
                                                                                                                                        if (p.contains(domains_ids, false)) break block33;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    catch (Exception e) {
                                                                                                                                        e.printStackTrace(System.out);
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                if (p.contains(domains_ids, true)) break block34;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            domains_ids.add(new DomainId("X"));
                                                                                                                            if (!p.contains(domains_ids, false)) break block35;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (!p.contains(domains_ids, true)) break block36;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    domains_ids = new ArrayList();
                                                                                                                    domains_ids.add(new DomainId("A"));
                                                                                                                    domains_ids.add(new DomainId("C"));
                                                                                                                    domains_ids.add(new DomainId("D"));
                                                                                                                    if (p.contains(domains_ids, false)) break block37;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (p.contains(domains_ids, true)) break block38;
                                                                                                                return false;
                                                                                                            }
                                                                                                            domains_ids = new ArrayList();
                                                                                                            domains_ids.add(new DomainId("A"));
                                                                                                            domains_ids.add(new DomainId("D"));
                                                                                                            domains_ids.add(new DomainId("C"));
                                                                                                            if (p.contains(domains_ids, false)) break block39;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (!p.contains(domains_ids, true)) break block40;
                                                                                                        return false;
                                                                                                    }
                                                                                                    domains_ids = new ArrayList();
                                                                                                    domains_ids.add(new DomainId("A"));
                                                                                                    domains_ids.add(new DomainId("A"));
                                                                                                    domains_ids.add(new DomainId("B"));
                                                                                                    if (p.contains(domains_ids, false)) break block41;
                                                                                                    return false;
                                                                                                }
                                                                                                if (p.contains(domains_ids, true)) break block42;
                                                                                                return false;
                                                                                            }
                                                                                            domains_ids = new ArrayList();
                                                                                            domains_ids.add(new DomainId("A"));
                                                                                            domains_ids.add(new DomainId("A"));
                                                                                            domains_ids.add(new DomainId("A"));
                                                                                            domains_ids.add(new DomainId("B"));
                                                                                            domains_ids.add(new DomainId("B"));
                                                                                            if (p.contains(domains_ids, false)) break block43;
                                                                                            return false;
                                                                                        }
                                                                                        if (p.contains(domains_ids, true)) break block44;
                                                                                        return false;
                                                                                    }
                                                                                    domains_ids = new ArrayList();
                                                                                    domains_ids.add(new DomainId("A"));
                                                                                    domains_ids.add(new DomainId("A"));
                                                                                    domains_ids.add(new DomainId("A"));
                                                                                    domains_ids.add(new DomainId("A"));
                                                                                    domains_ids.add(new DomainId("B"));
                                                                                    domains_ids.add(new DomainId("B"));
                                                                                    if (p.contains(domains_ids, false)) break block45;
                                                                                    return false;
                                                                                }
                                                                                if (p.contains(domains_ids, true)) break block46;
                                                                                return false;
                                                                            }
                                                                            domains_ids = new ArrayList();
                                                                            domains_ids.add(new DomainId("A"));
                                                                            domains_ids.add(new DomainId("A"));
                                                                            domains_ids.add(new DomainId("A"));
                                                                            domains_ids.add(new DomainId("A"));
                                                                            domains_ids.add(new DomainId("A"));
                                                                            domains_ids.add(new DomainId("B"));
                                                                            domains_ids.add(new DomainId("B"));
                                                                            if (p.contains(domains_ids, false)) break block47;
                                                                            return false;
                                                                        }
                                                                        if (!p.contains(domains_ids, true)) break block48;
                                                                        return false;
                                                                    }
                                                                    domains_ids = new ArrayList();
                                                                    domains_ids.add(new DomainId("A"));
                                                                    domains_ids.add(new DomainId("A"));
                                                                    domains_ids.add(new DomainId("B"));
                                                                    domains_ids.add(new DomainId("A"));
                                                                    domains_ids.add(new DomainId("B"));
                                                                    domains_ids.add(new DomainId("A"));
                                                                    domains_ids.add(new DomainId("B"));
                                                                    domains_ids.add(new DomainId("B"));
                                                                    domains_ids.add(new DomainId("C"));
                                                                    domains_ids.add(new DomainId("A"));
                                                                    domains_ids.add(new DomainId("C"));
                                                                    domains_ids.add(new DomainId("D"));
                                                                    if (p.contains(domains_ids, false)) break block49;
                                                                    return false;
                                                                }
                                                                if (p.contains(domains_ids, true)) break block50;
                                                                return false;
                                                            }
                                                            domains_ids = new ArrayList();
                                                            domains_ids.add(new DomainId("A"));
                                                            domains_ids.add(new DomainId("B"));
                                                            domains_ids.add(new DomainId("A"));
                                                            domains_ids.add(new DomainId("B"));
                                                            domains_ids.add(new DomainId("A"));
                                                            domains_ids.add(new DomainId("B"));
                                                            domains_ids.add(new DomainId("B"));
                                                            domains_ids.add(new DomainId("A"));
                                                            domains_ids.add(new DomainId("C"));
                                                            domains_ids.add(new DomainId("D"));
                                                            if (p.contains(domains_ids, false)) break block51;
                                                            return false;
                                                        }
                                                        if (p.contains(domains_ids, true)) break block52;
                                                        return false;
                                                    }
                                                    domains_ids = new ArrayList();
                                                    domains_ids.add(new DomainId("A"));
                                                    domains_ids.add(new DomainId("A"));
                                                    domains_ids.add(new DomainId("B"));
                                                    domains_ids.add(new DomainId("A"));
                                                    domains_ids.add(new DomainId("B"));
                                                    domains_ids.add(new DomainId("A"));
                                                    domains_ids.add(new DomainId("B"));
                                                    domains_ids.add(new DomainId("B"));
                                                    domains_ids.add(new DomainId("C"));
                                                    domains_ids.add(new DomainId("C"));
                                                    domains_ids.add(new DomainId("A"));
                                                    domains_ids.add(new DomainId("C"));
                                                    domains_ids.add(new DomainId("D"));
                                                    if (p.contains(domains_ids, false)) break block53;
                                                    return false;
                                                }
                                                if (!p.contains(domains_ids, true)) break block54;
                                                return false;
                                            }
                                            domains_ids = new ArrayList();
                                            domains_ids.add(new DomainId("A"));
                                            domains_ids.add(new DomainId("A"));
                                            domains_ids.add(new DomainId("A"));
                                            domains_ids.add(new DomainId("B"));
                                            domains_ids.add(new DomainId("A"));
                                            domains_ids.add(new DomainId("B"));
                                            domains_ids.add(new DomainId("A"));
                                            domains_ids.add(new DomainId("B"));
                                            domains_ids.add(new DomainId("B"));
                                            domains_ids.add(new DomainId("C"));
                                            domains_ids.add(new DomainId("A"));
                                            domains_ids.add(new DomainId("C"));
                                            domains_ids.add(new DomainId("D"));
                                            if (p.contains(domains_ids, false)) break block55;
                                            return false;
                                        }
                                        if (!p.contains(domains_ids, true)) break block56;
                                        return false;
                                    }
                                    domains_ids = new ArrayList();
                                    domains_ids.add(new DomainId("A"));
                                    domains_ids.add(new DomainId("A"));
                                    domains_ids.add(new DomainId("B"));
                                    domains_ids.add(new DomainId("A"));
                                    domains_ids.add(new DomainId("B"));
                                    domains_ids.add(new DomainId("A"));
                                    domains_ids.add(new DomainId("B"));
                                    domains_ids.add(new DomainId("B"));
                                    domains_ids.add(new DomainId("A"));
                                    domains_ids.add(new DomainId("D"));
                                    if (p.contains(domains_ids, false)) break block57;
                                    return false;
                                }
                                if (p.contains(domains_ids, true)) break block58;
                                return false;
                            }
                            domains_ids = new ArrayList();
                            domains_ids.add(new DomainId("A"));
                            domains_ids.add(new DomainId("A"));
                            domains_ids.add(new DomainId("B"));
                            domains_ids.add(new DomainId("A"));
                            domains_ids.add(new DomainId("B"));
                            domains_ids.add(new DomainId("A"));
                            domains_ids.add(new DomainId("B"));
                            domains_ids.add(new DomainId("B"));
                            domains_ids.add(new DomainId("C"));
                            domains_ids.add(new DomainId("A"));
                            domains_ids.add(new DomainId("C"));
                            domains_ids.add(new DomainId("D"));
                            domains_ids.add(new DomainId("X"));
                            if (!p.contains(domains_ids, false)) break block59;
                            return false;
                        }
                        if (!p.contains(domains_ids, true)) break block60;
                        return false;
                    }
                    domains_ids = new ArrayList();
                    domains_ids.add(new DomainId("X"));
                    domains_ids.add(new DomainId("A"));
                    domains_ids.add(new DomainId("A"));
                    domains_ids.add(new DomainId("B"));
                    domains_ids.add(new DomainId("A"));
                    domains_ids.add(new DomainId("B"));
                    domains_ids.add(new DomainId("A"));
                    domains_ids.add(new DomainId("B"));
                    domains_ids.add(new DomainId("B"));
                    domains_ids.add(new DomainId("C"));
                    domains_ids.add(new DomainId("A"));
                    domains_ids.add(new DomainId("C"));
                    domains_ids.add(new DomainId("D"));
                    if (!p.contains(domains_ids, false)) break block61;
                    return false;
                }
                if (!p.contains(domains_ids, true)) break block62;
                return false;
            }
            domains_ids = new ArrayList();
            domains_ids.add(new DomainId("A"));
            domains_ids.add(new DomainId("A"));
            domains_ids.add(new DomainId("B"));
            domains_ids.add(new DomainId("A"));
            domains_ids.add(new DomainId("B"));
            domains_ids.add(new DomainId("B"));
            domains_ids.add(new DomainId("A"));
            domains_ids.add(new DomainId("B"));
            domains_ids.add(new DomainId("C"));
            domains_ids.add(new DomainId("A"));
            domains_ids.add(new DomainId("C"));
            domains_ids.add(new DomainId("D"));
            if (p.contains(domains_ids, false)) break block63;
            return false;
        }
        return !p.contains(domains_ids, true);
    }

    private static boolean testBinaryDomainCombination() {
        DirectedBinaryDomainCombination bb;
        DirectedBinaryDomainCombination ab;
        block33: {
            DirectedBinaryDomainCombination aa;
            block32: {
                block31: {
                    DirectedBinaryDomainCombination ba;
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    BasicBinaryDomainCombination s8;
                                    BasicBinaryDomainCombination s7;
                                    BasicBinaryDomainCombination s6;
                                    BasicBinaryDomainCombination s5;
                                    BasicBinaryDomainCombination s4;
                                    BasicBinaryDomainCombination s3;
                                    BasicBinaryDomainCombination s2;
                                    BasicBinaryDomainCombination s1;
                                    BasicBinaryDomainCombination s0;
                                    block26: {
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block22: {
                                                        block21: {
                                                            block20: {
                                                                block19: {
                                                                    block18: {
                                                                        try {
                                                                            s0 = new BasicBinaryDomainCombination("a", "a");
                                                                            s1 = new BasicBinaryDomainCombination("b", "a");
                                                                            s2 = new BasicBinaryDomainCombination("a", "b");
                                                                            s3 = new BasicBinaryDomainCombination("B", "A");
                                                                            s4 = new BasicBinaryDomainCombination("A", "B");
                                                                            s5 = new BasicBinaryDomainCombination("c", "a");
                                                                            s6 = new BasicBinaryDomainCombination("b", "c");
                                                                            s7 = new BasicBinaryDomainCombination("d", "a");
                                                                            s8 = new BasicBinaryDomainCombination("b", "d");
                                                                            BinaryDomainCombination s9 = BasicBinaryDomainCombination.createInstance(" z-z=a-aa ");
                                                                            if (s9.toString().equals("a-aa=z-z")) break block18;
                                                                            return false;
                                                                        }
                                                                        catch (Exception e) {
                                                                            e.printStackTrace(System.out);
                                                                            return false;
                                                                        }
                                                                    }
                                                                    if (s0.equals(s0)) break block19;
                                                                    return false;
                                                                }
                                                                if (!s0.equals(s1)) break block20;
                                                                return false;
                                                            }
                                                            if (!s1.equals(s0)) break block21;
                                                            return false;
                                                        }
                                                        if (s1.equals(s2)) break block22;
                                                        return false;
                                                    }
                                                    if (s2.equals(s1)) break block23;
                                                    return false;
                                                }
                                                if (!s2.equals(s3)) break block24;
                                                return false;
                                            }
                                            if (!s2.equals(s3)) break block25;
                                            return false;
                                        }
                                        if (!s2.equals(s4)) break block26;
                                        return false;
                                    }
                                    TreeSet<BasicBinaryDomainCombination> sorted = new TreeSet<BasicBinaryDomainCombination>();
                                    sorted.add(s0);
                                    sorted.add(s1);
                                    sorted.add(s2);
                                    sorted.add(s3);
                                    sorted.add(s3);
                                    sorted.add(s3);
                                    sorted.add(s4);
                                    sorted.add(s5);
                                    sorted.add(s6);
                                    sorted.add(s7);
                                    sorted.add(s7);
                                    sorted.add(s8);
                                    if (sorted.size() == 6) break block27;
                                    return false;
                                }
                                aa = new DirectedBinaryDomainCombination("a", "a");
                                ba = new DirectedBinaryDomainCombination("b", "a");
                                ab = new DirectedBinaryDomainCombination("a", "b");
                                bb = new DirectedBinaryDomainCombination("b", "b");
                                if (aa.equals(aa)) break block28;
                                return false;
                            }
                            if (!aa.equals(bb)) break block29;
                            return false;
                        }
                        if (!ab.equals(ba)) break block30;
                        return false;
                    }
                    if (!ba.equals(ab)) break block31;
                    return false;
                }
                if (ab.equals(ab)) break block32;
                return false;
            }
            if (!ab.equals(aa)) break block33;
            return false;
        }
        return !ab.equals(bb);
    }

    private static boolean testBinaryStateMatrixToGainLossMatrix(File test_dir) {
        CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_matrix_0;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        DomainParsimonyCalculator dom_pars;
                                        block15: {
                                            block14: {
                                                block13: {
                                                    CharacterStateMatrix.BinaryStates I = CharacterStateMatrix.BinaryStates.PRESENT;
                                                    CharacterStateMatrix.BinaryStates O = CharacterStateMatrix.BinaryStates.ABSENT;
                                                    try {
                                                        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> binary_states_matrix_0 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(7, 6);
                                                        binary_states_matrix_0.setIdentifier(0, "A");
                                                        binary_states_matrix_0.setIdentifier(1, "B");
                                                        binary_states_matrix_0.setIdentifier(2, "C");
                                                        binary_states_matrix_0.setIdentifier(3, "D");
                                                        binary_states_matrix_0.setIdentifier(4, "1");
                                                        binary_states_matrix_0.setIdentifier(5, "2");
                                                        binary_states_matrix_0.setIdentifier(6, "3");
                                                        binary_states_matrix_0.setState(0, 0, O);
                                                        binary_states_matrix_0.setState(1, 0, O);
                                                        binary_states_matrix_0.setState(2, 0, O);
                                                        binary_states_matrix_0.setState(3, 0, O);
                                                        binary_states_matrix_0.setState(4, 0, O);
                                                        binary_states_matrix_0.setState(5, 0, O);
                                                        binary_states_matrix_0.setState(6, 0, O);
                                                        binary_states_matrix_0.setState(0, 1, I);
                                                        binary_states_matrix_0.setState(1, 1, O);
                                                        binary_states_matrix_0.setState(2, 1, O);
                                                        binary_states_matrix_0.setState(3, 1, O);
                                                        binary_states_matrix_0.setState(4, 1, O);
                                                        binary_states_matrix_0.setState(5, 1, O);
                                                        binary_states_matrix_0.setState(6, 1, O);
                                                        binary_states_matrix_0.setState(0, 2, O);
                                                        binary_states_matrix_0.setState(1, 2, O);
                                                        binary_states_matrix_0.setState(2, 2, O);
                                                        binary_states_matrix_0.setState(3, 2, O);
                                                        binary_states_matrix_0.setState(4, 2, I);
                                                        binary_states_matrix_0.setState(5, 2, O);
                                                        binary_states_matrix_0.setState(6, 2, O);
                                                        binary_states_matrix_0.setState(0, 3, I);
                                                        binary_states_matrix_0.setState(1, 3, O);
                                                        binary_states_matrix_0.setState(2, 3, O);
                                                        binary_states_matrix_0.setState(3, 3, O);
                                                        binary_states_matrix_0.setState(4, 3, I);
                                                        binary_states_matrix_0.setState(5, 3, O);
                                                        binary_states_matrix_0.setState(6, 3, I);
                                                        binary_states_matrix_0.setState(0, 4, I);
                                                        binary_states_matrix_0.setState(1, 4, O);
                                                        binary_states_matrix_0.setState(2, 4, I);
                                                        binary_states_matrix_0.setState(3, 4, O);
                                                        binary_states_matrix_0.setState(4, 4, I);
                                                        binary_states_matrix_0.setState(5, 4, O);
                                                        binary_states_matrix_0.setState(6, 4, I);
                                                        binary_states_matrix_0.setState(0, 5, I);
                                                        binary_states_matrix_0.setState(1, 5, I);
                                                        binary_states_matrix_0.setState(2, 5, I);
                                                        binary_states_matrix_0.setState(3, 5, I);
                                                        binary_states_matrix_0.setState(4, 5, I);
                                                        binary_states_matrix_0.setState(5, 5, I);
                                                        binary_states_matrix_0.setState(6, 5, I);
                                                        String[] character_labels_0 = new String[]{"first", "second", "third", "forth", "fifth", "sixth"};
                                                        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                                                        Phylogeny phylogeny_0 = factory.create("(((A,B)1,C)2,D)3", new NHXParser())[0];
                                                        dom_pars = DomainParsimonyCalculator.createInstance(phylogeny_0);
                                                        dom_pars.executeOnGivenBinaryStatesMatrix(binary_states_matrix_0, character_labels_0);
                                                        gl_matrix_0 = dom_pars.getGainLossMatrix();
                                                        if (dom_pars.getCost() == 13) break block13;
                                                        return false;
                                                    }
                                                    catch (Exception e) {
                                                        e.printStackTrace(System.out);
                                                        return false;
                                                    }
                                                }
                                                if (dom_pars.getTotalGains() == 5) break block14;
                                                return false;
                                            }
                                            if (dom_pars.getTotalLosses() == 8) break block15;
                                            return false;
                                        }
                                        if (dom_pars.getTotalUnchanged() == 29) break block16;
                                        return false;
                                    }
                                    if (gl_matrix_0.getState("A", 1) == CharacterStateMatrix.GainLossStates.GAIN) break block17;
                                    return false;
                                }
                                if (gl_matrix_0.getState("A", 4) == CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT) break block18;
                                return false;
                            }
                            if (gl_matrix_0.getState("B", 4) == CharacterStateMatrix.GainLossStates.LOSS) break block19;
                            return false;
                        }
                        if (gl_matrix_0.getState("C", 4) == CharacterStateMatrix.GainLossStates.GAIN) break block20;
                        return false;
                    }
                    if (gl_matrix_0.getState("D", 4) == CharacterStateMatrix.GainLossStates.LOSS) break block21;
                    return false;
                }
                if (gl_matrix_0.getState("1", 4) == CharacterStateMatrix.GainLossStates.GAIN) break block22;
                return false;
            }
            if (gl_matrix_0.getState("2", 4) == CharacterStateMatrix.GainLossStates.LOSS) break block23;
            return false;
        }
        return gl_matrix_0.getState("3", 4) == CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
    }

    private static boolean testCombinableDomains() {
        BasicCombinableDomains cd1;
        block47: {
            block46: {
                block45: {
                    BasicDomain key1;
                    block44: {
                        BasicDomain c1;
                        block43: {
                            BasicDomain b1;
                            block42: {
                                BasicDomain a1;
                                block41: {
                                    block40: {
                                        BasicBinaryDomainCombination s4;
                                        BasicCombinableDomains cd0;
                                        block39: {
                                            BasicBinaryDomainCombination s3;
                                            block38: {
                                                BasicBinaryDomainCombination s2;
                                                block37: {
                                                    BasicBinaryDomainCombination s1;
                                                    block36: {
                                                        block35: {
                                                            block34: {
                                                                BasicDomain key0;
                                                                block33: {
                                                                    BasicDomain c;
                                                                    block32: {
                                                                        BasicDomain b;
                                                                        block31: {
                                                                            BasicDomain a;
                                                                            block30: {
                                                                                block29: {
                                                                                    block28: {
                                                                                        block27: {
                                                                                            block26: {
                                                                                                block25: {
                                                                                                    try {
                                                                                                        key0 = new BasicDomain("key0", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                        a = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                        b = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                        c = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                        cd0 = new BasicCombinableDomains(key0.getDomainId(), new BasicSpecies("eel"));
                                                                                                        cd0.addCombinableDomain(a.getDomainId());
                                                                                                        cd0.addCombinableDomain(b.getDomainId());
                                                                                                        cd0.addCombinableDomain(b.getDomainId());
                                                                                                        cd0.addCombinableDomain(c.getDomainId());
                                                                                                        cd0.addCombinableDomain(c.getDomainId());
                                                                                                        cd0.addCombinableDomain(c.getDomainId());
                                                                                                        if (cd0.getNumberOfCombinableDomains() == 3) break block25;
                                                                                                        return false;
                                                                                                    }
                                                                                                    catch (Exception e) {
                                                                                                        e.printStackTrace(System.out);
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                                if (cd0.getNumberOfProteinsExhibitingCombination(a.getDomainId()) == 1) break block26;
                                                                                                return false;
                                                                                            }
                                                                                            if (cd0.getNumberOfProteinsExhibitingCombination(b.getDomainId()) == 2) break block27;
                                                                                            return false;
                                                                                        }
                                                                                        if (cd0.getNumberOfProteinsExhibitingCombination(c.getDomainId()) == 3) break block28;
                                                                                        return false;
                                                                                    }
                                                                                    if (cd0.getNumberOfProteinsExhibitingCombination(key0.getDomainId()) == 0) break block29;
                                                                                    return false;
                                                                                }
                                                                                if (cd0.getAllDomains().size() == 4) break block30;
                                                                                return false;
                                                                            }
                                                                            if (cd0.getAllDomains().contains(a.getDomainId())) break block31;
                                                                            return false;
                                                                        }
                                                                        if (cd0.getAllDomains().contains(b.getDomainId())) break block32;
                                                                        return false;
                                                                    }
                                                                    if (cd0.getAllDomains().contains(c.getDomainId())) break block33;
                                                                    return false;
                                                                }
                                                                if (cd0.getAllDomains().contains(key0.getDomainId())) break block34;
                                                                return false;
                                                            }
                                                            if (cd0.toBinaryDomainCombinations().size() == 3) break block35;
                                                            return false;
                                                        }
                                                        BasicBinaryDomainCombination s0 = new BasicBinaryDomainCombination("key0", "a");
                                                        s1 = new BasicBinaryDomainCombination("b", "key0");
                                                        s2 = new BasicBinaryDomainCombination("key0", "c");
                                                        s3 = new BasicBinaryDomainCombination("key0", "cc");
                                                        s4 = new BasicBinaryDomainCombination("c", "key0");
                                                        if (cd0.toBinaryDomainCombinations().contains(s0)) break block36;
                                                        return false;
                                                    }
                                                    if (cd0.toBinaryDomainCombinations().contains(s1)) break block37;
                                                    return false;
                                                }
                                                if (cd0.toBinaryDomainCombinations().contains(s2)) break block38;
                                                return false;
                                            }
                                            if (!cd0.toBinaryDomainCombinations().contains(s3)) break block39;
                                            return false;
                                        }
                                        if (cd0.toBinaryDomainCombinations().contains(s4)) break block40;
                                        return false;
                                    }
                                    key1 = new BasicDomain("key1", 23, 25, 1, 4, 0.1, -12.0);
                                    a1 = new BasicDomain("a1", 23, 25, 1, 4, 0.1, -12.0);
                                    b1 = new BasicDomain("b1", 23, 25, 1, 4, 0.1, -12.0);
                                    c1 = new BasicDomain("c1", 23, 25, 1, 4, 0.1, -12.0);
                                    cd1 = new BasicCombinableDomains(key1.getDomainId(), new BasicSpecies("eel"));
                                    cd1.addCombinableDomain(a1.getDomainId());
                                    cd1.addCombinableDomain(b1.getDomainId());
                                    cd1.addCombinableDomain(c1.getDomainId());
                                    cd1.addCombinableDomain(key1.getDomainId());
                                    if (cd1.getNumberOfCombinableDomains() == 4) break block41;
                                    return false;
                                }
                                if (cd1.getNumberOfProteinsExhibitingCombination(a1.getDomainId()) == 1) break block42;
                                return false;
                            }
                            if (cd1.getNumberOfProteinsExhibitingCombination(b1.getDomainId()) == 1) break block43;
                            return false;
                        }
                        if (cd1.getNumberOfProteinsExhibitingCombination(c1.getDomainId()) == 1) break block44;
                        return false;
                    }
                    if (cd1.getNumberOfProteinsExhibitingCombination(key1.getDomainId()) == 1) break block45;
                    return false;
                }
                if (cd1.getAllDomains().size() == 4) break block46;
                return false;
            }
            if (cd1.toBinaryDomainCombinations().size() == 4) break block47;
            return false;
        }
        BasicBinaryDomainCombination kk = new BasicBinaryDomainCombination("key1", "key1");
        return cd1.toBinaryDomainCombinations().contains(kk);
    }

    private static boolean testCombinationsBasedPairwiseSimilarityCalculator() {
        BasicCombinableDomains four;
        BasicCombinableDomains three;
        CombinationsBasedPairwiseDomainSimilarityCalculator calc;
        block21: {
            block20: {
                PairwiseDomainSimilarity s3;
                block19: {
                    block18: {
                        BasicCombinableDomains two;
                        BasicCombinableDomains one;
                        block17: {
                            PairwiseDomainSimilarity s2;
                            block16: {
                                block15: {
                                    BasicDomain c;
                                    BasicDomain b;
                                    block14: {
                                        PairwiseDomainSimilarity s1;
                                        block13: {
                                            block12: {
                                                try {
                                                    BasicDomain a = new BasicDomain("A", 1, 25, 1, 4, 0.1, -12.0);
                                                    b = new BasicDomain("B", 2, 25, 1, 4, 0.1, -12.0);
                                                    c = new BasicDomain("C", 3, 25, 1, 4, 0.1, -12.0);
                                                    BasicDomain one_key = new BasicDomain("bcl2", 4, 25, 1, 4, 0.1, -12.0);
                                                    BasicDomain two_key = new BasicDomain("bcl2", 5, 25, 1, 4, 0.1, -12.0);
                                                    one = new BasicCombinableDomains(one_key.getDomainId(), new BasicSpecies("mouse"));
                                                    two = new BasicCombinableDomains(two_key.getDomainId(), new BasicSpecies("rabbit"));
                                                    one.addCombinableDomain(a.getDomainId());
                                                    one.addCombinableDomain(a.getDomainId());
                                                    two.addCombinableDomain(new BasicDomain("A", 1, 5, 1, 4, 0.1, -12.0).getDomainId());
                                                    two.addCombinableDomain(b.getDomainId());
                                                    two.addCombinableDomain(c.getDomainId());
                                                    calc = new CombinationsBasedPairwiseDomainSimilarityCalculator();
                                                    s1 = calc.calculateSimilarity(one, two);
                                                    if (TestSurfacing.isEqual(s1.getSimilarityScore(), 0.3333333333333333)) break block12;
                                                    return false;
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace(System.out);
                                                    return false;
                                                }
                                            }
                                            if (s1.getDifferenceInCounts() == -2) break block13;
                                            return false;
                                        }
                                        if (((CombinationsBasedPairwiseDomainSimilarity)s1).getNumberOfDifferentDomains() == 2) break block14;
                                        return false;
                                    }
                                    one.addCombinableDomain(b.getDomainId());
                                    one.addCombinableDomain(c.getDomainId());
                                    s2 = calc.calculateSimilarity(one, two);
                                    if (TestSurfacing.isEqual(s2.getSimilarityScore(), 1.0)) break block15;
                                    return false;
                                }
                                if (s2.getDifferenceInCounts() == 0) break block16;
                                return false;
                            }
                            if (((CombinationsBasedPairwiseDomainSimilarity)s2).getNumberOfDifferentDomains() == 0) break block17;
                            return false;
                        }
                        BasicDomain d = new BasicDomain("D", 23, 25, 1, 4, 0.1, -12.0);
                        BasicDomain e = new BasicDomain("E", 23, 25, 1, 4, 0.1, -12.0);
                        BasicDomain f = new BasicDomain("F", 23, 25, 1, 4, 0.1, -12.0);
                        one.addCombinableDomain(d.getDomainId());
                        one.addCombinableDomain(d.getDomainId());
                        one.addCombinableDomain(e.getDomainId());
                        one.addCombinableDomain(f.getDomainId());
                        s3 = calc.calculateSimilarity(one, two);
                        if (TestSurfacing.isEqual(s3.getSimilarityScore(), 0.5)) break block18;
                        return false;
                    }
                    if (s3.getDifferenceInCounts() == 3) break block19;
                    return false;
                }
                if (((CombinationsBasedPairwiseDomainSimilarity)s3).getNumberOfDifferentDomains() == 3) break block20;
                return false;
            }
            BasicDomain aaa = new BasicDomain("aaa", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain bbb = new BasicDomain("bbb", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain three_key = new BasicDomain("bcl2", 23, 25, 1, 4, 0.1, -12.0);
            BasicDomain four_key = new BasicDomain("bcl2", 23, 25, 1, 4, 0.1, -12.0);
            three = new BasicCombinableDomains(three_key.getDomainId(), new BasicSpecies("mouse"));
            four = new BasicCombinableDomains(four_key.getDomainId(), new BasicSpecies("rabbit"));
            three.addCombinableDomain(aaa.getDomainId());
            four.addCombinableDomain(bbb.getDomainId());
            CombinationsBasedPairwiseDomainSimilarityCalculator calc2 = new CombinationsBasedPairwiseDomainSimilarityCalculator();
            PairwiseDomainSimilarity s4 = calc2.calculateSimilarity(three, four);
            if (TestSurfacing.isEqual(s4.getSimilarityScore(), 0.0)) break block21;
            return false;
        }
        BasicDomain aaa2 = new BasicDomain("aaa", 23, 25, 1, 4, 0.1, -12.0);
        four.addCombinableDomain(aaa2.getDomainId());
        PairwiseDomainSimilarity s5 = calc.calculateSimilarity(three, four);
        return TestSurfacing.isEqual(s5.getSimilarityScore(), 0.5);
    }

    private static boolean testCopyNumberBasedPairwiseSimilarityCalculator() {
        PairwiseDomainSimilarity s1;
        block11: {
            DomainCountsBasedPairwiseSimilarityCalculator calc;
            BasicCombinableDomains two;
            BasicCombinableDomains one;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            try {
                                BasicDomain one_key = new BasicDomain("bcl2", 4, 25, 1, 4, 0.1, -12.0);
                                BasicDomain two_key = new BasicDomain("bcl2", 5, 25, 1, 4, 0.1, -12.0);
                                one = new BasicCombinableDomains(one_key.getDomainId(), new BasicSpecies("mouse"));
                                two = new BasicCombinableDomains(two_key.getDomainId(), new BasicSpecies("rabbit"));
                                one.setKeyDomainCount(2);
                                two.setKeyDomainCount(3);
                                calc = new DomainCountsBasedPairwiseSimilarityCalculator();
                                s1 = calc.calculateSimilarity(one, two);
                                if (TestSurfacing.isEqual(s1.getSimilarityScore(), 0.8)) break block7;
                                return false;
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                                return false;
                            }
                        }
                        if (s1.getDifferenceInCounts() == -1) break block8;
                        return false;
                    }
                    one.setKeyDomainCount(1);
                    two.setKeyDomainCount(1);
                    s1 = calc.calculateSimilarity(one, two);
                    if (TestSurfacing.isEqual(s1.getSimilarityScore(), 1.0)) break block9;
                    return false;
                }
                if (s1.getDifferenceInCounts() == 0) break block10;
                return false;
            }
            one.setKeyDomainCount(1);
            two.setKeyDomainCount(1000);
            s1 = calc.calculateSimilarity(one, two);
            if (TestSurfacing.isEqual(s1.getSimilarityScore(), 0.0019980019980020414)) break block11;
            return false;
        }
        return s1.getDifferenceInCounts() == -999;
    }

    private static boolean testDirectedCombinableDomains() {
        DirectedCombinableDomains cd1;
        block55: {
            block54: {
                block53: {
                    BasicDomain key1;
                    block52: {
                        BasicDomain c1;
                        block51: {
                            BasicDomain b1;
                            block50: {
                                BasicDomain a1;
                                block49: {
                                    block48: {
                                        DirectedBinaryDomainCombination s8;
                                        DirectedCombinableDomains cd0;
                                        block47: {
                                            DirectedBinaryDomainCombination s7;
                                            block46: {
                                                DirectedBinaryDomainCombination s6;
                                                block45: {
                                                    DirectedBinaryDomainCombination s5;
                                                    block44: {
                                                        DirectedBinaryDomainCombination s4;
                                                        block43: {
                                                            DirectedBinaryDomainCombination s3;
                                                            block42: {
                                                                DirectedBinaryDomainCombination s2;
                                                                block41: {
                                                                    DirectedBinaryDomainCombination s1;
                                                                    block40: {
                                                                        block39: {
                                                                            block38: {
                                                                                BasicDomain key0;
                                                                                block37: {
                                                                                    BasicDomain c;
                                                                                    block36: {
                                                                                        BasicDomain b;
                                                                                        block35: {
                                                                                            BasicDomain a;
                                                                                            block34: {
                                                                                                block33: {
                                                                                                    block32: {
                                                                                                        block31: {
                                                                                                            block30: {
                                                                                                                block29: {
                                                                                                                    try {
                                                                                                                        key0 = new BasicDomain("key0", 10, 20, 1, 4, 0.1, -12.0);
                                                                                                                        a = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                        b = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                        c = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                        cd0 = new DirectedCombinableDomains(key0.getDomainId(), new BasicSpecies("eel"));
                                                                                                                        cd0.addCombinableDomain(a.getDomainId());
                                                                                                                        cd0.addCombinableDomain(b.getDomainId());
                                                                                                                        cd0.addCombinableDomain(b.getDomainId());
                                                                                                                        cd0.addCombinableDomain(c.getDomainId());
                                                                                                                        cd0.addCombinableDomain(c.getDomainId());
                                                                                                                        cd0.addCombinableDomain(c.getDomainId());
                                                                                                                        if (cd0.getNumberOfCombinableDomains() == 3) break block29;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    catch (Exception e) {
                                                                                                                        e.printStackTrace(System.out);
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                }
                                                                                                                if (cd0.getNumberOfProteinsExhibitingCombination(a.getDomainId()) == 1) break block30;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (cd0.getNumberOfProteinsExhibitingCombination(b.getDomainId()) == 2) break block31;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (cd0.getNumberOfProteinsExhibitingCombination(c.getDomainId()) == 3) break block32;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (cd0.getNumberOfProteinsExhibitingCombination(key0.getDomainId()) == 0) break block33;
                                                                                                    return false;
                                                                                                }
                                                                                                if (cd0.getAllDomains().size() == 4) break block34;
                                                                                                return false;
                                                                                            }
                                                                                            if (cd0.getAllDomains().contains(a.getDomainId())) break block35;
                                                                                            return false;
                                                                                        }
                                                                                        if (cd0.getAllDomains().contains(b.getDomainId())) break block36;
                                                                                        return false;
                                                                                    }
                                                                                    if (cd0.getAllDomains().contains(c.getDomainId())) break block37;
                                                                                    return false;
                                                                                }
                                                                                if (cd0.getAllDomains().contains(key0.getDomainId())) break block38;
                                                                                return false;
                                                                            }
                                                                            if (cd0.toBinaryDomainCombinations().size() == 3) break block39;
                                                                            return false;
                                                                        }
                                                                        DirectedBinaryDomainCombination s0 = new DirectedBinaryDomainCombination("key0", "a");
                                                                        s1 = new DirectedBinaryDomainCombination("b", "key0");
                                                                        s2 = new DirectedBinaryDomainCombination("key0", "c");
                                                                        s3 = new DirectedBinaryDomainCombination("key0", "cc");
                                                                        s4 = new DirectedBinaryDomainCombination("a", "b");
                                                                        s5 = new DirectedBinaryDomainCombination("b", "a");
                                                                        s6 = new DirectedBinaryDomainCombination("key0", "b");
                                                                        s7 = new DirectedBinaryDomainCombination("a", "key0");
                                                                        s8 = new DirectedBinaryDomainCombination("c", "key0");
                                                                        if (cd0.toBinaryDomainCombinations().contains(s0)) break block40;
                                                                        return false;
                                                                    }
                                                                    if (!cd0.toBinaryDomainCombinations().contains(s1)) break block41;
                                                                    return false;
                                                                }
                                                                if (cd0.toBinaryDomainCombinations().contains(s2)) break block42;
                                                                return false;
                                                            }
                                                            if (!cd0.toBinaryDomainCombinations().contains(s3)) break block43;
                                                            return false;
                                                        }
                                                        if (!cd0.toBinaryDomainCombinations().contains(s4)) break block44;
                                                        return false;
                                                    }
                                                    if (!cd0.toBinaryDomainCombinations().contains(s5)) break block45;
                                                    return false;
                                                }
                                                if (cd0.toBinaryDomainCombinations().contains(s6)) break block46;
                                                return false;
                                            }
                                            if (!cd0.toBinaryDomainCombinations().contains(s7)) break block47;
                                            return false;
                                        }
                                        if (!cd0.toBinaryDomainCombinations().contains(s8)) break block48;
                                        return false;
                                    }
                                    key1 = new BasicDomain("key1", 1, 2, 1, 4, 0.1, -12.0);
                                    a1 = new BasicDomain("a1", 23, 25, 1, 4, 0.1, -12.0);
                                    b1 = new BasicDomain("b1", 23, 25, 1, 4, 0.1, -12.0);
                                    c1 = new BasicDomain("c1", 23, 25, 1, 4, 0.1, -12.0);
                                    cd1 = new DirectedCombinableDomains(key1.getDomainId(), new BasicSpecies("eel"));
                                    cd1.addCombinableDomain(a1.getDomainId());
                                    cd1.addCombinableDomain(b1.getDomainId());
                                    cd1.addCombinableDomain(c1.getDomainId());
                                    cd1.addCombinableDomain(key1.getDomainId());
                                    if (cd1.getNumberOfCombinableDomains() == 4) break block49;
                                    return false;
                                }
                                if (cd1.getNumberOfProteinsExhibitingCombination(a1.getDomainId()) == 1) break block50;
                                return false;
                            }
                            if (cd1.getNumberOfProteinsExhibitingCombination(b1.getDomainId()) == 1) break block51;
                            return false;
                        }
                        if (cd1.getNumberOfProteinsExhibitingCombination(c1.getDomainId()) == 1) break block52;
                        return false;
                    }
                    if (cd1.getNumberOfProteinsExhibitingCombination(key1.getDomainId()) == 1) break block53;
                    return false;
                }
                if (cd1.getAllDomains().size() == 4) break block54;
                return false;
            }
            if (cd1.toBinaryDomainCombinations().size() == 4) break block55;
            return false;
        }
        DirectedBinaryDomainCombination kk = new DirectedBinaryDomainCombination("key1", "key1");
        return cd1.toBinaryDomainCombinations().contains(kk);
    }

    private static boolean testDirectedness() {
        BasicGenomeWideCombinableDomains gwcd_1;
        block53: {
            block52: {
                block51: {
                    block50: {
                        block49: {
                            block48: {
                                block47: {
                                    block46: {
                                        block45: {
                                            block44: {
                                                block43: {
                                                    block42: {
                                                        block41: {
                                                            block40: {
                                                                block39: {
                                                                    block38: {
                                                                        block37: {
                                                                            block36: {
                                                                                block35: {
                                                                                    block34: {
                                                                                        block33: {
                                                                                            block32: {
                                                                                                block31: {
                                                                                                    block30: {
                                                                                                        block29: {
                                                                                                            block28: {
                                                                                                                try {
                                                                                                                    CharacterStateMatrix.BinaryStates X = CharacterStateMatrix.BinaryStates.PRESENT;
                                                                                                                    CharacterStateMatrix.BinaryStates O = CharacterStateMatrix.BinaryStates.ABSENT;
                                                                                                                    CharacterStateMatrix.GainLossStates G = CharacterStateMatrix.GainLossStates.GAIN;
                                                                                                                    CharacterStateMatrix.GainLossStates L = CharacterStateMatrix.GainLossStates.LOSS;
                                                                                                                    CharacterStateMatrix.GainLossStates A = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
                                                                                                                    CharacterStateMatrix.GainLossStates P = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
                                                                                                                    BasicProtein one_1 = new BasicProtein("one", "1");
                                                                                                                    BasicProtein two_1 = new BasicProtein("two", "1");
                                                                                                                    BasicProtein three_1 = new BasicProtein("three", "1");
                                                                                                                    BasicProtein four_1 = new BasicProtein("four", "1");
                                                                                                                    BasicProtein five_1 = new BasicProtein("five", "1");
                                                                                                                    one_1.addProteinDomain(new BasicDomain("B", 12, 14, 1, 4, 0.1, -12.0));
                                                                                                                    one_1.addProteinDomain(new BasicDomain("C", 13, 14, 1, 4, 0.1, -12.0));
                                                                                                                    one_1.addProteinDomain(new BasicDomain("A", 11, 12, 1, 4, 0.1, -12.0));
                                                                                                                    one_1.addProteinDomain(new BasicDomain("X", 100, 110, 1, 4, 0.1, -12.0));
                                                                                                                    one_1.addProteinDomain(new BasicDomain("Y", 200, 210, 1, 4, 0.1, -12.0));
                                                                                                                    two_1.addProteinDomain(new BasicDomain("A", 10, 20, 1, 4, 0.1, -12.0));
                                                                                                                    two_1.addProteinDomain(new BasicDomain("B", 30, 40, 1, 4, 0.1, -12.0));
                                                                                                                    two_1.addProteinDomain(new BasicDomain("Y", 1, 2, 1, 4, 0.1, -12.0));
                                                                                                                    two_1.addProteinDomain(new BasicDomain("X", 10, 11, 1, 4, 0.1, -12.0));
                                                                                                                    three_1.addProteinDomain(new BasicDomain("P", 10, 11, 1, 4, 0.1, -12.0));
                                                                                                                    three_1.addProteinDomain(new BasicDomain("M", 1, 2, 1, 4, 0.1, -12.0));
                                                                                                                    three_1.addProteinDomain(new BasicDomain("M", 5, 6, 1, 4, 0.1, -12.0));
                                                                                                                    three_1.addProteinDomain(new BasicDomain("N", 7, 8, 1, 4, 0.1, -12.0));
                                                                                                                    three_1.addProteinDomain(new BasicDomain("N", 3, 4, 1, 4, 0.1, -12.0));
                                                                                                                    four_1.addProteinDomain(new BasicDomain("XX", 10, 20, 1, 4, 0.1, -12.0));
                                                                                                                    five_1.addProteinDomain(new BasicDomain("YY", 30, 40, 1, 4, 0.1, -12.0));
                                                                                                                    ArrayList<Protein> list_1 = new ArrayList<Protein>();
                                                                                                                    list_1.add(one_1);
                                                                                                                    list_1.add(two_1);
                                                                                                                    list_1.add(three_1);
                                                                                                                    list_1.add(four_1);
                                                                                                                    list_1.add(five_1);
                                                                                                                    gwcd_1 = BasicGenomeWideCombinableDomains.createInstance(list_1, false, new BasicSpecies("1"), BinaryDomainCombination.DomainCombinationType.DIRECTED);
                                                                                                                    if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("A", "B"))) break block28;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                catch (Exception e) {
                                                                                                                    e.printStackTrace(System.out);
                                                                                                                    return false;
                                                                                                                }
                                                                                                            }
                                                                                                            if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("B", "A"))) break block29;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("A", "A"))) break block30;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("A", "C"))) break block31;
                                                                                                    return false;
                                                                                                }
                                                                                                if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("C", "A"))) break block32;
                                                                                                return false;
                                                                                            }
                                                                                            if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("B", "C"))) break block33;
                                                                                            return false;
                                                                                        }
                                                                                        if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("C", "X"))) break block34;
                                                                                        return false;
                                                                                    }
                                                                                    if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("C", "Y"))) break block35;
                                                                                    return false;
                                                                                }
                                                                                if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("A", "X"))) break block36;
                                                                                return false;
                                                                            }
                                                                            if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("A", "Y"))) break block37;
                                                                            return false;
                                                                        }
                                                                        if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("Y", "A"))) break block38;
                                                                        return false;
                                                                    }
                                                                    if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("X", "A"))) break block39;
                                                                    return false;
                                                                }
                                                                if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("C", "B"))) break block40;
                                                                return false;
                                                            }
                                                            if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("X", "Y"))) break block41;
                                                            return false;
                                                        }
                                                        if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("Y", "X"))) break block42;
                                                        return false;
                                                    }
                                                    if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("A", "Y"))) break block43;
                                                    return false;
                                                }
                                                if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("A", "X"))) break block44;
                                                return false;
                                            }
                                            if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("Y", "C"))) break block45;
                                            return false;
                                        }
                                        if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("M", "N"))) break block46;
                                        return false;
                                    }
                                    if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("N", "M"))) break block47;
                                    return false;
                                }
                                if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("N", "P"))) break block48;
                                return false;
                            }
                            if (gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("M", "P"))) break block49;
                            return false;
                        }
                        if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("P", "N"))) break block50;
                        return false;
                    }
                    if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("P", "M"))) break block51;
                    return false;
                }
                if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("XX", "YY"))) break block52;
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("YY", "XX"))) break block53;
            return false;
        }
        return !gwcd_1.toBinaryDomainCombinations().contains(new DirectedBinaryDomainCombination("B", "B"));
    }

    private static boolean testDirectednessAndAdjacency() {
        BasicGenomeWideCombinableDomains gwcd_1;
        block55: {
            block54: {
                block53: {
                    block52: {
                        block51: {
                            block50: {
                                block49: {
                                    block48: {
                                        block47: {
                                            block46: {
                                                block45: {
                                                    block44: {
                                                        block43: {
                                                            block42: {
                                                                block41: {
                                                                    block40: {
                                                                        block39: {
                                                                            block38: {
                                                                                block37: {
                                                                                    block36: {
                                                                                        block35: {
                                                                                            block34: {
                                                                                                block33: {
                                                                                                    block32: {
                                                                                                        block31: {
                                                                                                            block30: {
                                                                                                                block29: {
                                                                                                                    try {
                                                                                                                        BasicProtein one_1 = new BasicProtein("one", "1");
                                                                                                                        BasicProtein two_1 = new BasicProtein("two", "1");
                                                                                                                        BasicProtein three_1 = new BasicProtein("three", "1");
                                                                                                                        BasicProtein four_1 = new BasicProtein("four", "1");
                                                                                                                        BasicProtein five_1 = new BasicProtein("five", "1");
                                                                                                                        one_1.addProteinDomain(new BasicDomain("B", 12, 14, 1, 4, 0.1, -12.0));
                                                                                                                        one_1.addProteinDomain(new BasicDomain("C", 13, 14, 1, 4, 0.1, -12.0));
                                                                                                                        one_1.addProteinDomain(new BasicDomain("A", 11, 12, 1, 4, 0.1, -12.0));
                                                                                                                        one_1.addProteinDomain(new BasicDomain("X", 100, 110, 1, 4, 0.1, -12.0));
                                                                                                                        one_1.addProteinDomain(new BasicDomain("Y", 200, 210, 1, 4, 0.1, -12.0));
                                                                                                                        two_1.addProteinDomain(new BasicDomain("A", 10, 20, 1, 4, 0.1, -12.0));
                                                                                                                        two_1.addProteinDomain(new BasicDomain("B", 30, 40, 1, 4, 0.1, -12.0));
                                                                                                                        two_1.addProteinDomain(new BasicDomain("Y", 1, 2, 1, 4, 0.1, -12.0));
                                                                                                                        two_1.addProteinDomain(new BasicDomain("X", 10, 11, 1, 4, 0.1, -12.0));
                                                                                                                        three_1.addProteinDomain(new BasicDomain("P", 10, 11, 1, 4, 0.1, -12.0));
                                                                                                                        three_1.addProteinDomain(new BasicDomain("M", 1, 2, 1, 4, 0.1, -12.0));
                                                                                                                        three_1.addProteinDomain(new BasicDomain("M", 5, 6, 1, 4, 0.1, -12.0));
                                                                                                                        three_1.addProteinDomain(new BasicDomain("N", 7, 8, 1, 4, 0.1, -12.0));
                                                                                                                        three_1.addProteinDomain(new BasicDomain("N", 3, 4, 1, 4, 0.1, -12.0));
                                                                                                                        four_1.addProteinDomain(new BasicDomain("XX", 10, 20, 1, 4, 0.1, -12.0));
                                                                                                                        five_1.addProteinDomain(new BasicDomain("YY", 30, 40, 1, 4, 0.1, -12.0));
                                                                                                                        ArrayList<Protein> list_1 = new ArrayList<Protein>();
                                                                                                                        list_1.add(one_1);
                                                                                                                        list_1.add(two_1);
                                                                                                                        list_1.add(three_1);
                                                                                                                        list_1.add(four_1);
                                                                                                                        list_1.add(five_1);
                                                                                                                        gwcd_1 = BasicGenomeWideCombinableDomains.createInstance(list_1, false, new BasicSpecies("1"), BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT);
                                                                                                                        if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("A", "B"))) break block29;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    catch (Exception e) {
                                                                                                                        e.printStackTrace(System.out);
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                }
                                                                                                                if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("B", "A"))) break block30;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("A", "A"))) break block31;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("A", "C"))) break block32;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("C", "A"))) break block33;
                                                                                                    return false;
                                                                                                }
                                                                                                if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("B", "C"))) break block34;
                                                                                                return false;
                                                                                            }
                                                                                            if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("C", "X"))) break block35;
                                                                                            return false;
                                                                                        }
                                                                                        if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("C", "Y"))) break block36;
                                                                                        return false;
                                                                                    }
                                                                                    if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("X", "Y"))) break block37;
                                                                                    return false;
                                                                                }
                                                                                if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("A", "X"))) break block38;
                                                                                return false;
                                                                            }
                                                                            if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("A", "Y"))) break block39;
                                                                            return false;
                                                                        }
                                                                        if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("Y", "A"))) break block40;
                                                                        return false;
                                                                    }
                                                                    if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("X", "A"))) break block41;
                                                                    return false;
                                                                }
                                                                if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("C", "B"))) break block42;
                                                                return false;
                                                            }
                                                            if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("X", "Y"))) break block43;
                                                            return false;
                                                        }
                                                        if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("Y", "X"))) break block44;
                                                        return false;
                                                    }
                                                    if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("A", "Y"))) break block45;
                                                    return false;
                                                }
                                                if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("A", "X"))) break block46;
                                                return false;
                                            }
                                            if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("Y", "C"))) break block47;
                                            return false;
                                        }
                                        if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("M", "N"))) break block48;
                                        return false;
                                    }
                                    if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("N", "M"))) break block49;
                                    return false;
                                }
                                if (gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("N", "P"))) break block50;
                                return false;
                            }
                            if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("M", "P"))) break block51;
                            return false;
                        }
                        if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("P", "N"))) break block52;
                        return false;
                    }
                    if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("P", "M"))) break block53;
                    return false;
                }
                if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("XX", "YY"))) break block54;
                return false;
            }
            if (!gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("YY", "XX"))) break block55;
            return false;
        }
        return !gwcd_1.toBinaryDomainCombinations().contains(new AdjactantDirectedBinaryDomainCombination("B", "B"));
    }

    private static boolean testDomainArchitectureBasedGenomeSimilarityCalculator() {
        DomainArchitectureBasedGenomeSimilarityCalculator calc_u;
        block491: {
            block490: {
                block489: {
                    block488: {
                        block487: {
                            block486: {
                                block485: {
                                    block484: {
                                        block483: {
                                            block482: {
                                                block481: {
                                                    block480: {
                                                        block479: {
                                                            block478: {
                                                                BasicDomain x;
                                                                block477: {
                                                                    BasicDomain v;
                                                                    block476: {
                                                                        BasicDomain z;
                                                                        block475: {
                                                                            BasicDomain y;
                                                                            block474: {
                                                                                BasicDomain w;
                                                                                block473: {
                                                                                    BasicDomain u;
                                                                                    block472: {
                                                                                        block471: {
                                                                                            block470: {
                                                                                                block469: {
                                                                                                    block468: {
                                                                                                        block467: {
                                                                                                            block466: {
                                                                                                                block465: {
                                                                                                                    block464: {
                                                                                                                        block463: {
                                                                                                                            block462: {
                                                                                                                                block461: {
                                                                                                                                    block460: {
                                                                                                                                        block459: {
                                                                                                                                            block458: {
                                                                                                                                                block457: {
                                                                                                                                                    block456: {
                                                                                                                                                        block455: {
                                                                                                                                                            block454: {
                                                                                                                                                                block453: {
                                                                                                                                                                    block452: {
                                                                                                                                                                        block451: {
                                                                                                                                                                            block450: {
                                                                                                                                                                                block449: {
                                                                                                                                                                                    block448: {
                                                                                                                                                                                        block447: {
                                                                                                                                                                                            block446: {
                                                                                                                                                                                                block445: {
                                                                                                                                                                                                    block444: {
                                                                                                                                                                                                        block443: {
                                                                                                                                                                                                            block442: {
                                                                                                                                                                                                                block441: {
                                                                                                                                                                                                                    block440: {
                                                                                                                                                                                                                        block439: {
                                                                                                                                                                                                                            block438: {
                                                                                                                                                                                                                                block437: {
                                                                                                                                                                                                                                    block436: {
                                                                                                                                                                                                                                        block435: {
                                                                                                                                                                                                                                            block434: {
                                                                                                                                                                                                                                                block433: {
                                                                                                                                                                                                                                                    block432: {
                                                                                                                                                                                                                                                        block431: {
                                                                                                                                                                                                                                                            block430: {
                                                                                                                                                                                                                                                                block429: {
                                                                                                                                                                                                                                                                    block428: {
                                                                                                                                                                                                                                                                        block427: {
                                                                                                                                                                                                                                                                            block426: {
                                                                                                                                                                                                                                                                                block425: {
                                                                                                                                                                                                                                                                                    block424: {
                                                                                                                                                                                                                                                                                        block423: {
                                                                                                                                                                                                                                                                                            block422: {
                                                                                                                                                                                                                                                                                                block421: {
                                                                                                                                                                                                                                                                                                    block420: {
                                                                                                                                                                                                                                                                                                        block419: {
                                                                                                                                                                                                                                                                                                            block418: {
                                                                                                                                                                                                                                                                                                                block417: {
                                                                                                                                                                                                                                                                                                                    block416: {
                                                                                                                                                                                                                                                                                                                        block415: {
                                                                                                                                                                                                                                                                                                                            block414: {
                                                                                                                                                                                                                                                                                                                                block413: {
                                                                                                                                                                                                                                                                                                                                    block412: {
                                                                                                                                                                                                                                                                                                                                        block411: {
                                                                                                                                                                                                                                                                                                                                            block410: {
                                                                                                                                                                                                                                                                                                                                                block409: {
                                                                                                                                                                                                                                                                                                                                                    block408: {
                                                                                                                                                                                                                                                                                                                                                        block407: {
                                                                                                                                                                                                                                                                                                                                                            block406: {
                                                                                                                                                                                                                                                                                                                                                                block405: {
                                                                                                                                                                                                                                                                                                                                                                    block404: {
                                                                                                                                                                                                                                                                                                                                                                        block403: {
                                                                                                                                                                                                                                                                                                                                                                            block402: {
                                                                                                                                                                                                                                                                                                                                                                                block401: {
                                                                                                                                                                                                                                                                                                                                                                                    block400: {
                                                                                                                                                                                                                                                                                                                                                                                        block399: {
                                                                                                                                                                                                                                                                                                                                                                                            block398: {
                                                                                                                                                                                                                                                                                                                                                                                                DomainArchitectureBasedGenomeSimilarityCalculator calc_i;
                                                                                                                                                                                                                                                                                                                                                                                                block397: {
                                                                                                                                                                                                                                                                                                                                                                                                    DomainArchitectureBasedGenomeSimilarityCalculator calc_ni;
                                                                                                                                                                                                                                                                                                                                                                                                    block396: {
                                                                                                                                                                                                                                                                                                                                                                                                        block395: {
                                                                                                                                                                                                                                                                                                                                                                                                            block394: {
                                                                                                                                                                                                                                                                                                                                                                                                                Set<BinaryDomainCombination> s_1_i;
                                                                                                                                                                                                                                                                                                                                                                                                                block393: {
                                                                                                                                                                                                                                                                                                                                                                                                                    block392: {
                                                                                                                                                                                                                                                                                                                                                                                                                        block391: {
                                                                                                                                                                                                                                                                                                                                                                                                                            block390: {
                                                                                                                                                                                                                                                                                                                                                                                                                                block389: {
                                                                                                                                                                                                                                                                                                                                                                                                                                    block388: {
                                                                                                                                                                                                                                                                                                                                                                                                                                        block387: {
                                                                                                                                                                                                                                                                                                                                                                                                                                            block386: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                block385: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    block384: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        block383: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            Set<BinaryDomainCombination> s_1_ni;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            block382: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                block381: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block380: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block379: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block378: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block377: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block376: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block375: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block374: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block373: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block372: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Set<BinaryDomainCombination> s_0_i;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block371: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block370: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block369: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block368: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block367: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block366: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block365: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block364: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block363: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block362: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Set<BinaryDomainCombination> s_0_ni;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block361: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block360: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block359: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block358: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block357: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block356: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block355: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block354: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block353: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block352: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Set<BinaryDomainCombination> shared_i;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block351: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block350: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block349: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block348: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block347: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block346: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Set<BinaryDomainCombination> shared_ni;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block345: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block344: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block343: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block342: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block341: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block340: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Set<BinaryDomainCombination> a_i;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block339: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block338: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block337: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Set<BinaryDomainCombination> a_ni;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block336: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block335: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block334: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block333: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block332: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block331: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block330: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block329: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block328: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block327: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block326: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block325: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block324: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block323: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block322: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block321: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block320: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block319: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block318: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block317: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block316: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block315: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block314: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block313: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block312: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block311: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block310: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block309: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block308: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block307: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block306: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block305: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block304: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block303: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block302: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Set<DomainId> all;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicDomain n;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block301: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain m;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block300: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicDomain k;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block299: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BasicDomain j;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block298: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicDomain l;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block297: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain i;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block296: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicDomain h;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block295: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BasicDomain g;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block294: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicDomain f;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block293: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain e;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block292: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        BasicDomain d;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block291: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BasicDomain c;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block290: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicDomain b;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block289: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BasicDomain a;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block288: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block287: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block286: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block285: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block284: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block283: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block282: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block281: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block280: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block279: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block278: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block277: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block276: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block275: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block274: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block273: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block272: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block271: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block270: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block269: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block268: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block267: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block266: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block265: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block264: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block263: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block262: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block261: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block260: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block259: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block258: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block257: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block256: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block255: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block254: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block253: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block252: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block251: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block250: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block249: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block248: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block247: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            try {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                a = new BasicDomain("a", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                b = new BasicDomain("b", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                c = new BasicDomain("c", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                d = new BasicDomain("d", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                e = new BasicDomain("e", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                f = new BasicDomain("f", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                g = new BasicDomain("g", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                h = new BasicDomain("h", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                i = new BasicDomain("i", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                j = new BasicDomain("j", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                k = new BasicDomain("k", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                l = new BasicDomain("l", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m = new BasicDomain("m", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                n = new BasicDomain("n", 23, 25, 1, 4, 0.1, -12.0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein eel_0 = new BasicProtein("0", "eel");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein eel_1 = new BasicProtein("1", "eel");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein eel_2 = new BasicProtein("2", "eel");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein eel_3 = new BasicProtein("3", "eel");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein eel_4 = new BasicProtein("4", "eel");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein eel_5 = new BasicProtein("5", "eel");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein eel_6 = new BasicProtein("6", "eel");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein rat_0 = new BasicProtein("0", "rat");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein rat_1 = new BasicProtein("1", "rat");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein rat_2 = new BasicProtein("2", "rat");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein rat_3 = new BasicProtein("3", "rat");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein rat_4 = new BasicProtein("4", "rat");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein rat_5 = new BasicProtein("5", "rat");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein rat_6 = new BasicProtein("6", "rat");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicProtein rat_7 = new BasicProtein("7", "rat");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_1.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_2.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_2.addProteinDomain(b);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_3.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_3.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_3.addProteinDomain(b);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_4.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_4.addProteinDomain(b);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_4.addProteinDomain(c);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_4.addProteinDomain(d);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_4.addProteinDomain(e);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_5.addProteinDomain(e);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_5.addProteinDomain(e);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_5.addProteinDomain(f);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_5.addProteinDomain(f);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_5.addProteinDomain(f);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_5.addProteinDomain(f);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_6.addProteinDomain(g);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                eel_6.addProteinDomain(h);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_1.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_2.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_2.addProteinDomain(b);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_3.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_3.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_3.addProteinDomain(b);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_4.addProteinDomain(a);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_4.addProteinDomain(b);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_4.addProteinDomain(c);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_4.addProteinDomain(i);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_4.addProteinDomain(l);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_5.addProteinDomain(i);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_5.addProteinDomain(f);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_5.addProteinDomain(f);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_6.addProteinDomain(j);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_6.addProteinDomain(k);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_7.addProteinDomain(m);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rat_7.addProteinDomain(n);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ArrayList<Protein> protein_list_eel = new ArrayList<Protein>();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_eel.add(eel_0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_eel.add(eel_1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_eel.add(eel_2);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_eel.add(eel_3);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_eel.add(eel_4);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_eel.add(eel_5);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_eel.add(eel_6);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ArrayList<Protein> protein_list_rat = new ArrayList<Protein>();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_rat.add(rat_0);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_rat.add(rat_1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_rat.add(rat_2);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_rat.add(rat_3);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_rat.add(rat_4);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_rat.add(rat_5);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_rat.add(rat_6);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                protein_list_rat.add(rat_7);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicGenomeWideCombinableDomains eel_not_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_eel, false, new BasicSpecies("eel"));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicGenomeWideCombinableDomains eel_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_eel, true, new BasicSpecies("eel"));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicGenomeWideCombinableDomains rat_not_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_rat, false, new BasicSpecies("rat"));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicGenomeWideCombinableDomains rat_ignore = BasicGenomeWideCombinableDomains.createInstance(protein_list_rat, true, new BasicSpecies("rat"));
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                calc_ni = new DomainArchitectureBasedGenomeSimilarityCalculator(eel_not_ignore, rat_not_ignore);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                calc_i = new DomainArchitectureBasedGenomeSimilarityCalculator(eel_ignore, rat_ignore);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (calc_ni.getAllDomains().size() == 14) break block247;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            catch (Exception e2) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                e2.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_i.getAllDomains().size() == 14) break block248;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (calc_ni.getDomainsSpecificToGenome0().size() == 4) break block249;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (calc_i.getDomainsSpecificToGenome0().size() == 4) break block250;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (calc_ni.getDomainsSpecificToGenome1().size() == 6) break block251;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_i.getDomainsSpecificToGenome1().size() == 6) break block252;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (calc_i.getSharedDomains().size() == 4) break block253;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (calc_ni.getSharedDomains().size() == 4) break block254;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (calc_ni.getDomainsSpecificToGenome0().contains(d.getDomainId())) break block255;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_ni.getDomainsSpecificToGenome0().contains(e.getDomainId())) break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (calc_ni.getDomainsSpecificToGenome0().contains(g.getDomainId())) break block257;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (calc_ni.getDomainsSpecificToGenome0().contains(h.getDomainId())) break block258;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!calc_ni.getDomainsSpecificToGenome0().contains(a.getDomainId())) break block259;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!calc_ni.getDomainsSpecificToGenome0().contains(i.getDomainId())) break block260;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (calc_i.getDomainsSpecificToGenome0().contains(d.getDomainId())) break block261;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (calc_i.getDomainsSpecificToGenome0().contains(e.getDomainId())) break block262;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (calc_i.getDomainsSpecificToGenome0().contains(g.getDomainId())) break block263;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_i.getDomainsSpecificToGenome0().contains(h.getDomainId())) break block264;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!calc_i.getDomainsSpecificToGenome0().contains(a.getDomainId())) break block265;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!calc_i.getDomainsSpecificToGenome0().contains(i.getDomainId())) break block266;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (calc_ni.getDomainsSpecificToGenome1().contains(i.getDomainId())) break block267;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_ni.getDomainsSpecificToGenome1().contains(l.getDomainId())) break block268;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (calc_ni.getDomainsSpecificToGenome1().contains(j.getDomainId())) break block269;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (calc_ni.getDomainsSpecificToGenome1().contains(k.getDomainId())) break block270;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (calc_ni.getDomainsSpecificToGenome1().contains(m.getDomainId())) break block271;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_ni.getDomainsSpecificToGenome1().contains(n.getDomainId())) break block272;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!calc_ni.getDomainsSpecificToGenome1().contains(a.getDomainId())) break block273;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!calc_ni.getDomainsSpecificToGenome1().contains(b.getDomainId())) break block274;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!calc_ni.getDomainsSpecificToGenome1().contains(d.getDomainId())) break block275;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_i.getDomainsSpecificToGenome1().contains(i.getDomainId())) break block276;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (calc_i.getDomainsSpecificToGenome1().contains(l.getDomainId())) break block277;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (calc_i.getDomainsSpecificToGenome1().contains(j.getDomainId())) break block278;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (calc_i.getDomainsSpecificToGenome1().contains(k.getDomainId())) break block279;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_i.getDomainsSpecificToGenome1().contains(m.getDomainId())) break block280;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (calc_i.getDomainsSpecificToGenome1().contains(n.getDomainId())) break block281;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!calc_i.getDomainsSpecificToGenome1().contains(a.getDomainId())) break block282;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!calc_i.getDomainsSpecificToGenome1().contains(b.getDomainId())) break block283;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!calc_i.getDomainsSpecificToGenome1().contains(d.getDomainId())) break block284;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (calc_i.getSharedDomains().contains(a.getDomainId())) break block285;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (calc_i.getSharedDomains().contains(b.getDomainId())) break block286;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (calc_i.getSharedDomains().contains(c.getDomainId())) break block287;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (calc_i.getSharedDomains().contains(f.getDomainId())) break block288;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    all = calc_ni.getAllDomains();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (all.contains(a.getDomainId())) break block289;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (all.contains(b.getDomainId())) break block290;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (all.contains(c.getDomainId())) break block291;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (all.contains(d.getDomainId())) break block292;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (all.contains(e.getDomainId())) break block293;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (all.contains(f.getDomainId())) break block294;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (all.contains(g.getDomainId())) break block295;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (all.contains(h.getDomainId())) break block296;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (all.contains(i.getDomainId())) break block297;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (all.contains(l.getDomainId())) break block298;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (all.contains(j.getDomainId())) break block299;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (all.contains(k.getDomainId())) break block300;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (all.contains(m.getDomainId())) break block301;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (all.contains(n.getDomainId())) break block302;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            s_0_ni = calc_ni.getBinaryDomainCombinationsSpecificToGenome0();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            s_0_i = calc_i.getBinaryDomainCombinationsSpecificToGenome0();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            s_1_ni = calc_ni.getBinaryDomainCombinationsSpecificToGenome1();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            s_1_i = calc_i.getBinaryDomainCombinationsSpecificToGenome1();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            a_ni = calc_ni.getAllBinaryDomainCombinations();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            a_i = calc_i.getAllBinaryDomainCombinations();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            shared_ni = calc_ni.getSharedBinaryDomainCombinations();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            shared_i = calc_i.getSharedBinaryDomainCombinations();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (a_ni.size() == 25) break block303;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (a_i.size() == 22) break block304;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_0_ni.size() == 10) break block305;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_0_i.size() == 9) break block306;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_1_ni.size() == 10) break block307;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_1_i.size() == 10) break block308;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (shared_ni.size() == 5) break block309;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (shared_i.size() == 3) break block310;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (a_ni.contains(new BasicBinaryDomainCombination("a", "a"))) break block311;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (a_ni.contains(new BasicBinaryDomainCombination("b", "a"))) break block312;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (a_ni.contains(new BasicBinaryDomainCombination("a", "c"))) break block313;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (a_ni.contains(new BasicBinaryDomainCombination("a", "d"))) break block314;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (a_ni.contains(new BasicBinaryDomainCombination("a", "e"))) break block315;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (a_ni.contains(new BasicBinaryDomainCombination("b", "c"))) break block316;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (a_ni.contains(new BasicBinaryDomainCombination("b", "d"))) break block317;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (a_ni.contains(new BasicBinaryDomainCombination("b", "e"))) break block318;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (a_ni.contains(new BasicBinaryDomainCombination("c", "d"))) break block319;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (a_ni.contains(new BasicBinaryDomainCombination("c", "e"))) break block320;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (a_ni.contains(new BasicBinaryDomainCombination("d", "e"))) break block321;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (a_ni.contains(new BasicBinaryDomainCombination("e", "f"))) break block322;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (a_ni.contains(new BasicBinaryDomainCombination("g", "h"))) break block323;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (a_ni.contains(new BasicBinaryDomainCombination("f", "f"))) break block324;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (a_ni.contains(new BasicBinaryDomainCombination("e", "e"))) break block325;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (a_ni.contains(new BasicBinaryDomainCombination("a", "i"))) break block326;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (a_ni.contains(new BasicBinaryDomainCombination("a", "l"))) break block327;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (a_ni.contains(new BasicBinaryDomainCombination("b", "i"))) break block328;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (a_ni.contains(new BasicBinaryDomainCombination("b", "l"))) break block329;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (a_ni.contains(new BasicBinaryDomainCombination("c", "i"))) break block330;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (a_ni.contains(new BasicBinaryDomainCombination("c", "l"))) break block331;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (a_ni.contains(new BasicBinaryDomainCombination("i", "l"))) break block332;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (a_ni.contains(new BasicBinaryDomainCombination("i", "f"))) break block333;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (a_ni.contains(new BasicBinaryDomainCombination("m", "n"))) break block334;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (a_ni.contains(new BasicBinaryDomainCombination("j", "k"))) break block335;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!a_ni.contains(new BasicBinaryDomainCombination("a", "g"))) break block336;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!a_ni.contains(new BasicBinaryDomainCombination("a", "m"))) break block337;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!a_i.contains(new BasicBinaryDomainCombination("a", "a"))) break block338;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!a_i.contains(new BasicBinaryDomainCombination("f", "f"))) break block339;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!a_i.contains(new BasicBinaryDomainCombination("e", "e"))) break block340;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (shared_ni.contains(new BasicBinaryDomainCombination("a", "a"))) break block341;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (shared_ni.contains(new BasicBinaryDomainCombination("a", "b"))) break block342;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (shared_ni.contains(new BasicBinaryDomainCombination("a", "c"))) break block343;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (shared_ni.contains(new BasicBinaryDomainCombination("b", "c"))) break block344;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (shared_ni.contains(new BasicBinaryDomainCombination("f", "f"))) break block345;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!shared_ni.contains(new BasicBinaryDomainCombination("m", "n"))) break block346;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!shared_i.contains(new BasicBinaryDomainCombination("a", "a"))) break block347;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (shared_i.contains(new BasicBinaryDomainCombination("a", "b"))) break block348;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (shared_i.contains(new BasicBinaryDomainCombination("a", "c"))) break block349;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (shared_i.contains(new BasicBinaryDomainCombination("b", "c"))) break block350;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!shared_i.contains(new BasicBinaryDomainCombination("f", "f"))) break block351;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!shared_i.contains(new BasicBinaryDomainCombination("m", "n"))) break block352;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_0_ni.contains(new BasicBinaryDomainCombination("a", "d"))) break block353;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_0_ni.contains(new BasicBinaryDomainCombination("a", "e"))) break block354;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_0_ni.contains(new BasicBinaryDomainCombination("b", "d"))) break block355;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_0_ni.contains(new BasicBinaryDomainCombination("b", "e"))) break block356;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_0_ni.contains(new BasicBinaryDomainCombination("c", "d"))) break block357;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_0_ni.contains(new BasicBinaryDomainCombination("c", "e"))) break block358;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_0_ni.contains(new BasicBinaryDomainCombination("d", "e"))) break block359;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_0_ni.contains(new BasicBinaryDomainCombination("e", "f"))) break block360;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_0_ni.contains(new BasicBinaryDomainCombination("g", "h"))) break block361;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_0_ni.contains(new BasicBinaryDomainCombination("e", "e"))) break block362;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_0_i.contains(new BasicBinaryDomainCombination("a", "d"))) break block363;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_0_i.contains(new BasicBinaryDomainCombination("a", "e"))) break block364;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_0_i.contains(new BasicBinaryDomainCombination("b", "d"))) break block365;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_0_i.contains(new BasicBinaryDomainCombination("b", "e"))) break block366;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_0_i.contains(new BasicBinaryDomainCombination("c", "d"))) break block367;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_0_i.contains(new BasicBinaryDomainCombination("c", "e"))) break block368;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_0_i.contains(new BasicBinaryDomainCombination("d", "e"))) break block369;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_0_i.contains(new BasicBinaryDomainCombination("e", "f"))) break block370;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_0_i.contains(new BasicBinaryDomainCombination("g", "h"))) break block371;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!s_0_i.contains(new BasicBinaryDomainCombination("e", "e"))) break block372;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_1_ni.contains(new BasicBinaryDomainCombination("a", "i"))) break block373;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_1_ni.contains(new BasicBinaryDomainCombination("a", "l"))) break block374;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_1_ni.contains(new BasicBinaryDomainCombination("b", "i"))) break block375;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_1_ni.contains(new BasicBinaryDomainCombination("b", "l"))) break block376;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_1_ni.contains(new BasicBinaryDomainCombination("c", "i"))) break block377;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_1_ni.contains(new BasicBinaryDomainCombination("c", "l"))) break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_1_ni.contains(new BasicBinaryDomainCombination("l", "i"))) break block379;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_1_ni.contains(new BasicBinaryDomainCombination("i", "f"))) break block380;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_1_ni.contains(new BasicBinaryDomainCombination("m", "n"))) break block381;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_1_ni.contains(new BasicBinaryDomainCombination("j", "k"))) break block382;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!s_1_ni.contains(new BasicBinaryDomainCombination("a", "b"))) break block383;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_1_i.contains(new BasicBinaryDomainCombination("a", "i"))) break block384;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_1_i.contains(new BasicBinaryDomainCombination("a", "l"))) break block385;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_1_i.contains(new BasicBinaryDomainCombination("b", "i"))) break block386;
                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (s_1_i.contains(new BasicBinaryDomainCombination("b", "l"))) break block387;
                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (s_1_i.contains(new BasicBinaryDomainCombination("c", "i"))) break block388;
                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (s_1_i.contains(new BasicBinaryDomainCombination("c", "l"))) break block389;
                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                if (s_1_i.contains(new BasicBinaryDomainCombination("l", "i"))) break block390;
                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                    