/*
 * Decompiled with CFR 0.152.
 */
package org.forester.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.forester.application.support_transfer;
import org.forester.development.SupportCount;
import org.forester.go.TestGo;
import org.forester.io.parsers.HmmscanPerDomainTableParser;
import org.forester.io.parsers.nexus.NexusBinaryStatesMatrixParser;
import org.forester.io.parsers.nexus.NexusCharactersParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.pccx.TestPccx;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.phylogenyinference.TestPhylogenyReconstruction;
import org.forester.sdi.SDIR;
import org.forester.sdi.SDIse;
import org.forester.sdi.TaxonomyAssigner;
import org.forester.sdi.TestGSDI;
import org.forester.surfacing.Protein;
import org.forester.surfacing.TestSurfacing;
import org.forester.tools.ConfidenceAssessor;
import org.forester.tools.TreeSplitMatrix;
import org.forester.util.AsciiHistogram;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;
import org.forester.util.GeneralTable;

public final class Test {
    private static final double ZERO_DIFF = 1.0E-9;
    private static final String PATH_TO_TEST_DATA = String.valueOf(System.getProperty("user.dir")) + ForesterUtil.getFileSeparator() + "test_data" + ForesterUtil.getFileSeparator();
    private static final String PATH_TO_RESOURCES = String.valueOf(System.getProperty("user.dir")) + ForesterUtil.getFileSeparator() + "resources" + ForesterUtil.getFileSeparator();
    private static final boolean USE_LOCAL_PHYLOXML_SCHEMA = true;
    private static final String PHYLOXML_REMOTE_XSD = "http://www.phyloxml.org/1.10/phyloxml.xsd";
    private static final String PHYLOXML_LOCAL_XSD = String.valueOf(PATH_TO_RESOURCES) + "phyloxml_schema/" + "1.10" + "/" + "phyloxml.xsd";

    private static final Phylogeny createPhylogeny(String nhx) throws IOException {
        Phylogeny p = ParserBasedPhylogenyFactory.getInstance().create(nhx, new NHXParser())[0];
        return p;
    }

    private static final Event getEvent(Phylogeny p, String n1, String n2) {
        PhylogenyMethods pm = PhylogenyMethods.getInstance();
        return pm.getLCA(p.getNode(n1), p.getNode(n2)).getNodeData().getEvent();
    }

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static void main(String[] args) {
        System.out.println("[Java version: " + ForesterUtil.JAVA_VERSION + " " + ForesterUtil.JAVA_VENDOR + "]");
        System.out.println("[OS: " + ForesterUtil.OS_NAME + " " + ForesterUtil.OS_ARCH + " " + ForesterUtil.OS_VERSION + "]");
        Locale.setDefault(Locale.US);
        System.out.println("[Locale: " + Locale.getDefault() + "]");
        int failed = 0;
        int succeeded = 0;
        System.out.print("[Test if directory with files for testing exists/is readable: ");
        if (Test.testDir(PATH_TO_TEST_DATA)) {
            System.out.println("OK.]");
        } else {
            System.out.println("could not find/read from directory \"" + PATH_TO_TEST_DATA + "\".]");
            System.out.println("Testing aborted.");
            System.exit(-1);
        }
        System.out.print("[Test if resources directory exists/is readable: ");
        if (Test.testDir(PATH_TO_RESOURCES)) {
            System.out.println("OK.]");
        } else {
            System.out.println("could not find/read from directory \"" + PATH_TO_RESOURCES + "\".]");
            System.out.println("Testing aborted.");
            System.exit(-1);
        }
        long start_time = new Date().getTime();
        System.out.print("Hmmscan output parser: ");
        if (Test.testHmmscanOutputParser()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Basic node methods: ");
        if (Test.testBasicNodeMethods()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Basic node construction and parsing of NHX (node level): ");
        if (Test.testNHXNodeParsing()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("NH parsing: ");
        if (Test.testNHParsing()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Conversion to NHX (node level): ");
        if (Test.testNHXconversion()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("NHX parsing: ");
        if (Test.testNHXParsing()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("NHX parsing with quotes: ");
        if (Test.testNHXParsingQuotes()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Nexus characters parsing: ");
        if (Test.testNexusCharactersParsing()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Nexus tree parsing: ");
        if (Test.testNexusTreeParsing()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Nexus tree parsing (translating): ");
        if (Test.testNexusTreeParsingTranslating()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Nexus matrix parsing: ");
        if (Test.testNexusMatrixParsing()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Basic phyloXML parsing: ");
        if (Test.testBasicPhyloXMLparsing()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Basic phyloXML parsing (validating against schema): ");
        if (Test.testBasicPhyloXMLparsingValidating()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Roundtrip phyloXML parsing (validating against schema): ");
        if (Test.testBasicPhyloXMLparsingRoundtrip()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Tol XML parsing: ");
        if (Test.testBasicTolXMLparsing()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Copying of node data: ");
        if (Test.testCopyOfNodeData()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Basic tree methods: ");
        if (Test.testBasicTreeMethods()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Postorder Iterator: ");
        if (Test.testPostOrderIterator()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Preorder Iterator: ");
        if (Test.testPreOrderIterator()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Levelorder Iterator: ");
        if (Test.testLevelOrderIterator()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Re-id methods: ");
        if (Test.testReIdMethods()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Methods on last external nodes: ");
        if (Test.testLastExternalNodeMethods()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Methods on external nodes: ");
        if (Test.testExternalNodeRelatedMethods()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Deletion of external nodes: ");
        if (Test.testDeletionOfExternalNodes()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Subtree deletion: ");
        if (Test.testSubtreeDeletion()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Phylogeny branch: ");
        if (Test.testPhylogenyBranch()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Rerooting: ");
        if (Test.testRerooting()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Mipoint rooting: ");
        if (Test.testMidpointrooting()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Support count: ");
        if (Test.testSupportCount()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Support transfer: ");
        if (Test.testSupportTransfer()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Finding of LCA: ");
        if (Test.testGetLCA()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Calculation of distance between nodes: ");
        if (Test.testGetDistance()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("SDIse: ");
        if (Test.testSDIse()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Taxonomy assigner: ");
        if (Test.testTaxonomyAssigner()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("SDIunrooted: ");
        if (Test.testSDIunrooted()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("GSDI: ");
        if (TestGSDI.test()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Descriptive statistics: ");
        if (Test.testDescriptiveStatistics()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Data objects and methods: ");
        if (Test.testDataObjects()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Phylogeny reconstruction:");
        System.out.println();
        if (TestPhylogenyReconstruction.test(new File(PATH_TO_TEST_DATA))) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Analysis of domain architectures: ");
        System.out.println();
        if (TestSurfacing.test(new File(PATH_TO_TEST_DATA))) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("GO: ");
        System.out.println();
        if (TestGo.test(new File(PATH_TO_TEST_DATA))) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Modeling tools: ");
        if (TestPccx.test()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Split Matrix: ");
        if (Test.testSplit()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Split Matrix: ");
        if (Test.testConfidenceAssessor()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("Basic table: ");
        if (Test.testBasicTable()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.print("General table: ");
        if (Test.testGeneralTable()) {
            System.out.println("OK.");
            ++succeeded;
        } else {
            System.out.println("failed.");
            ++failed;
        }
        System.out.println();
        Runtime rt = Runtime.getRuntime();
        long free_memory = rt.freeMemory() / 1000000L;
        long total_memory = rt.totalMemory() / 1000000L;
        System.out.println("Running time    : " + (new Date().getTime() - start_time) + "ms " + "(free memory: " + free_memory + "MB, total memory: " + total_memory + "MB)");
        System.out.println();
        System.out.println("Successful tests: " + succeeded);
        System.out.println("Failed     tests: " + failed);
        System.out.println();
        if (failed < 1) {
            System.out.println("OK.");
        } else {
            System.out.println("Not OK.");
        }
    }

    private static boolean testConfidenceAssessor() {
        PhylogenyFactory factory;
        block10: {
            Phylogeny t1;
            block9: {
                block8: {
                    Phylogeny t0;
                    block7: {
                        factory = ParserBasedPhylogenyFactory.getInstance();
                        t0 = factory.create("((((A,B)ab,C)abc,D)abcd,E)abcde", new NHXParser())[0];
                        Phylogeny[] ev0 = factory.create("((((A,B),C),D),E);((((A,B),C),D),E);((((A,B),C),D),E);((((A,B),C),D),E);", new NHXParser());
                        ConfidenceAssessor.evaluate("bootstrap", ev0, t0, false, 1.0, 0, 2);
                        if (Test.isEqual(t0.getNode("ab").getBranchData().getConfidence(0).getValue(), 3.0)) break block7;
                        return false;
                    }
                    if (Test.isEqual(t0.getNode("abc").getBranchData().getConfidence(0).getValue(), 3.0)) break block8;
                    return false;
                }
                t1 = factory.create("((((A,B)ab,C)abc,D)abcd,E)abcde", new NHXParser())[0];
                Phylogeny[] ev1 = factory.create("((((A,B),C),D),E);((A,B),((E,D),C));(((A,B),C),(E,D));(A,(((E,D),C),B));(B,(A,((E,D),C)));(C,((E,D),(A,B)));(D,(E,((A,B),C)));", new NHXParser());
                ConfidenceAssessor.evaluate("bootstrap", ev1, t1, false, 1.0);
                if (Test.isEqual(t1.getNode("ab").getBranchData().getConfidence(0).getValue(), 7.0)) break block9;
                return false;
            }
            if (Test.isEqual(t1.getNode("abc").getBranchData().getConfidence(0).getValue(), 7.0)) break block10;
            return false;
        }
        try {
            Phylogeny[] t2 = factory.create("((((a,b),c),d),e);(((a,b),c),(d,e));(((((a,b),c),d),e),f);((((a,b),c),(d,e)),f);(((a,b),c),d,e);((a,b,c),d,e);", new NHXParser());
            Phylogeny[] ev2 = factory.create("((((a,b),c),d),e);((((a,b),c),d),e);((((a,b),e),d),c);((((a,b),e),d),c);(((a,b),(c,d)),e);((a,b),x);((a,b),(x,y));(a,b);(a,e);(a,b,c);", new NHXParser());
            Phylogeny[] phylogenyArray = t2;
            int n = t2.length;
            int n2 = 0;
            while (n2 < n) {
                Phylogeny target = phylogenyArray[n2];
                ConfidenceAssessor.evaluate("bootstrap", ev2, target, false, 1.0);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static boolean testSplit() {
        HashSet<PhylogenyNode> query_nodes;
        TreeSplitMatrix s0;
        block47: {
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                block37: {
                                                    block36: {
                                                        block35: {
                                                            block34: {
                                                                block33: {
                                                                    block32: {
                                                                        block31: {
                                                                            block30: {
                                                                                block29: {
                                                                                    block28: {
                                                                                        block27: {
                                                                                            block26: {
                                                                                                block25: {
                                                                                                    try {
                                                                                                        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                        Phylogeny p0 = factory.create("(((A,B,C),D),(E,(F,G)))R", new NHXParser())[0];
                                                                                                        HashSet<PhylogenyNode> ex = new HashSet<PhylogenyNode>();
                                                                                                        ex.add(new PhylogenyNode("A"));
                                                                                                        ex.add(new PhylogenyNode("B"));
                                                                                                        ex.add(new PhylogenyNode("C"));
                                                                                                        ex.add(new PhylogenyNode("D"));
                                                                                                        ex.add(new PhylogenyNode("E"));
                                                                                                        ex.add(new PhylogenyNode("F"));
                                                                                                        ex.add(new PhylogenyNode("G"));
                                                                                                        s0 = new TreeSplitMatrix(p0, false, ex);
                                                                                                        query_nodes = new HashSet<PhylogenyNode>();
                                                                                                        query_nodes.add(new PhylogenyNode("A"));
                                                                                                        query_nodes.add(new PhylogenyNode("B"));
                                                                                                        if (!s0.match(query_nodes)) break block25;
                                                                                                        return false;
                                                                                                    }
                                                                                                    catch (Exception e) {
                                                                                                        e.printStackTrace();
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                                query_nodes = new HashSet();
                                                                                                query_nodes.add(new PhylogenyNode("A"));
                                                                                                query_nodes.add(new PhylogenyNode("B"));
                                                                                                query_nodes.add(new PhylogenyNode("C"));
                                                                                                query_nodes.add(new PhylogenyNode("D"));
                                                                                                query_nodes.add(new PhylogenyNode("E"));
                                                                                                query_nodes.add(new PhylogenyNode("F"));
                                                                                                query_nodes.add(new PhylogenyNode("G"));
                                                                                                if (s0.match(query_nodes)) break block26;
                                                                                                return false;
                                                                                            }
                                                                                            query_nodes = new HashSet();
                                                                                            query_nodes.add(new PhylogenyNode("A"));
                                                                                            query_nodes.add(new PhylogenyNode("B"));
                                                                                            query_nodes.add(new PhylogenyNode("C"));
                                                                                            if (s0.match(query_nodes)) break block27;
                                                                                            return false;
                                                                                        }
                                                                                        query_nodes = new HashSet();
                                                                                        query_nodes.add(new PhylogenyNode("D"));
                                                                                        query_nodes.add(new PhylogenyNode("E"));
                                                                                        query_nodes.add(new PhylogenyNode("F"));
                                                                                        query_nodes.add(new PhylogenyNode("G"));
                                                                                        if (s0.match(query_nodes)) break block28;
                                                                                        return false;
                                                                                    }
                                                                                    query_nodes = new HashSet();
                                                                                    query_nodes.add(new PhylogenyNode("A"));
                                                                                    query_nodes.add(new PhylogenyNode("B"));
                                                                                    query_nodes.add(new PhylogenyNode("C"));
                                                                                    query_nodes.add(new PhylogenyNode("D"));
                                                                                    if (s0.match(query_nodes)) break block29;
                                                                                    return false;
                                                                                }
                                                                                query_nodes = new HashSet();
                                                                                query_nodes.add(new PhylogenyNode("E"));
                                                                                query_nodes.add(new PhylogenyNode("F"));
                                                                                query_nodes.add(new PhylogenyNode("G"));
                                                                                if (s0.match(query_nodes)) break block30;
                                                                                return false;
                                                                            }
                                                                            query_nodes = new HashSet();
                                                                            query_nodes.add(new PhylogenyNode("F"));
                                                                            query_nodes.add(new PhylogenyNode("G"));
                                                                            if (s0.match(query_nodes)) break block31;
                                                                            return false;
                                                                        }
                                                                        query_nodes = new HashSet();
                                                                        query_nodes.add(new PhylogenyNode("E"));
                                                                        query_nodes.add(new PhylogenyNode("D"));
                                                                        query_nodes.add(new PhylogenyNode("C"));
                                                                        query_nodes.add(new PhylogenyNode("B"));
                                                                        query_nodes.add(new PhylogenyNode("A"));
                                                                        if (s0.match(query_nodes)) break block32;
                                                                        return false;
                                                                    }
                                                                    query_nodes = new HashSet();
                                                                    query_nodes.add(new PhylogenyNode("F"));
                                                                    query_nodes.add(new PhylogenyNode("G"));
                                                                    query_nodes.add(new PhylogenyNode("E"));
                                                                    if (s0.match(query_nodes)) break block33;
                                                                    return false;
                                                                }
                                                                query_nodes = new HashSet();
                                                                query_nodes.add(new PhylogenyNode("F"));
                                                                query_nodes.add(new PhylogenyNode("G"));
                                                                query_nodes.add(new PhylogenyNode("E"));
                                                                query_nodes.add(new PhylogenyNode("D"));
                                                                if (s0.match(query_nodes)) break block34;
                                                                return false;
                                                            }
                                                            query_nodes = new HashSet();
                                                            query_nodes.add(new PhylogenyNode("F"));
                                                            query_nodes.add(new PhylogenyNode("A"));
                                                            if (!s0.match(query_nodes)) break block35;
                                                            return false;
                                                        }
                                                        query_nodes = new HashSet();
                                                        query_nodes.add(new PhylogenyNode("A"));
                                                        query_nodes.add(new PhylogenyNode("E"));
                                                        query_nodes.add(new PhylogenyNode("B"));
                                                        query_nodes.add(new PhylogenyNode("C"));
                                                        if (!s0.match(query_nodes)) break block36;
                                                        return false;
                                                    }
                                                    query_nodes = new HashSet();
                                                    query_nodes.add(new PhylogenyNode("F"));
                                                    query_nodes.add(new PhylogenyNode("G"));
                                                    query_nodes.add(new PhylogenyNode("E"));
                                                    query_nodes.add(new PhylogenyNode("D"));
                                                    query_nodes.add(new PhylogenyNode("C"));
                                                    if (!s0.match(query_nodes)) break block37;
                                                    return false;
                                                }
                                                query_nodes = new HashSet();
                                                query_nodes.add(new PhylogenyNode("A"));
                                                query_nodes.add(new PhylogenyNode("B"));
                                                query_nodes.add(new PhylogenyNode("D"));
                                                if (!s0.match(query_nodes)) break block38;
                                                return false;
                                            }
                                            query_nodes = new HashSet();
                                            query_nodes.add(new PhylogenyNode("A"));
                                            query_nodes.add(new PhylogenyNode("D"));
                                            if (!s0.match(query_nodes)) break block39;
                                            return false;
                                        }
                                        query_nodes = new HashSet();
                                        query_nodes.add(new PhylogenyNode("A"));
                                        query_nodes.add(new PhylogenyNode("B"));
                                        if (!s0.match(query_nodes)) break block40;
                                        return false;
                                    }
                                    query_nodes = new HashSet();
                                    query_nodes.add(new PhylogenyNode("A"));
                                    query_nodes.add(new PhylogenyNode("C"));
                                    if (!s0.match(query_nodes)) break block41;
                                    return false;
                                }
                                query_nodes = new HashSet();
                                query_nodes.add(new PhylogenyNode("A"));
                                query_nodes.add(new PhylogenyNode("E"));
                                if (!s0.match(query_nodes)) break block42;
                                return false;
                            }
                            query_nodes = new HashSet();
                            query_nodes.add(new PhylogenyNode("A"));
                            query_nodes.add(new PhylogenyNode("F"));
                            if (!s0.match(query_nodes)) break block43;
                            return false;
                        }
                        query_nodes = new HashSet();
                        query_nodes.add(new PhylogenyNode("A"));
                        query_nodes.add(new PhylogenyNode("G"));
                        if (!s0.match(query_nodes)) break block44;
                        return false;
                    }
                    query_nodes = new HashSet();
                    query_nodes.add(new PhylogenyNode("A"));
                    query_nodes.add(new PhylogenyNode("F"));
                    query_nodes.add(new PhylogenyNode("G"));
                    if (!s0.match(query_nodes)) break block45;
                    return false;
                }
                query_nodes = new HashSet();
                query_nodes.add(new PhylogenyNode("A"));
                query_nodes.add(new PhylogenyNode("B"));
                query_nodes.add(new PhylogenyNode("D"));
                if (!s0.match(query_nodes)) break block46;
                return false;
            }
            query_nodes = new HashSet();
            query_nodes.add(new PhylogenyNode("E"));
            query_nodes.add(new PhylogenyNode("D"));
            query_nodes.add(new PhylogenyNode("A"));
            if (!s0.match(query_nodes)) break block47;
            return false;
        }
        query_nodes = new HashSet();
        query_nodes.add(new PhylogenyNode("E"));
        query_nodes.add(new PhylogenyNode("D"));
        query_nodes.add(new PhylogenyNode("A"));
        query_nodes.add(new PhylogenyNode("G"));
        return !s0.match(query_nodes);
    }

    private static boolean testBasicNodeMethods() {
        PhylogenyNode n4;
        block15: {
            PhylogenyNode n3;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    try {
                                        if (PhylogenyNode.getNodeCount() == 0) break block9;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace(System.out);
                                        return false;
                                    }
                                }
                                PhylogenyNode n1 = new PhylogenyNode();
                                PhylogenyNode n2 = new PhylogenyNode("", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                n3 = new PhylogenyNode("n3", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                n4 = new PhylogenyNode("n4:0.01", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                if (!n1.isHasAssignedEvent()) break block10;
                                return false;
                            }
                            if (PhylogenyNode.getNodeCount() == 4) break block11;
                            return false;
                        }
                        if (n3.getIndicator() == 0) break block12;
                        return false;
                    }
                    if (n3.getNumberOfExternalNodes() == 1) break block13;
                    return false;
                }
                if (n3.isExternal()) break block14;
                return false;
            }
            if (n3.isRoot()) break block15;
            return false;
        }
        return n4.getNodeName().equals("n4");
    }

    private static boolean testBasicPhyloXMLparsing() {
        Phylogeny t3;
        block79: {
            block78: {
                block77: {
                    block76: {
                        block75: {
                            block74: {
                                block73: {
                                    block72: {
                                        block71: {
                                            block70: {
                                                block69: {
                                                    block68: {
                                                        block67: {
                                                            block66: {
                                                                block65: {
                                                                    block64: {
                                                                        block63: {
                                                                            block62: {
                                                                                block61: {
                                                                                    block60: {
                                                                                        block59: {
                                                                                            block58: {
                                                                                                block57: {
                                                                                                    block56: {
                                                                                                        block55: {
                                                                                                            block54: {
                                                                                                                Phylogeny t4;
                                                                                                                block53: {
                                                                                                                    block52: {
                                                                                                                        Phylogeny t2;
                                                                                                                        block51: {
                                                                                                                            Phylogeny t1;
                                                                                                                            block50: {
                                                                                                                                block49: {
                                                                                                                                    block48: {
                                                                                                                                        block47: {
                                                                                                                                            block46: {
                                                                                                                                                block45: {
                                                                                                                                                    block44: {
                                                                                                                                                        block43: {
                                                                                                                                                            Phylogeny[] phylogenies_0;
                                                                                                                                                            block42: {
                                                                                                                                                                block41: {
                                                                                                                                                                    try {
                                                                                                                                                                        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                        PhyloXmlParser xml_parser = new PhyloXmlParser();
                                                                                                                                                                        phylogenies_0 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "phyloxml_test_t1.xml", xml_parser);
                                                                                                                                                                        if (xml_parser.getErrorCount() <= 0) break block41;
                                                                                                                                                                        System.out.println(xml_parser.getErrorMessages().toString());
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    catch (Exception e) {
                                                                                                                                                                        e.printStackTrace(System.out);
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                                if (phylogenies_0.length == 4) break block42;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            t1 = phylogenies_0[0];
                                                                                                                                                            t2 = phylogenies_0[1];
                                                                                                                                                            t3 = phylogenies_0[2];
                                                                                                                                                            t4 = phylogenies_0[3];
                                                                                                                                                            if (t1.getNumberOfExternalNodes() == 1) break block43;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (t1.isRooted()) break block44;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (!t1.isRerootable()) break block45;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (t1.getType().equals("gene_tree")) break block46;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (t2.getNumberOfExternalNodes() == 2) break block47;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (Test.isEqual(t2.getNode("node a").getDistanceToParent(), 1.0)) break block48;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (Test.isEqual(t2.getNode("node b").getDistanceToParent(), 2.0)) break block49;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (t3.getNumberOfExternalNodes() == 4) break block50;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (t1.getName().equals("t1")) break block51;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (t2.getName().equals("t2")) break block52;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (t3.getName().equals("t3")) break block53;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (t4.getName().equals("t4")) break block54;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (t3.getIdentifier().getValue().equals("1-1")) break block55;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (t3.getIdentifier().getProvider().equals("treebank")) break block56;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (t3.getNode("root node").getNodeData().getSequence().getType().equals("protein")) break block57;
                                                                                                    return false;
                                                                                                }
                                                                                                if (t3.getNode("root node").getNodeData().getSequence().getName().equals("Apoptosis facilitator Bcl-2-like 14 protein")) break block58;
                                                                                                return false;
                                                                                            }
                                                                                            if (t3.getNode("root node").getNodeData().getSequence().getSymbol().equals("BCL2L14")) break block59;
                                                                                            return false;
                                                                                        }
                                                                                        if (t3.getNode("root node").getNodeData().getSequence().getAccession().getValue().equals("Q9BZR8")) break block60;
                                                                                        return false;
                                                                                    }
                                                                                    if (t3.getNode("root node").getNodeData().getSequence().getAccession().getSource().equals("UniProtKB")) break block61;
                                                                                    return false;
                                                                                }
                                                                                if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getDesc().equals("apoptosis")) break block62;
                                                                                return false;
                                                                            }
                                                                            if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getRef().equals("GO:0006915")) break block63;
                                                                            return false;
                                                                        }
                                                                        if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getSource().equals("UniProtKB")) break block64;
                                                                        return false;
                                                                    }
                                                                    if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getEvidence().equals("experimental")) break block65;
                                                                    return false;
                                                                }
                                                                if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getType().equals("function")) break block66;
                                                                return false;
                                                            }
                                                            if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getConfidence().getValue() == 1.0) break block67;
                                                            return false;
                                                        }
                                                        if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getConfidence().getType().equals("ml")) break block68;
                                                        return false;
                                                    }
                                                    if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getDesc().equals("apoptosis")) break block69;
                                                    return false;
                                                }
                                                if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getAppliesTo() == Property.AppliesTo.ANNOTATION) break block70;
                                                return false;
                                            }
                                            if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getDataType().equals("xsd:double")) break block71;
                                            return false;
                                        }
                                        if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getRef().equals("AFFY:expression")) break block72;
                                        return false;
                                    }
                                    if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getUnit().equals("AFFY:x")) break block73;
                                    return false;
                                }
                                if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getValue().equals("0.2")) break block74;
                                return false;
                            }
                            if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("MED:disease").getValue().equals("lymphoma")) break block75;
                            return false;
                        }
                        if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(1)).getRef().equals("GO:0005829")) break block76;
                        return false;
                    }
                    if (((Annotation)t3.getNode("root node").getNodeData().getSequence().getAnnotation(2)).getDesc().equals("intracellular organelle")) break block77;
                    return false;
                }
                if (t3.getNode("root node").getNodeData().getSequence().getUri().getType().equals("source")) break block78;
                return false;
            }
            if (t3.getNode("root node").getNodeData().getSequence().getUri().getDescription().equals("UniProt link")) break block79;
            return false;
        }
        return t3.getNode("root node").getNodeData().getSequence().getLocation().equals("12p13-p12");
    }

    private static boolean testBasicPhyloXMLparsingRoundtrip() {
        Phylogeny t3_rt;
        block159: {
            block158: {
                block157: {
                    block156: {
                        block155: {
                            block154: {
                                block153: {
                                    block152: {
                                        block151: {
                                            block150: {
                                                block149: {
                                                    block148: {
                                                        block147: {
                                                            block146: {
                                                                block145: {
                                                                    Taxonomy taxbb;
                                                                    block144: {
                                                                        block143: {
                                                                            block142: {
                                                                                block141: {
                                                                                    block140: {
                                                                                        block139: {
                                                                                            block138: {
                                                                                                block137: {
                                                                                                    block136: {
                                                                                                        block135: {
                                                                                                            block134: {
                                                                                                                block133: {
                                                                                                                    block132: {
                                                                                                                        block131: {
                                                                                                                            block130: {
                                                                                                                                block129: {
                                                                                                                                    block128: {
                                                                                                                                        block127: {
                                                                                                                                            block126: {
                                                                                                                                                block125: {
                                                                                                                                                    block124: {
                                                                                                                                                        block123: {
                                                                                                                                                            block122: {
                                                                                                                                                                block121: {
                                                                                                                                                                    block120: {
                                                                                                                                                                        block119: {
                                                                                                                                                                            block118: {
                                                                                                                                                                                block117: {
                                                                                                                                                                                    block116: {
                                                                                                                                                                                        block115: {
                                                                                                                                                                                            block114: {
                                                                                                                                                                                                block113: {
                                                                                                                                                                                                    block112: {
                                                                                                                                                                                                        block111: {
                                                                                                                                                                                                            block110: {
                                                                                                                                                                                                                block109: {
                                                                                                                                                                                                                    block108: {
                                                                                                                                                                                                                        block107: {
                                                                                                                                                                                                                            block106: {
                                                                                                                                                                                                                                block105: {
                                                                                                                                                                                                                                    block104: {
                                                                                                                                                                                                                                        block103: {
                                                                                                                                                                                                                                            block102: {
                                                                                                                                                                                                                                                block101: {
                                                                                                                                                                                                                                                    block100: {
                                                                                                                                                                                                                                                        block99: {
                                                                                                                                                                                                                                                            block98: {
                                                                                                                                                                                                                                                                block97: {
                                                                                                                                                                                                                                                                    block96: {
                                                                                                                                                                                                                                                                        block95: {
                                                                                                                                                                                                                                                                            block94: {
                                                                                                                                                                                                                                                                                block93: {
                                                                                                                                                                                                                                                                                    block92: {
                                                                                                                                                                                                                                                                                        block91: {
                                                                                                                                                                                                                                                                                            block90: {
                                                                                                                                                                                                                                                                                                block89: {
                                                                                                                                                                                                                                                                                                    Phylogeny[] phylogenies_1;
                                                                                                                                                                                                                                                                                                    block88: {
                                                                                                                                                                                                                                                                                                        Phylogeny[] phylogenies_0;
                                                                                                                                                                                                                                                                                                        PhyloXmlParser xml_parser;
                                                                                                                                                                                                                                                                                                        PhylogenyFactory factory;
                                                                                                                                                                                                                                                                                                        block87: {
                                                                                                                                                                                                                                                                                                            Phylogeny t1_rt;
                                                                                                                                                                                                                                                                                                            block86: {
                                                                                                                                                                                                                                                                                                                block85: {
                                                                                                                                                                                                                                                                                                                    block84: {
                                                                                                                                                                                                                                                                                                                        Phylogeny[] phylogenies_t1;
                                                                                                                                                                                                                                                                                                                        block83: {
                                                                                                                                                                                                                                                                                                                            block82: {
                                                                                                                                                                                                                                                                                                                                block81: {
                                                                                                                                                                                                                                                                                                                                    try {
                                                                                                                                                                                                                                                                                                                                        factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                                        xml_parser = new PhyloXmlParser();
                                                                                                                                                                                                                                                                                                                                        xml_parser.setValidateAgainstSchema(PHYLOXML_LOCAL_XSD);
                                                                                                                                                                                                                                                                                                                                        phylogenies_0 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "phyloxml_test_t1.xml", xml_parser);
                                                                                                                                                                                                                                                                                                                                        if (xml_parser.getErrorCount() <= 0) break block81;
                                                                                                                                                                                                                                                                                                                                        System.out.println(xml_parser.getErrorMessages().toString());
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    catch (Exception e) {
                                                                                                                                                                                                                                                                                                                                        e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (phylogenies_0.length == 4) break block82;
                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            StringBuffer t1_sb = new StringBuffer(phylogenies_0[0].toPhyloXML(0));
                                                                                                                                                                                                                                                                                                                            phylogenies_t1 = factory.create(t1_sb, xml_parser);
                                                                                                                                                                                                                                                                                                                            if (phylogenies_t1.length == 1) break block83;
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        t1_rt = phylogenies_t1[0];
                                                                                                                                                                                                                                                                                                                        if (t1_rt.getDistanceUnit().equals("cc")) break block84;
                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (t1_rt.isRooted()) break block85;
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (!t1_rt.isRerootable()) break block86;
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (t1_rt.getType().equals("gene_tree")) break block87;
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        StringBuffer t3_sb_0 = new StringBuffer(phylogenies_0[2].toPhyloXML(0));
                                                                                                                                                                                                                                                                                                        Phylogeny[] phylogenies_1_0 = factory.create(t3_sb_0, xml_parser);
                                                                                                                                                                                                                                                                                                        StringBuffer t3_sb = new StringBuffer(phylogenies_1_0[0].toPhyloXML(0));
                                                                                                                                                                                                                                                                                                        phylogenies_1 = factory.create(t3_sb, xml_parser);
                                                                                                                                                                                                                                                                                                        if (phylogenies_1.length == 1) break block88;
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    t3_rt = phylogenies_1[0];
                                                                                                                                                                                                                                                                                                    if (t3_rt.getName().equals("t3")) break block89;
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (t3_rt.getNumberOfExternalNodes() == 4) break block90;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (t3_rt.getIdentifier().getValue().equals("1-1")) break block91;
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (t3_rt.getIdentifier().getProvider().equals("treebank")) break block92;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (t3_rt.getNode("root node").getNodeData().getSequence().getType().equals("protein")) break block93;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (t3_rt.getNode("root node").getNodeData().getSequence().getName().equals("Apoptosis facilitator Bcl-2-like 14 protein")) break block94;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (t3_rt.getNode("root node").getNodeData().getSequence().getSymbol().equals("BCL2L14")) break block95;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (t3_rt.getNode("root node").getNodeData().getSequence().getAccession().getValue().equals("Q9BZR8")) break block96;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (t3_rt.getNode("root node").getNodeData().getSequence().getAccession().getSource().equals("UniProtKB")) break block97;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getDesc().equals("apoptosis")) break block98;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getRef().equals("GO:0006915")) break block99;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getSource().equals("UniProtKB")) break block100;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getEvidence().equals("experimental")) break block101;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getType().equals("function")) break block102;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getConfidence().getValue() == 1.0) break block103;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getConfidence().getType().equals("ml")) break block104;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getDesc().equals("apoptosis")) break block105;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getAppliesTo() == Property.AppliesTo.ANNOTATION) break block106;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getDataType().equals("xsd:double")) break block107;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getRef().equals("AFFY:expression")) break block108;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getUnit().equals("AFFY:x")) break block109;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("AFFY:expression").getValue().equals("0.2")) break block110;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(0)).getProperties().getProperty("MED:disease").getValue().equals("lymphoma")) break block111;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(1)).getRef().equals("GO:0005829")) break block112;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (((Annotation)t3_rt.getNode("root node").getNodeData().getSequence().getAnnotation(2)).getDesc().equals("intracellular organelle")) break block113;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (t3_rt.getNode("root node").getNodeData().getSequence().getUri().getType().equals("source")) break block114;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (t3_rt.getNode("root node").getNodeData().getSequence().getUri().getDescription().equals("UniProt link")) break block115;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (t3_rt.getNode("root node").getNodeData().getSequence().getLocation().equals("12p13-p12")) break block116;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (t3_rt.getNode("root node").getNodeData().getReference().getDoi().equals("10.1074/jbc.M005889200")) break block117;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (t3_rt.getNode("root node").getNodeData().getTaxonomy().getTaxonomyCode().equals("ECDYS")) break block118;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (t3_rt.getNode("root node").getNodeData().getTaxonomy().getScientificName().equals("ecdysozoa")) break block119;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (t3_rt.getNode("root node").getNodeData().getTaxonomy().getCommonName().equals("molting animals")) break block120;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (t3_rt.getNode("root node").getNodeData().getTaxonomy().getIdentifier().getValue().equals("1")) break block121;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (t3_rt.getNode("root node").getNodeData().getTaxonomy().getIdentifier().getProvider().equals("ncbi")) break block122;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (t3_rt.getNode("node bc").getNodeData().getSequence().getDomainArchitecture().getTotalLength() == 124) break block123;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (t3_rt.getNode("node bc").getNodeData().getSequence().getDomainArchitecture().getDomain(0).getName().equals("B")) break block124;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (t3_rt.getNode("node bc").getNodeData().getSequence().getDomainArchitecture().getDomain(0).getFrom() == 21) break block125;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (t3_rt.getNode("node bc").getNodeData().getSequence().getDomainArchitecture().getDomain(0).getTo() == 44) break block126;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (t3_rt.getNode("node bc").getNodeData().getSequence().getDomainArchitecture().getDomain(0).getLength() == 24) break block127;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (t3_rt.getNode("node bc").getNodeData().getSequence().getDomainArchitecture().getDomain(0).getConfidence() == 2144.0) break block128;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (t3_rt.getNode("node bc").getNodeData().getSequence().getDomainArchitecture().getDomain(0).getId().equals("pfam")) break block129;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (t3_rt.getNode("node bb").getNodeData().getBinaryCharacters().getGainedCharacters().size() == 3) break block130;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (t3_rt.getNode("node bb").getNodeData().getBinaryCharacters().getPresentCharacters().size() == 2) break block131;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (t3_rt.getNode("node bb").getNodeData().getBinaryCharacters().getLostCharacters().size() == 1) break block132;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (t3_rt.getNode("node bb").getNodeData().getBinaryCharacters().getType().equals("domains")) break block133;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                taxbb = t3_rt.getNode("node bb").getNodeData().getTaxonomy();
                                                                                                                if (taxbb.getAuthority().equals("Stephenson, 1935")) break block134;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (taxbb.getCommonName().equals("starlet sea anemone")) break block135;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (taxbb.getIdentifier().getProvider().equals("EOL")) break block136;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (taxbb.getIdentifier().getValue().equals("704294")) break block137;
                                                                                                    return false;
                                                                                                }
                                                                                                if (taxbb.getTaxonomyCode().equals("NEMVE")) break block138;
                                                                                                return false;
                                                                                            }
                                                                                            if (taxbb.getScientificName().equals("Nematostella vectensis")) break block139;
                                                                                            return false;
                                                                                        }
                                                                                        if (taxbb.getSynonyms().size() == 2) break block140;
                                                                                        return false;
                                                                                    }
                                                                                    if (taxbb.getSynonyms().contains("Nematostella vectensis Stephenson1935")) break block141;
                                                                                    return false;
                                                                                }
                                                                                if (taxbb.getSynonyms().contains("See Anemone")) break block142;
                                                                                return false;
                                                                            }
                                                                            if (taxbb.getUri().getDescription().equals("EOL")) break block143;
                                                                            return false;
                                                                        }
                                                                        if (taxbb.getUri().getType().equals("linkout")) break block144;
                                                                        return false;
                                                                    }
                                                                    if (taxbb.getUri().getValue().toString().equals("http://www.eol.org/pages/704294")) break block145;
                                                                    return false;
                                                                }
                                                                if (((BinaryCharacters)t3_rt.getNode("node bb").getNodeData().getBinaryCharacters().copy()).getLostCount() == -1) break block146;
                                                                return false;
                                                            }
                                                            if (t3_rt.getNode("node b").getNodeData().getBinaryCharacters().getGainedCount() == 1) break block147;
                                                            return false;
                                                        }
                                                        if (t3_rt.getNode("node b").getNodeData().getBinaryCharacters().getGainedCharacters().size() == 1) break block148;
                                                        return false;
                                                    }
                                                    if (t3_rt.getNode("node b").getNodeData().getBinaryCharacters().getLostCount() == 3) break block149;
                                                    return false;
                                                }
                                                if (t3_rt.getNode("node b").getNodeData().getBinaryCharacters().getLostCharacters().size() == 3) break block150;
                                                return false;
                                            }
                                            if (t3_rt.getNode("node b").getNodeData().getBinaryCharacters().getPresentCount() == 2) break block151;
                                            return false;
                                        }
                                        if (t3_rt.getNode("node b").getNodeData().getBinaryCharacters().getPresentCharacters().size() == 2) break block152;
                                        return false;
                                    }
                                    if (t3_rt.getNode("node b").getNodeData().getBinaryCharacters().getType().equals("characters")) break block153;
                                    return false;
                                }
                                if (t3_rt.getNode("node ba").getNodeData().getDate().getDesc().equals("Silurian")) break block154;
                                return false;
                            }
                            if (t3_rt.getNode("node ba").getNodeData().getDate().getValue().toPlainString().equalsIgnoreCase("435")) break block155;
                            return false;
                        }
                        if (t3_rt.getNode("node ba").getNodeData().getDate().getMin().toPlainString().equalsIgnoreCase("416")) break block156;
                        return false;
                    }
                    if (t3_rt.getNode("node ba").getNodeData().getDate().getMax().toPlainString().equalsIgnoreCase("443.7")) break block157;
                    return false;
                }
                if (t3_rt.getNode("node ba").getNodeData().getDate().getUnit().equals("mya")) break block158;
                return false;
            }
            if (t3_rt.getNode("node bb").getNodeData().getDate().getDesc().equals("Triassic")) break block159;
            return false;
        }
        return t3_rt.getNode("node bc").getNodeData().getDate().getValue().toPlainString().equalsIgnoreCase("433");
    }

    private static boolean testBasicPhyloXMLparsingValidating() {
        Phylogeny s;
        block50: {
            Phylogeny[] phylogenies_4;
            block49: {
                block48: {
                    PhyloXmlParser xml_parser;
                    PhylogenyFactory factory;
                    block47: {
                        Phylogeny a;
                        block46: {
                            block45: {
                                block44: {
                                    Phylogeny[] phylogenies_3;
                                    block43: {
                                        block42: {
                                            block41: {
                                                Phylogeny[] phylogenies_2;
                                                block40: {
                                                    block39: {
                                                        block38: {
                                                            Phylogeny[] phylogenies_1;
                                                            block37: {
                                                                block36: {
                                                                    Phylogeny t3;
                                                                    block35: {
                                                                        Phylogeny t2;
                                                                        block34: {
                                                                            Phylogeny t1;
                                                                            block33: {
                                                                                Phylogeny t4;
                                                                                block32: {
                                                                                    block31: {
                                                                                        block30: {
                                                                                            Phylogeny[] phylogenies_0;
                                                                                            block29: {
                                                                                                block28: {
                                                                                                    try {
                                                                                                        factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                        xml_parser = null;
                                                                                                        try {
                                                                                                            xml_parser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
                                                                                                        }
                                                                                                        catch (Exception exception) {
                                                                                                            // empty catch block
                                                                                                        }
                                                                                                        if (xml_parser == null) {
                                                                                                            xml_parser = new PhyloXmlParser();
                                                                                                            xml_parser.setValidateAgainstSchema(PHYLOXML_LOCAL_XSD);
                                                                                                        }
                                                                                                        phylogenies_0 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "phyloxml_test_t1.xml", xml_parser);
                                                                                                        if (xml_parser.getErrorCount() <= 0) break block28;
                                                                                                        System.out.println(xml_parser.getErrorMessages().toString());
                                                                                                        return false;
                                                                                                    }
                                                                                                    catch (Exception e) {
                                                                                                        e.printStackTrace(System.out);
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                                if (phylogenies_0.length == 4) break block29;
                                                                                                return false;
                                                                                            }
                                                                                            t1 = phylogenies_0[0];
                                                                                            t2 = phylogenies_0[1];
                                                                                            t3 = phylogenies_0[2];
                                                                                            t4 = phylogenies_0[3];
                                                                                            if (t1.getName().equals("t1")) break block30;
                                                                                            return false;
                                                                                        }
                                                                                        if (t2.getName().equals("t2")) break block31;
                                                                                        return false;
                                                                                    }
                                                                                    if (t3.getName().equals("t3")) break block32;
                                                                                    return false;
                                                                                }
                                                                                if (t4.getName().equals("t4")) break block33;
                                                                                return false;
                                                                            }
                                                                            if (t1.getNumberOfExternalNodes() == 1) break block34;
                                                                            return false;
                                                                        }
                                                                        if (t2.getNumberOfExternalNodes() == 2) break block35;
                                                                        return false;
                                                                    }
                                                                    if (t3.getNumberOfExternalNodes() == 4) break block36;
                                                                    return false;
                                                                }
                                                                String x2 = String.valueOf(PATH_TO_TEST_DATA) + "phyloxml_test_t1.xml";
                                                                phylogenies_1 = factory.create(x2, xml_parser);
                                                                if (xml_parser.getErrorCount() <= 0) break block37;
                                                                System.out.println("errors:");
                                                                System.out.println(xml_parser.getErrorMessages().toString());
                                                                return false;
                                                            }
                                                            if (phylogenies_1.length == 4) break block38;
                                                            return false;
                                                        }
                                                        phylogenies_2 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "phyloxml_test_t3.xml", xml_parser);
                                                        if (xml_parser.getErrorCount() <= 0) break block39;
                                                        System.out.println("errors:");
                                                        System.out.println(xml_parser.getErrorMessages().toString());
                                                        return false;
                                                    }
                                                    if (phylogenies_2.length == 1) break block40;
                                                    return false;
                                                }
                                                if (phylogenies_2[0].getNumberOfExternalNodes() == 2) break block41;
                                                return false;
                                            }
                                            phylogenies_3 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "phyloxml_test_t4.xml", xml_parser);
                                            if (xml_parser.getErrorCount() <= 0) break block42;
                                            System.out.println(xml_parser.getErrorMessages().toString());
                                            return false;
                                        }
                                        if (phylogenies_3.length == 2) break block43;
                                        return false;
                                    }
                                    a = phylogenies_3[0];
                                    if (a.getName().equals("tree 4")) break block44;
                                    return false;
                                }
                                if (a.getNumberOfExternalNodes() == 3) break block45;
                                return false;
                            }
                            if (a.getNode("node b1").getNodeData().getSequence().getName().equals("b1 gene")) break block46;
                            return false;
                        }
                        if (a.getNode("node b1").getNodeData().getTaxonomy().getCommonName().equals("b1 species")) break block47;
                        return false;
                    }
                    phylogenies_4 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "special_characters.xml", xml_parser);
                    if (xml_parser.getErrorCount() <= 0) break block48;
                    System.out.println(xml_parser.getErrorMessages().toString());
                    return false;
                }
                if (phylogenies_4.length == 1) break block49;
                return false;
            }
            s = phylogenies_4[0];
            if (s.getNumberOfExternalNodes() == 6) break block50;
            return false;
        }
        s.getNode("first");
        s.getNode("<>");
        s.getNode("\"<a'b&c'd\">\"");
        s.getNode("'''\"");
        s.getNode("\"\"\"");
        s.getNode("dick & doof");
        return true;
    }

    private static boolean testBasicTable() {
        BasicTable<String> t4;
        block65: {
            BasicTable<String> t3;
            block64: {
                block63: {
                    block62: {
                        block61: {
                            List<BasicTable<String>> tl;
                            block60: {
                                String l;
                                block59: {
                                    BasicTable<String> t2;
                                    block58: {
                                        block57: {
                                            block56: {
                                                block55: {
                                                    block54: {
                                                        block53: {
                                                            block52: {
                                                                block51: {
                                                                    BasicTable<String> t1;
                                                                    block50: {
                                                                        block49: {
                                                                            block48: {
                                                                                block47: {
                                                                                    block46: {
                                                                                        block45: {
                                                                                            BasicTable<String> t0;
                                                                                            block44: {
                                                                                                block43: {
                                                                                                    block42: {
                                                                                                        block41: {
                                                                                                            block40: {
                                                                                                                block39: {
                                                                                                                    block38: {
                                                                                                                        block37: {
                                                                                                                            block36: {
                                                                                                                                block35: {
                                                                                                                                    block34: {
                                                                                                                                        try {
                                                                                                                                            t0 = new BasicTable<String>();
                                                                                                                                            if (t0.getNumberOfColumns() == 0) break block34;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        catch (Exception e) {
                                                                                                                                            e.printStackTrace(System.out);
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (t0.getNumberOfRows() == 0) break block35;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                t0.setValue(3, 2, "23");
                                                                                                                                t0.setValue(10, 1, "error");
                                                                                                                                t0.setValue(10, 1, "110");
                                                                                                                                t0.setValue(9, 1, "19");
                                                                                                                                t0.setValue(1, 10, "101");
                                                                                                                                t0.setValue(10, 10, "1010");
                                                                                                                                t0.setValue(100, 10, "10100");
                                                                                                                                t0.setValue(0, 0, "00");
                                                                                                                                if (((String)t0.getValue(3, 2)).equals("23")) break block36;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (((String)t0.getValue(10, 1)).equals("110")) break block37;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (t0.getValueAsString(1, 10).equals("101")) break block38;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (t0.getValueAsString(10, 10).equals("1010")) break block39;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (t0.getValueAsString(100, 10).equals("10100")) break block40;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (t0.getValueAsString(9, 1).equals("19")) break block41;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (t0.getValueAsString(0, 0).equals("00")) break block42;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (t0.getNumberOfColumns() == 101) break block43;
                                                                                                    return false;
                                                                                                }
                                                                                                if (t0.getNumberOfRows() == 11) break block44;
                                                                                                return false;
                                                                                            }
                                                                                            if (t0.getValueAsString(49, 4) == null) break block45;
                                                                                            return false;
                                                                                        }
                                                                                        l = ForesterUtil.getLineSeparator();
                                                                                        StringBuffer source = new StringBuffer();
                                                                                        source.append(l);
                                                                                        source.append("# 1 1 1 1 1 1 1 1" + l);
                                                                                        source.append(" 00 01 02 03" + l);
                                                                                        source.append("   10 11 12 13  " + l);
                                                                                        source.append("20 21 22 23 " + l);
                                                                                        source.append("    30  31    32 33" + l);
                                                                                        source.append("40 41 42 43" + l);
                                                                                        source.append("  # 1 1 1 1 1 " + l);
                                                                                        source.append("50 51 52 53 54" + l);
                                                                                        t1 = BasicTableParser.parse(source.toString(), " ");
                                                                                        if (t1.getNumberOfColumns() == 5) break block46;
                                                                                        return false;
                                                                                    }
                                                                                    if (t1.getNumberOfRows() == 6) break block47;
                                                                                    return false;
                                                                                }
                                                                                if (t1.getValueAsString(0, 0).equals("00")) break block48;
                                                                                return false;
                                                                            }
                                                                            if (t1.getValueAsString(1, 0).equals("01")) break block49;
                                                                            return false;
                                                                        }
                                                                        if (t1.getValueAsString(3, 0).equals("03")) break block50;
                                                                        return false;
                                                                    }
                                                                    if (t1.getValueAsString(4, 5).equals("54")) break block51;
                                                                    return false;
                                                                }
                                                                StringBuffer source1 = new StringBuffer();
                                                                source1.append(l);
                                                                source1.append("# 1; 1; 1; 1 ;1 ;1; 1 ;1;" + l);
                                                                source1.append(" 00; 01 ;02;03" + l);
                                                                source1.append("   10; 11; 12; 13  " + l);
                                                                source1.append("20; 21; 22; 23 " + l);
                                                                source1.append("    30;  31;    32; 33" + l);
                                                                source1.append("40;41;42;43" + l);
                                                                source1.append("  # 1 1 1 1 1 " + l);
                                                                source1.append(";;;50  ;  ;52; 53;;54   " + l);
                                                                t2 = BasicTableParser.parse(source1.toString(), ";");
                                                                if (t2.getNumberOfColumns() == 5) break block52;
                                                                return false;
                                                            }
                                                            if (t2.getNumberOfRows() == 6) break block53;
                                                            return false;
                                                        }
                                                        if (t2.getValueAsString(0, 0).equals("00")) break block54;
                                                        return false;
                                                    }
                                                    if (t2.getValueAsString(1, 0).equals("01")) break block55;
                                                    return false;
                                                }
                                                if (t2.getValueAsString(3, 0).equals("03")) break block56;
                                                return false;
                                            }
                                            if (t2.getValueAsString(3, 3).equals("33")) break block57;
                                            return false;
                                        }
                                        if (t2.getValueAsString(3, 5).equals("53")) break block58;
                                        return false;
                                    }
                                    if (t2.getValueAsString(1, 5).equals("")) break block59;
                                    return false;
                                }
                                StringBuffer source2 = new StringBuffer();
                                source2.append(l);
                                source2.append("comment: 1; 1; 1; 1 ;1 ;1; 1 ;1;" + l);
                                source2.append(" 00; 01 ;02;03" + l);
                                source2.append("   10; 11; 12; 13  " + l);
                                source2.append("20; 21; 22; 23 " + l);
                                source2.append("                     " + l);
                                source2.append("    30;  31;    32; 33" + l);
                                source2.append("40;41;42;43" + l);
                                source2.append("  comment: 1 1 1 1 1 " + l);
                                source2.append(";;;50  ;   52; 53;;54   " + l);
                                tl = BasicTableParser.parse(source2.toString(), ";", false, "comment:", false);
                                if (tl.size() == 2) break block60;
                                return false;
                            }
                            t3 = tl.get(0);
                            t4 = tl.get(1);
                            if (t3.getNumberOfColumns() == 4) break block61;
                            return false;
                        }
                        if (t3.getNumberOfRows() == 3) break block62;
                        return false;
                    }
                    if (t4.getNumberOfColumns() == 4) break block63;
                    return false;
                }
                if (t4.getNumberOfRows() == 3) break block64;
                return false;
            }
            if (t3.getValueAsString(0, 0).equals("00")) break block65;
            return false;
        }
        return t4.getValueAsString(0, 0).equals("30");
    }

    private static boolean testBasicTolXMLparsing() {
        Phylogeny t5;
        block71: {
            block70: {
                block69: {
                    Phylogeny[] phylogenies_4;
                    block68: {
                        block67: {
                            TolParser parser;
                            PhylogenyFactory factory;
                            block66: {
                                Phylogeny t4;
                                block65: {
                                    block64: {
                                        block63: {
                                            Phylogeny[] phylogenies_3;
                                            block62: {
                                                block61: {
                                                    block60: {
                                                        Phylogeny t3;
                                                        block59: {
                                                            block58: {
                                                                block57: {
                                                                    Phylogeny[] phylogenies_2;
                                                                    block56: {
                                                                        block55: {
                                                                            block54: {
                                                                                Phylogeny t2;
                                                                                block53: {
                                                                                    block52: {
                                                                                        block51: {
                                                                                            block50: {
                                                                                                block49: {
                                                                                                    block48: {
                                                                                                        block47: {
                                                                                                            Phylogeny[] phylogenies_1;
                                                                                                            block46: {
                                                                                                                block45: {
                                                                                                                    block44: {
                                                                                                                        Phylogeny t1;
                                                                                                                        block43: {
                                                                                                                            block42: {
                                                                                                                                block41: {
                                                                                                                                    block40: {
                                                                                                                                        block39: {
                                                                                                                                            Phylogeny[] phylogenies_0;
                                                                                                                                            block38: {
                                                                                                                                                block37: {
                                                                                                                                                    try {
                                                                                                                                                        factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                        parser = new TolParser();
                                                                                                                                                        phylogenies_0 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "tol_2484.tol", parser);
                                                                                                                                                        if (parser.getErrorCount() <= 0) break block37;
                                                                                                                                                        System.out.println(parser.getErrorMessages().toString());
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    catch (Exception e) {
                                                                                                                                                        e.printStackTrace(System.out);
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                if (phylogenies_0.length == 1) break block38;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            t1 = phylogenies_0[0];
                                                                                                                                            if (t1.getNumberOfExternalNodes() == 5) break block39;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (t1.isRooted()) break block40;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (t1.getRoot().getNodeData().getTaxonomy().getCommonName().equals("Mesozoa")) break block41;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (t1.getRoot().getNodeData().getTaxonomy().getIdentifier().getValue().equals("2484")) break block42;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (t1.getRoot().getChildNode(0).getNodeData().getTaxonomy().getCommonName().equals("Rhombozoa")) break block43;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (t1.getRoot().getChildNode(0).getNumberOfDescendants() == 3) break block44;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    phylogenies_1 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "tol_2.tol", parser);
                                                                                                                    if (parser.getErrorCount() <= 0) break block45;
                                                                                                                    System.out.println(parser.getErrorMessages().toString());
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (phylogenies_1.length == 1) break block46;
                                                                                                                return false;
                                                                                                            }
                                                                                                            t2 = phylogenies_1[0];
                                                                                                            if (t2.getNumberOfExternalNodes() == 664) break block47;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (t2.isRooted()) break block48;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (t2.getRoot().getNodeData().getTaxonomy().getCommonName().equals("Eubacteria")) break block49;
                                                                                                    return false;
                                                                                                }
                                                                                                if (t2.getRoot().getNodeData().getTaxonomy().getIdentifier().getValue().equals("2")) break block50;
                                                                                                return false;
                                                                                            }
                                                                                            if (t2.getRoot().getNumberOfDescendants() == 24) break block51;
                                                                                            return false;
                                                                                        }
                                                                                        if (t2.getRoot().getNumberOfDescendants() == 24) break block52;
                                                                                        return false;
                                                                                    }
                                                                                    if (t2.getRoot().getChildNode(0).getNodeData().getTaxonomy().getCommonName().equals("Aquificae")) break block53;
                                                                                    return false;
                                                                                }
                                                                                if (t2.getRoot().getChildNode(0).getChildNode(0).getNodeData().getTaxonomy().getScientificName().equals("Aquifex")) break block54;
                                                                                return false;
                                                                            }
                                                                            phylogenies_2 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "tol_5.tol", parser);
                                                                            if (parser.getErrorCount() <= 0) break block55;
                                                                            System.out.println(parser.getErrorMessages().toString());
                                                                            return false;
                                                                        }
                                                                        if (phylogenies_2.length == 1) break block56;
                                                                        return false;
                                                                    }
                                                                    t3 = phylogenies_2[0];
                                                                    if (t3.getNumberOfExternalNodes() == 184) break block57;
                                                                    return false;
                                                                }
                                                                if (t3.getRoot().getNodeData().getTaxonomy().getCommonName().equals("Viruses")) break block58;
                                                                return false;
                                                            }
                                                            if (t3.getRoot().getNodeData().getTaxonomy().getIdentifier().getValue().equals("5")) break block59;
                                                            return false;
                                                        }
                                                        if (t3.getRoot().getNumberOfDescendants() == 6) break block60;
                                                        return false;
                                                    }
                                                    phylogenies_3 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "tol_4567.tol", parser);
                                                    if (parser.getErrorCount() <= 0) break block61;
                                                    System.out.println(parser.getErrorMessages().toString());
                                                    return false;
                                                }
                                                if (phylogenies_3.length == 1) break block62;
                                                return false;
                                            }
                                            t4 = phylogenies_3[0];
                                            if (t4.getNumberOfExternalNodes() == 1) break block63;
                                            return false;
                                        }
                                        if (t4.getRoot().getNodeData().getTaxonomy().getCommonName().equals("Marpissa decorata")) break block64;
                                        return false;
                                    }
                                    if (t4.getRoot().getNodeData().getTaxonomy().getIdentifier().getValue().equals("4567")) break block65;
                                    return false;
                                }
                                if (t4.getRoot().getNumberOfDescendants() == 0) break block66;
                                return false;
                            }
                            phylogenies_4 = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "tol_16299.tol", parser);
                            if (parser.getErrorCount() <= 0) break block67;
                            System.out.println(parser.getErrorMessages().toString());
                            return false;
                        }
                        if (phylogenies_4.length == 1) break block68;
                        return false;
                    }
                    t5 = phylogenies_4[0];
                    if (t5.getNumberOfExternalNodes() == 13) break block69;
                    return false;
                }
                if (t5.getRoot().getNodeData().getTaxonomy().getCommonName().equals("Hominidae")) break block70;
                return false;
            }
            if (t5.getRoot().getNodeData().getTaxonomy().getIdentifier().getValue().equals("16299")) break block71;
            return false;
        }
        return t5.getRoot().getNumberOfDescendants() == 2;
    }

    private static boolean testBasicTreeMethods() {
        PhylogenyFactory factory;
        block47: {
            block46: {
                Phylogeny t8;
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                Phylogeny t5;
                                block41: {
                                    block40: {
                                        Phylogeny t4;
                                        block39: {
                                            block38: {
                                                block37: {
                                                    PhylogenyNodeIterator it2;
                                                    block36: {
                                                        block35: {
                                                            block34: {
                                                                Phylogeny t3;
                                                                block33: {
                                                                    block32: {
                                                                        block31: {
                                                                            block30: {
                                                                                Phylogeny t2;
                                                                                block29: {
                                                                                    block28: {
                                                                                        block27: {
                                                                                            block26: {
                                                                                                factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                Phylogeny t1 = factory.create();
                                                                                                if (t1.isEmpty()) break block26;
                                                                                                return false;
                                                                                            }
                                                                                            t2 = factory.create("((A:1,B:2)AB:1,(C:3,D:5)CD:3)ABCD:0.5", new NHXParser())[0];
                                                                                            if (t2.getNumberOfExternalNodes() == 4) break block27;
                                                                                            return false;
                                                                                        }
                                                                                        if (t2.getHeight() == 8.5) break block28;
                                                                                        return false;
                                                                                    }
                                                                                    if (t2.isCompletelyBinary()) break block29;
                                                                                    return false;
                                                                                }
                                                                                if (!t2.isEmpty()) break block30;
                                                                                return false;
                                                                            }
                                                                            t3 = factory.create("((A:1,B:2,C:10)ABC:1,(D:3,E:5)DE:3)", new NHXParser())[0];
                                                                            if (t3.getNumberOfExternalNodes() == 5) break block31;
                                                                            return false;
                                                                        }
                                                                        if (t3.getHeight() == 11.0) break block32;
                                                                        return false;
                                                                    }
                                                                    if (!t3.isCompletelyBinary()) break block33;
                                                                    return false;
                                                                }
                                                                try {
                                                                    PhylogenyNode n = t3.getNode("ABC");
                                                                    PhylogenyNodeIterator it = n.iterateChildNodesForward();
                                                                    while (it.hasNext()) {
                                                                        it.next();
                                                                    }
                                                                    it.reset();
                                                                    while (it.hasNext()) {
                                                                        it.next();
                                                                    }
                                                                    it2 = n.iterateChildNodesForward();
                                                                    if (it2.next().getNodeName().equals("A")) break block34;
                                                                    return false;
                                                                }
                                                                catch (Exception e) {
                                                                    e.printStackTrace(System.out);
                                                                    return false;
                                                                }
                                                            }
                                                            if (it2.next().getNodeName().equals("B")) break block35;
                                                            return false;
                                                        }
                                                        if (it2.next().getNodeName().equals("C")) break block36;
                                                        return false;
                                                    }
                                                    if (!it2.hasNext()) break block37;
                                                    return false;
                                                }
                                                t4 = factory.create("((A:1,B:2,C:10)ABC:1,(D:3,E:5)DE:3,(F,G,H,I))", new NHXParser())[0];
                                                if (t4.getNumberOfExternalNodes() == 9) break block38;
                                                return false;
                                            }
                                            if (t4.getHeight() == 11.0) break block39;
                                            return false;
                                        }
                                        if (!t4.isCompletelyBinary()) break block40;
                                        return false;
                                    }
                                    StringBuffer sb5 = new StringBuffer("(((A11:2)A1:2,(A21:1,A22:2,A23)A2:11,A3:2)A:2,B:10,C:3,D:8)");
                                    t5 = factory.create(sb5, new NHXParser())[0];
                                    if (t5.getNumberOfExternalNodes() == 8) break block41;
                                    return false;
                                }
                                if (t5.getHeight() == 15.0) break block42;
                                return false;
                            }
                            StringBuffer sb6 = new StringBuffer("(X,Y,Z,(((A111)A11:2)A1:2,(X,Y,Z,A21:1,A22:2,A23)A2:11,A3:2)A:2,B:10,C:3,D:8)");
                            Phylogeny t6 = factory.create(sb6, new NHXParser())[0];
                            if (t6.getHeight() == 15.0) break block43;
                            return false;
                        }
                        StringBuffer sb7 = new StringBuffer("(((A11:2)A1:2,(A21:1,A22:2,A23)A2:11,A3:2)A:2,B:10,C:15,D:8)");
                        Phylogeny t7 = factory.create(sb7, new NHXParser())[0];
                        if (t7.getHeight() == 15.0) break block44;
                        return false;
                    }
                    StringBuffer sb8 = new StringBuffer("(((A11:11)A1:2,(A21:2,A22:2,A23,A24,AA:)A2:11,A3:2)A:2,B:15,C:15,D:15)");
                    t8 = factory.create(sb8, new NHXParser())[0];
                    if (t8.getNumberOfExternalNodes() == 10) break block45;
                    return false;
                }
                if (t8.getHeight() == 15.0) break block46;
                return false;
            }
            char[] a9 = new char[]{};
            Phylogeny t9 = factory.create(a9, new NHXParser())[0];
            if (t9.getHeight() == 0.0) break block47;
            return false;
        }
        char[] a10 = new char[]{'a', ':', '6'};
        Phylogeny t10 = factory.create(a10, new NHXParser())[0];
        return t10.getHeight() == 6.0;
    }

    private static boolean testCopyOfNodeData() {
        try {
            PhylogenyNode n1 = new PhylogenyNode("n5:0.1[&&NHX:S=Ecoli:E=1.1.1.1:D=Y:Co=Y:B=56:T=1:O=22:SO=33:SN=44:W=2:C=10.20.30:XN=S=tag1=value1=unit1]");
            PhylogenyNode n2 = n1.copyNodeData();
            return n1.toNewHampshireX().equals(n2.toNewHampshireX());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    private static boolean testDataObjects() {
        Event e8;
        block117: {
            block116: {
                Event e7;
                block115: {
                    block114: {
                        Event e6;
                        block113: {
                            block112: {
                                Event e5;
                                block111: {
                                    block110: {
                                        block109: {
                                            Event e4cc;
                                            Event e4c;
                                            block108: {
                                                Event e4;
                                                block107: {
                                                    block106: {
                                                        block105: {
                                                            Event e3cc;
                                                            Event e3c;
                                                            Event e3;
                                                            block104: {
                                                                block103: {
                                                                    block102: {
                                                                        block101: {
                                                                            block100: {
                                                                                block99: {
                                                                                    Event e2;
                                                                                    block98: {
                                                                                        Event e11;
                                                                                        block97: {
                                                                                            block96: {
                                                                                                block95: {
                                                                                                    block94: {
                                                                                                        block93: {
                                                                                                            block92: {
                                                                                                                block91: {
                                                                                                                    Event e1;
                                                                                                                    block90: {
                                                                                                                        block89: {
                                                                                                                            block88: {
                                                                                                                                block87: {
                                                                                                                                    block86: {
                                                                                                                                        DomainArchitecture ds3;
                                                                                                                                        block85: {
                                                                                                                                            DomainArchitecture ds1;
                                                                                                                                            block84: {
                                                                                                                                                DomainArchitecture ds0;
                                                                                                                                                ProteinDomain d4;
                                                                                                                                                ProteinDomain d2;
                                                                                                                                                ProteinDomain d1;
                                                                                                                                                ProteinDomain d0;
                                                                                                                                                block83: {
                                                                                                                                                    block82: {
                                                                                                                                                        block81: {
                                                                                                                                                            block80: {
                                                                                                                                                                ProteinDomain pd3;
                                                                                                                                                                block79: {
                                                                                                                                                                    ProteinDomain pd0;
                                                                                                                                                                    block78: {
                                                                                                                                                                        ProteinDomain pd2;
                                                                                                                                                                        block77: {
                                                                                                                                                                            ProteinDomain pd1;
                                                                                                                                                                            block76: {
                                                                                                                                                                                block75: {
                                                                                                                                                                                    Identifier id1;
                                                                                                                                                                                    block74: {
                                                                                                                                                                                        Identifier id0;
                                                                                                                                                                                        block73: {
                                                                                                                                                                                            block72: {
                                                                                                                                                                                                block71: {
                                                                                                                                                                                                    Taxonomy t5;
                                                                                                                                                                                                    Taxonomy t1;
                                                                                                                                                                                                    block70: {
                                                                                                                                                                                                        block69: {
                                                                                                                                                                                                            Taxonomy t4;
                                                                                                                                                                                                            block68: {
                                                                                                                                                                                                                block67: {
                                                                                                                                                                                                                    Taxonomy t3;
                                                                                                                                                                                                                    block66: {
                                                                                                                                                                                                                        Taxonomy t2;
                                                                                                                                                                                                                        block65: {
                                                                                                                                                                                                                            block64: {
                                                                                                                                                                                                                                Confidence s3;
                                                                                                                                                                                                                                block63: {
                                                                                                                                                                                                                                    block62: {
                                                                                                                                                                                                                                        Confidence s2;
                                                                                                                                                                                                                                        block61: {
                                                                                                                                                                                                                                            Confidence s1;
                                                                                                                                                                                                                                            block60: {
                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                    Confidence s0 = new Confidence();
                                                                                                                                                                                                                                                    s1 = new Confidence();
                                                                                                                                                                                                                                                    if (s0.isEqual(s1)) break block60;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                catch (Exception e) {
                                                                                                                                                                                                                                                    e.printStackTrace(System.out);
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            s2 = new Confidence(0.23, "bootstrap");
                                                                                                                                                                                                                                            s3 = new Confidence(0.23, "bootstrap");
                                                                                                                                                                                                                                            if (!s2.isEqual(s1)) break block61;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (s2.isEqual(s3)) break block62;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    Confidence s4 = (Confidence)s3.copy();
                                                                                                                                                                                                                                    if (s4.isEqual(s3)) break block63;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                s3.asSimpleText();
                                                                                                                                                                                                                                s3.asText();
                                                                                                                                                                                                                                t1 = new Taxonomy();
                                                                                                                                                                                                                                t2 = new Taxonomy();
                                                                                                                                                                                                                                t3 = new Taxonomy();
                                                                                                                                                                                                                                t4 = new Taxonomy();
                                                                                                                                                                                                                                t5 = new Taxonomy();
                                                                                                                                                                                                                                t1.setIdentifier(new Identifier("ecoli"));
                                                                                                                                                                                                                                t1.setTaxonomyCode("ECOLI");
                                                                                                                                                                                                                                t1.setScientificName("E. coli");
                                                                                                                                                                                                                                t1.setCommonName("coli");
                                                                                                                                                                                                                                Taxonomy t0 = (Taxonomy)t1.copy();
                                                                                                                                                                                                                                if (t1.isEqual(t0)) break block64;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            t2.setIdentifier(new Identifier("ecoli"));
                                                                                                                                                                                                                            t2.setTaxonomyCode("other");
                                                                                                                                                                                                                            t2.setScientificName("what");
                                                                                                                                                                                                                            t2.setCommonName("something");
                                                                                                                                                                                                                            if (t1.isEqual(t2)) break block65;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        t2.setIdentifier(new Identifier("nemve"));
                                                                                                                                                                                                                        if (!t1.isEqual(t2)) break block66;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    t1.setIdentifier(null);
                                                                                                                                                                                                                    t3.setTaxonomyCode("ECOLI");
                                                                                                                                                                                                                    t3.setScientificName("what");
                                                                                                                                                                                                                    t3.setCommonName("something");
                                                                                                                                                                                                                    if (t1.isEqual(t3)) break block67;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                t1.setIdentifier(null);
                                                                                                                                                                                                                t1.setTaxonomyCode("");
                                                                                                                                                                                                                t4.setScientificName("E. ColI");
                                                                                                                                                                                                                t4.setCommonName("something");
                                                                                                                                                                                                                if (t1.isEqual(t4)) break block68;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            t4.setScientificName("B. subtilis");
                                                                                                                                                                                                            t4.setCommonName("something");
                                                                                                                                                                                                            if (!t1.isEqual(t4)) break block69;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        t1.setIdentifier(null);
                                                                                                                                                                                                        t1.setTaxonomyCode("");
                                                                                                                                                                                                        t1.setScientificName("");
                                                                                                                                                                                                        t5.setCommonName("COLI");
                                                                                                                                                                                                        if (t1.isEqual(t5)) break block70;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    t5.setCommonName("vibrio");
                                                                                                                                                                                                    if (!t1.isEqual(t5)) break block71;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                id0 = new Identifier("123", "pfam");
                                                                                                                                                                                                id1 = (Identifier)id0.copy();
                                                                                                                                                                                                if (id1.isEqual(id1)) break block72;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (id1.isEqual(id0)) break block73;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (id0.isEqual(id1)) break block74;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    id1.asSimpleText();
                                                                                                                                                                                    id1.asText();
                                                                                                                                                                                    pd0 = new ProteinDomain("abc", 100, 200);
                                                                                                                                                                                    pd1 = (ProteinDomain)pd0.copy();
                                                                                                                                                                                    if (pd1.isEqual(pd1)) break block75;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (pd1.isEqual(pd0)) break block76;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            pd1.asSimpleText();
                                                                                                                                                                            pd1.asText();
                                                                                                                                                                            pd2 = new ProteinDomain(pd0.getName(), pd0.getFrom(), pd0.getTo(), "id");
                                                                                                                                                                            pd3 = (ProteinDomain)pd2.copy();
                                                                                                                                                                            if (pd3.isEqual(pd3)) break block77;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (pd2.isEqual(pd3)) break block78;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (pd0.isEqual(pd3)) break block79;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                pd3.asSimpleText();
                                                                                                                                                                pd3.asText();
                                                                                                                                                                d0 = new ProteinDomain("domain0", 10, 20);
                                                                                                                                                                d1 = new ProteinDomain("domain1", 30, 40);
                                                                                                                                                                d2 = new ProteinDomain("domain2", 50, 60);
                                                                                                                                                                ProteinDomain d3 = new ProteinDomain("domain3", 70, 80);
                                                                                                                                                                d4 = new ProteinDomain("domain4", 90, 100);
                                                                                                                                                                ArrayList<PhylogenyData> domains0 = new ArrayList<PhylogenyData>();
                                                                                                                                                                domains0.add(d2);
                                                                                                                                                                domains0.add(d0);
                                                                                                                                                                domains0.add(d3);
                                                                                                                                                                domains0.add(d1);
                                                                                                                                                                ds0 = new DomainArchitecture(domains0, 110);
                                                                                                                                                                if (ds0.getNumberOfDomains() == 4) break block80;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            ds1 = (DomainArchitecture)ds0.copy();
                                                                                                                                                            if (ds0.isEqual(ds0)) break block81;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (ds0.isEqual(ds1)) break block82;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (ds1.getNumberOfDomains() == 4) break block83;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                ArrayList<PhylogenyData> domains1 = new ArrayList<PhylogenyData>();
                                                                                                                                                domains1.add(d1);
                                                                                                                                                domains1.add(d2);
                                                                                                                                                domains1.add(d4);
                                                                                                                                                domains1.add(d0);
                                                                                                                                                DomainArchitecture ds2 = new DomainArchitecture(domains1, 200);
                                                                                                                                                if (!ds0.isEqual(ds2)) break block84;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            ds1.asSimpleText();
                                                                                                                                            ds1.asText();
                                                                                                                                            ds1.toNHX();
                                                                                                                                            ds3 = new DomainArchitecture("120>30>40>0.9>b>50>60>0.4>c>10>20>0.1>a");
                                                                                                                                            if (ds3.toNHX().toString().equals(":DS=120>10>20>0.1>a>30>40>0.9>b>50>60>0.4>c")) break block85;
                                                                                                                                            System.out.println(ds3.toNHX());
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (ds3.getNumberOfDomains() == 3) break block86;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    e1 = new Event(Event.EventType.fusion);
                                                                                                                                    if (!e1.isDuplication()) break block87;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (e1.isFusion()) break block88;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (e1.asText().toString().equals("fusion")) break block89;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (e1.asSimpleText().toString().equals("fusion")) break block90;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    e11 = new Event(Event.EventType.fusion);
                                                                                                                    if (e11.isEqual(e1)) break block91;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (e11.toNHX().toString().equals("")) break block92;
                                                                                                                return false;
                                                                                                            }
                                                                                                            e2 = new Event(Event.EventType.speciation_or_duplication);
                                                                                                            if (!e2.isDuplication()) break block93;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (e2.isSpeciationOrDuplication()) break block94;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (e2.asText().toString().equals("speciation_or_duplication")) break block95;
                                                                                                    return false;
                                                                                                }
                                                                                                if (e2.asSimpleText().toString().equals("?")) break block96;
                                                                                                return false;
                                                                                            }
                                                                                            if (e2.toNHX().toString().equals(":D=?")) break block97;
                                                                                            return false;
                                                                                        }
                                                                                        if (!e11.isEqual(e2)) break block98;
                                                                                        return false;
                                                                                    }
                                                                                    Event e2c = (Event)e2.copy();
                                                                                    if (e2c.isEqual(e2)) break block99;
                                                                                    return false;
                                                                                }
                                                                                e3 = new Event(1, 2, 3);
                                                                                if (!e3.isDuplication()) break block100;
                                                                                return false;
                                                                            }
                                                                            if (!e3.isSpeciation()) break block101;
                                                                            return false;
                                                                        }
                                                                        if (!e3.isGeneLoss()) break block102;
                                                                        return false;
                                                                    }
                                                                    if (e3.asText().toString().equals("duplications [1] speciations [2] gene-losses [3]")) break block103;
                                                                    return false;
                                                                }
                                                                e3c = (Event)e3.copy();
                                                                e3cc = (Event)e3c.copy();
                                                                if (e3c.asSimpleText().toString().equals("D2S3L")) break block104;
                                                                return false;
                                                            }
                                                            e3 = null;
                                                            if (e3c.isEqual(e3cc)) break block105;
                                                            return false;
                                                        }
                                                        e4 = new Event(1, 2, 3);
                                                        if (e4.asText().toString().equals("duplications [1] speciations [2] gene-losses [3]")) break block106;
                                                        return false;
                                                    }
                                                    if (e4.asSimpleText().toString().equals("D2S3L")) break block107;
                                                    return false;
                                                }
                                                e4c = (Event)e4.copy();
                                                e4 = null;
                                                e4cc = (Event)e4c.copy();
                                                if (e4cc.asText().toString().equals("duplications [1] speciations [2] gene-losses [3]")) break block108;
                                                return false;
                                            }
                                            if (e4c.isEqual(e4cc)) break block109;
                                            return false;
                                        }
                                        e5 = new Event();
                                        if (e5.isUnassigned()) break block110;
                                        return false;
                                    }
                                    if (e5.asText().toString().equals("unassigned")) break block111;
                                    return false;
                                }
                                if (e5.asSimpleText().toString().equals("")) break block112;
                                return false;
                            }
                            e6 = new Event(1, 0, 0);
                            if (e6.asText().toString().equals("duplication")) break block113;
                            return false;
                        }
                        if (e6.asSimpleText().toString().equals("D")) break block114;
                        return false;
                    }
                    e7 = new Event(0, 1, 0);
                    if (e7.asText().toString().equals("speciation")) break block115;
                    return false;
                }
                if (e7.asSimpleText().toString().equals("S")) break block116;
                return false;
            }
            e8 = new Event(0, 0, 1);
            if (e8.asText().toString().equals("gene-loss")) break block117;
            return false;
        }
        return e8.asSimpleText().toString().equals("L");
    }

    private static boolean testDeletionOfExternalNodes() {
        Phylogeny t15;
        block139: {
            block138: {
                block137: {
                    block136: {
                        block135: {
                            PhylogenyFactory factory;
                            block134: {
                                Phylogeny t14;
                                String s;
                                PhylogenyWriter w;
                                block133: {
                                    block132: {
                                        Phylogeny t13;
                                        block131: {
                                            block130: {
                                                Phylogeny t12;
                                                block129: {
                                                    block128: {
                                                        block127: {
                                                            block126: {
                                                                block125: {
                                                                    block124: {
                                                                        block123: {
                                                                            block122: {
                                                                                block121: {
                                                                                    block120: {
                                                                                        block119: {
                                                                                            block118: {
                                                                                                block117: {
                                                                                                    block116: {
                                                                                                        Phylogeny t11;
                                                                                                        block115: {
                                                                                                            block114: {
                                                                                                                block113: {
                                                                                                                    block112: {
                                                                                                                        Phylogeny t10;
                                                                                                                        block111: {
                                                                                                                            block110: {
                                                                                                                                Phylogeny t9;
                                                                                                                                block109: {
                                                                                                                                    block108: {
                                                                                                                                        Phylogeny t8;
                                                                                                                                        block107: {
                                                                                                                                            block106: {
                                                                                                                                                Phylogeny t7;
                                                                                                                                                block105: {
                                                                                                                                                    block104: {
                                                                                                                                                        Phylogeny t6;
                                                                                                                                                        block103: {
                                                                                                                                                            block102: {
                                                                                                                                                                Phylogeny t5;
                                                                                                                                                                block101: {
                                                                                                                                                                    block100: {
                                                                                                                                                                        Phylogeny t4;
                                                                                                                                                                        block99: {
                                                                                                                                                                            PhylogenyNode n;
                                                                                                                                                                            block98: {
                                                                                                                                                                                block97: {
                                                                                                                                                                                    block96: {
                                                                                                                                                                                        block95: {
                                                                                                                                                                                            block94: {
                                                                                                                                                                                                block93: {
                                                                                                                                                                                                    block92: {
                                                                                                                                                                                                        Phylogeny t3;
                                                                                                                                                                                                        block91: {
                                                                                                                                                                                                            block90: {
                                                                                                                                                                                                                block89: {
                                                                                                                                                                                                                    block88: {
                                                                                                                                                                                                                        block87: {
                                                                                                                                                                                                                            block86: {
                                                                                                                                                                                                                                block85: {
                                                                                                                                                                                                                                    block84: {
                                                                                                                                                                                                                                        Phylogeny t2;
                                                                                                                                                                                                                                        block83: {
                                                                                                                                                                                                                                            block82: {
                                                                                                                                                                                                                                                block81: {
                                                                                                                                                                                                                                                    block80: {
                                                                                                                                                                                                                                                        block79: {
                                                                                                                                                                                                                                                            Phylogeny t1;
                                                                                                                                                                                                                                                            block78: {
                                                                                                                                                                                                                                                                block77: {
                                                                                                                                                                                                                                                                    block76: {
                                                                                                                                                                                                                                                                        block75: {
                                                                                                                                                                                                                                                                            block74: {
                                                                                                                                                                                                                                                                                Phylogeny t0;
                                                                                                                                                                                                                                                                                block73: {
                                                                                                                                                                                                                                                                                    block72: {
                                                                                                                                                                                                                                                                                        block71: {
                                                                                                                                                                                                                                                                                            try {
                                                                                                                                                                                                                                                                                                factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                t0 = factory.create("A", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                w = new PhylogenyWriter();
                                                                                                                                                                                                                                                                                                if (!t0.isEmpty()) break block71;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                                                                                                                                e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (t0.getNumberOfExternalNodes() == 1) break block72;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    t0.deleteSubtree(t0.getNode("A"), false);
                                                                                                                                                                                                                                                                                    if (t0.getNumberOfExternalNodes() == 0) break block73;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (t0.isEmpty()) break block74;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            t1 = factory.create("(A,B)r", new NHXParser())[0];
                                                                                                                                                                                                                                                                            if (t1.getNumberOfExternalNodes() == 2) break block75;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        t1.deleteSubtree(t1.getNode("A"), false);
                                                                                                                                                                                                                                                                        if (t1.getNumberOfExternalNodes() == 1) break block76;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (t1.getNode("B").getNodeName().equals("B")) break block77;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                t1.deleteSubtree(t1.getNode("B"), false);
                                                                                                                                                                                                                                                                if (t1.getNumberOfExternalNodes() == 1) break block78;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            t1.deleteSubtree(t1.getNode("r"), false);
                                                                                                                                                                                                                                                            if (t1.isEmpty()) break block79;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        t2 = factory.create("((A,B),C)", new NHXParser())[0];
                                                                                                                                                                                                                                                        if (t2.getNumberOfExternalNodes() == 3) break block80;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    t2.deleteSubtree(t2.getNode("B"), false);
                                                                                                                                                                                                                                                    if (t2.getNumberOfExternalNodes() == 2) break block81;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                t2.toNewHampshireX();
                                                                                                                                                                                                                                                n = t2.getNode("A");
                                                                                                                                                                                                                                                if (n.getNextExternalNode().getNodeName().equals("C")) break block82;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            t2.deleteSubtree(t2.getNode("A"), false);
                                                                                                                                                                                                                                            if (t2.getNumberOfExternalNodes() == 2) break block83;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        t2.deleteSubtree(t2.getNode("C"), true);
                                                                                                                                                                                                                                        if (t2.getNumberOfExternalNodes() == 1) break block84;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    t3 = factory.create("((A,B),(C,D))", new NHXParser())[0];
                                                                                                                                                                                                                                    if (t3.getNumberOfExternalNodes() == 4) break block85;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                t3.deleteSubtree(t3.getNode("B"), true);
                                                                                                                                                                                                                                if (t3.getNumberOfExternalNodes() == 3) break block86;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            n = t3.getNode("A");
                                                                                                                                                                                                                            if (n.getNextExternalNode().getNodeName().equals("C")) break block87;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        n = n.getNextExternalNode();
                                                                                                                                                                                                                        if (n.getNextExternalNode().getNodeName().equals("D")) break block88;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    t3.deleteSubtree(t3.getNode("A"), true);
                                                                                                                                                                                                                    if (t3.getNumberOfExternalNodes() == 2) break block89;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                n = t3.getNode("C");
                                                                                                                                                                                                                if (n.getNextExternalNode().getNodeName().equals("D")) break block90;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            t3.deleteSubtree(t3.getNode("C"), true);
                                                                                                                                                                                                            if (t3.getNumberOfExternalNodes() == 1) break block91;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        t3.deleteSubtree(t3.getNode("D"), true);
                                                                                                                                                                                                        if (t3.getNumberOfExternalNodes() == 0) break block92;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    t4 = factory.create("((A,((B11,B12),B2)),(C,D))", new NHXParser())[0];
                                                                                                                                                                                                    if (t4.getNumberOfExternalNodes() == 6) break block93;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                t4.deleteSubtree(t4.getNode("B2"), true);
                                                                                                                                                                                                if (t4.getNumberOfExternalNodes() == 5) break block94;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            s = w.toNewHampshire(t4, false, true).toString();
                                                                                                                                                                                            if (s.equals("((A,(B11,B12)),(C,D));")) break block95;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        t4.deleteSubtree(t4.getNode("B11"), true);
                                                                                                                                                                                        if (t4.getNumberOfExternalNodes() == 4) break block96;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    t4.deleteSubtree(t4.getNode("C"), true);
                                                                                                                                                                                    if (t4.getNumberOfExternalNodes() == 3) break block97;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                n = t4.getNode("A");
                                                                                                                                                                                n = n.getNextExternalNode();
                                                                                                                                                                                if (n.getNodeName().equals("B12")) break block98;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            n = n.getNextExternalNode();
                                                                                                                                                                            if (n.getNodeName().equals("D")) break block99;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        s = w.toNewHampshire(t4, false, true).toString();
                                                                                                                                                                        if (s.equals("((A,B12),D);")) break block100;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    t5 = factory.create("((A,((B11,B12),B2)),(C,D))", new NHXParser())[0];
                                                                                                                                                                    t5.deleteSubtree(t5.getNode("A"), true);
                                                                                                                                                                    if (t5.getNumberOfExternalNodes() == 5) break block101;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                s = w.toNewHampshire(t5, false, true).toString();
                                                                                                                                                                if (s.equals("(((B11,B12),B2),(C,D));")) break block102;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            t6 = factory.create("((A,((B11,B12),B2)),(C,D))", new NHXParser())[0];
                                                                                                                                                            t6.deleteSubtree(t6.getNode("B11"), true);
                                                                                                                                                            if (t6.getNumberOfExternalNodes() == 5) break block103;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        s = w.toNewHampshire(t6, false, false).toString();
                                                                                                                                                        if (s.equals("((A,(B12,B2)),(C,D));")) break block104;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    t7 = factory.create("((A,((B11,B12),B2)),(C,D))", new NHXParser())[0];
                                                                                                                                                    t7.deleteSubtree(t7.getNode("B12"), true);
                                                                                                                                                    if (t7.getNumberOfExternalNodes() == 5) break block105;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                s = w.toNewHampshire(t7, false, true).toString();
                                                                                                                                                if (s.equals("((A,(B11,B2)),(C,D));")) break block106;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            t8 = factory.create("((A,((B11,B12),B2)),(C,D))", new NHXParser())[0];
                                                                                                                                            t8.deleteSubtree(t8.getNode("B2"), true);
                                                                                                                                            if (t8.getNumberOfExternalNodes() == 5) break block107;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        s = w.toNewHampshire(t8, false, false).toString();
                                                                                                                                        if (s.equals("((A,(B11,B12)),(C,D));")) break block108;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    t9 = factory.create("((A,((B11,B12),B2)),(C,D))", new NHXParser())[0];
                                                                                                                                    t9.deleteSubtree(t9.getNode("C"), true);
                                                                                                                                    if (t9.getNumberOfExternalNodes() == 5) break block109;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                s = w.toNewHampshire(t9, false, true).toString();
                                                                                                                                if (s.equals("((A,((B11,B12),B2)),D);")) break block110;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            t10 = factory.create("((A,((B11,B12),B2)),(C,D))", new NHXParser())[0];
                                                                                                                            t10.deleteSubtree(t10.getNode("D"), true);
                                                                                                                            if (t10.getNumberOfExternalNodes() == 5) break block111;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        s = w.toNewHampshire(t10, false, true).toString();
                                                                                                                        if (s.equals("((A,((B11,B12),B2)),C);")) break block112;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    t11 = factory.create("(A,B,C)", new NHXParser())[0];
                                                                                                                    t11.deleteSubtree(t11.getNode("A"), true);
                                                                                                                    if (t11.getNumberOfExternalNodes() == 2) break block113;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                s = w.toNewHampshire(t11, false, true).toString();
                                                                                                                if (s.equals("(B,C);")) break block114;
                                                                                                                return false;
                                                                                                            }
                                                                                                            t11.deleteSubtree(t11.getNode("C"), true);
                                                                                                            if (t11.getNumberOfExternalNodes() == 1) break block115;
                                                                                                            return false;
                                                                                                        }
                                                                                                        s = w.toNewHampshire(t11, false, false).toString();
                                                                                                        if (s.equals("B;")) break block116;
                                                                                                        return false;
                                                                                                    }
                                                                                                    t12 = factory.create("((A1,A2,A3),(B1,B2,B3),(C1,C2,C3))", new NHXParser())[0];
                                                                                                    t12.deleteSubtree(t12.getNode("B2"), true);
                                                                                                    if (t12.getNumberOfExternalNodes() == 8) break block117;
                                                                                                    return false;
                                                                                                }
                                                                                                s = w.toNewHampshire(t12, false, true).toString();
                                                                                                if (s.equals("((A1,A2,A3),(B1,B3),(C1,C2,C3));")) break block118;
                                                                                                return false;
                                                                                            }
                                                                                            t12.deleteSubtree(t12.getNode("B3"), true);
                                                                                            if (t12.getNumberOfExternalNodes() == 7) break block119;
                                                                                            return false;
                                                                                        }
                                                                                        s = w.toNewHampshire(t12, false, true).toString();
                                                                                        if (s.equals("((A1,A2,A3),B1,(C1,C2,C3));")) break block120;
                                                                                        return false;
                                                                                    }
                                                                                    t12.deleteSubtree(t12.getNode("C3"), true);
                                                                                    if (t12.getNumberOfExternalNodes() == 6) break block121;
                                                                                    return false;
                                                                                }
                                                                                s = w.toNewHampshire(t12, false, true).toString();
                                                                                if (s.equals("((A1,A2,A3),B1,(C1,C2));")) break block122;
                                                                                return false;
                                                                            }
                                                                            t12.deleteSubtree(t12.getNode("A1"), true);
                                                                            if (t12.getNumberOfExternalNodes() == 5) break block123;
                                                                            return false;
                                                                        }
                                                                        s = w.toNewHampshire(t12, false, true).toString();
                                                                        if (s.equals("((A2,A3),B1,(C1,C2));")) break block124;
                                                                        return false;
                                                                    }
                                                                    t12.deleteSubtree(t12.getNode("B1"), true);
                                                                    if (t12.getNumberOfExternalNodes() == 4) break block125;
                                                                    return false;
                                                                }
                                                                s = w.toNewHampshire(t12, false, true).toString();
                                                                if (s.equals("((A2,A3),(C1,C2));")) break block126;
                                                                return false;
                                                            }
                                                            t12.deleteSubtree(t12.getNode("A3"), true);
                                                            if (t12.getNumberOfExternalNodes() == 3) break block127;
                                                            return false;
                                                        }
                                                        s = w.toNewHampshire(t12, false, true).toString();
                                                        if (s.equals("(A2,(C1,C2));")) break block128;
                                                        return false;
                                                    }
                                                    t12.deleteSubtree(t12.getNode("A2"), true);
                                                    if (t12.getNumberOfExternalNodes() == 2) break block129;
                                                    return false;
                                                }
                                                s = w.toNewHampshire(t12, false, true).toString();
                                                if (s.equals("(C1,C2);")) break block130;
                                                return false;
                                            }
                                            t13 = factory.create("(A,B,C,(D:1.0,E:2.0):3.0)", new NHXParser())[0];
                                            t13.deleteSubtree(t13.getNode("D"), true);
                                            if (t13.getNumberOfExternalNodes() == 4) break block131;
                                            return false;
                                        }
                                        s = w.toNewHampshire(t13, false, true).toString();
                                        if (s.equals("(A,B,C,E:5.0);")) break block132;
                                        return false;
                                    }
                                    t14 = factory.create("((A,B,C,(D:0.1,E:0.4):1.0),F)", new NHXParser())[0];
                                    t14.deleteSubtree(t14.getNode("E"), true);
                                    if (t14.getNumberOfExternalNodes() == 5) break block133;
                                    return false;
                                }
                                s = w.toNewHampshire(t14, false, true).toString();
                                if (s.equals("((A,B,C,D:1.1),F);")) break block134;
                                return false;
                            }
                            t15 = factory.create("((A1,A2,A3,A4),(B1,B2,B3,B4),(C1,C2,C3,C4))", new NHXParser())[0];
                            t15.deleteSubtree(t15.getNode("B2"), true);
                            if (t15.getNumberOfExternalNodes() == 11) break block135;
                            return false;
                        }
                        t15.deleteSubtree(t15.getNode("B1"), true);
                        if (t15.getNumberOfExternalNodes() == 10) break block136;
                        return false;
                    }
                    t15.deleteSubtree(t15.getNode("B3"), true);
                    if (t15.getNumberOfExternalNodes() == 9) break block137;
                    return false;
                }
                t15.deleteSubtree(t15.getNode("B4"), true);
                if (t15.getNumberOfExternalNodes() == 8) break block138;
                return false;
            }
            t15.deleteSubtree(t15.getNode("A1"), true);
            if (t15.getNumberOfExternalNodes() == 7) break block139;
            return false;
        }
        t15.deleteSubtree(t15.getNode("C4"), true);
        return t15.getNumberOfExternalNodes() == 6;
    }

    private static boolean testDescriptiveStatistics() {
        block77: {
            int[] bins1_2;
            block76: {
                block75: {
                    block74: {
                        double[] ds1;
                        block73: {
                            int[] bins1_1;
                            block72: {
                                block71: {
                                    block70: {
                                        block69: {
                                            int[] bins1;
                                            block68: {
                                                block67: {
                                                    block66: {
                                                        block65: {
                                                            block64: {
                                                                int[] bins;
                                                                block63: {
                                                                    block62: {
                                                                        block61: {
                                                                            block60: {
                                                                                block59: {
                                                                                    BasicDescriptiveStatistics dss2;
                                                                                    block58: {
                                                                                        block57: {
                                                                                            block56: {
                                                                                                block55: {
                                                                                                    block54: {
                                                                                                        BasicDescriptiveStatistics dss1;
                                                                                                        block53: {
                                                                                                            block52: {
                                                                                                                block51: {
                                                                                                                    block50: {
                                                                                                                        block49: {
                                                                                                                            block48: {
                                                                                                                                block47: {
                                                                                                                                    block46: {
                                                                                                                                        block45: {
                                                                                                                                            block44: {
                                                                                                                                                block43: {
                                                                                                                                                    block42: {
                                                                                                                                                        block41: {
                                                                                                                                                            block40: {
                                                                                                                                                                try {
                                                                                                                                                                    dss1 = new BasicDescriptiveStatistics();
                                                                                                                                                                    dss1.addValue(82.0);
                                                                                                                                                                    dss1.addValue(78.0);
                                                                                                                                                                    dss1.addValue(70.0);
                                                                                                                                                                    dss1.addValue(58.0);
                                                                                                                                                                    dss1.addValue(42.0);
                                                                                                                                                                    if (dss1.getN() == 5) break block40;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                catch (Exception e) {
                                                                                                                                                                    e.printStackTrace(System.out);
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            if (Test.isEqual(dss1.getMin(), 42.0)) break block41;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (Test.isEqual(dss1.getMax(), 82.0)) break block42;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (Test.isEqual(dss1.arithmeticMean(), 66.0)) break block43;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (Test.isEqual(dss1.sampleStandardDeviation(), 16.24807680927192)) break block44;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (Test.isEqual(dss1.median(), 70.0)) break block45;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (Test.isEqual(dss1.midrange(), 62.0)) break block46;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (Test.isEqual(dss1.sampleVariance(), 264.0)) break block47;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (Test.isEqual(dss1.pearsonianSkewness(), -0.7385489458759964)) break block48;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (Test.isEqual(dss1.coefficientOfVariation(), 0.24618298195866548)) break block49;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (Test.isEqual(dss1.sampleStandardUnit(49.75192319072808), -1.0)) break block50;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (Test.isEqual(dss1.getValue(1), 78.0)) break block51;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                dss1.addValue(123.0);
                                                                                                                if (Test.isEqual(dss1.arithmeticMean(), 75.5)) break block52;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (Test.isEqual(dss1.getMax(), 123.0)) break block53;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (Test.isEqual(dss1.standardErrorOfMean(), 11.200446419674531)) break block54;
                                                                                                        return false;
                                                                                                    }
                                                                                                    dss2 = new BasicDescriptiveStatistics();
                                                                                                    dss2.addValue(-1.85);
                                                                                                    dss2.addValue(57.5);
                                                                                                    dss2.addValue(92.78);
                                                                                                    dss2.addValue(57.78);
                                                                                                    if (Test.isEqual(dss2.median(), 57.64)) break block55;
                                                                                                    return false;
                                                                                                }
                                                                                                if (Test.isEqual(dss2.sampleStandardDeviation(), 39.266984753946495)) break block56;
                                                                                                return false;
                                                                                            }
                                                                                            double[] a = dss2.getDataAsDoubleArray();
                                                                                            if (Test.isEqual(a[3], 57.78)) break block57;
                                                                                            return false;
                                                                                        }
                                                                                        dss2.addValue(-100.0);
                                                                                        if (Test.isEqual(dss2.sampleStandardDeviation(), 75.829111296388)) break block58;
                                                                                        return false;
                                                                                    }
                                                                                    if (Test.isEqual(dss2.sampleVariance(), 5750.05412)) break block59;
                                                                                    return false;
                                                                                }
                                                                                double[] ds = new double[]{34.0, 23.0, 1.0, 32.0, 11.0, 2.0, 12.0, 33.0, 13.0, 22.0, 21.0, 35.0, 24.0, 31.0};
                                                                                bins = BasicDescriptiveStatistics.performBinning(ds, 0.0, 40.0, 4);
                                                                                if (bins.length == 4) break block60;
                                                                                return false;
                                                                            }
                                                                            if (bins[0] == 2) break block61;
                                                                            return false;
                                                                        }
                                                                        if (bins[1] == 3) break block62;
                                                                        return false;
                                                                    }
                                                                    if (bins[2] == 4) break block63;
                                                                    return false;
                                                                }
                                                                if (bins[3] == 5) break block64;
                                                                return false;
                                                            }
                                                            ds1 = new double[]{10.0, 19.0, 9.999, 0.0, 39.9, 39.999, 30.0, 19.999, 30.1};
                                                            bins1 = BasicDescriptiveStatistics.performBinning(ds1, 0.0, 40.0, 4);
                                                            if (bins1.length == 4) break block65;
                                                            return false;
                                                        }
                                                        if (bins1[0] == 2) break block66;
                                                        return false;
                                                    }
                                                    if (bins1[1] == 3) break block67;
                                                    return false;
                                                }
                                                if (bins1[2] == 0) break block68;
                                                return false;
                                            }
                                            if (bins1[3] == 4) break block69;
                                            return false;
                                        }
                                        bins1_1 = BasicDescriptiveStatistics.performBinning(ds1, 0.0, 40.0, 3);
                                        if (bins1_1.length == 3) break block70;
                                        return false;
                                    }
                                    if (bins1_1[0] == 3) break block71;
                                    return false;
                                }
                                if (bins1_1[1] == 2) break block72;
                                return false;
                            }
                            if (bins1_1[2] == 4) break block73;
                            return false;
                        }
                        bins1_2 = BasicDescriptiveStatistics.performBinning(ds1, 1.0, 39.0, 3);
                        if (bins1_2.length == 3) break block74;
                        return false;
                    }
                    if (bins1_2[0] == 2) break block75;
                    return false;
                }
                if (bins1_2[1] == 2) break block76;
                return false;
            }
            if (bins1_2[2] == 2) break block77;
            return false;
        }
        BasicDescriptiveStatistics dss3 = new BasicDescriptiveStatistics();
        dss3.addValue(1.0);
        dss3.addValue(1.0);
        dss3.addValue(1.0);
        dss3.addValue(2.0);
        dss3.addValue(3.0);
        dss3.addValue(4.0);
        dss3.addValue(5.0);
        dss3.addValue(5.0);
        dss3.addValue(5.0);
        dss3.addValue(6.0);
        dss3.addValue(7.0);
        dss3.addValue(8.0);
        dss3.addValue(9.0);
        dss3.addValue(10.0);
        dss3.addValue(10.0);
        dss3.addValue(10.0);
        AsciiHistogram histo = new AsciiHistogram(dss3);
        histo.toStringBuffer(10, '=', 40, 5);
        histo.toStringBuffer(3.0, 8.0, 10, '=', 40, 5);
        return true;
    }

    private static boolean testDir(String file) {
        File f;
        block5: {
            block4: {
                try {
                    f = new File(file);
                    if (f.exists()) break block4;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (f.isDirectory()) break block5;
            return false;
        }
        return f.canRead();
    }

    private static boolean testExternalNodeRelatedMethods() {
        Phylogeny t3;
        PhylogenyNode n;
        PhylogenyFactory factory;
        block32: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    Phylogeny t2;
                                    block25: {
                                        block24: {
                                            block23: {
                                                Phylogeny t1;
                                                block22: {
                                                    block21: {
                                                        block20: {
                                                            factory = ParserBasedPhylogenyFactory.getInstance();
                                                            t1 = factory.create("((A,B),(C,D))", new NHXParser())[0];
                                                            n = t1.getNode("A");
                                                            n = n.getNextExternalNode();
                                                            if (n.getNodeName().equals("B")) break block20;
                                                            return false;
                                                        }
                                                        n = n.getNextExternalNode();
                                                        if (n.getNodeName().equals("C")) break block21;
                                                        return false;
                                                    }
                                                    n = n.getNextExternalNode();
                                                    if (n.getNodeName().equals("D")) break block22;
                                                    return false;
                                                }
                                                n = t1.getNode("B");
                                                while (!n.isLastExternalNode()) {
                                                    n = n.getNextExternalNode();
                                                }
                                                t2 = factory.create("(((A,B),C),D)", new NHXParser())[0];
                                                n = t2.getNode("A");
                                                if ((n = n.getNextExternalNode()).getNodeName().equals("B")) break block23;
                                                return false;
                                            }
                                            n = n.getNextExternalNode();
                                            if (n.getNodeName().equals("C")) break block24;
                                            return false;
                                        }
                                        n = n.getNextExternalNode();
                                        if (n.getNodeName().equals("D")) break block25;
                                        return false;
                                    }
                                    n = t2.getNode("B");
                                    while (!n.isLastExternalNode()) {
                                        n = n.getNextExternalNode();
                                    }
                                    t3 = factory.create("(((A,B),(C,D)),((E,F),(G,H)))", new NHXParser())[0];
                                    n = t3.getNode("A");
                                    if ((n = n.getNextExternalNode()).getNodeName().equals("B")) break block26;
                                    return false;
                                }
                                n = n.getNextExternalNode();
                                if (n.getNodeName().equals("C")) break block27;
                                return false;
                            }
                            n = n.getNextExternalNode();
                            if (n.getNodeName().equals("D")) break block28;
                            return false;
                        }
                        n = n.getNextExternalNode();
                        if (n.getNodeName().equals("E")) break block29;
                        return false;
                    }
                    n = n.getNextExternalNode();
                    if (n.getNodeName().equals("F")) break block30;
                    return false;
                }
                n = n.getNextExternalNode();
                if (n.getNodeName().equals("G")) break block31;
                return false;
            }
            n = n.getNextExternalNode();
            if (n.getNodeName().equals("H")) break block32;
            return false;
        }
        try {
            n = t3.getNode("B");
            while (!n.isLastExternalNode()) {
                n = n.getNextExternalNode();
            }
            Phylogeny t4 = factory.create("((A,B),(C,D))", new NHXParser())[0];
            PhylogenyNodeIterator iter = t4.iteratorExternalForward();
            while (iter.hasNext()) {
                PhylogenyNode phylogenyNode = iter.next();
            }
            Phylogeny t5 = factory.create("(((A,B),(C,D)),((E,F),(G,H)))", new NHXParser())[0];
            PhylogenyNodeIterator iter2 = t5.iteratorExternalForward();
            while (iter2.hasNext()) {
                PhylogenyNode phylogenyNode = iter2.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testGeneralTable() {
        GeneralTable<String, String> t1;
        block37: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block30: {
                                        block29: {
                                            block28: {
                                                GeneralTable<Integer, String> t0;
                                                block27: {
                                                    block26: {
                                                        block25: {
                                                            block24: {
                                                                block23: {
                                                                    block22: {
                                                                        block21: {
                                                                            block20: {
                                                                                try {
                                                                                    t0 = new GeneralTable<Integer, String>();
                                                                                    t0.setValue(3, 2, "23");
                                                                                    t0.setValue(10, 1, "error");
                                                                                    t0.setValue(10, 1, "110");
                                                                                    t0.setValue(9, 1, "19");
                                                                                    t0.setValue(1, 10, "101");
                                                                                    t0.setValue(10, 10, "1010");
                                                                                    t0.setValue(100, 10, "10100");
                                                                                    t0.setValue(0, 0, "00");
                                                                                    if (((String)t0.getValue(3, 2)).equals("23")) break block20;
                                                                                    return false;
                                                                                }
                                                                                catch (Exception e) {
                                                                                    e.printStackTrace(System.out);
                                                                                    return false;
                                                                                }
                                                                            }
                                                                            if (((String)t0.getValue(10, 1)).equals("110")) break block21;
                                                                            return false;
                                                                        }
                                                                        if (t0.getValueAsString(1, 10).equals("101")) break block22;
                                                                        return false;
                                                                    }
                                                                    if (t0.getValueAsString(10, 10).equals("1010")) break block23;
                                                                    return false;
                                                                }
                                                                if (t0.getValueAsString(100, 10).equals("10100")) break block24;
                                                                return false;
                                                            }
                                                            if (t0.getValueAsString(9, 1).equals("19")) break block25;
                                                            return false;
                                                        }
                                                        if (t0.getValueAsString(0, 0).equals("00")) break block26;
                                                        return false;
                                                    }
                                                    if (t0.getValueAsString(49, 4).equals("")) break block27;
                                                    return false;
                                                }
                                                if (t0.getValueAsString(22349, 3434344).equals("")) break block28;
                                                return false;
                                            }
                                            t1 = new GeneralTable<String, String>();
                                            t1.setValue("3", "2", "23");
                                            t1.setValue("10", "1", "error");
                                            t1.setValue("10", "1", "110");
                                            t1.setValue("9", "1", "19");
                                            t1.setValue("1", "10", "101");
                                            t1.setValue("10", "10", "1010");
                                            t1.setValue("100", "10", "10100");
                                            t1.setValue("0", "0", "00");
                                            t1.setValue("qwerty", "zxcvbnm", "asdef");
                                            if (((String)t1.getValue("3", "2")).equals("23")) break block29;
                                            return false;
                                        }
                                        if (((String)t1.getValue("10", "1")).equals("110")) break block30;
                                        return false;
                                    }
                                    if (t1.getValueAsString("1", "10").equals("101")) break block31;
                                    return false;
                                }
                                if (t1.getValueAsString("10", "10").equals("1010")) break block32;
                                return false;
                            }
                            if (t1.getValueAsString("100", "10").equals("10100")) break block33;
                            return false;
                        }
                        if (t1.getValueAsString("9", "1").equals("19")) break block34;
                        return false;
                    }
                    if (t1.getValueAsString("0", "0").equals("00")) break block35;
                    return false;
                }
                if (t1.getValueAsString("qwerty", "zxcvbnm").equals("asdef")) break block36;
                return false;
            }
            if (t1.getValueAsString("49", "4").equals("")) break block37;
            return false;
        }
        return t1.getValueAsString("22349", "3434344").equals("");
    }

    private static boolean testGetDistance() {
        Phylogeny p2;
        PhylogenyMethods pm;
        block83: {
            block82: {
                block81: {
                    block80: {
                        block79: {
                            block78: {
                                block77: {
                                    block76: {
                                        block75: {
                                            block74: {
                                                PhylogenyFactory factory;
                                                block73: {
                                                    Phylogeny p1;
                                                    block72: {
                                                        block71: {
                                                            block70: {
                                                                block69: {
                                                                    block68: {
                                                                        block67: {
                                                                            block66: {
                                                                                block65: {
                                                                                    block64: {
                                                                                        block63: {
                                                                                            block62: {
                                                                                                block61: {
                                                                                                    block60: {
                                                                                                        block59: {
                                                                                                            block58: {
                                                                                                                block57: {
                                                                                                                    block56: {
                                                                                                                        block55: {
                                                                                                                            block54: {
                                                                                                                                block53: {
                                                                                                                                    block52: {
                                                                                                                                        block51: {
                                                                                                                                            block50: {
                                                                                                                                                block49: {
                                                                                                                                                    block48: {
                                                                                                                                                        block47: {
                                                                                                                                                            block46: {
                                                                                                                                                                block45: {
                                                                                                                                                                    block44: {
                                                                                                                                                                        block43: {
                                                                                                                                                                            try {
                                                                                                                                                                                factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                p1 = factory.create("(((A:1,B:2,X:100)ab:3,C:4)abc:5,(D:7,(E:9,F:10)ef:8)def:6)r", new NHXParser())[0];
                                                                                                                                                                                pm = PhylogenyMethods.getInstance();
                                                                                                                                                                                if (pm.calculateDistance(p1.getNode("C"), p1.getNode("C")) == 0.0) break block43;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                e.printStackTrace(System.out);
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                        if (pm.calculateDistance(p1.getNode("def"), p1.getNode("def")) == 0.0) break block44;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (pm.calculateDistance(p1.getNode("ef"), p1.getNode("ef")) == 0.0) break block45;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (pm.calculateDistance(p1.getNode("r"), p1.getNode("r")) == 0.0) break block46;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (pm.calculateDistance(p1.getNode("A"), p1.getNode("A")) == 0.0) break block47;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (pm.calculateDistance(p1.getNode("A"), p1.getNode("B")) == 3.0) break block48;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (pm.calculateDistance(p1.getNode("B"), p1.getNode("A")) == 3.0) break block49;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (pm.calculateDistance(p1.getNode("A"), p1.getNode("C")) == 8.0) break block50;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (pm.calculateDistance(p1.getNode("C"), p1.getNode("A")) == 8.0) break block51;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (pm.calculateDistance(p1.getNode("A"), p1.getNode("D")) == 22.0) break block52;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (pm.calculateDistance(p1.getNode("A"), p1.getNode("E")) == 32.0) break block53;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (pm.calculateDistance(p1.getNode("E"), p1.getNode("A")) == 32.0) break block54;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (pm.calculateDistance(p1.getNode("A"), p1.getNode("F")) == 33.0) break block55;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (pm.calculateDistance(p1.getNode("F"), p1.getNode("A")) == 33.0) break block56;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (pm.calculateDistance(p1.getNode("A"), p1.getNode("ab")) == 1.0) break block57;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (pm.calculateDistance(p1.getNode("ab"), p1.getNode("A")) == 1.0) break block58;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (pm.calculateDistance(p1.getNode("A"), p1.getNode("abc")) == 4.0) break block59;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (pm.calculateDistance(p1.getNode("abc"), p1.getNode("A")) == 4.0) break block60;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (pm.calculateDistance(p1.getNode("A"), p1.getNode("r")) == 9.0) break block61;
                                                                                                    return false;
                                                                                                }
                                                                                                if (pm.calculateDistance(p1.getNode("r"), p1.getNode("A")) == 9.0) break block62;
                                                                                                return false;
                                                                                            }
                                                                                            if (pm.calculateDistance(p1.getNode("A"), p1.getNode("def")) == 15.0) break block63;
                                                                                            return false;
                                                                                        }
                                                                                        if (pm.calculateDistance(p1.getNode("def"), p1.getNode("A")) == 15.0) break block64;
                                                                                        return false;
                                                                                    }
                                                                                    if (pm.calculateDistance(p1.getNode("A"), p1.getNode("ef")) == 23.0) break block65;
                                                                                    return false;
                                                                                }
                                                                                if (pm.calculateDistance(p1.getNode("ef"), p1.getNode("A")) == 23.0) break block66;
                                                                                return false;
                                                                            }
                                                                            if (pm.calculateDistance(p1.getNode("ef"), p1.getNode("def")) == 8.0) break block67;
                                                                            return false;
                                                                        }
                                                                        if (pm.calculateDistance(p1.getNode("def"), p1.getNode("ef")) == 8.0) break block68;
                                                                        return false;
                                                                    }
                                                                    if (pm.calculateDistance(p1.getNode("ef"), p1.getNode("r")) == 14.0) break block69;
                                                                    return false;
                                                                }
                                                                if (pm.calculateDistance(p1.getNode("ef"), p1.getNode("abc")) == 19.0) break block70;
                                                                return false;
                                                            }
                                                            if (pm.calculateDistance(p1.getNode("ef"), p1.getNode("ab")) == 22.0) break block71;
                                                            return false;
                                                        }
                                                        if (pm.calculateDistance(p1.getNode("ab"), p1.getNode("ef")) == 22.0) break block72;
                                                        return false;
                                                    }
                                                    if (pm.calculateDistance(p1.getNode("def"), p1.getNode("abc")) == 11.0) break block73;
                                                    return false;
                                                }
                                                p2 = factory.create("((A:4,B:5,C:6)abc:1,(D:7,E:8,F:9)def:2,(G:10,H:11,I:12)ghi:3)r", new NHXParser())[0];
                                                if (pm.calculateDistance(p2.getNode("A"), p2.getNode("B")) == 9.0) break block74;
                                                return false;
                                            }
                                            if (pm.calculateDistance(p2.getNode("A"), p2.getNode("C")) == 10.0) break block75;
                                            return false;
                                        }
                                        if (pm.calculateDistance(p2.getNode("A"), p2.getNode("D")) == 14.0) break block76;
                                        return false;
                                    }
                                    if (pm.calculateDistance(p2.getNode("A"), p2.getNode("ghi")) == 8.0) break block77;
                                    return false;
                                }
                                if (pm.calculateDistance(p2.getNode("A"), p2.getNode("I")) == 20.0) break block78;
                                return false;
                            }
                            if (pm.calculateDistance(p2.getNode("G"), p2.getNode("ghi")) == 10.0) break block79;
                            return false;
                        }
                        if (pm.calculateDistance(p2.getNode("r"), p2.getNode("r")) == 0.0) break block80;
                        return false;
                    }
                    if (pm.calculateDistance(p2.getNode("r"), p2.getNode("G")) == 13.0) break block81;
                    return false;
                }
                if (pm.calculateDistance(p2.getNode("G"), p2.getNode("r")) == 13.0) break block82;
                return false;
            }
            if (pm.calculateDistance(p2.getNode("G"), p2.getNode("H")) == 21.0) break block83;
            return false;
        }
        return pm.calculateDistance(p2.getNode("G"), p2.getNode("I")) == 22.0;
    }

    private static boolean testGetLCA() {
        Phylogeny p3;
        PhylogenyMethods pm;
        block87: {
            PhylogenyNode fl_3;
            block86: {
                block85: {
                    PhylogenyNode kl_3;
                    block84: {
                        block83: {
                            PhylogenyNode al_3;
                            block82: {
                                block81: {
                                    PhylogenyNode ag_3;
                                    block80: {
                                        block79: {
                                            block78: {
                                                block77: {
                                                    block76: {
                                                        PhylogenyFactory factory;
                                                        block75: {
                                                            Phylogeny p2;
                                                            block74: {
                                                                block73: {
                                                                    block72: {
                                                                        block71: {
                                                                            block70: {
                                                                                block69: {
                                                                                    block68: {
                                                                                        block67: {
                                                                                            Phylogeny p1;
                                                                                            block66: {
                                                                                                block65: {
                                                                                                    block64: {
                                                                                                        block63: {
                                                                                                            block62: {
                                                                                                                block61: {
                                                                                                                    block60: {
                                                                                                                        block59: {
                                                                                                                            block58: {
                                                                                                                                block57: {
                                                                                                                                    block56: {
                                                                                                                                        block55: {
                                                                                                                                            block54: {
                                                                                                                                                block53: {
                                                                                                                                                    block52: {
                                                                                                                                                        block51: {
                                                                                                                                                            block50: {
                                                                                                                                                                block49: {
                                                                                                                                                                    block48: {
                                                                                                                                                                        block47: {
                                                                                                                                                                            block46: {
                                                                                                                                                                                block45: {
                                                                                                                                                                                    try {
                                                                                                                                                                                        factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                        p1 = factory.create("((((((A,B)ab,C)abc,D)abcd,E)abcde,F)abcdef,(G,H)gh)abcdefgh", new NHXParser())[0];
                                                                                                                                                                                        pm = PhylogenyMethods.getInstance();
                                                                                                                                                                                        PhylogenyNode A = pm.getLCA(p1.getNode("A"), p1.getNode("A"));
                                                                                                                                                                                        if (A.getNodeName().equals("A")) break block45;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    catch (Exception e) {
                                                                                                                                                                                        e.printStackTrace(System.out);
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                                PhylogenyNode gh = pm.getLCA(p1.getNode("gh"), p1.getNode("gh"));
                                                                                                                                                                                if (gh.getNodeName().equals("gh")) break block46;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            PhylogenyNode ab = pm.getLCA(p1.getNode("A"), p1.getNode("B"));
                                                                                                                                                                            if (ab.getNodeName().equals("ab")) break block47;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        PhylogenyNode ab2 = pm.getLCA(p1.getNode("B"), p1.getNode("A"));
                                                                                                                                                                        if (ab2.getNodeName().equals("ab")) break block48;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    PhylogenyNode gh2 = pm.getLCA(p1.getNode("H"), p1.getNode("G"));
                                                                                                                                                                    if (gh2.getNodeName().equals("gh")) break block49;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                PhylogenyNode gh3 = pm.getLCA(p1.getNode("G"), p1.getNode("H"));
                                                                                                                                                                if (gh3.getNodeName().equals("gh")) break block50;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            PhylogenyNode abc = pm.getLCA(p1.getNode("C"), p1.getNode("A"));
                                                                                                                                                            if (abc.getNodeName().equals("abc")) break block51;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        PhylogenyNode abc2 = pm.getLCA(p1.getNode("A"), p1.getNode("C"));
                                                                                                                                                        if (abc2.getNodeName().equals("abc")) break block52;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    PhylogenyNode abcd = pm.getLCA(p1.getNode("A"), p1.getNode("D"));
                                                                                                                                                    if (abcd.getNodeName().equals("abcd")) break block53;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                PhylogenyNode abcd2 = pm.getLCA(p1.getNode("D"), p1.getNode("A"));
                                                                                                                                                if (abcd2.getNodeName().equals("abcd")) break block54;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            PhylogenyNode abcdef = pm.getLCA(p1.getNode("A"), p1.getNode("F"));
                                                                                                                                            if (abcdef.getNodeName().equals("abcdef")) break block55;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        PhylogenyNode abcdef2 = pm.getLCA(p1.getNode("F"), p1.getNode("A"));
                                                                                                                                        if (abcdef2.getNodeName().equals("abcdef")) break block56;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    PhylogenyNode abcdef3 = pm.getLCA(p1.getNode("ab"), p1.getNode("F"));
                                                                                                                                    if (abcdef3.getNodeName().equals("abcdef")) break block57;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                PhylogenyNode abcdef4 = pm.getLCA(p1.getNode("F"), p1.getNode("ab"));
                                                                                                                                if (abcdef4.getNodeName().equals("abcdef")) break block58;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            PhylogenyNode abcde = pm.getLCA(p1.getNode("A"), p1.getNode("E"));
                                                                                                                            if (abcde.getNodeName().equals("abcde")) break block59;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        PhylogenyNode abcde2 = pm.getLCA(p1.getNode("E"), p1.getNode("A"));
                                                                                                                        if (abcde2.getNodeName().equals("abcde")) break block60;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    PhylogenyNode r = pm.getLCA(p1.getNode("abcdefgh"), p1.getNode("abcdefgh"));
                                                                                                                    if (r.getNodeName().equals("abcdefgh")) break block61;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                PhylogenyNode r2 = pm.getLCA(p1.getNode("A"), p1.getNode("H"));
                                                                                                                if (r2.getNodeName().equals("abcdefgh")) break block62;
                                                                                                                return false;
                                                                                                            }
                                                                                                            PhylogenyNode r3 = pm.getLCA(p1.getNode("H"), p1.getNode("A"));
                                                                                                            if (r3.getNodeName().equals("abcdefgh")) break block63;
                                                                                                            return false;
                                                                                                        }
                                                                                                        PhylogenyNode abcde3 = pm.getLCA(p1.getNode("E"), p1.getNode("abcde"));
                                                                                                        if (abcde3.getNodeName().equals("abcde")) break block64;
                                                                                                        return false;
                                                                                                    }
                                                                                                    PhylogenyNode abcde4 = pm.getLCA(p1.getNode("abcde"), p1.getNode("E"));
                                                                                                    if (abcde4.getNodeName().equals("abcde")) break block65;
                                                                                                    return false;
                                                                                                }
                                                                                                PhylogenyNode ab3 = pm.getLCA(p1.getNode("ab"), p1.getNode("B"));
                                                                                                if (ab3.getNodeName().equals("ab")) break block66;
                                                                                                return false;
                                                                                            }
                                                                                            PhylogenyNode ab4 = pm.getLCA(p1.getNode("B"), p1.getNode("ab"));
                                                                                            if (ab4.getNodeName().equals("ab")) break block67;
                                                                                            return false;
                                                                                        }
                                                                                        p2 = factory.create("(a,b,(((c,d)cd,e)cde,f)cdef)r", new NHXParser())[0];
                                                                                        PhylogenyNode cd = pm.getLCA(p2.getNode("c"), p2.getNode("d"));
                                                                                        if (cd.getNodeName().equals("cd")) break block68;
                                                                                        return false;
                                                                                    }
                                                                                    PhylogenyNode cd2 = pm.getLCA(p2.getNode("d"), p2.getNode("c"));
                                                                                    if (cd2.getNodeName().equals("cd")) break block69;
                                                                                    return false;
                                                                                }
                                                                                PhylogenyNode cde = pm.getLCA(p2.getNode("c"), p2.getNode("e"));
                                                                                if (cde.getNodeName().equals("cde")) break block70;
                                                                                return false;
                                                                            }
                                                                            PhylogenyNode cde2 = pm.getLCA(p2.getNode("e"), p2.getNode("c"));
                                                                            if (cde2.getNodeName().equals("cde")) break block71;
                                                                            return false;
                                                                        }
                                                                        PhylogenyNode cdef = pm.getLCA(p2.getNode("c"), p2.getNode("f"));
                                                                        if (cdef.getNodeName().equals("cdef")) break block72;
                                                                        return false;
                                                                    }
                                                                    PhylogenyNode cdef2 = pm.getLCA(p2.getNode("d"), p2.getNode("f"));
                                                                    if (cdef2.getNodeName().equals("cdef")) break block73;
                                                                    return false;
                                                                }
                                                                PhylogenyNode cdef3 = pm.getLCA(p2.getNode("f"), p2.getNode("d"));
                                                                if (cdef3.getNodeName().equals("cdef")) break block74;
                                                                return false;
                                                            }
                                                            PhylogenyNode rt = pm.getLCA(p2.getNode("c"), p2.getNode("a"));
                                                            if (rt.getNodeName().equals("r")) break block75;
                                                            return false;
                                                        }
                                                        p3 = factory.create("((((a,(b,c)bc)abc,(d,e)de)abcde,f)abcdef,(((g,h)gh,(i,j)ij)ghij,k)ghijk,l)", new NHXParser())[0];
                                                        PhylogenyNode bc_3 = pm.getLCA(p3.getNode("b"), p3.getNode("c"));
                                                        if (bc_3.getNodeName().equals("bc")) break block76;
                                                        return false;
                                                    }
                                                    PhylogenyNode ac_3 = pm.getLCA(p3.getNode("a"), p3.getNode("c"));
                                                    if (ac_3.getNodeName().equals("abc")) break block77;
                                                    return false;
                                                }
                                                PhylogenyNode ad_3 = pm.getLCA(p3.getNode("a"), p3.getNode("d"));
                                                if (ad_3.getNodeName().equals("abcde")) break block78;
                                                return false;
                                            }
                                            PhylogenyNode af_3 = pm.getLCA(p3.getNode("a"), p3.getNode("f"));
                                            if (af_3.getNodeName().equals("abcdef")) break block79;
                                            return false;
                                        }
                                        ag_3 = pm.getLCA(p3.getNode("a"), p3.getNode("g"));
                                        if (ag_3.getNodeName().equals("")) break block80;
                                        return false;
                                    }
                                    if (ag_3.isRoot()) break block81;
                                    return false;
                                }
                                al_3 = pm.getLCA(p3.getNode("a"), p3.getNode("l"));
                                if (al_3.getNodeName().equals("")) break block82;
                                return false;
                            }
                            if (al_3.isRoot()) break block83;
                            return false;
                        }
                        kl_3 = pm.getLCA(p3.getNode("k"), p3.getNode("l"));
                        if (kl_3.getNodeName().equals("")) break block84;
                        return false;
                    }
                    if (kl_3.isRoot()) break block85;
                    return false;
                }
                fl_3 = pm.getLCA(p3.getNode("f"), p3.getNode("l"));
                if (fl_3.getNodeName().equals("")) break block86;
                return false;
            }
            if (fl_3.isRoot()) break block87;
            return false;
        }
        PhylogenyNode gk_3 = pm.getLCA(p3.getNode("g"), p3.getNode("k"));
        return gk_3.getNodeName().equals("ghijk");
    }

    private static boolean testHmmscanOutputParser() {
        Protein p4;
        block31: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            List<Protein> domain_collections;
                                            block22: {
                                                block21: {
                                                    HmmscanPerDomainTableParser parser2;
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                block17: {
                                                                    String test_dir = PATH_TO_TEST_DATA;
                                                                    try {
                                                                        HmmscanPerDomainTableParser parser1 = new HmmscanPerDomainTableParser(new File(String.valueOf(test_dir) + ForesterUtil.getFileSeparator() + "hmmscan30b3_output_1"), "MONBR", HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.NONE);
                                                                        parser1.parse();
                                                                        parser2 = new HmmscanPerDomainTableParser(new File(String.valueOf(test_dir) + ForesterUtil.getFileSeparator() + "hmmscan30b3_output_2"), "MONBR", HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.NONE);
                                                                        domain_collections = parser2.parse();
                                                                        if (parser2.getProteinsEncountered() == 4) break block17;
                                                                        return false;
                                                                    }
                                                                    catch (Exception e) {
                                                                        e.printStackTrace(System.out);
                                                                        return false;
                                                                    }
                                                                }
                                                                if (domain_collections.size() == 4) break block18;
                                                                return false;
                                                            }
                                                            if (parser2.getDomainsEncountered() == 69) break block19;
                                                            return false;
                                                        }
                                                        if (parser2.getDomainsIgnoredDueToDuf() == 0) break block20;
                                                        return false;
                                                    }
                                                    if (parser2.getDomainsIgnoredDueToEval() == 0) break block21;
                                                    return false;
                                                }
                                                Protein p1 = domain_collections.get(0);
                                                if (p1.getNumberOfProteinDomains() == 15) break block22;
                                                return false;
                                            }
                                            p4 = domain_collections.get(3);
                                            if (p4.getNumberOfProteinDomains() == 1) break block23;
                                            return false;
                                        }
                                        if (p4.getProteinDomain(0).getDomainId().toString().equals("DNA_pol_B_new")) break block24;
                                        return false;
                                    }
                                    if (p4.getProteinDomain(0).getFrom() == 51) break block25;
                                    return false;
                                }
                                if (p4.getProteinDomain(0).getTo() == 395) break block26;
                                return false;
                            }
                            if (Test.isEqual(p4.getProteinDomain(0).getPerDomainEvalue(), 1.2E-39)) break block27;
                            return false;
                        }
                        if (Test.isEqual(p4.getProteinDomain(0).getPerDomainScore(), 135.7)) break block28;
                        return false;
                    }
                    if (Test.isEqual(p4.getProteinDomain(0).getPerSequenceEvalue(), 8.3E-40)) break block29;
                    return false;
                }
                if (Test.isEqual(p4.getProteinDomain(0).getPerSequenceScore(), 136.3)) break block30;
                return false;
            }
            if (Test.isEqual(p4.getProteinDomain(0).getNumber(), 1.0)) break block31;
            return false;
        }
        return Test.isEqual(p4.getProteinDomain(0).getTotalCount(), 1.0);
    }

    private static boolean testLastExternalNodeMethods() {
        Phylogeny t0;
        block7: {
            block6: {
                block5: {
                    try {
                        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                        char[] a0 = new char[]{'(', '(', 'A', ',', 'B', ')', ',', '(', 'C', ',', 'D', ')', ')'};
                        t0 = factory.create(a0, new NHXParser())[0];
                        PhylogenyNode n1 = t0.getNode("A");
                        if (!n1.isLastExternalNode()) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        return false;
                    }
                }
                PhylogenyNode n2 = t0.getNode("B");
                if (!n2.isLastExternalNode()) break block6;
                return false;
            }
            PhylogenyNode n3 = t0.getNode("C");
            if (!n3.isLastExternalNode()) break block7;
            return false;
        }
        PhylogenyNode n4 = t0.getNode("D");
        return n4.isLastExternalNode();
    }

    private static boolean testLevelOrderIterator() {
        PhylogenyNodeIterator it;
        block89: {
            PhylogenyFactory factory;
            block88: {
                PhylogenyNodeIterator it5;
                block87: {
                    block86: {
                        block85: {
                            block84: {
                                block83: {
                                    PhylogenyNodeIterator it3;
                                    block82: {
                                        block81: {
                                            block80: {
                                                block79: {
                                                    block78: {
                                                        block77: {
                                                            block76: {
                                                                block75: {
                                                                    block74: {
                                                                        block73: {
                                                                            block72: {
                                                                                block71: {
                                                                                    block70: {
                                                                                        block69: {
                                                                                            block68: {
                                                                                                block67: {
                                                                                                    block66: {
                                                                                                        block65: {
                                                                                                            block64: {
                                                                                                                block63: {
                                                                                                                    block62: {
                                                                                                                        block61: {
                                                                                                                            block60: {
                                                                                                                                block59: {
                                                                                                                                    block58: {
                                                                                                                                        block57: {
                                                                                                                                            block56: {
                                                                                                                                                block55: {
                                                                                                                                                    block54: {
                                                                                                                                                        block53: {
                                                                                                                                                            block52: {
                                                                                                                                                                block51: {
                                                                                                                                                                    block50: {
                                                                                                                                                                        factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                        Phylogeny t0 = factory.create("((A,B)ab,(C,D)cd)r", new NHXParser())[0];
                                                                                                                                                                        PhylogenyNodeIterator it0 = t0.iteratorLevelOrder();
                                                                                                                                                                        while (it0.hasNext()) {
                                                                                                                                                                            it0.next();
                                                                                                                                                                        }
                                                                                                                                                                        it0.reset();
                                                                                                                                                                        while (it0.hasNext()) {
                                                                                                                                                                            it0.next();
                                                                                                                                                                        }
                                                                                                                                                                        it = t0.iteratorLevelOrder();
                                                                                                                                                                        if (it.next().getNodeName().equals("r")) break block50;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (it.next().getNodeName().equals("ab")) break block51;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (it.next().getNodeName().equals("cd")) break block52;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (it.next().getNodeName().equals("A")) break block53;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (it.next().getNodeName().equals("B")) break block54;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (it.next().getNodeName().equals("C")) break block55;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (it.next().getNodeName().equals("D")) break block56;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (!it.hasNext()) break block57;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        Phylogeny t2 = factory.create("(((1,2,(a,(X,Y,Z)b)3,4,5,6)A,B,C)abc,(D,E,(f1,(f21)f2,f3)F,G)defg)r", new NHXParser())[0];
                                                                                                                                        PhylogenyNodeIterator it2 = t2.iteratorLevelOrder();
                                                                                                                                        while (it2.hasNext()) {
                                                                                                                                            it2.next();
                                                                                                                                        }
                                                                                                                                        it2.reset();
                                                                                                                                        while (it2.hasNext()) {
                                                                                                                                            it2.next();
                                                                                                                                        }
                                                                                                                                        it3 = t2.iteratorLevelOrder();
                                                                                                                                        if (it3.next().getNodeName().equals("r")) break block58;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (it3.next().getNodeName().equals("abc")) break block59;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (it3.next().getNodeName().equals("defg")) break block60;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (it3.next().getNodeName().equals("A")) break block61;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (it3.next().getNodeName().equals("B")) break block62;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (it3.next().getNodeName().equals("C")) break block63;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (it3.next().getNodeName().equals("D")) break block64;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (it3.next().getNodeName().equals("E")) break block65;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (it3.next().getNodeName().equals("F")) break block66;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (it3.next().getNodeName().equals("G")) break block67;
                                                                                                    return false;
                                                                                                }
                                                                                                if (it3.next().getNodeName().equals("1")) break block68;
                                                                                                return false;
                                                                                            }
                                                                                            if (it3.next().getNodeName().equals("2")) break block69;
                                                                                            return false;
                                                                                        }
                                                                                        if (it3.next().getNodeName().equals("3")) break block70;
                                                                                        return false;
                                                                                    }
                                                                                    if (it3.next().getNodeName().equals("4")) break block71;
                                                                                    return false;
                                                                                }
                                                                                if (it3.next().getNodeName().equals("5")) break block72;
                                                                                return false;
                                                                            }
                                                                            if (it3.next().getNodeName().equals("6")) break block73;
                                                                            return false;
                                                                        }
                                                                        if (it3.next().getNodeName().equals("f1")) break block74;
                                                                        return false;
                                                                    }
                                                                    if (it3.next().getNodeName().equals("f2")) break block75;
                                                                    return false;
                                                                }
                                                                if (it3.next().getNodeName().equals("f3")) break block76;
                                                                return false;
                                                            }
                                                            if (it3.next().getNodeName().equals("a")) break block77;
                                                            return false;
                                                        }
                                                        if (it3.next().getNodeName().equals("b")) break block78;
                                                        return false;
                                                    }
                                                    if (it3.next().getNodeName().equals("f21")) break block79;
                                                    return false;
                                                }
                                                if (it3.next().getNodeName().equals("X")) break block80;
                                                return false;
                                            }
                                            if (it3.next().getNodeName().equals("Y")) break block81;
                                            return false;
                                        }
                                        if (it3.next().getNodeName().equals("Z")) break block82;
                                        return false;
                                    }
                                    if (!it3.hasNext()) break block83;
                                    return false;
                                }
                                Phylogeny t4 = factory.create("((((D)C)B)A)r", new NHXParser())[0];
                                PhylogenyNodeIterator it4 = t4.iteratorLevelOrder();
                                while (it4.hasNext()) {
                                    it4.next();
                                }
                                it4.reset();
                                while (it4.hasNext()) {
                                    it4.next();
                                }
                                it5 = t4.iteratorLevelOrder();
                                if (it5.next().getNodeName().equals("r")) break block84;
                                return false;
                            }
                            if (it5.next().getNodeName().equals("A")) break block85;
                            return false;
                        }
                        if (it5.next().getNodeName().equals("B")) break block86;
                        return false;
                    }
                    if (it5.next().getNodeName().equals("C")) break block87;
                    return false;
                }
                if (it5.next().getNodeName().equals("D")) break block88;
                return false;
            }
            try {
                Phylogeny t5 = factory.create("A", new NHXParser())[0];
                PhylogenyNodeIterator it6 = t5.iteratorLevelOrder();
                while (it6.hasNext()) {
                    it6.next();
                }
                it6.reset();
                while (it6.hasNext()) {
                    it6.next();
                }
                PhylogenyNodeIterator it7 = t5.iteratorLevelOrder();
                if (it7.next().getNodeName().equals("A")) break block89;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
        }
        return !it.hasNext();
    }

    private static boolean testMidpointrooting() {
        Phylogeny t1;
        block25: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        try {
                                                            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                                                            t1 = factory.create("((A:1,B:2)AB:1[&&NHX:B=55],(C:3,D:4)CD:3[&&NHX:B=10])ABCD:0.5", new NHXParser())[0];
                                                            if (t1.isRooted()) break block14;
                                                            return false;
                                                        }
                                                        catch (Exception e) {
                                                            e.printStackTrace(System.out);
                                                            return false;
                                                        }
                                                    }
                                                    PhylogenyMethods.midpointRoot(t1);
                                                    if (Test.isEqual(t1.getNode("A").getDistanceToParent(), 1.0)) break block15;
                                                    return false;
                                                }
                                                if (Test.isEqual(t1.getNode("B").getDistanceToParent(), 2.0)) break block16;
                                                return false;
                                            }
                                            if (Test.isEqual(t1.getNode("C").getDistanceToParent(), 3.0)) break block17;
                                            return false;
                                        }
                                        if (Test.isEqual(t1.getNode("D").getDistanceToParent(), 4.0)) break block18;
                                        return false;
                                    }
                                    if (Test.isEqual(t1.getNode("CD").getDistanceToParent(), 1.0)) break block19;
                                    return false;
                                }
                                if (Test.isEqual(t1.getNode("AB").getDistanceToParent(), 3.0)) break block20;
                                return false;
                            }
                            t1.reRoot(t1.getNode("A"));
                            PhylogenyMethods.midpointRoot(t1);
                            if (Test.isEqual(t1.getNode("A").getDistanceToParent(), 1.0)) break block21;
                            return false;
                        }
                        if (Test.isEqual(t1.getNode("B").getDistanceToParent(), 2.0)) break block22;
                        return false;
                    }
                    if (Test.isEqual(t1.getNode("C").getDistanceToParent(), 3.0)) break block23;
                    return false;
                }
                if (Test.isEqual(t1.getNode("D").getDistanceToParent(), 4.0)) break block24;
                return false;
            }
            if (Test.isEqual(t1.getNode("CD").getDistanceToParent(), 1.0)) break block25;
            return false;
        }
        return Test.isEqual(t1.getNode("AB").getDistanceToParent(), 3.0);
    }

    private static boolean testNexusCharactersParsing() {
        String[] labels;
        block31: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    NexusCharactersParser parser;
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                block17: {
                                                                    try {
                                                                        parser = new NexusCharactersParser();
                                                                        parser.setSource(new File(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_7.nex"));
                                                                        parser.parse();
                                                                        labels = parser.getCharStateLabels();
                                                                        if (labels.length == 7) break block17;
                                                                        return false;
                                                                    }
                                                                    catch (Exception e) {
                                                                        e.printStackTrace(System.out);
                                                                        return false;
                                                                    }
                                                                }
                                                                if (labels[0].equals("14-3-3")) break block18;
                                                                return false;
                                                            }
                                                            if (labels[1].equals("2-Hacid_dh")) break block19;
                                                            return false;
                                                        }
                                                        if (labels[2].equals("2-Hacid_dh_C")) break block20;
                                                        return false;
                                                    }
                                                    if (labels[3].equals("2-oxoacid_dh")) break block21;
                                                    return false;
                                                }
                                                if (labels[4].equals("2OG-FeII_Oxy")) break block22;
                                                return false;
                                            }
                                            if (labels[5].equals("3-HAO")) break block23;
                                            return false;
                                        }
                                        if (labels[6].equals("3_5_exonuc")) break block24;
                                        return false;
                                    }
                                    parser.setSource(new File(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_8.nex"));
                                    parser.parse();
                                    labels = parser.getCharStateLabels();
                                    if (labels.length == 7) break block25;
                                    return false;
                                }
                                if (labels[0].equals("14-3-3")) break block26;
                                return false;
                            }
                            if (labels[1].equals("2-Hacid_dh")) break block27;
                            return false;
                        }
                        if (labels[2].equals("2-Hacid_dh_C")) break block28;
                        return false;
                    }
                    if (labels[3].equals("2-oxoacid_dh")) break block29;
                    return false;
                }
                if (labels[4].equals("2OG-FeII_Oxy")) break block30;
                return false;
            }
            if (labels[5].equals("3-HAO")) break block31;
            return false;
        }
        return labels[6].equals("3_5_exonuc");
    }

    private static boolean testNexusMatrixParsing() {
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> m;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        try {
                                            NexusBinaryStatesMatrixParser parser = new NexusBinaryStatesMatrixParser();
                                            parser.setSource(new File(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_9.nex"));
                                            parser.parse();
                                            m = parser.getMatrix();
                                            if (m.getNumberOfCharacters() == 9) break block10;
                                            return false;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace(System.out);
                                            return false;
                                        }
                                    }
                                    if (m.getNumberOfIdentifiers() == 5) break block11;
                                    return false;
                                }
                                if (m.getState(0, 0) == CharacterStateMatrix.BinaryStates.PRESENT) break block12;
                                return false;
                            }
                            if (m.getState(0, 1) == CharacterStateMatrix.BinaryStates.ABSENT) break block13;
                            return false;
                        }
                        if (m.getState(1, 0) == CharacterStateMatrix.BinaryStates.PRESENT) break block14;
                        return false;
                    }
                    if (m.getState(2, 0) == CharacterStateMatrix.BinaryStates.ABSENT) break block15;
                    return false;
                }
                if (m.getState(4, 8) == CharacterStateMatrix.BinaryStates.PRESENT) break block16;
                return false;
            }
            if (m.getIdentifier(0).equals("MOUSE")) break block17;
            return false;
        }
        return m.getIdentifier(4).equals("ARATH");
    }

    private static boolean testNexusTreeParsing() {
        Phylogeny[] phylogenies;
        block101: {
            block100: {
                block99: {
                    block98: {
                        block97: {
                            block96: {
                                block95: {
                                    block94: {
                                        block93: {
                                            block92: {
                                                block91: {
                                                    block90: {
                                                        block89: {
                                                            block88: {
                                                                block87: {
                                                                    block86: {
                                                                        block85: {
                                                                            block84: {
                                                                                block83: {
                                                                                    block82: {
                                                                                        block81: {
                                                                                            block80: {
                                                                                                block79: {
                                                                                                    block78: {
                                                                                                        block77: {
                                                                                                            block76: {
                                                                                                                block75: {
                                                                                                                    block74: {
                                                                                                                        block73: {
                                                                                                                            block72: {
                                                                                                                                block71: {
                                                                                                                                    block70: {
                                                                                                                                        block69: {
                                                                                                                                            block68: {
                                                                                                                                                block67: {
                                                                                                                                                    block66: {
                                                                                                                                                        block65: {
                                                                                                                                                            block64: {
                                                                                                                                                                block63: {
                                                                                                                                                                    block62: {
                                                                                                                                                                        NexusPhylogeniesParser parser;
                                                                                                                                                                        PhylogenyFactory factory;
                                                                                                                                                                        block61: {
                                                                                                                                                                            block60: {
                                                                                                                                                                                block59: {
                                                                                                                                                                                    block58: {
                                                                                                                                                                                        block57: {
                                                                                                                                                                                            block56: {
                                                                                                                                                                                                block55: {
                                                                                                                                                                                                    block54: {
                                                                                                                                                                                                        block53: {
                                                                                                                                                                                                            block52: {
                                                                                                                                                                                                                try {
                                                                                                                                                                                                                    factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                    parser = new NexusPhylogeniesParser();
                                                                                                                                                                                                                    phylogenies = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_1.nex", parser);
                                                                                                                                                                                                                    if (phylogenies.length == 1) break block52;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                catch (Exception e) {
                                                                                                                                                                                                                    e.printStackTrace(System.out);
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (phylogenies[0].getNumberOfExternalNodes() == 25) break block53;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (phylogenies[0].getName().equals("")) break block54;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    phylogenies = null;
                                                                                                                                                                                                    phylogenies = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_2.nex", parser);
                                                                                                                                                                                                    if (phylogenies.length == 1) break block55;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (phylogenies[0].getNumberOfExternalNodes() == 10) break block56;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (phylogenies[0].getName().equals("name")) break block57;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        phylogenies = null;
                                                                                                                                                                                        phylogenies = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_3.nex", parser);
                                                                                                                                                                                        if (phylogenies.length == 1) break block58;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (phylogenies[0].getNumberOfExternalNodes() == 3) break block59;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (phylogenies[0].getName().equals("")) break block60;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (!phylogenies[0].isRooted()) break block61;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        phylogenies = null;
                                                                                                                                                                        phylogenies = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_4.nex", parser);
                                                                                                                                                                        if (phylogenies.length == 18) break block62;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (phylogenies[0].getNumberOfExternalNodes() == 10) break block63;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (phylogenies[0].getName().equals("tree 0")) break block64;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (phylogenies[1].getName().equals("tree 1")) break block65;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (phylogenies[1].getNumberOfExternalNodes() == 10) break block66;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (phylogenies[2].getNumberOfExternalNodes() == 3) break block67;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (phylogenies[3].getNumberOfExternalNodes() == 3) break block68;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (phylogenies[4].getNumberOfExternalNodes() == 3) break block69;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (phylogenies[5].getNumberOfExternalNodes() == 3) break block70;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (phylogenies[6].getNumberOfExternalNodes() == 3) break block71;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (phylogenies[7].getNumberOfExternalNodes() == 3) break block72;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (phylogenies[8].getName().equals("tree 8")) break block73;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (!phylogenies[8].isRooted()) break block74;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (phylogenies[8].getNumberOfExternalNodes() == 3) break block75;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (phylogenies[9].getName().equals("tree 9")) break block76;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (phylogenies[9].isRooted()) break block77;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (phylogenies[9].getNumberOfExternalNodes() == 3) break block78;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (phylogenies[10].getName().equals("tree 10")) break block79;
                                                                                                    return false;
                                                                                                }
                                                                                                if (phylogenies[10].isRooted()) break block80;
                                                                                                return false;
                                                                                            }
                                                                                            if (phylogenies[10].getNumberOfExternalNodes() == 3) break block81;
                                                                                            return false;
                                                                                        }
                                                                                        if (phylogenies[11].getName().equals("tree 11")) break block82;
                                                                                        return false;
                                                                                    }
                                                                                    if (!phylogenies[11].isRooted()) break block83;
                                                                                    return false;
                                                                                }
                                                                                if (phylogenies[11].getNumberOfExternalNodes() == 3) break block84;
                                                                                return false;
                                                                            }
                                                                            if (phylogenies[12].getName().equals("tree 12")) break block85;
                                                                            return false;
                                                                        }
                                                                        if (phylogenies[12].isRooted()) break block86;
                                                                        return false;
                                                                    }
                                                                    if (phylogenies[12].getNumberOfExternalNodes() == 3) break block87;
                                                                    return false;
                                                                }
                                                                if (phylogenies[13].getName().equals("tree 13")) break block88;
                                                                return false;
                                                            }
                                                            if (phylogenies[13].isRooted()) break block89;
                                                            return false;
                                                        }
                                                        if (phylogenies[13].getNumberOfExternalNodes() == 3) break block90;
                                                        return false;
                                                    }
                                                    if (phylogenies[14].getName().equals("tree 14")) break block91;
                                                    return false;
                                                }
                                                if (phylogenies[14].isRooted()) break block92;
                                                return false;
                                            }
                                            if (phylogenies[14].getNumberOfExternalNodes() == 10) break block93;
                                            return false;
                                        }
                                        if (phylogenies[15].getName().equals("tree 15")) break block94;
                                        return false;
                                    }
                                    if (!phylogenies[15].isRooted()) break block95;
                                    return false;
                                }
                                if (phylogenies[15].getNumberOfExternalNodes() == 10) break block96;
                                return false;
                            }
                            if (phylogenies[16].getName().equals("tree 16")) break block97;
                            return false;
                        }
                        if (phylogenies[16].isRooted()) break block98;
                        return false;
                    }
                    if (phylogenies[16].getNumberOfExternalNodes() == 10) break block99;
                    return false;
                }
                if (phylogenies[17].getName().equals("tree 17")) break block100;
                return false;
            }
            if (!phylogenies[17].isRooted()) break block101;
            return false;
        }
        return phylogenies[17].getNumberOfExternalNodes() == 10;
    }

    private static boolean testNexusTreeParsingTranslating() {
        Phylogeny[] phylogenies;
        block87: {
            block86: {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block81: {
                                    block80: {
                                        block79: {
                                            block78: {
                                                block77: {
                                                    block76: {
                                                        block75: {
                                                            block74: {
                                                                block73: {
                                                                    block72: {
                                                                        block71: {
                                                                            block70: {
                                                                                NexusPhylogeniesParser parser;
                                                                                PhylogenyFactory factory;
                                                                                block69: {
                                                                                    block68: {
                                                                                        block67: {
                                                                                            block66: {
                                                                                                block65: {
                                                                                                    block64: {
                                                                                                        block63: {
                                                                                                            block62: {
                                                                                                                block61: {
                                                                                                                    block60: {
                                                                                                                        block59: {
                                                                                                                            block58: {
                                                                                                                                block57: {
                                                                                                                                    block56: {
                                                                                                                                        block55: {
                                                                                                                                            block54: {
                                                                                                                                                block53: {
                                                                                                                                                    block52: {
                                                                                                                                                        block51: {
                                                                                                                                                            block50: {
                                                                                                                                                                block49: {
                                                                                                                                                                    block48: {
                                                                                                                                                                        block47: {
                                                                                                                                                                            block46: {
                                                                                                                                                                                block45: {
                                                                                                                                                                                    try {
                                                                                                                                                                                        factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                        parser = new NexusPhylogeniesParser();
                                                                                                                                                                                        phylogenies = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_5.nex", parser);
                                                                                                                                                                                        if (phylogenies.length == 1) break block45;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    catch (Exception e) {
                                                                                                                                                                                        e.printStackTrace(System.out);
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                                if (phylogenies[0].getNumberOfExternalNodes() == 3) break block46;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (phylogenies[0].getName().equals("Tree0")) break block47;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (phylogenies[0].getFirstExternalNode().getNodeName().equals("Scarabaeus")) break block48;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (phylogenies[0].getFirstExternalNode().getNextExternalNode().getNodeName().equals("Drosophila")) break block49;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (phylogenies[0].getFirstExternalNode().getNextExternalNode().getNextExternalNode().getNodeName().equals("Aranaeus")) break block50;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            phylogenies = null;
                                                                                                                                                            phylogenies = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_6.nex", parser);
                                                                                                                                                            if (phylogenies.length == 3) break block51;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (phylogenies[0].getNumberOfExternalNodes() == 3) break block52;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (phylogenies[0].getName().equals("Tree0")) break block53;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (!phylogenies[0].isRooted()) break block54;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (phylogenies[0].getFirstExternalNode().getNodeName().equals("Scarabaeus")) break block55;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (phylogenies[0].getFirstExternalNode().getNextExternalNode().getNodeName().equals("Drosophila")) break block56;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (phylogenies[0].getFirstExternalNode().getNextExternalNode().getNextExternalNode().getNodeName().equals("Aranaeus")) break block57;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (phylogenies[1].getNumberOfExternalNodes() == 3) break block58;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (phylogenies[1].getName().equals("Tree1")) break block59;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (!phylogenies[1].isRooted()) break block60;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (phylogenies[1].getFirstExternalNode().getNodeName().equals("Scarabaeus")) break block61;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (phylogenies[1].getFirstExternalNode().getNextExternalNode().getNodeName().equals("Drosophila")) break block62;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (phylogenies[1].getFirstExternalNode().getNextExternalNode().getNextExternalNode().getNodeName().equals("Aranaeus")) break block63;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (phylogenies[2].getNumberOfExternalNodes() == 3) break block64;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (phylogenies[2].getName().equals("Tree2")) break block65;
                                                                                                    return false;
                                                                                                }
                                                                                                if (phylogenies[2].isRooted()) break block66;
                                                                                                return false;
                                                                                            }
                                                                                            if (phylogenies[2].getFirstExternalNode().getNodeName().equals("Scarabaeus")) break block67;
                                                                                            return false;
                                                                                        }
                                                                                        if (phylogenies[2].getFirstExternalNode().getNextExternalNode().getNodeName().equals("Drosophila")) break block68;
                                                                                        return false;
                                                                                    }
                                                                                    if (phylogenies[2].getFirstExternalNode().getNextExternalNode().getNextExternalNode().getNodeName().equals("Aranaeus")) break block69;
                                                                                    return false;
                                                                                }
                                                                                phylogenies = null;
                                                                                phylogenies = factory.create(String.valueOf(PATH_TO_TEST_DATA) + "nexus_test_7.nex", parser);
                                                                                if (phylogenies.length == 3) break block70;
                                                                                return false;
                                                                            }
                                                                            if (phylogenies[0].getNumberOfExternalNodes() == 3) break block71;
                                                                            return false;
                                                                        }
                                                                        if (phylogenies[0].getName().equals("Tree0")) break block72;
                                                                        return false;
                                                                    }
                                                                    if (!phylogenies[0].isRooted()) break block73;
                                                                    return false;
                                                                }
                                                                if (phylogenies[0].getFirstExternalNode().getNodeName().equals("Scarabaeus")) break block74;
                                                                return false;
                                                            }
                                                            if (phylogenies[0].getFirstExternalNode().getNextExternalNode().getNodeName().equals("Drosophila")) break block75;
                                                            return false;
                                                        }
                                                        if (phylogenies[0].getFirstExternalNode().getNextExternalNode().getNextExternalNode().getNodeName().equals("Aranaeus")) break block76;
                                                        return false;
                                                    }
                                                    if (phylogenies[1].getNumberOfExternalNodes() == 3) break block77;
                                                    return false;
                                                }
                                                if (phylogenies[1].getName().equals("Tree1")) break block78;
                                                return false;
                                            }
                                            if (!phylogenies[1].isRooted()) break block79;
                                            return false;
                                        }
                                        if (phylogenies[1].getFirstExternalNode().getNodeName().equals("Scarabaeus")) break block80;
                                        return false;
                                    }
                                    if (phylogenies[1].getFirstExternalNode().getNextExternalNode().getNodeName().equals("Drosophila")) break block81;
                                    return false;
                                }
                                if (phylogenies[1].getFirstExternalNode().getNextExternalNode().getNextExternalNode().getNodeName().equals("Aranaeus")) break block82;
                                return false;
                            }
                            if (phylogenies[2].getNumberOfExternalNodes() == 3) break block83;
                            return false;
                        }
                        if (phylogenies[2].getName().equals("Tree2")) break block84;
                        return false;
                    }
                    if (phylogenies[2].isRooted()) break block85;
                    return false;
                }
                if (phylogenies[2].getFirstExternalNode().getNodeName().equals("Scarabaeus")) break block86;
                return false;
            }
            if (phylogenies[2].getFirstExternalNode().getNextExternalNode().getNodeName().equals("Drosophila")) break block87;
            return false;
        }
        return phylogenies[2].getFirstExternalNode().getNextExternalNode().getNextExternalNode().getNodeName().equals("Aranaeus");
    }

    private static boolean testNHParsing() {
        PhylogenyFactory factory;
        block85: {
            block84: {
                block83: {
                    block82: {
                        block81: {
                            block80: {
                                block79: {
                                    block78: {
                                        block77: {
                                            block76: {
                                                block75: {
                                                    block74: {
                                                        block73: {
                                                            block72: {
                                                                block71: {
                                                                    block70: {
                                                                        block69: {
                                                                            Phylogeny[] p28;
                                                                            block68: {
                                                                                block67: {
                                                                                    block66: {
                                                                                        block65: {
                                                                                            block64: {
                                                                                                block63: {
                                                                                                    block62: {
                                                                                                        Phylogeny[] p241;
                                                                                                        block61: {
                                                                                                            block60: {
                                                                                                                block59: {
                                                                                                                    block58: {
                                                                                                                        block57: {
                                                                                                                            block56: {
                                                                                                                                block55: {
                                                                                                                                    block54: {
                                                                                                                                        block53: {
                                                                                                                                            block52: {
                                                                                                                                                block51: {
                                                                                                                                                    Phylogeny[] p13;
                                                                                                                                                    block50: {
                                                                                                                                                        block49: {
                                                                                                                                                            block48: {
                                                                                                                                                                block47: {
                                                                                                                                                                    block46: {
                                                                                                                                                                        Phylogeny uc0;
                                                                                                                                                                        block45: {
                                                                                                                                                                            block44: {
                                                                                                                                                                                try {
                                                                                                                                                                                    factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                    Phylogeny p1 = factory.create("(A,B1)", new NHXParser())[0];
                                                                                                                                                                                    if (p1.toNewHampshireX().equals("(A,B1)")) break block44;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                catch (Exception e) {
                                                                                                                                                                                    e.printStackTrace(System.out);
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            NHXParser nhxp = new NHXParser();
                                                                                                                                                                            nhxp.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.NO);
                                                                                                                                                                            nhxp.setReplaceUnderscores(true);
                                                                                                                                                                            uc0 = factory.create("(A__A_,_B_B)", nhxp)[0];
                                                                                                                                                                            if (uc0.getRoot().getChildNode(0).getNodeName().equals("A A ")) break block45;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (uc0.getRoot().getChildNode(1).getNodeName().equals(" B B")) break block46;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    Phylogeny p1b = factory.create("   \n  \t  \b   \r \f   ; (  \n  \t  \b   \r \f; A ;  \n  \t  \b   \r \f,  \n  \t  \b   \r \f; B ;   \n  \t  \b   \r \f 1  \n  \t  \b   \r \f ;  \n  \t  \b   \r \f );;;;; \n  \t  \b   \r \f;;;  \n  \t  \b   \r \f ", new NHXParser())[0];
                                                                                                                                                                    if (p1b.toNewHampshireX().equals("(_A_,_B_1_)")) break block47;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                Phylogeny p2 = factory.create(new StringBuffer("(A,B2)"), new NHXParser())[0];
                                                                                                                                                                Phylogeny p3 = factory.create(new char[]{'(', 'A', ',', 'B', '3', ')'}, new NHXParser())[0];
                                                                                                                                                                Phylogeny p4 = factory.create("(A,B4);", new NHXParser())[0];
                                                                                                                                                                Phylogeny p5 = factory.create(new StringBuffer("(A,B5);"), new NHXParser())[0];
                                                                                                                                                                Phylogeny[] p7 = factory.create("(A,B7);(C,D7)", new NHXParser());
                                                                                                                                                                Phylogeny[] p8 = factory.create("(A,B8) (C,D8)", new NHXParser());
                                                                                                                                                                Phylogeny[] p9 = factory.create("(A,B9)\n(C,D9)", new NHXParser());
                                                                                                                                                                Phylogeny[] p10 = factory.create("(A,B10);(C,D10);", new NHXParser());
                                                                                                                                                                Phylogeny[] p11 = factory.create("(A,B11);(C,D11) (E,F11)\t(G,H11)", new NHXParser());
                                                                                                                                                                Phylogeny[] p12 = factory.create("(A,B12) (C,D12) (E,F12) (G,H12)", new NHXParser());
                                                                                                                                                                p13 = factory.create(" ; (;A; , ; B ; 1  3 ; \n)\t ( \n ; C ; ,; D;13;);;;;;;(;E;,;F;13 ;) ; ; ; ( \t\n\r\b; G ;, ;H ;1 3; )  ;  ;   ;", new NHXParser());
                                                                                                                                                                if (p13[0].toNewHampshireX().equals("(_A_,_B_13_)")) break block48;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (p13[1].toNewHampshireX().equals("(_C_,_D_13_)")) break block49;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (p13[2].toNewHampshireX().equals("(_E_,_F_13_)")) break block50;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (p13[3].toNewHampshireX().equals("(_G_,_H_13_)")) break block51;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                Phylogeny[] p14 = factory.create("(A,B14)ab", new NHXParser());
                                                                                                                                                Phylogeny[] p15 = factory.create("(A,B15)ab;", new NHXParser());
                                                                                                                                                String p16_S = "((A,B),C)";
                                                                                                                                                Phylogeny[] p16 = factory.create("((A,B),C)", new NHXParser());
                                                                                                                                                if (p16[0].toNewHampshireX().equals("((A,B),C)")) break block52;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            String p17_S = "(C,(A,B))";
                                                                                                                                            Phylogeny[] p17 = factory.create("(C,(A,B))", new NHXParser());
                                                                                                                                            if (p17[0].toNewHampshireX().equals("(C,(A,B))")) break block53;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        String p18_S = "((A,B),(C,D))";
                                                                                                                                        Phylogeny[] p18 = factory.create("((A,B),(C,D))", new NHXParser());
                                                                                                                                        if (p18[0].toNewHampshireX().equals("((A,B),(C,D))")) break block54;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    String p19_S = "(((A,B),C),D)";
                                                                                                                                    Phylogeny[] p19 = factory.create("(((A,B),C),D)", new NHXParser());
                                                                                                                                    if (p19[0].toNewHampshireX().equals("(((A,B),C),D)")) break block55;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                String p20_S = "(A,(B,(C,D)))";
                                                                                                                                Phylogeny[] p20 = factory.create("(A,(B,(C,D)))", new NHXParser());
                                                                                                                                if (p20[0].toNewHampshireX().equals("(A,(B,(C,D)))")) break block56;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            String p21_S = "(A,(B,(C,(D,E))))";
                                                                                                                            Phylogeny[] p21 = factory.create("(A,(B,(C,(D,E))))", new NHXParser());
                                                                                                                            if (p21[0].toNewHampshireX().equals("(A,(B,(C,(D,E))))")) break block57;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        String p22_S = "((((A,B),C),D),E)";
                                                                                                                        Phylogeny[] p22 = factory.create("((((A,B),C),D),E)", new NHXParser());
                                                                                                                        if (p22[0].toNewHampshireX().equals("((((A,B),C),D),E)")) break block58;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    String p23_S = "(A,(B,(C,(D,E)de)cde)bcde)abcde";
                                                                                                                    Phylogeny[] p23 = factory.create("(A,(B,(C,(D,E)de)cde)bcde)abcde", new NHXParser());
                                                                                                                    if (p23[0].toNewHampshireX().equals("(A,(B,(C,(D,E)de)cde)bcde)abcde")) break block59;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                String p24_S = "((((A,B)ab,C)abc,D)abcd,E)abcde";
                                                                                                                Phylogeny[] p24 = factory.create("((((A,B)ab,C)abc,D)abcd,E)abcde", new NHXParser());
                                                                                                                if (p24[0].toNewHampshireX().equals("((((A,B)ab,C)abc,D)abcd,E)abcde")) break block60;
                                                                                                                return false;
                                                                                                            }
                                                                                                            String p241_S1 = "(A,(B,(C,(D,E)de)cde)bcde)abcde";
                                                                                                            String p241_S2 = "((((A,B)ab,C)abc,D)abcd,E)abcde";
                                                                                                            p241 = factory.create("(A,(B,(C,(D,E)de)cde)bcde)abcde((((A,B)ab,C)abc,D)abcd,E)abcde", new NHXParser());
                                                                                                            if (p241[0].toNewHampshireX().equals("(A,(B,(C,(D,E)de)cde)bcde)abcde")) break block61;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (p241[1].toNewHampshireX().equals("((((A,B)ab,C)abc,D)abcd,E)abcde")) break block62;
                                                                                                        return false;
                                                                                                    }
                                                                                                    String p25_S = "((((((((((((((A,B)ab,C)abc,D)abcd,E)abcde,(B,(C,(D,E)de)cde)bcde)abcde,(B,((A,(B,(C,(D,E)de)cde)bcde)abcde,(D,E)de)cde)bcde)abcde,B)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde,((((A,((((((((A,B)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde,((((A,B)ab,C)abc,D)abcd,E)abcde)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde)ab,C)abc,D)abcd,E)abcde)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde";
                                                                                                    Phylogeny[] p25 = factory.create("((((((((((((((A,B)ab,C)abc,D)abcd,E)abcde,(B,(C,(D,E)de)cde)bcde)abcde,(B,((A,(B,(C,(D,E)de)cde)bcde)abcde,(D,E)de)cde)bcde)abcde,B)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde,((((A,((((((((A,B)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde,((((A,B)ab,C)abc,D)abcd,E)abcde)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde)ab,C)abc,D)abcd,E)abcde)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde", new NHXParser());
                                                                                                    if (p25[0].toNewHampshireX().equals("((((((((((((((A,B)ab,C)abc,D)abcd,E)abcde,(B,(C,(D,E)de)cde)bcde)abcde,(B,((A,(B,(C,(D,E)de)cde)bcde)abcde,(D,E)de)cde)bcde)abcde,B)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde,((((A,((((((((A,B)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde,((((A,B)ab,C)abc,D)abcd,E)abcde)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde)ab,C)abc,D)abcd,E)abcde)ab,C)abc,((((A,B)ab,C)abc,D)abcd,E)abcde)abcd,E)abcde")) break block63;
                                                                                                    return false;
                                                                                                }
                                                                                                String p26_S = "(A,B)ab";
                                                                                                Phylogeny[] p26 = factory.create("(A,B)ab", new NHXParser());
                                                                                                if (p26[0].toNewHampshireX().equals("(A,B)ab")) break block64;
                                                                                                return false;
                                                                                            }
                                                                                            String p27_S = "((((A,B)ab,C)abc,D)abcd,E)abcde";
                                                                                            Phylogeny[] p27 = factory.create(new File(String.valueOf(PATH_TO_TEST_DATA) + "phylogeny27.nhx"), new NHXParser());
                                                                                            if (p27[0].toNewHampshireX().equals("((((A,B)ab,C)abc,D)abcd,E)abcde")) break block65;
                                                                                            return false;
                                                                                        }
                                                                                        String p28_S1 = "((((A,B)ab,C)abc,D)abcd,E)abcde";
                                                                                        String p28_S2 = "(A,(B,(C,(D,E)de)cde)bcde)abcde";
                                                                                        String p28_S3 = "(A,B)ab";
                                                                                        String p28_S4 = "((((A,B),C),D),;E;)";
                                                                                        p28 = factory.create(new File(String.valueOf(PATH_TO_TEST_DATA) + "phylogeny28.nhx"), new NHXParser());
                                                                                        if (p28[0].toNewHampshireX().equals("((((A,B)ab,C)abc,D)abcd,E)abcde")) break block66;
                                                                                        return false;
                                                                                    }
                                                                                    if (p28[1].toNewHampshireX().equals("(A,(B,(C,(D,E)de)cde)bcde)abcde")) break block67;
                                                                                    return false;
                                                                                }
                                                                                if (p28[2].toNewHampshireX().equals("(A,B)ab")) break block68;
                                                                                return false;
                                                                            }
                                                                            if (p28[3].toNewHampshireX().equals("((((A,B),C),D),_E_)")) break block69;
                                                                            return false;
                                                                        }
                                                                        String p29_S = "((((A:0.01,B:0.684)ab:0.345,C:0.3451)abc:0.3451,D:1.5)abcd:0.134,E:0.32)abcde:0.1345";
                                                                        Phylogeny[] p29 = factory.create("((((A:0.01,B:0.684)ab:0.345,C:0.3451)abc:0.3451,D:1.5)abcd:0.134,E:0.32)abcde:0.1345", new NHXParser());
                                                                        if (p29[0].toNewHampshireX().equals("((((A:0.01,B:0.684)ab:0.345,C:0.3451)abc:0.3451,D:1.5)abcd:0.134,E:0.32)abcde:0.1345")) break block70;
                                                                        return false;
                                                                    }
                                                                    String p30_S = "((((A:0.01,B:0.02):0.93,C:0.04):0.05,D:1.4):0.06,E):0.72";
                                                                    Phylogeny[] p30 = factory.create("((((A:0.01,B:0.02):0.93,C:0.04):0.05,D:1.4):0.06,E):0.72", new NHXParser());
                                                                    if (p30[0].toNewHampshireX().equals("((((A:0.01,B:0.02):0.93,C:0.04):0.05,D:1.4):0.06,E):0.72")) break block71;
                                                                    return false;
                                                                }
                                                                String p32_S = " ;   ; \t\n  \t  \b   \f  \r  ;;;;;; ";
                                                                Phylogeny[] p32 = factory.create(" ;   ; \t\n  \t  \b   \f  \r  ;;;;;; ", new NHXParser());
                                                                if (p32.length == 1 && p32[0].isEmpty()) break block72;
                                                                return false;
                                                            }
                                                            String p33_S = "A";
                                                            Phylogeny[] p33 = factory.create("A", new NHXParser());
                                                            if (p33[0].toNewHampshireX().equals("A")) break block73;
                                                            return false;
                                                        }
                                                        String p34_S = "B;";
                                                        Phylogeny[] p34 = factory.create("B;", new NHXParser());
                                                        if (p34[0].toNewHampshireX().equals("B")) break block74;
                                                        return false;
                                                    }
                                                    String p35_S = "B:0.2";
                                                    Phylogeny[] p35 = factory.create("B:0.2", new NHXParser());
                                                    if (p35[0].toNewHampshireX().equals("B:0.2")) break block75;
                                                    return false;
                                                }
                                                String p36_S = "(A)";
                                                Phylogeny[] p36 = factory.create("(A)", new NHXParser());
                                                if (p36[0].toNewHampshireX().equals("(A)")) break block76;
                                                return false;
                                            }
                                            String p37_S = "((A))";
                                            Phylogeny[] p37 = factory.create("((A))", new NHXParser());
                                            if (p37[0].toNewHampshireX().equals("((A))")) break block77;
                                            return false;
                                        }
                                        String p38_S = "(((((((A:0.2):0.2):0.3):0.4):0.5):0.6):0.7):0.8";
                                        Phylogeny[] p38 = factory.create("(((((((A:0.2):0.2):0.3):0.4):0.5):0.6):0.7):0.8", new NHXParser());
                                        if (p38[0].toNewHampshireX().equals("(((((((A:0.2):0.2):0.3):0.4):0.5):0.6):0.7):0.8")) break block78;
                                        return false;
                                    }
                                    String p39_S = "(((B,((((A:0.2):0.2):0.3):0.4):0.5):0.6):0.7):0.8";
                                    Phylogeny[] p39 = factory.create("(((B,((((A:0.2):0.2):0.3):0.4):0.5):0.6):0.7):0.8", new NHXParser());
                                    if (p39[0].toNewHampshireX().equals("(((B,((((A:0.2):0.2):0.3):0.4):0.5):0.6):0.7):0.8")) break block79;
                                    return false;
                                }
                                String p40_S = "(A,B,C)";
                                Phylogeny[] p40 = factory.create("(A,B,C)", new NHXParser());
                                if (p40[0].toNewHampshireX().equals("(A,B,C)")) break block80;
                                return false;
                            }
                            String p41_S = "(A,B,C,D,E,F,G,H,I,J,K)";
                            Phylogeny[] p41 = factory.create("(A,B,C,D,E,F,G,H,I,J,K)", new NHXParser());
                            if (p41[0].toNewHampshireX().equals("(A,B,C,D,E,F,G,H,I,J,K)")) break block81;
                            return false;
                        }
                        String p42_S = "(A,B,(X,Y,Z),D,E,F,G,H,I,J,K)";
                        Phylogeny[] p42 = factory.create("(A,B,(X,Y,Z),D,E,F,G,H,I,J,K)", new NHXParser());
                        if (p42[0].toNewHampshireX().equals("(A,B,(X,Y,Z),D,E,F,G,H,I,J,K)")) break block82;
                        return false;
                    }
                    String p43_S = "(A,B,C,(AA,BB,CC,(CCC,DDD,EEE,(FFFF,GGGG)x)y,DD,EE,FF,GG,HH),D,E,(EE,FF),F,G,H,(((((5)4)3)2)1),I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,(XX,(YY)),Y,Z)";
                    Phylogeny[] p43 = factory.create("(A,B,C,(AA,BB,CC,(CCC,DDD,EEE,(FFFF,GGGG)x)y,DD,EE,FF,GG,HH),D,E,(EE,FF),F,G,H,(((((5)4)3)2)1),I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,(XX,(YY)),Y,Z)", new NHXParser());
                    if (p43[0].toNewHampshireX().equals("(A,B,C,(AA,BB,CC,(CCC,DDD,EEE,(FFFF,GGGG)x)y,DD,EE,FF,GG,HH),D,E,(EE,FF),F,G,H,(((((5)4)3)2)1),I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,(XX,(YY)),Y,Z)")) break block83;
                    return false;
                }
                String p44_S = "(((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)))";
                Phylogeny[] p44 = factory.create("(((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)))", new NHXParser());
                if (p44[0].toNewHampshireX().equals("(((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)))")) break block84;
                return false;
            }
            String p45_S = "((((((((((A))))))))),(((((((((B))))))))),(((((((((C))))))))))";
            Phylogeny[] p45 = factory.create("((((((((((A))))))))),(((((((((B))))))))),(((((((((C))))))))))", new NHXParser());
            if (p45[0].toNewHampshireX().equals("((((((((((A))))))))),(((((((((B))))))))),(((((((((C))))))))))")) break block85;
            return false;
        }
        String p46_S = "";
        Phylogeny[] p46 = factory.create("", new NHXParser());
        return p46.length == 1 && p46[0].isEmpty();
    }

    private static boolean testNHXconversion() {
        PhylogenyNode n6;
        block11: {
            PhylogenyNode n5;
            block10: {
                PhylogenyNode n4;
                block9: {
                    PhylogenyNode n3;
                    block8: {
                        PhylogenyNode n2;
                        block7: {
                            try {
                                PhylogenyNode n1 = new PhylogenyNode();
                                n2 = new PhylogenyNode("");
                                n3 = new PhylogenyNode("n3");
                                n4 = new PhylogenyNode("n4:0.01");
                                n5 = new PhylogenyNode("n5:0.1[&&NHX:S=Ecoli:E=1.1.1.1:D=Y:Co=Y:B=56:T=1:W=2:C=10.20.30:XN=S=tag1=value1=unit1]");
                                n6 = new PhylogenyNode("n6:0.000001[&&NHX:S=Ecoli:E=1.1.1.1:D=N:Co=N:B=100:T=1:W=2:C=0.0.0:XN=B=bool_tag=T]");
                                if (n1.toNewHampshireX().equals("")) break block7;
                                return false;
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.out);
                                return false;
                            }
                        }
                        if (n2.toNewHampshireX().equals("")) break block8;
                        return false;
                    }
                    if (n3.toNewHampshireX().equals("n3")) break block9;
                    return false;
                }
                if (n4.toNewHampshireX().equals("n4:0.01")) break block10;
                return false;
            }
            if (n5.toNewHampshireX().equals("n5:0.1[&&NHX:T=1:S=Ecoli:D=Y:XN=S=tag1=value1=unit1:B=56.0:W=2.0:C=10.20.30]")) break block11;
            return false;
        }
        return n6.toNewHampshireX().equals("n6:1.0E-6[&&NHX:T=1:S=Ecoli:D=N:XN=B=bool_tag=T:B=100.0:W=2.0:C=0.0.0]");
    }

    private static boolean testNHXNodeParsing() {
        PhylogenyNode n18;
        block185: {
            block184: {
                block183: {
                    PhylogenyNode n17;
                    block182: {
                        block181: {
                            PhylogenyNode n16;
                            block180: {
                                block179: {
                                    block178: {
                                        PhylogenyNode n15;
                                        block177: {
                                            block176: {
                                                block175: {
                                                    PhylogenyNode n14;
                                                    block174: {
                                                        block173: {
                                                            PhylogenyNode n13;
                                                            block172: {
                                                                block171: {
                                                                    block170: {
                                                                        block169: {
                                                                            PhylogenyNode n00;
                                                                            block168: {
                                                                                block167: {
                                                                                    block166: {
                                                                                        block165: {
                                                                                            block164: {
                                                                                                block163: {
                                                                                                    block162: {
                                                                                                        block161: {
                                                                                                            PhylogenyNode n2;
                                                                                                            block160: {
                                                                                                                block159: {
                                                                                                                    block158: {
                                                                                                                        PhylogenyNode n1;
                                                                                                                        block157: {
                                                                                                                            block156: {
                                                                                                                                block155: {
                                                                                                                                    Property tvu3;
                                                                                                                                    block154: {
                                                                                                                                        block153: {
                                                                                                                                            block152: {
                                                                                                                                                block151: {
                                                                                                                                                    Property tvu1;
                                                                                                                                                    block150: {
                                                                                                                                                        block149: {
                                                                                                                                                            block148: {
                                                                                                                                                                PhylogenyNode n5;
                                                                                                                                                                block147: {
                                                                                                                                                                    PhylogenyNode n12;
                                                                                                                                                                    block146: {
                                                                                                                                                                        block145: {
                                                                                                                                                                            block144: {
                                                                                                                                                                                PhylogenyNode n11;
                                                                                                                                                                                block143: {
                                                                                                                                                                                    block142: {
                                                                                                                                                                                        block141: {
                                                                                                                                                                                            PhylogenyNode e;
                                                                                                                                                                                            block140: {
                                                                                                                                                                                                block139: {
                                                                                                                                                                                                    PhylogenyNode d;
                                                                                                                                                                                                    block138: {
                                                                                                                                                                                                        block137: {
                                                                                                                                                                                                            PhylogenyNode c;
                                                                                                                                                                                                            block136: {
                                                                                                                                                                                                                block135: {
                                                                                                                                                                                                                    PhylogenyNode b;
                                                                                                                                                                                                                    block134: {
                                                                                                                                                                                                                        block133: {
                                                                                                                                                                                                                            PhylogenyNode a;
                                                                                                                                                                                                                            block132: {
                                                                                                                                                                                                                                block131: {
                                                                                                                                                                                                                                    PhylogenyNode n23;
                                                                                                                                                                                                                                    block130: {
                                                                                                                                                                                                                                        block129: {
                                                                                                                                                                                                                                            PhylogenyNode n22;
                                                                                                                                                                                                                                            block128: {
                                                                                                                                                                                                                                                block127: {
                                                                                                                                                                                                                                                    PhylogenyNode n21x;
                                                                                                                                                                                                                                                    block126: {
                                                                                                                                                                                                                                                        block125: {
                                                                                                                                                                                                                                                            PhylogenyNode n21;
                                                                                                                                                                                                                                                            block124: {
                                                                                                                                                                                                                                                                block123: {
                                                                                                                                                                                                                                                                    PhylogenyNode n20xxxx;
                                                                                                                                                                                                                                                                    block122: {
                                                                                                                                                                                                                                                                        block121: {
                                                                                                                                                                                                                                                                            PhylogenyNode n20xxx;
                                                                                                                                                                                                                                                                            block120: {
                                                                                                                                                                                                                                                                                block119: {
                                                                                                                                                                                                                                                                                    PhylogenyNode n20xx;
                                                                                                                                                                                                                                                                                    block118: {
                                                                                                                                                                                                                                                                                        block117: {
                                                                                                                                                                                                                                                                                            PhylogenyNode n20x;
                                                                                                                                                                                                                                                                                            block116: {
                                                                                                                                                                                                                                                                                                block115: {
                                                                                                                                                                                                                                                                                                    PhylogenyNode n20;
                                                                                                                                                                                                                                                                                                    block114: {
                                                                                                                                                                                                                                                                                                        block113: {
                                                                                                                                                                                                                                                                                                            block112: {
                                                                                                                                                                                                                                                                                                                PhylogenyNode n9;
                                                                                                                                                                                                                                                                                                                block111: {
                                                                                                                                                                                                                                                                                                                    block110: {
                                                                                                                                                                                                                                                                                                                        PhylogenyNode n8;
                                                                                                                                                                                                                                                                                                                        block109: {
                                                                                                                                                                                                                                                                                                                            block108: {
                                                                                                                                                                                                                                                                                                                                block107: {
                                                                                                                                                                                                                                                                                                                                    block106: {
                                                                                                                                                                                                                                                                                                                                        block105: {
                                                                                                                                                                                                                                                                                                                                            block104: {
                                                                                                                                                                                                                                                                                                                                                block103: {
                                                                                                                                                                                                                                                                                                                                                    block102: {
                                                                                                                                                                                                                                                                                                                                                        block101: {
                                                                                                                                                                                                                                                                                                                                                            block100: {
                                                                                                                                                                                                                                                                                                                                                                PhylogenyNode n4;
                                                                                                                                                                                                                                                                                                                                                                block99: {
                                                                                                                                                                                                                                                                                                                                                                    block98: {
                                                                                                                                                                                                                                                                                                                                                                        PhylogenyNode n3;
                                                                                                                                                                                                                                                                                                                                                                        block97: {
                                                                                                                                                                                                                                                                                                                                                                            block96: {
                                                                                                                                                                                                                                                                                                                                                                                block95: {
                                                                                                                                                                                                                                                                                                                                                                                    block94: {
                                                                                                                                                                                                                                                                                                                                                                                        try {
                                                                                                                                                                                                                                                                                                                                                                                            n1 = new PhylogenyNode();
                                                                                                                                                                                                                                                                                                                                                                                            n2 = new PhylogenyNode("");
                                                                                                                                                                                                                                                                                                                                                                                            n3 = new PhylogenyNode("n3");
                                                                                                                                                                                                                                                                                                                                                                                            n4 = new PhylogenyNode("n4:0.01");
                                                                                                                                                                                                                                                                                                                                                                                            n5 = new PhylogenyNode("n5:0.1[&&NHX:S=Ecoli:E=1.1.1.1:D=Y:B=56:T=1:On=22:SOn=33:SNn=44:W=2:C=10.20.30:XN=S=tag1=value1=unit1:XN=S=tag3=value3=unit3]");
                                                                                                                                                                                                                                                                                                                                                                                            if (n3.getNodeName().equals("n3")) break block94;
                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        catch (Exception e2) {
                                                                                                                                                                                                                                                                                                                                                                                            e2.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    if (n3.getDistanceToParent() == -1024.0) break block95;
                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                if (!n3.isDuplication()) break block96;
                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            if (!n3.isHasAssignedEvent()) break block97;
                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        if (PhylogenyMethods.getBranchWidthValue(n3) == 1.0) break block98;
                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    if (n4.getNodeName().equals("n4")) break block99;
                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                if (n4.getDistanceToParent() == 0.01) break block100;
                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (n5.getNodeName().equals("n5")) break block101;
                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (PhylogenyMethods.getConfidenceValue(n5) == 56.0) break block102;
                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (n5.getDistanceToParent() == 0.1) break block103;
                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (PhylogenyMethods.getSpecies(n5).equals("Ecoli")) break block104;
                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (n5.isDuplication()) break block105;
                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (n5.isHasAssignedEvent()) break block106;
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (PhylogenyMethods.getBranchWidthValue(n5) == 2.0) break block107;
                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (n5.getNodeData().getProperties().getPropertyRefs().length == 2) break block108;
                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            n8 = new PhylogenyNode("n8_ECOLI/12:0.01", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                                                                                            if (n8.getNodeName().equals("n8_ECOLI/12")) break block109;
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (PhylogenyMethods.getSpecies(n8).equals("ECOLI")) break block110;
                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    n9 = new PhylogenyNode("n9_ECOLI/12=12:0.01", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                                                                                    if (n9.getNodeName().equals("n9_ECOLI/12=12")) break block111;
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (PhylogenyMethods.getSpecies(n9).equals("ECOLI")) break block112;
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            PhylogenyNode n10 = new PhylogenyNode("n10.ECOLI", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                                                                            if (n10.getNodeName().equals("n10.ECOLI")) break block113;
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        n20 = new PhylogenyNode("n20_ECOLI/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                                                                        if (n20.getNodeName().equals("n20_ECOLI/1-2")) break block114;
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (PhylogenyMethods.getSpecies(n20).equals("ECOLI")) break block115;
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                n20x = new PhylogenyNode("n20_ECOL1/1-2", NHXParser.TAXONOMY_EXTRACTION.YES);
                                                                                                                                                                                                                                                                                                if (n20x.getNodeName().equals("n20_ECOL1/1-2")) break block116;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (PhylogenyMethods.getSpecies(n20x).equals("ECOL1")) break block117;
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        n20xx = new PhylogenyNode("n20_eCOL1/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                                                        if (n20xx.getNodeName().equals("n20_eCOL1/1-2")) break block118;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (PhylogenyMethods.getSpecies(n20xx).length() <= 0) break block119;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                n20xxx = new PhylogenyNode("n20_ecoli/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                                                if (n20xxx.getNodeName().equals("n20_ecoli/1-2")) break block120;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (PhylogenyMethods.getSpecies(n20xxx).length() <= 0) break block121;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        n20xxxx = new PhylogenyNode("n20_Ecoli/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                                        if (n20xxxx.getNodeName().equals("n20_Ecoli/1-2")) break block122;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (PhylogenyMethods.getSpecies(n20xxxx).length() <= 0) break block123;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                n21 = new PhylogenyNode("n21_PIG", NHXParser.TAXONOMY_EXTRACTION.YES);
                                                                                                                                                                                                                                                                if (n21.getNodeName().equals("n21_PIG")) break block124;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (PhylogenyMethods.getSpecies(n21).equals("PIG")) break block125;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        n21x = new PhylogenyNode("n21_PIG", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                        if (n21x.getNodeName().equals("n21_PIG")) break block126;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (PhylogenyMethods.getSpecies(n21x).length() <= 0) break block127;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                n22 = new PhylogenyNode("n22/PIG", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                                if (n22.getNodeName().equals("n22/PIG")) break block128;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (PhylogenyMethods.getSpecies(n22).length() <= 0) break block129;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        n23 = new PhylogenyNode("n23/PIG_1", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                        if (n23.getNodeName().equals("n23/PIG_1")) break block130;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (PhylogenyMethods.getSpecies(n23).length() <= 0) break block131;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                a = new PhylogenyNode("n10_ECOLI/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                                if (a.getNodeName().equals("n10_ECOLI/1-2")) break block132;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (PhylogenyMethods.getSpecies(a).equals("ECOLI")) break block133;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        b = new PhylogenyNode("n10_ECOLI1/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                        if (b.getNodeName().equals("n10_ECOLI1/1-2")) break block134;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (PhylogenyMethods.getSpecies(b).equals("ECOLI")) break block135;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                c = new PhylogenyNode("n10_RATAF12/1000-2000", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                                if (c.getNodeName().equals("n10_RATAF12/1000-2000")) break block136;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (PhylogenyMethods.getSpecies(c).equals("RATAF")) break block137;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        d = new PhylogenyNode("n10_RAT1/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                        if (d.getNodeName().equals("n10_RAT1/1-2")) break block138;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (PhylogenyMethods.getSpecies(d).equals("RAT")) break block139;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                e = new PhylogenyNode("n10_RAT1", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                                if (e.getNodeName().equals("n10_RAT1")) break block140;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (ForesterUtil.isEmpty(PhylogenyMethods.getSpecies(e))) break block141;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        n11 = new PhylogenyNode("n111111_ECOLI/jdj:0.4", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                                        if (n11.getNodeName().equals("n111111_ECOLI/jdj")) break block142;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (n11.getDistanceToParent() == 0.4) break block143;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (PhylogenyMethods.getSpecies(n11).equals("ECOLI")) break block144;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            n12 = new PhylogenyNode("n111111-ECOLI---/jdj:0.4", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                                                                                                                            if (n12.getNodeName().equals("n111111-ECOLI---/jdj")) break block145;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (n12.getDistanceToParent() == 0.4) break block146;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (PhylogenyMethods.getSpecies(n12).length() <= 0) break block147;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                tvu1 = n5.getNodeData().getProperties().getProperty("tag1");
                                                                                                                                                                tvu3 = n5.getNodeData().getProperties().getProperty("tag3");
                                                                                                                                                                if (tvu1.getRef().equals("tag1")) break block148;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (tvu1.getDataType().equals("xsd:string")) break block149;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (tvu1.getUnit().equals("unit1")) break block150;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (tvu1.getValue().equals("value1")) break block151;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (tvu3.getRef().equals("tag3")) break block152;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (tvu3.getDataType().equals("xsd:string")) break block153;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (tvu3.getUnit().equals("unit3")) break block154;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (tvu3.getValue().equals("value3")) break block155;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (n1.getNodeName().compareTo("") == 0) break block156;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (PhylogenyMethods.getConfidenceValue(n1) == -9999.0) break block157;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (n1.getDistanceToParent() == -1024.0) break block158;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (n2.getNodeName().compareTo("") == 0) break block159;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (PhylogenyMethods.getConfidenceValue(n2) == -9999.0) break block160;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (n2.getDistanceToParent() == -1024.0) break block161;
                                                                                                            return false;
                                                                                                        }
                                                                                                        n00 = new PhylogenyNode("n7:0.000001[&&NHX:GN=gene_name:AC=accession123:ID=node_identifier:S=Ecoli:D=N:Co=N:B=100:T=1:On=100:SOn=100:SNn=100:W=2:C=0.0.0:XN=U=url_tag=www.yahoo.com]");
                                                                                                        if (n00.getNodeData().getNodeIdentifier().getValue().equals("node_identifier")) break block162;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (n00.getNodeData().getSequence().getName().equals("gene_name")) break block163;
                                                                                                    return false;
                                                                                                }
                                                                                                if (n00.getNodeData().getSequence().getAccession().getValue().equals("accession123")) break block164;
                                                                                                return false;
                                                                                            }
                                                                                            if (n00.getNodeData().getProperties().getProperty("url_tag").getRef().equals("url_tag")) break block165;
                                                                                            return false;
                                                                                        }
                                                                                        if (n00.getNodeData().getProperties().getProperty("url_tag").getAppliesTo() == Property.AppliesTo.NODE) break block166;
                                                                                        return false;
                                                                                    }
                                                                                    if (n00.getNodeData().getProperties().getProperty("url_tag").getDataType().equals("xsd:anyURI")) break block167;
                                                                                    return false;
                                                                                }
                                                                                if (n00.getNodeData().getProperties().getProperty("url_tag").getValue().equals("www.yahoo.com")) break block168;
                                                                                return false;
                                                                            }
                                                                            if (n00.getNodeData().getProperties().getProperty("url_tag").getUnit().equals("")) break block169;
                                                                            return false;
                                                                        }
                                                                        PhylogenyNode nx = new PhylogenyNode("n5:0.1[&&NHX:S=Ecoli:GN=gene_1]");
                                                                        if (nx.getNodeData().getSequence().getName().equals("gene_1")) break block170;
                                                                        return false;
                                                                    }
                                                                    PhylogenyNode nx2 = new PhylogenyNode("n5:0.1[&&NHX:S=Ecoli:G=gene_2]");
                                                                    if (nx2.getNodeData().getSequence().getName().equals("gene_2")) break block171;
                                                                    return false;
                                                                }
                                                                n13 = new PhylogenyNode("blah_12345/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                                if (n13.getNodeName().equals("blah_12345/1-2")) break block172;
                                                                return false;
                                                            }
                                                            if (PhylogenyMethods.getSpecies(n13).equals("")) break block173;
                                                            return false;
                                                        }
                                                        n14 = new PhylogenyNode("blah_12X45/1-2", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                        if (n14.getNodeName().equals("blah_12X45/1-2")) break block174;
                                                        return false;
                                                    }
                                                    if (PhylogenyMethods.getSpecies(n14).equals("12X45")) break block175;
                                                    return false;
                                                }
                                                n15 = new PhylogenyNode("something_wicked[123]", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                                if (n15.getNodeName().equals("something_wicked")) break block176;
                                                return false;
                                            }
                                            if (n15.getBranchData().getNumberOfConfidences() == 1) break block177;
                                            return false;
                                        }
                                        if (Test.isEqual(n15.getBranchData().getConfidence(0).getValue(), 123.0)) break block178;
                                        return false;
                                    }
                                    n16 = new PhylogenyNode("something_wicked2[9]", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                                    if (n16.getNodeName().equals("something_wicked2")) break block179;
                                    return false;
                                }
                                if (n16.getBranchData().getNumberOfConfidences() == 1) break block180;
                                return false;
                            }
                            if (Test.isEqual(n16.getBranchData().getConfidence(0).getValue(), 9.0)) break block181;
                            return false;
                        }
                        n17 = new PhylogenyNode("something_wicked3[a]", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                        if (n17.getNodeName().equals("something_wicked3")) break block182;
                        return false;
                    }
                    if (n17.getBranchData().getNumberOfConfidences() == 0) break block183;
                    return false;
                }
                n18 = new PhylogenyNode(":0.5[91]", NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY);
                if (Test.isEqual(n18.getDistanceToParent(), 0.5)) break block184;
                return false;
            }
            if (n18.getBranchData().getNumberOfConfidences() == 1) break block185;
            return false;
        }
        return Test.isEqual(n18.getBranchData().getConfidence(0).getValue(), 91.0);
    }

    private static boolean testNHXParsing() {
        PhylogenyFactory factory;
        block21: {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                try {
                                                    factory = ParserBasedPhylogenyFactory.getInstance();
                                                    Phylogeny p1 = factory.create("(A     [&&NHX:S=a_species],B1[&&NHX:S=b_species])", new NHXParser())[0];
                                                    if (p1.toNewHampshireX().equals("(A[&&NHX:S=a_species],B1[&&NHX:S=b_species])")) break block12;
                                                    return false;
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace(System.out);
                                                    return false;
                                                }
                                            }
                                            String p2_S = "(((((((A:0.2[&&NHX:S=qwerty]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=asdf]):0.4[&&NHX:S=zxc]):0.5[&&NHX:S=a]):0.6[&&NHX:S=asd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq]";
                                            Phylogeny[] p2 = factory.create("(((((((A:0.2[&&NHX:S=qwerty]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=asdf]):0.4[&&NHX:S=zxc]):0.5[&&NHX:S=a]):0.6[&&NHX:S=asd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq]", new NHXParser());
                                            if (p2[0].toNewHampshireX().equals("(((((((A:0.2[&&NHX:S=qwerty]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=asdf]):0.4[&&NHX:S=zxc]):0.5[&&NHX:S=a]):0.6[&&NHX:S=asd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq]")) break block13;
                                            return false;
                                        }
                                        String p2b_S = "(((((((A:0.2[&NHX:S=qwerty]):0.2[&:S=uiop]):0.3[&NHX:S=asdf]):0.4[S=zxc]):0.5[]):0.6[&&NH:S=asd]):0.7[&&HX:S=za]):0.8[&&:S=zaq]";
                                        Phylogeny[] p2b = factory.create("(((((((A:0.2[&NHX:S=qwerty]):0.2[&:S=uiop]):0.3[&NHX:S=asdf]):0.4[S=zxc]):0.5[]):0.6[&&NH:S=asd]):0.7[&&HX:S=za]):0.8[&&:S=zaq]", new NHXParser());
                                        if (p2b[0].toNewHampshireX().equals("(((((((A:0.2):0.2):0.3):0.4):0.5):0.6):0.7):0.8")) break block14;
                                        return false;
                                    }
                                    Phylogeny[] p3 = factory.create("[  comment&&NHX,())))](((((((A:0.2[&&NHX:S=qwerty]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=asdf]):0.4[&&NHX:S=zxc]):0.5[&&NHX:S=a]):0.6[&&NHX:S=asd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq]", new NHXParser());
                                    if (p3[0].toNewHampshireX().equals("(((((((A:0.2[&&NHX:S=qwerty]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=asdf]):0.4[&&NHX:S=zxc]):0.5[&&NHX:S=a]):0.6[&&NHX:S=asd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq]")) break block15;
                                    return false;
                                }
                                Phylogeny[] p4 = factory.create("(((((((A:0.2[&&NHX:S=qwerty]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=asdf]):0.4[&&NHX:S=zxc]):0.5[&&NHX:S=a]):0.6[&&NHX:S=asd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq][comment(]", new NHXParser());
                                if (p4[0].toNewHampshireX().equals("(((((((A:0.2[&&NHX:S=qwerty]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=asdf]):0.4[&&NHX:S=zxc]):0.5[&&NHX:S=a]):0.6[&&NHX:S=asd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq]")) break block16;
                                return false;
                            }
                            Phylogeny[] p5 = factory.create("[]  (  [][ ][   ]  ([((( &&NHXcomment only![[[[[[]([]((((A:0.2[&&NHX:S=q[comment )))]werty][,,,,))]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=a[comment,,))]sdf])[comment(((]:0.4[&&NHX:S=zxc][comment(((][comment(((]):0.5[&&NHX:S=a]):0.6[&&NHX:S=a[comment(((]sd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq][comment(((]", new NHXParser());
                            if (p5[0].toNewHampshireX().equals("(((((((A:0.2[&&NHX:S=qwerty]):0.2[&&NHX:S=uiop]):0.3[&&NHX:S=asdf]):0.4[&&NHX:S=zxc]):0.5[&&NHX:S=a]):0.6[&&NHX:S=asd]):0.7[&&NHX:S=za]):0.8[&&NHX:S=zaq]")) break block17;
                            return false;
                        }
                        String p6_S_C = "(A[][][][1][22][333][4444][55555][666666][&&NHX:S=Aspecies],B[))],C,(AA,BB,CC,(CCC,DDD,EEE,[comment](FFFF,GGGG)x)y,D[comment]D,EE,FF,GG,HH),D,E,(EE,FF),F,G,H,(((((5)4)3)2)1),I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,(XX,(YY)),Y,Z)";
                        String p6_S_WO_C = "(A[&&NHX:S=Aspecies],B,C,(AA,BB,CC,(CCC,DDD,EEE,(FFFF,GGGG)x)y,DD,EE,FF,GG,HH),D,E,(EE,FF),F,G,H,(((((5)4)3)2)1),I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,(XX,(YY)),Y,Z)";
                        Phylogeny[] p6 = factory.create("(A[][][][1][22][333][4444][55555][666666][&&NHX:S=Aspecies],B[))],C,(AA,BB,CC,(CCC,DDD,EEE,[comment](FFFF,GGGG)x)y,D[comment]D,EE,FF,GG,HH),D,E,(EE,FF),F,G,H,(((((5)4)3)2)1),I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,(XX,(YY)),Y,Z)", new NHXParser());
                        if (p6[0].toNewHampshireX().equals("(A[&&NHX:S=Aspecies],B,C,(AA,BB,CC,(CCC,DDD,EEE,(FFFF,GGGG)x)y,DD,EE,FF,GG,HH),D,E,(EE,FF),F,G,H,(((((5)4)3)2)1),I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,(XX,(YY)),Y,Z)")) break block18;
                        return false;
                    }
                    String p7_S_C = "(((A [&&NHX:S=species_a], B [&&NHX:S=Vstorri] , C   , D),(A,B,C,D[comment])[],[c][]([xxx]A[comment],[comment]B[comment][comment],[comment][comment]C[comment][comment],[comment][comment]D[comment][comment])[comment][comment],[comment]   [comment](A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C[comment][comment][comment][comment][comment]    [comment],D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),[comment][comment]((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)))";
                    String p7_S_WO_C = "(((A[&&NHX:S=species_a],B[&&NHX:S=Vstorri],C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)))";
                    Phylogeny[] p7 = factory.create("(((A [&&NHX:S=species_a], B [&&NHX:S=Vstorri] , C   , D),(A,B,C,D[comment])[],[c][]([xxx]A[comment],[comment]B[comment][comment],[comment][comment]C[comment][comment],[comment][comment]D[comment][comment])[comment][comment],[comment]   [comment](A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C[comment][comment][comment][comment][comment]    [comment],D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),[comment][comment]((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)))", new NHXParser());
                    if (p7[0].toNewHampshireX().equals("(((A[&&NHX:S=species_a],B[&&NHX:S=Vstorri],C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)),((A,B,C,D),(A,B,C,D),(A,B,C,D),(A,B,C,D)))")) break block19;
                    return false;
                }
                String p8_S_C = "[cmt](((([]([))))))](((((A[&&NHX:S= [a comment] a])))))))[too many comments!:)])),(((((((((B[&&NHX[ a comment in a bad place]:S   =b])))))[] []   )))),(((((((((C[&&NHX:S=c])   ))[,,, ])))))))";
                String p8_S_WO_C = "((((((((((A[&&NHX:S=a]))))))))),(((((((((B[&&NHX:S=b]))))))))),(((((((((C[&&NHX:S=c]))))))))))";
                Phylogeny[] p8 = factory.create("[cmt](((([]([))))))](((((A[&&NHX:S= [a comment] a])))))))[too many comments!:)])),(((((((((B[&&NHX[ a comment in a bad place]:S   =b])))))[] []   )))),(((((((((C[&&NHX:S=c])   ))[,,, ])))))))", new NHXParser());
                if (p8[0].toNewHampshireX().equals("((((((((((A[&&NHX:S=a]))))))))),(((((((((B[&&NHX:S=b]))))))))),(((((((((C[&&NHX:S=c]))))))))))")) break block20;
                return false;
            }
            Phylogeny p9 = factory.create("((A:0.2,B:0.3):0.5[91],C:0.1)root:0.1[100]", new NHXParser())[0];
            if (p9.toNewHampshireX().equals("((A:0.2,B:0.3):0.5[&&NHX:B=91.0],C:0.1)root:0.1[&&NHX:B=100.0]")) break block21;
            return false;
        }
        Phylogeny p10 = factory.create(" [79]   ( (A [co mment] :0 .2[comment],B:0.3[com])[com ment]: 0. 5 \t[ 9 1 ][ comment],C: 0.1)[comment]root:0.1[100] [comment]", new NHXParser())[0];
        return p10.toNewHampshireX().equals("((A:0.2,B:0.3):0.5[&&NHX:B=91.0],C:0.1)root:0.1[&&NHX:B=100.0]");
    }

    private static boolean testNHXParsingQuotes() {
        Phylogeny phy;
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        Phylogeny[] phylogenies_0;
                                        block11: {
                                            try {
                                                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                                                NHXParser p = new NHXParser();
                                                p.setIgnoreQuotes(false);
                                                phylogenies_0 = factory.create(new File(String.valueOf(PATH_TO_TEST_DATA) + "quotes.nhx"), p);
                                                if (phylogenies_0.length == 5) break block11;
                                                return false;
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace(System.out);
                                                return false;
                                            }
                                        }
                                        phy = phylogenies_0[4];
                                        if (phy.getNumberOfExternalNodes() == 7) break block12;
                                        return false;
                                    }
                                    if (phy.getNodes("a name in double quotes from tree ((a,b),c)").size() == 1) break block13;
                                    return false;
                                }
                                if (phy.getNodes("charles darwin 'origin of species'").size() == 1) break block14;
                                return false;
                            }
                            if (phy.getNodes("charles darwin 'origin of species'").get(0).getNodeData().getTaxonomy().getScientificName().equals("hsapiens")) break block15;
                            return false;
                        }
                        if (phy.getNodes("shouldbetogether single quotes").size() == 1) break block16;
                        return false;
                    }
                    if (phy.getNodes("'single quotes' inside double quotes").size() == 1) break block17;
                    return false;
                }
                if (phy.getNodes("double quotes inside single quotes").size() == 1) break block18;
                return false;
            }
            if (phy.getNodes("noquotes").size() == 1) break block19;
            return false;
        }
        return phy.getNodes("A   (  B    C '").size() == 1;
    }

    private static boolean testPhylogenyBranch() {
        PhylogenyBranch a1_b1_;
        PhylogenyBranch b1_a1;
        block15: {
            PhylogenyBranch b1_a1_;
            block14: {
                PhylogenyBranch a1_b1;
                PhylogenyNode b1;
                PhylogenyNode a1;
                block13: {
                    block12: {
                        block11: {
                            PhylogenyBranch b1a1;
                            PhylogenyBranch a1b1;
                            block10: {
                                block9: {
                                    try {
                                        a1 = new PhylogenyNode("a");
                                        b1 = new PhylogenyNode("b");
                                        a1b1 = new PhylogenyBranch(a1, b1);
                                        b1a1 = new PhylogenyBranch(b1, a1);
                                        if (a1b1.equals(a1b1)) break block9;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace(System.out);
                                        return false;
                                    }
                                }
                                if (a1b1.equals(b1a1)) break block10;
                                return false;
                            }
                            if (b1a1.equals(a1b1)) break block11;
                            return false;
                        }
                        a1_b1 = new PhylogenyBranch(a1, b1, true);
                        b1_a1 = new PhylogenyBranch(b1, a1, true);
                        a1_b1_ = new PhylogenyBranch(a1, b1, false);
                        if (!a1_b1.equals(b1_a1)) break block12;
                        return false;
                    }
                    if (!a1_b1.equals(a1_b1_)) break block13;
                    return false;
                }
                b1_a1_ = new PhylogenyBranch(b1, a1, false);
                if (a1_b1.equals(b1_a1_)) break block14;
                return false;
            }
            if (!a1_b1_.equals(b1_a1_)) break block15;
            return false;
        }
        return a1_b1_.equals(b1_a1);
    }

    private static boolean testPostOrderIterator() {
        PhylogenyNodeIterator it;
        block33: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block22: {
                                                        block21: {
                                                            block20: {
                                                                block19: {
                                                                    try {
                                                                        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                                                                        Phylogeny t0 = factory.create("((A,B)ab,(C,D)cd)r", new NHXParser())[0];
                                                                        PhylogenyNodeIterator it0 = t0.iteratorPostorder();
                                                                        while (it0.hasNext()) {
                                                                            it0.next();
                                                                        }
                                                                        it0.reset();
                                                                        while (it0.hasNext()) {
                                                                            it0.next();
                                                                        }
                                                                        Phylogeny t1 = factory.create("(((A,B)ab,(C,D)cd)abcd,((E,F)ef,(G,H)gh)efgh)r", new NHXParser())[0];
                                                                        it = t1.iteratorPostorder();
                                                                        if (it.next().getNodeName().equals("A")) break block19;
                                                                        return false;
                                                                    }
                                                                    catch (Exception e) {
                                                                        e.printStackTrace(System.out);
                                                                        return false;
                                                                    }
                                                                }
                                                                if (it.next().getNodeName().equals("B")) break block20;
                                                                return false;
                                                            }
                                                            if (it.next().getNodeName().equals("ab")) break block21;
                                                            return false;
                                                        }
                                                        if (it.next().getNodeName().equals("C")) break block22;
                                                        return false;
                                                    }
                                                    if (it.next().getNodeName().equals("D")) break block23;
                                                    return false;
                                                }
                                                if (it.next().getNodeName().equals("cd")) break block24;
                                                return false;
                                            }
                                            if (it.next().getNodeName().equals("abcd")) break block25;
                                            return false;
                                        }
                                        if (it.next().getNodeName().equals("E")) break block26;
                                        return false;
                                    }
                                    if (it.next().getNodeName().equals("F")) break block27;
                                    return false;
                                }
                                if (it.next().getNodeName().equals("ef")) break block28;
                                return false;
                            }
                            if (it.next().getNodeName().equals("G")) break block29;
                            return false;
                        }
                        if (it.next().getNodeName().equals("H")) break block30;
                        return false;
                    }
                    if (it.next().getNodeName().equals("gh")) break block31;
                    return false;
                }
                if (it.next().getNodeName().equals("efgh")) break block32;
                return false;
            }
            if (it.next().getNodeName().equals("r")) break block33;
            return false;
        }
        return !it.hasNext();
    }

    private static boolean testPreOrderIterator() {
        PhylogenyNodeIterator it;
        block49: {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            block40: {
                                                block39: {
                                                    block38: {
                                                        block37: {
                                                            block36: {
                                                                block35: {
                                                                    PhylogenyFactory factory;
                                                                    block34: {
                                                                        block33: {
                                                                            block32: {
                                                                                block31: {
                                                                                    block30: {
                                                                                        block29: {
                                                                                            block28: {
                                                                                                block27: {
                                                                                                    try {
                                                                                                        factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                        Phylogeny t0 = factory.create("((A,B)ab,(C,D)cd)r", new NHXParser())[0];
                                                                                                        PhylogenyNodeIterator it0 = t0.iteratorPreorder();
                                                                                                        while (it0.hasNext()) {
                                                                                                            it0.next();
                                                                                                        }
                                                                                                        it0.reset();
                                                                                                        while (it0.hasNext()) {
                                                                                                            it0.next();
                                                                                                        }
                                                                                                        it = t0.iteratorPreorder();
                                                                                                        if (it.next().getNodeName().equals("r")) break block27;
                                                                                                        return false;
                                                                                                    }
                                                                                                    catch (Exception e) {
                                                                                                        e.printStackTrace(System.out);
                                                                                                        return false;
                                                                                                    }
                                                                                                }
                                                                                                if (it.next().getNodeName().equals("ab")) break block28;
                                                                                                return false;
                                                                                            }
                                                                                            if (it.next().getNodeName().equals("A")) break block29;
                                                                                            return false;
                                                                                        }
                                                                                        if (it.next().getNodeName().equals("B")) break block30;
                                                                                        return false;
                                                                                    }
                                                                                    if (it.next().getNodeName().equals("cd")) break block31;
                                                                                    return false;
                                                                                }
                                                                                if (it.next().getNodeName().equals("C")) break block32;
                                                                                return false;
                                                                            }
                                                                            if (it.next().getNodeName().equals("D")) break block33;
                                                                            return false;
                                                                        }
                                                                        if (!it.hasNext()) break block34;
                                                                        return false;
                                                                    }
                                                                    Phylogeny t1 = factory.create("(((A,B)ab,(C,D)cd)abcd,((E,F)ef,(G,H)gh)efgh)r", new NHXParser())[0];
                                                                    it = t1.iteratorPreorder();
                                                                    if (it.next().getNodeName().equals("r")) break block35;
                                                                    return false;
                                                                }
                                                                if (it.next().getNodeName().equals("abcd")) break block36;
                                                                return false;
                                                            }
                                                            if (it.next().getNodeName().equals("ab")) break block37;
                                                            return false;
                                                        }
                                                        if (it.next().getNodeName().equals("A")) break block38;
                                                        return false;
                                                    }
                                                    if (it.next().getNodeName().equals("B")) break block39;
                                                    return false;
                                                }
                                                if (it.next().getNodeName().equals("cd")) break block40;
                                                return false;
                                            }
                                            if (it.next().getNodeName().equals("C")) break block41;
                                            return false;
                                        }
                                        if (it.next().getNodeName().equals("D")) break block42;
                                        return false;
                                    }
                                    if (it.next().getNodeName().equals("efgh")) break block43;
                                    return false;
                                }
                                if (it.next().getNodeName().equals("ef")) break block44;
                                return false;
                            }
                            if (it.next().getNodeName().equals("E")) break block45;
                            return false;
                        }
                        if (it.next().getNodeName().equals("F")) break block46;
                        return false;
                    }
                    if (it.next().getNodeName().equals("gh")) break block47;
                    return false;
                }
                if (it.next().getNodeName().equals("G")) break block48;
                return false;
            }
            if (it.next().getNodeName().equals("H")) break block49;
            return false;
        }
        return !it.hasNext();
    }

    private static boolean testReIdMethods() {
        Phylogeny p;
        block31: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                block17: {
                                                                    try {
                                                                        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                                                                        p = factory.create("((1,2)A,(((X,Y,Z)a,b)3)B,(4,5,6)C)r", new NHXParser())[0];
                                                                        int last = p.levelOrderReID(120);
                                                                        if (last == 124) break block17;
                                                                        return false;
                                                                    }
                                                                    catch (Exception e) {
                                                                        e.printStackTrace(System.out);
                                                                        return false;
                                                                    }
                                                                }
                                                                if (p.getNode("r").getNodeId() == 120) break block18;
                                                                return false;
                                                            }
                                                            if (p.getNode("A").getNodeId() == 121) break block19;
                                                            return false;
                                                        }
                                                        if (p.getNode("B").getNodeId() == 121) break block20;
                                                        return false;
                                                    }
                                                    if (p.getNode("C").getNodeId() == 121) break block21;
                                                    return false;
                                                }
                                                if (p.getNode("1").getNodeId() == 122) break block22;
                                                return false;
                                            }
                                            if (p.getNode("2").getNodeId() == 122) break block23;
                                            return false;
                                        }
                                        if (p.getNode("3").getNodeId() == 122) break block24;
                                        return false;
                                    }
                                    if (p.getNode("4").getNodeId() == 122) break block25;
                                    return false;
                                }
                                if (p.getNode("5").getNodeId() == 122) break block26;
                                return false;
                            }
                            if (p.getNode("6").getNodeId() == 122) break block27;
                            return false;
                        }
                        if (p.getNode("a").getNodeId() == 123) break block28;
                        return false;
                    }
                    if (p.getNode("b").getNodeId() == 123) break block29;
                    return false;
                }
                if (p.getNode("X").getNodeId() == 124) break block30;
                return false;
            }
            if (p.getNode("Y").getNodeId() == 124) break block31;
            return false;
        }
        return p.getNode("Z").getNodeId() == 124;
    }

    private static boolean testRerooting() {
        Phylogeny t3;
        block59: {
            block58: {
                block57: {
                    block56: {
                        block55: {
                            block54: {
                                block53: {
                                    block52: {
                                        PhylogenyFactory factory;
                                        block51: {
                                            Phylogeny t2;
                                            block50: {
                                                block49: {
                                                    block48: {
                                                        block47: {
                                                            block46: {
                                                                block45: {
                                                                    block44: {
                                                                        block43: {
                                                                            block42: {
                                                                                block41: {
                                                                                    block40: {
                                                                                        block39: {
                                                                                            block38: {
                                                                                                block37: {
                                                                                                    Phylogeny t1;
                                                                                                    block36: {
                                                                                                        block35: {
                                                                                                            block34: {
                                                                                                                block33: {
                                                                                                                    block32: {
                                                                                                                        block31: {
                                                                                                                            try {
                                                                                                                                factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                t1 = factory.create("((A:1,B:2)AB:1[&&NHX:B=55],(C:3,D:5)CD:3[&&NHX:B=10])ABCD:0.5", new NHXParser())[0];
                                                                                                                                if (t1.isRooted()) break block31;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            catch (Exception e) {
                                                                                                                                e.printStackTrace(System.out);
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        t1.reRoot(t1.getNode("D"));
                                                                                                                        t1.reRoot(t1.getNode("CD"));
                                                                                                                        t1.reRoot(t1.getNode("A"));
                                                                                                                        t1.reRoot(t1.getNode("B"));
                                                                                                                        t1.reRoot(t1.getNode("AB"));
                                                                                                                        t1.reRoot(t1.getNode("D"));
                                                                                                                        t1.reRoot(t1.getNode("C"));
                                                                                                                        t1.reRoot(t1.getNode("CD"));
                                                                                                                        t1.reRoot(t1.getNode("A"));
                                                                                                                        t1.reRoot(t1.getNode("B"));
                                                                                                                        t1.reRoot(t1.getNode("AB"));
                                                                                                                        t1.reRoot(t1.getNode("D"));
                                                                                                                        t1.reRoot(t1.getNode("D"));
                                                                                                                        t1.reRoot(t1.getNode("C"));
                                                                                                                        t1.reRoot(t1.getNode("A"));
                                                                                                                        t1.reRoot(t1.getNode("B"));
                                                                                                                        t1.reRoot(t1.getNode("AB"));
                                                                                                                        t1.reRoot(t1.getNode("C"));
                                                                                                                        t1.reRoot(t1.getNode("D"));
                                                                                                                        t1.reRoot(t1.getNode("CD"));
                                                                                                                        t1.reRoot(t1.getNode("D"));
                                                                                                                        t1.reRoot(t1.getNode("A"));
                                                                                                                        t1.reRoot(t1.getNode("B"));
                                                                                                                        t1.reRoot(t1.getNode("AB"));
                                                                                                                        t1.reRoot(t1.getNode("C"));
                                                                                                                        t1.reRoot(t1.getNode("D"));
                                                                                                                        t1.reRoot(t1.getNode("CD"));
                                                                                                                        t1.reRoot(t1.getNode("D"));
                                                                                                                        if (Test.isEqual(t1.getNode("A").getDistanceToParent(), 1.0)) break block32;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (Test.isEqual(t1.getNode("B").getDistanceToParent(), 2.0)) break block33;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (Test.isEqual(t1.getNode("C").getDistanceToParent(), 3.0)) break block34;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (Test.isEqual(t1.getNode("D").getDistanceToParent(), 2.5)) break block35;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (Test.isEqual(t1.getNode("CD").getDistanceToParent(), 2.5)) break block36;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (Test.isEqual(t1.getNode("AB").getDistanceToParent(), 4.0)) break block37;
                                                                                                    return false;
                                                                                                }
                                                                                                t2 = factory.create("(((A:1,B:2)AB:10[&&NHX:B=55],C)ABC:3[&&NHX:B=33],D:5)ABCD:0.5", new NHXParser())[0];
                                                                                                t2.reRoot(t2.getNode("A"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("ABC"));
                                                                                                t2.reRoot(t2.getNode("A"));
                                                                                                t2.reRoot(t2.getNode("B"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("C"));
                                                                                                t2.reRoot(t2.getNode("ABC"));
                                                                                                t2.reRoot(t2.getNode("A"));
                                                                                                t2.reRoot(t2.getNode("B"));
                                                                                                t2.reRoot(t2.getNode("AB"));
                                                                                                t2.reRoot(t2.getNode("AB"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("C"));
                                                                                                t2.reRoot(t2.getNode("B"));
                                                                                                t2.reRoot(t2.getNode("AB"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("ABC"));
                                                                                                t2.reRoot(t2.getNode("A"));
                                                                                                t2.reRoot(t2.getNode("B"));
                                                                                                t2.reRoot(t2.getNode("AB"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("C"));
                                                                                                t2.reRoot(t2.getNode("ABC"));
                                                                                                t2.reRoot(t2.getNode("A"));
                                                                                                t2.reRoot(t2.getNode("B"));
                                                                                                t2.reRoot(t2.getNode("AB"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("C"));
                                                                                                t2.reRoot(t2.getNode("A"));
                                                                                                t2.reRoot(t2.getNode("B"));
                                                                                                t2.reRoot(t2.getNode("AB"));
                                                                                                t2.reRoot(t2.getNode("C"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("ABC"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("A"));
                                                                                                t2.reRoot(t2.getNode("B"));
                                                                                                t2.reRoot(t2.getNode("AB"));
                                                                                                t2.reRoot(t2.getNode("C"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                t2.reRoot(t2.getNode("ABC"));
                                                                                                t2.reRoot(t2.getNode("D"));
                                                                                                if (Test.isEqual(t2.getNode("AB").getBranchData().getConfidence(0).getValue(), 55.0)) break block38;
                                                                                                return false;
                                                                                            }
                                                                                            if (Test.isEqual(t2.getNode("ABC").getBranchData().getConfidence(0).getValue(), 33.0)) break block39;
                                                                                            return false;
                                                                                        }
                                                                                        t2.reRoot(t2.getNode("ABC"));
                                                                                        if (Test.isEqual(t2.getNode("AB").getBranchData().getConfidence(0).getValue(), 55.0)) break block40;
                                                                                        return false;
                                                                                    }
                                                                                    if (Test.isEqual(t2.getNode("ABC").getBranchData().getConfidence(0).getValue(), 33.0)) break block41;
                                                                                    return false;
                                                                                }
                                                                                t2.reRoot(t2.getNode("AB"));
                                                                                if (Test.isEqual(t2.getNode("AB").getBranchData().getConfidence(0).getValue(), 55.0)) break block42;
                                                                                return false;
                                                                            }
                                                                            if (Test.isEqual(t2.getNode("ABC").getBranchData().getConfidence(0).getValue(), 55.0)) break block43;
                                                                            return false;
                                                                        }
                                                                        if (Test.isEqual(t2.getNode("D").getBranchData().getConfidence(0).getValue(), 33.0)) break block44;
                                                                        return false;
                                                                    }
                                                                    t2.reRoot(t2.getNode("AB"));
                                                                    if (Test.isEqual(t2.getNode("AB").getBranchData().getConfidence(0).getValue(), 55.0)) break block45;
                                                                    return false;
                                                                }
                                                                if (Test.isEqual(t2.getNode("ABC").getBranchData().getConfidence(0).getValue(), 55.0)) break block46;
                                                                return false;
                                                            }
                                                            if (Test.isEqual(t2.getNode("D").getBranchData().getConfidence(0).getValue(), 33.0)) break block47;
                                                            return false;
                                                        }
                                                        t2.reRoot(t2.getNode("D"));
                                                        if (Test.isEqual(t2.getNode("AB").getBranchData().getConfidence(0).getValue(), 55.0)) break block48;
                                                        return false;
                                                    }
                                                    if (Test.isEqual(t2.getNode("ABC").getBranchData().getConfidence(0).getValue(), 33.0)) break block49;
                                                    return false;
                                                }
                                                t2.reRoot(t2.getNode("ABC"));
                                                if (Test.isEqual(t2.getNode("AB").getBranchData().getConfidence(0).getValue(), 55.0)) break block50;
                                                return false;
                                            }
                                            if (Test.isEqual(t2.getNode("ABC").getBranchData().getConfidence(0).getValue(), 33.0)) break block51;
                                            return false;
                                        }
                                        t3 = factory.create("(A[&&NHX:B=10],B[&&NHX:B=20],C[&&NHX:B=30],D[&&NHX:B=40])", new NHXParser())[0];
                                        t3.reRoot(t3.getNode("B"));
                                        if (t3.getNode("B").getBranchData().getConfidence(0).getValue() == 20.0) break block52;
                                        return false;
                                    }
                                    if (t3.getNode("A").getParent().getBranchData().getConfidence(0).getValue() == 20.0) break block53;
                                    return false;
                                }
                                if (t3.getNode("A").getParent().getNumberOfDescendants() == 3) break block54;
                                return false;
                            }
                            t3.reRoot(t3.getNode("B"));
                            if (t3.getNode("B").getBranchData().getConfidence(0).getValue() == 20.0) break block55;
                            return false;
                        }
                        if (t3.getNode("A").getParent().getBranchData().getConfidence(0).getValue() == 20.0) break block56;
                        return false;
                    }
                    if (t3.getNode("A").getParent().getNumberOfDescendants() == 3) break block57;
                    return false;
                }
                t3.reRoot(t3.getRoot());
                if (t3.getNode("B").getBranchData().getConfidence(0).getValue() == 20.0) break block58;
                return false;
            }
            if (t3.getNode("A").getParent().getBranchData().getConfidence(0).getValue() == 20.0) break block59;
            return false;
        }
        return t3.getNode("A").getParent().getNumberOfDescendants() == 3;
    }

    private static boolean testSDIse() {
        Phylogeny gene7_2;
        block107: {
            block106: {
                block105: {
                    block104: {
                        block103: {
                            block102: {
                                block101: {
                                    block100: {
                                        block99: {
                                            Phylogeny species7;
                                            block98: {
                                                Phylogeny gene7_1;
                                                block97: {
                                                    block96: {
                                                        block95: {
                                                            block94: {
                                                                block93: {
                                                                    block92: {
                                                                        block91: {
                                                                            block90: {
                                                                                block89: {
                                                                                    Phylogeny gene6;
                                                                                    block88: {
                                                                                        Phylogeny species6;
                                                                                        block87: {
                                                                                            SDIse sdi6;
                                                                                            block86: {
                                                                                                block85: {
                                                                                                    block84: {
                                                                                                        block83: {
                                                                                                            block82: {
                                                                                                                block81: {
                                                                                                                    block80: {
                                                                                                                        block79: {
                                                                                                                            block78: {
                                                                                                                                PhylogenyFactory factory;
                                                                                                                                block77: {
                                                                                                                                    Phylogeny gene5;
                                                                                                                                    block76: {
                                                                                                                                        Phylogeny species5;
                                                                                                                                        block75: {
                                                                                                                                            block74: {
                                                                                                                                                block73: {
                                                                                                                                                    block72: {
                                                                                                                                                        block71: {
                                                                                                                                                            Phylogeny gene4;
                                                                                                                                                            block70: {
                                                                                                                                                                Phylogeny species4;
                                                                                                                                                                block69: {
                                                                                                                                                                    block68: {
                                                                                                                                                                        block67: {
                                                                                                                                                                            block66: {
                                                                                                                                                                                block65: {
                                                                                                                                                                                    Phylogeny gene3;
                                                                                                                                                                                    block64: {
                                                                                                                                                                                        block63: {
                                                                                                                                                                                            block62: {
                                                                                                                                                                                                Phylogeny gene2;
                                                                                                                                                                                                block61: {
                                                                                                                                                                                                    block60: {
                                                                                                                                                                                                        block59: {
                                                                                                                                                                                                            block58: {
                                                                                                                                                                                                                block57: {
                                                                                                                                                                                                                    block56: {
                                                                                                                                                                                                                        block55: {
                                                                                                                                                                                                                            try {
                                                                                                                                                                                                                                factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                Phylogeny species1 = factory.create("[&&NHX:S=yeast]", new NHXParser())[0];
                                                                                                                                                                                                                                Phylogeny gene1 = factory.create("(A1[&&NHX:S=yeast],A2[&&NHX:S=yeast])", new NHXParser())[0];
                                                                                                                                                                                                                                gene1.setRooted(true);
                                                                                                                                                                                                                                species1.setRooted(true);
                                                                                                                                                                                                                                SDIse sdi2 = new SDIse(gene1, species1);
                                                                                                                                                                                                                                if (gene1.getRoot().isDuplication()) break block55;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        Phylogeny species2 = factory.create("(((([&&NHX:S=A],[&&NHX:S=B]),[&&NHX:S=C]),[&&NHX:S=D]),([&&NHX:S=E],[&&NHX:S=F]))", new NHXParser())[0];
                                                                                                                                                                                                                        gene2 = factory.create("(((([&&NHX:S=A],[&&NHX:S=B])ab,[&&NHX:S=C])abc,[&&NHX:S=D])abcd,([&&NHX:S=E],[&&NHX:S=F])ef)r", new NHXParser())[0];
                                                                                                                                                                                                                        species2.setRooted(true);
                                                                                                                                                                                                                        gene2.setRooted(true);
                                                                                                                                                                                                                        SDIse sdi2 = new SDIse(gene2, species2);
                                                                                                                                                                                                                        if (sdi2.getDuplicationsSum() == 0) break block56;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (gene2.getNode("ab").isSpeciation()) break block57;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (gene2.getNode("ab").isHasAssignedEvent()) break block58;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (gene2.getNode("abc").isSpeciation()) break block59;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (gene2.getNode("abc").isHasAssignedEvent()) break block60;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (gene2.getNode("r").isSpeciation()) break block61;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (gene2.getNode("r").isHasAssignedEvent()) break block62;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            Phylogeny species3 = factory.create("(((([&&NHX:S=A],[&&NHX:S=B]),[&&NHX:S=C]),[&&NHX:S=D]),([&&NHX:S=E],[&&NHX:S=F]))", new NHXParser())[0];
                                                                                                                                                                                            gene3 = factory.create("(((([&&NHX:S=A],[&&NHX:S=A])aa,[&&NHX:S=C])abc,[&&NHX:S=D])abcd,([&&NHX:S=E],[&&NHX:S=F])ef)r", new NHXParser())[0];
                                                                                                                                                                                            species3.setRooted(true);
                                                                                                                                                                                            gene3.setRooted(true);
                                                                                                                                                                                            SDIse sdi3 = new SDIse(gene3, species3);
                                                                                                                                                                                            if (sdi3.getDuplicationsSum() == 1) break block63;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (gene3.getNode("aa").isDuplication()) break block64;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (gene3.getNode("aa").isHasAssignedEvent()) break block65;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                species4 = factory.create("(((([&&NHX:S=A],[&&NHX:S=B]),[&&NHX:S=C]),[&&NHX:S=D]),([&&NHX:S=E],[&&NHX:S=F]))", new NHXParser())[0];
                                                                                                                                                                                gene4 = factory.create("(((([&&NHX:S=A],[&&NHX:S=C])ac,[&&NHX:S=B])abc,[&&NHX:S=D])abcd,([&&NHX:S=E],[&&NHX:S=F])ef)r", new NHXParser())[0];
                                                                                                                                                                                species4.setRooted(true);
                                                                                                                                                                                gene4.setRooted(true);
                                                                                                                                                                                SDIse sdi4 = new SDIse(gene4, species4);
                                                                                                                                                                                if (sdi4.getDuplicationsSum() == 1) break block66;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (gene4.getNode("ac").isSpeciation()) break block67;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (gene4.getNode("abc").isDuplication()) break block68;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (!gene4.getNode("abcd").isDuplication()) break block69;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (species4.getNumberOfExternalNodes() == 6) break block70;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (gene4.getNumberOfExternalNodes() == 6) break block71;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        species5 = factory.create("(((([&&NHX:S=A],[&&NHX:S=B]),[&&NHX:S=C]),[&&NHX:S=D]),([&&NHX:S=E],[&&NHX:S=F]))", new NHXParser())[0];
                                                                                                                                                        gene5 = factory.create("(((([&&NHX:S=A],[&&NHX:S=D])ad,[&&NHX:S=C])adc,[&&NHX:S=B])abcd,([&&NHX:S=E],[&&NHX:S=F])ef)r", new NHXParser())[0];
                                                                                                                                                        species5.setRooted(true);
                                                                                                                                                        gene5.setRooted(true);
                                                                                                                                                        SDIse sdi5 = new SDIse(gene5, species5);
                                                                                                                                                        if (sdi5.getDuplicationsSum() == 2) break block72;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (gene5.getNode("ad").isSpeciation()) break block73;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (gene5.getNode("adc").isDuplication()) break block74;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (gene5.getNode("abcd").isDuplication()) break block75;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (species5.getNumberOfExternalNodes() == 6) break block76;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (gene5.getNumberOfExternalNodes() == 6) break block77;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                species6 = factory.create("(((1:[&&NHX:S=1],5:[&&NHX:S=5])1-5,((4:[&&NHX:S=4],6:[&&NHX:S=6])4-6,2:[&&NHX:S=2])4-6-2)1-5-4-6-2,((9:[&&NHX:S=9],3:[&&NHX:S=3])9-3,(8:[&&NHX:S=8],7:[&&NHX:S=7])8-7)9-3-8-7)", new NHXParser())[0];
                                                                                                                                gene6 = factory.create("(((1:0.1[&&NHX:S=1],2:0.1[&&NHX:S=2])1-2:0.1,3:0.1[&&NHX:S=3])1-2-3:0.1,((4:0.1[&&NHX:S=4],(5:0.1[&&NHX:S=5],6:0.1[&&NHX:S=6])5-6:0.1)4-5-6:0.1,(7:0.1[&&NHX:S=7],(8:0.1[&&NHX:S=8],9:0.1[&&NHX:S=9])8-9:0.1)7-8-9:0.1)4-5-6-7-8-9:0.1)r;", new NHXParser())[0];
                                                                                                                                species6.setRooted(true);
                                                                                                                                gene6.setRooted(true);
                                                                                                                                sdi6 = new SDIse(gene6, species6);
                                                                                                                                if (sdi6.getDuplicationsSum() == 3) break block78;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (gene6.getNode("r").isDuplication()) break block79;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (gene6.getNode("4-5-6").isDuplication()) break block80;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (gene6.getNode("7-8-9").isDuplication()) break block81;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (gene6.getNode("1-2").isSpeciation()) break block82;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (gene6.getNode("1-2-3").isSpeciation()) break block83;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (gene6.getNode("5-6").isSpeciation()) break block84;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (gene6.getNode("8-9").isSpeciation()) break block85;
                                                                                                    return false;
                                                                                                }
                                                                                                if (gene6.getNode("4-5-6-7-8-9").isSpeciation()) break block86;
                                                                                                return false;
                                                                                            }
                                                                                            sdi6.computeMappingCostL();
                                                                                            if (sdi6.computeMappingCostL() == 17) break block87;
                                                                                            return false;
                                                                                        }
                                                                                        if (species6.getNumberOfExternalNodes() == 9) break block88;
                                                                                        return false;
                                                                                    }
                                                                                    if (gene6.getNumberOfExternalNodes() == 9) break block89;
                                                                                    return false;
                                                                                }
                                                                                species7 = Test.createPhylogeny("(((((((([&&NHX:S=a1],[&&NHX:S=a2]),([&&NHX:S=b1],[&&NHX:S=b2])),[&&NHX:S=x]),(([&&NHX:S=m1],[&&NHX:S=m2]),([&&NHX:S=n1],[&&NHX:S=n2]))),(([&&NHX:S=i1],[&&NHX:S=i2]),([&&NHX:S=j1],[&&NHX:S=j2]))),(([&&NHX:S=e1],[&&NHX:S=e2]),([&&NHX:S=f1],[&&NHX:S=f2]))),[&&NHX:S=y]),[&&NHX:S=z])");
                                                                                species7.setRooted(true);
                                                                                gene7_1 = Test.createPhylogeny("((((((((a1[&&NHX:S=a1],a2[&&NHX:S=a2]),b1[&&NHX:S=b1]),x[&&NHX:S=x]),m1[&&NHX:S=m1]),i1[&&NHX:S=i1]),e1[&&NHX:S=e1]),y[&&NHX:S=y]),z[&&NHX:S=z])");
                                                                                gene7_1.setRooted(true);
                                                                                SDIse sdi7 = new SDIse(gene7_1, species7);
                                                                                if (sdi7.getDuplicationsSum() == 0) break block90;
                                                                                return false;
                                                                            }
                                                                            if (Test.getEvent(gene7_1, "a1", "a2").isSpeciation()) break block91;
                                                                            return false;
                                                                        }
                                                                        if (Test.getEvent(gene7_1, "a1", "b1").isSpeciation()) break block92;
                                                                        return false;
                                                                    }
                                                                    if (Test.getEvent(gene7_1, "a1", "x").isSpeciation()) break block93;
                                                                    return false;
                                                                }
                                                                if (Test.getEvent(gene7_1, "a1", "m1").isSpeciation()) break block94;
                                                                return false;
                                                            }
                                                            if (Test.getEvent(gene7_1, "a1", "i1").isSpeciation()) break block95;
                                                            return false;
                                                        }
                                                        if (Test.getEvent(gene7_1, "a1", "e1").isSpeciation()) break block96;
                                                        return false;
                                                    }
                                                    if (Test.getEvent(gene7_1, "a1", "y").isSpeciation()) break block97;
                                                    return false;
                                                }
                                                if (Test.getEvent(gene7_1, "a1", "z").isSpeciation()) break block98;
                                                return false;
                                            }
                                            gene7_2 = Test.createPhylogeny("(((((((((a1[&&NHX:S=a1],a2[&&NHX:S=a2]),b1[&&NHX:S=b1]),x[&&NHX:S=x]),m1[&&NHX:S=m1]),i1[&&NHX:S=i1]),j2[&&NHX:S=j2]),e1[&&NHX:S=e1]),y[&&NHX:S=y]),z[&&NHX:S=z])");
                                            gene7_2.setRooted(true);
                                            SDIse sdi7_2 = new SDIse(gene7_2, species7);
                                            if (sdi7_2.getDuplicationsSum() == 1) break block99;
                                            return false;
                                        }
                                        if (Test.getEvent(gene7_2, "a1", "a2").isSpeciation()) break block100;
                                        return false;
                                    }
                                    if (Test.getEvent(gene7_2, "a1", "b1").isSpeciation()) break block101;
                                    return false;
                                }
                                if (Test.getEvent(gene7_2, "a1", "x").isSpeciation()) break block102;
                                return false;
                            }
                            if (Test.getEvent(gene7_2, "a1", "m1").isSpeciation()) break block103;
                            return false;
                        }
                        if (Test.getEvent(gene7_2, "a1", "i1").isSpeciation()) break block104;
                        return false;
                    }
                    if (Test.getEvent(gene7_2, "a1", "j2").isDuplication()) break block105;
                    return false;
                }
                if (Test.getEvent(gene7_2, "a1", "e1").isSpeciation()) break block106;
                return false;
            }
            if (Test.getEvent(gene7_2, "a1", "y").isSpeciation()) break block107;
            return false;
        }
        return Test.getEvent(gene7_2, "a1", "z").isSpeciation();
    }

    private static boolean testSDIunrooted() {
        Phylogeny[] p8;
        block189: {
            block188: {
                block187: {
                    block186: {
                        block185: {
                            block184: {
                                block183: {
                                    block182: {
                                        block181: {
                                            SDIR sdi_unrooted;
                                            block180: {
                                                block179: {
                                                    block178: {
                                                        block177: {
                                                            Phylogeny[] p7;
                                                            PhylogenyFactory factory;
                                                            block176: {
                                                                block175: {
                                                                    block174: {
                                                                        block173: {
                                                                            block172: {
                                                                                block171: {
                                                                                    block170: {
                                                                                        block169: {
                                                                                            block168: {
                                                                                                block167: {
                                                                                                    block166: {
                                                                                                        block165: {
                                                                                                            block164: {
                                                                                                                Phylogeny[] p6;
                                                                                                                block163: {
                                                                                                                    block162: {
                                                                                                                        block161: {
                                                                                                                            block160: {
                                                                                                                                block159: {
                                                                                                                                    block158: {
                                                                                                                                        block157: {
                                                                                                                                            block156: {
                                                                                                                                                block155: {
                                                                                                                                                    block154: {
                                                                                                                                                        block153: {
                                                                                                                                                            block152: {
                                                                                                                                                                block151: {
                                                                                                                                                                    block150: {
                                                                                                                                                                        block149: {
                                                                                                                                                                            block148: {
                                                                                                                                                                                block147: {
                                                                                                                                                                                    block146: {
                                                                                                                                                                                        Phylogeny species0;
                                                                                                                                                                                        block145: {
                                                                                                                                                                                            block144: {
                                                                                                                                                                                                block143: {
                                                                                                                                                                                                    block142: {
                                                                                                                                                                                                        block141: {
                                                                                                                                                                                                            block140: {
                                                                                                                                                                                                                Iterator<PhylogenyBranch> iter2;
                                                                                                                                                                                                                block139: {
                                                                                                                                                                                                                    PhylogenyBranch br;
                                                                                                                                                                                                                    block138: {
                                                                                                                                                                                                                        block137: {
                                                                                                                                                                                                                            block136: {
                                                                                                                                                                                                                                block135: {
                                                                                                                                                                                                                                    block134: {
                                                                                                                                                                                                                                        block133: {
                                                                                                                                                                                                                                            Iterator<PhylogenyBranch> iter1;
                                                                                                                                                                                                                                            block132: {
                                                                                                                                                                                                                                                block131: {
                                                                                                                                                                                                                                                    block130: {
                                                                                                                                                                                                                                                        block129: {
                                                                                                                                                                                                                                                            block128: {
                                                                                                                                                                                                                                                                block127: {
                                                                                                                                                                                                                                                                    block126: {
                                                                                                                                                                                                                                                                        Iterator<PhylogenyBranch> iter;
                                                                                                                                                                                                                                                                        block125: {
                                                                                                                                                                                                                                                                            block124: {
                                                                                                                                                                                                                                                                                block123: {
                                                                                                                                                                                                                                                                                    block122: {
                                                                                                                                                                                                                                                                                        block121: {
                                                                                                                                                                                                                                                                                            block120: {
                                                                                                                                                                                                                                                                                                block119: {
                                                                                                                                                                                                                                                                                                    block118: {
                                                                                                                                                                                                                                                                                                        block117: {
                                                                                                                                                                                                                                                                                                            block116: {
                                                                                                                                                                                                                                                                                                                block115: {
                                                                                                                                                                                                                                                                                                                    block114: {
                                                                                                                                                                                                                                                                                                                        block113: {
                                                                                                                                                                                                                                                                                                                            block112: {
                                                                                                                                                                                                                                                                                                                                block111: {
                                                                                                                                                                                                                                                                                                                                    block110: {
                                                                                                                                                                                                                                                                                                                                        block109: {
                                                                                                                                                                                                                                                                                                                                            block108: {
                                                                                                                                                                                                                                                                                                                                                block107: {
                                                                                                                                                                                                                                                                                                                                                    block106: {
                                                                                                                                                                                                                                                                                                                                                        block105: {
                                                                                                                                                                                                                                                                                                                                                            block104: {
                                                                                                                                                                                                                                                                                                                                                                block103: {
                                                                                                                                                                                                                                                                                                                                                                    block102: {
                                                                                                                                                                                                                                                                                                                                                                        block101: {
                                                                                                                                                                                                                                                                                                                                                                            block100: {
                                                                                                                                                                                                                                                                                                                                                                                block99: {
                                                                                                                                                                                                                                                                                                                                                                                    block98: {
                                                                                                                                                                                                                                                                                                                                                                                        block97: {
                                                                                                                                                                                                                                                                                                                                                                                            block96: {
                                                                                                                                                                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                                                                                                                                                                    factory = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                                                                                                    Phylogeny p0 = factory.create("((((A,B)ab,(C1,C2)cc)abc,D)abcd,(E,F)ef)abcdef", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                                                                    List<PhylogenyBranch> l = SDIR.getBranchesInPreorder(p0);
                                                                                                                                                                                                                                                                                                                                                                                                    iter = l.iterator();
                                                                                                                                                                                                                                                                                                                                                                                                    br = iter.next();
                                                                                                                                                                                                                                                                                                                                                                                                    if (br.getFirstNode().getNodeName().equals("abcd") || br.getFirstNode().getNodeName().equals("ef")) break block96;
                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                catch (Exception e) {
                                                                                                                                                                                                                                                                                                                                                                                                    e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("abcd") || br.getSecondNode().getNodeName().equals("ef")) break block97;
                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        br = iter.next();
                                                                                                                                                                                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("abcd") || br.getFirstNode().getNodeName().equals("abc")) break block98;
                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("abcd") || br.getSecondNode().getNodeName().equals("abc")) break block99;
                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                br = iter.next();
                                                                                                                                                                                                                                                                                                                                                                                if (br.getFirstNode().getNodeName().equals("abc") || br.getFirstNode().getNodeName().equals("ab")) break block100;
                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("abc") || br.getSecondNode().getNodeName().equals("ab")) break block101;
                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        br = iter.next();
                                                                                                                                                                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("A")) break block102;
                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("A")) break block103;
                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                br = iter.next();
                                                                                                                                                                                                                                                                                                                                                                if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("B")) break block104;
                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("B")) break block105;
                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        br = iter.next();
                                                                                                                                                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("abc")) break block106;
                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("abc")) break block107;
                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                br = iter.next();
                                                                                                                                                                                                                                                                                                                                                if (br.getFirstNode().getNodeName().equals("abc") || br.getFirstNode().getNodeName().equals("cc")) break block108;
                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("abc") || br.getSecondNode().getNodeName().equals("cc")) break block109;
                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        br = iter.next();
                                                                                                                                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("C1") || br.getFirstNode().getNodeName().equals("cc")) break block110;
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("C1") || br.getSecondNode().getNodeName().equals("cc")) break block111;
                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                br = iter.next();
                                                                                                                                                                                                                                                                                                                                if (br.getFirstNode().getNodeName().equals("C2") || br.getFirstNode().getNodeName().equals("cc")) break block112;
                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("C2") || br.getSecondNode().getNodeName().equals("cc")) break block113;
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        br = iter.next();
                                                                                                                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("abc") || br.getFirstNode().getNodeName().equals("cc")) break block114;
                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("abc") || br.getSecondNode().getNodeName().equals("cc")) break block115;
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                br = iter.next();
                                                                                                                                                                                                                                                                                                                if (br.getFirstNode().getNodeName().equals("abc") || br.getFirstNode().getNodeName().equals("abcd")) break block116;
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("abc") || br.getSecondNode().getNodeName().equals("abcd")) break block117;
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        br = iter.next();
                                                                                                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("abcd") || br.getFirstNode().getNodeName().equals("D")) break block118;
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("abcd") || br.getSecondNode().getNodeName().equals("D")) break block119;
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                br = iter.next();
                                                                                                                                                                                                                                                                                                if (br.getFirstNode().getNodeName().equals("ef") || br.getFirstNode().getNodeName().equals("abcd")) break block120;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("ef") || br.getSecondNode().getNodeName().equals("abcd")) break block121;
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        br = iter.next();
                                                                                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("ef") || br.getFirstNode().getNodeName().equals("E")) break block122;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("ef") || br.getSecondNode().getNodeName().equals("E")) break block123;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                br = iter.next();
                                                                                                                                                                                                                                                                                if (br.getFirstNode().getNodeName().equals("ef") || br.getFirstNode().getNodeName().equals("F")) break block124;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("ef") || br.getSecondNode().getNodeName().equals("F")) break block125;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (!iter.hasNext()) break block126;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    Phylogeny p1 = factory.create("(C,(A,B)ab)abc", new NHXParser())[0];
                                                                                                                                                                                                                                                                    List<PhylogenyBranch> l1 = SDIR.getBranchesInPreorder(p1);
                                                                                                                                                                                                                                                                    iter1 = l1.iterator();
                                                                                                                                                                                                                                                                    br = iter1.next();
                                                                                                                                                                                                                                                                    if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("C")) break block127;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("C")) break block128;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            br = iter1.next();
                                                                                                                                                                                                                                                            if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("A")) break block129;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("A")) break block130;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    br = iter1.next();
                                                                                                                                                                                                                                                    if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("B")) break block131;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("B")) break block132;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (!iter1.hasNext()) break block133;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        Phylogeny p2 = factory.create("((A,B)ab,C)abc", new NHXParser())[0];
                                                                                                                                                                                                                                        List<PhylogenyBranch> l2 = SDIR.getBranchesInPreorder(p2);
                                                                                                                                                                                                                                        iter2 = l2.iterator();
                                                                                                                                                                                                                                        br = iter2.next();
                                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("C")) break block134;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("C")) break block135;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                br = iter2.next();
                                                                                                                                                                                                                                if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("A")) break block136;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("A")) break block137;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        br = iter2.next();
                                                                                                                                                                                                                        if (br.getFirstNode().getNodeName().equals("ab") || br.getFirstNode().getNodeName().equals("B")) break block138;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (br.getSecondNode().getNodeName().equals("ab") || br.getSecondNode().getNodeName().equals("B")) break block139;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (!iter2.hasNext()) break block140;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            species0 = factory.create("(((([&&NHX:S=A],[&&NHX:S=B]),[&&NHX:S=C]),[&&NHX:S=D]),([&&NHX:S=E],[&&NHX:S=F]))", new NHXParser())[0];
                                                                                                                                                                                                            Phylogeny gene1 = factory.create("(((((A:0.6[&&NHX:S=A],B:0.1[&&NHX:S=B])ab:0.1,C:0.1[&&NHX:S=C])abc:0.3,D:1.0[&&NHX:S=D])abcd:0.2,E:0.1[&&NHX:S=E])abcde:0.2,F:0.2[&&NHX:S=F])", new NHXParser())[0];
                                                                                                                                                                                                            species0.setRooted(true);
                                                                                                                                                                                                            gene1.setRooted(true);
                                                                                                                                                                                                            sdi_unrooted = new SDIR();
                                                                                                                                                                                                            sdi_unrooted.infer(gene1, species0, false, true, true, true, 10);
                                                                                                                                                                                                            if (sdi_unrooted.getCount() == 1) break block141;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (sdi_unrooted.getMinimalDuplications() == 0) break block142;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (Test.isEqual(sdi_unrooted.getMinimalDiffInSubTreeHeights(), 0.4)) break block143;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (Test.isEqual(sdi_unrooted.getMinimalTreeHeight(), 1.0)) break block144;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (sdi_unrooted.getMinimalMappingCost() == Integer.MAX_VALUE) break block145;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        Phylogeny gene2 = factory.create("(((((A:2.6[&&NHX:S=A],B:0.1[&&NHX:S=B])ab:0.1,C:0.1[&&NHX:S=C])abc:0.3,D:1.0[&&NHX:S=D])abcd:0.2,E:0.1[&&NHX:S=E])abcde:0.2,F:0.2[&&NHX:S=F])", new NHXParser())[0];
                                                                                                                                                                                        gene2.setRooted(true);
                                                                                                                                                                                        sdi_unrooted.infer(gene2, species0, false, false, true, true, 10);
                                                                                                                                                                                        if (sdi_unrooted.getCount() == 1) break block146;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (sdi_unrooted.getMinimalDuplications() == 3) break block147;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (Test.isEqual(sdi_unrooted.getMinimalDiffInSubTreeHeights(), 0.0)) break block148;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (Test.isEqual(sdi_unrooted.getMinimalTreeHeight(), 2.0)) break block149;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (sdi_unrooted.getMinimalMappingCost() == Integer.MAX_VALUE) break block150;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    Phylogeny species6 = factory.create("(((1:[&&NHX:S=1],5:[&&NHX:S=5])1-5,((4:[&&NHX:S=4],6:[&&NHX:S=6])4-6,2:[&&NHX:S=2])4-6-2)1-5-4-6-2,((9:[&&NHX:S=9],3:[&&NHX:S=3])9-3,(8:[&&NHX:S=8],7:[&&NHX:S=7])8-7)9-3-8-7)", new NHXParser())[0];
                                                                                                                                                                    Phylogeny gene6 = factory.create("((5:0.1[&&NHX:S=5],6:0.1[&&NHX:S=6])5-6:0.05[&&NHX:S=6],(4:0.1[&&NHX:S=4],(((1:0.1[&&NHX:S=1],2:0.1[&&NHX:S=2])1-2:0.1[&&NHX:S=2],3:0.25[&&NHX:S=3])1-2-3:0.2[&&NHX:S=2],(7:0.1[&&NHX:S=7],(8:0.1[&&NHX:S=8],9:0.1[&&NHX:S=9])8-9:0.1[&&NHX:S=9])7-8-9:0.1[&&NHX:S=8])4-5-6-7-8-9:0.1[&&NHX:S=5])4-5-6:0.05[&&NHX:S=5])", new NHXParser())[0];
                                                                                                                                                                    species6.setRooted(true);
                                                                                                                                                                    gene6.setRooted(true);
                                                                                                                                                                    p6 = sdi_unrooted.infer(gene6, species6, false, true, true, true, 10);
                                                                                                                                                                    if (sdi_unrooted.getCount() == 1) break block151;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (Test.isEqual(sdi_unrooted.getMinimalDiffInSubTreeHeights(), 0.0)) break block152;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (Test.isEqual(sdi_unrooted.getMinimalTreeHeight(), 0.375)) break block153;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (sdi_unrooted.getMinimalDuplications() == 3) break block154;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (sdi_unrooted.getMinimalMappingCost() == Integer.MAX_VALUE) break block155;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (p6[0].getRoot().isDuplication()) break block156;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (p6[0].getNode("4-5-6").isDuplication()) break block157;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (p6[0].getNode("7-8-9").isDuplication()) break block158;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (!p6[0].getNode("1-2").isDuplication()) break block159;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (!p6[0].getNode("1-2-3").isDuplication()) break block160;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (!p6[0].getNode("5-6").isDuplication()) break block161;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (!p6[0].getNode("8-9").isDuplication()) break block162;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (!p6[0].getNode("4-5-6-7-8-9").isDuplication()) break block163;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                p6 = null;
                                                                                                                Phylogeny species7 = factory.create("(((1:[&&NHX:S=1],5:[&&NHX:S=5])1-5,((4:[&&NHX:S=4],6:[&&NHX:S=6])4-6,2:[&&NHX:S=2])4-6-2)1-5-4-6-2,((9:[&&NHX:S=9],3:[&&NHX:S=3])9-3,(8:[&&NHX:S=8],7:[&&NHX:S=7])8-7)9-3-8-7)", new NHXParser())[0];
                                                                                                                Phylogeny gene7 = factory.create("((5:0.1[&&NHX:S=5],6:0.1[&&NHX:S=6])5-6:0.05[&&NHX:S=6],(4:0.1[&&NHX:S=4],(((1:0.1[&&NHX:S=1],2:0.1[&&NHX:S=2])1-2:0.1[&&NHX:S=2],3:0.25[&&NHX:S=3])1-2-3:0.2[&&NHX:S=2],(7:0.1[&&NHX:S=7],(8:0.1[&&NHX:S=8],9:0.1[&&NHX:S=9])8-9:0.1[&&NHX:S=9])7-8-9:0.1[&&NHX:S=8])4-5-6-7-8-9:0.1[&&NHX:S=5])4-5-6:0.05[&&NHX:S=5])", new NHXParser())[0];
                                                                                                                species7.setRooted(true);
                                                                                                                gene7.setRooted(true);
                                                                                                                p7 = sdi_unrooted.infer(gene7, species7, true, true, true, true, 10);
                                                                                                                if (sdi_unrooted.getCount() == 1) break block164;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (Test.isEqual(sdi_unrooted.getMinimalDiffInSubTreeHeights(), 0.0)) break block165;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (Test.isEqual(sdi_unrooted.getMinimalTreeHeight(), 0.375)) break block166;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (sdi_unrooted.getMinimalDuplications() == 3) break block167;
                                                                                                    return false;
                                                                                                }
                                                                                                if (sdi_unrooted.getMinimalMappingCost() == 17) break block168;
                                                                                                return false;
                                                                                            }
                                                                                            if (p7[0].getRoot().isDuplication()) break block169;
                                                                                            return false;
                                                                                        }
                                                                                        if (p7[0].getNode("4-5-6").isDuplication()) break block170;
                                                                                        return false;
                                                                                    }
                                                                                    if (p7[0].getNode("7-8-9").isDuplication()) break block171;
                                                                                    return false;
                                                                                }
                                                                                if (!p7[0].getNode("1-2").isDuplication()) break block172;
                                                                                return false;
                                                                            }
                                                                            if (!p7[0].getNode("1-2-3").isDuplication()) break block173;
                                                                            return false;
                                                                        }
                                                                        if (!p7[0].getNode("5-6").isDuplication()) break block174;
                                                                        return false;
                                                                    }
                                                                    if (!p7[0].getNode("8-9").isDuplication()) break block175;
                                                                    return false;
                                                                }
                                                                if (!p7[0].getNode("4-5-6-7-8-9").isDuplication()) break block176;
                                                                return false;
                                                            }
                                                            p7 = null;
                                                            Phylogeny species8 = factory.create("(((1:[&&NHX:S=1],5:[&&NHX:S=5])1-5,((4:[&&NHX:S=4],6:[&&NHX:S=6])4-6,2:[&&NHX:S=2])4-6-2)1-5-4-6-2,((9:[&&NHX:S=9],3:[&&NHX:S=3])9-3,(8:[&&NHX:S=8],7:[&&NHX:S=7])8-7)9-3-8-7)", new NHXParser())[0];
                                                            Phylogeny gene8 = factory.create("((5:0.1[&&NHX:S=5],6:0.1[&&NHX:S=6])5-6:0.05[&&NHX:S=6],(4:0.1[&&NHX:S=4],(((1:0.1[&&NHX:S=1],2:0.1[&&NHX:S=2])1-2:0.1[&&NHX:S=2],3:0.25[&&NHX:S=3])1-2-3:0.2[&&NHX:S=2],(7:0.1[&&NHX:S=7],(8:0.1[&&NHX:S=8],9:0.1[&&NHX:S=9])8-9:0.1[&&NHX:S=9])7-8-9:0.1[&&NHX:S=8])4-5-6-7-8-9:0.1[&&NHX:S=5])4-5-6:0.05[&&NHX:S=5])", new NHXParser())[0];
                                                            species8.setRooted(true);
                                                            gene8.setRooted(true);
                                                            p8 = sdi_unrooted.infer(gene8, species8, false, false, true, true, 10);
                                                            if (sdi_unrooted.getCount() == 1) break block177;
                                                            return false;
                                                        }
                                                        if (Test.isEqual(sdi_unrooted.getMinimalDiffInSubTreeHeights(), 0.0)) break block178;
                                                        return false;
                                                    }
                                                    if (Test.isEqual(sdi_unrooted.getMinimalTreeHeight(), 0.375)) break block179;
                                                    return false;
                                                }
                                                if (sdi_unrooted.getMinimalDuplications() == 3) break block180;
                                                return false;
                                            }
                                            if (sdi_unrooted.getMinimalMappingCost() == Integer.MAX_VALUE) break block181;
                                            return false;
                                        }
                                        if (p8[0].getRoot().isDuplication()) break block182;
                                        return false;
                                    }
                                    if (p8[0].getNode("4-5-6").isDuplication()) break block183;
                                    return false;
                                }
                                if (p8[0].getNode("7-8-9").isDuplication()) break block184;
                                return false;
                            }
                            if (!p8[0].getNode("1-2").isDuplication()) break block185;
                            return false;
                        }
                        if (!p8[0].getNode("1-2-3").isDuplication()) break block186;
                        return false;
                    }
                    if (!p8[0].getNode("5-6").isDuplication()) break block187;
                    return false;
                }
                if (!p8[0].getNode("8-9").isDuplication()) break block188;
                return false;
            }
            if (!p8[0].getNode("4-5-6-7-8-9").isDuplication()) break block189;
            return false;
        }
        p8 = null;
        return true;
    }

    private static boolean testSubtreeDeletion() {
        Phylogeny t2;
        block25: {
            block24: {
                PhylogenyFactory factory;
                block23: {
                    Phylogeny t1;
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        try {
                                                            factory = ParserBasedPhylogenyFactory.getInstance();
                                                            t1 = factory.create("((A,B,C)abc,(D,E,F)def)r", new NHXParser())[0];
                                                            t1.deleteSubtree(t1.getNode("A"), false);
                                                            if (t1.getNumberOfExternalNodes() == 5) break block14;
                                                            return false;
                                                        }
                                                        catch (Exception e) {
                                                            e.printStackTrace(System.out);
                                                            return false;
                                                        }
                                                    }
                                                    t1.toNewHampshireX();
                                                    t1.deleteSubtree(t1.getNode("E"), false);
                                                    if (t1.getNumberOfExternalNodes() == 4) break block15;
                                                    return false;
                                                }
                                                t1.toNewHampshireX();
                                                t1.deleteSubtree(t1.getNode("F"), false);
                                                if (t1.getNumberOfExternalNodes() == 3) break block16;
                                                return false;
                                            }
                                            t1.toNewHampshireX();
                                            t1.deleteSubtree(t1.getNode("D"), false);
                                            t1.toNewHampshireX();
                                            if (t1.getNumberOfExternalNodes() == 3) break block17;
                                            return false;
                                        }
                                        t1.deleteSubtree(t1.getNode("def"), false);
                                        t1.toNewHampshireX();
                                        if (t1.getNumberOfExternalNodes() == 2) break block18;
                                        return false;
                                    }
                                    t1.deleteSubtree(t1.getNode("B"), false);
                                    t1.toNewHampshireX();
                                    if (t1.getNumberOfExternalNodes() == 1) break block19;
                                    return false;
                                }
                                t1.deleteSubtree(t1.getNode("C"), false);
                                t1.toNewHampshireX();
                                if (t1.getNumberOfExternalNodes() == 1) break block20;
                                return false;
                            }
                            t1.deleteSubtree(t1.getNode("abc"), false);
                            t1.toNewHampshireX();
                            if (t1.getNumberOfExternalNodes() == 1) break block21;
                            return false;
                        }
                        t1.deleteSubtree(t1.getNode("r"), false);
                        if (t1.getNumberOfExternalNodes() == 0) break block22;
                        return false;
                    }
                    if (t1.isEmpty()) break block23;
                    return false;
                }
                t2 = factory.create("(((1,2,3)A,B,C)abc,(D,E,F)def)r", new NHXParser())[0];
                t2.deleteSubtree(t2.getNode("A"), false);
                t2.toNewHampshireX();
                if (t2.getNumberOfExternalNodes() == 5) break block24;
                return false;
            }
            t2.deleteSubtree(t2.getNode("abc"), false);
            t2.toNewHampshireX();
            if (t2.getNumberOfExternalNodes() == 3) break block25;
            return false;
        }
        t2.deleteSubtree(t2.getNode("def"), false);
        t2.toNewHampshireX();
        return t2.getNumberOfExternalNodes() == 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean testSupportCount() {
        try {
            Phylogeny t0_3;
            PhylogenyFactory factory;
            block27: {
                PhylogenyNode n;
                factory = ParserBasedPhylogenyFactory.getInstance();
                Phylogeny t0_1 = factory.create("(((A,B),C),(D,E))", new NHXParser())[0];
                Phylogeny[] phylogenies_1 = factory.create("(((A,B),C),(D,E)) (((C,B),A),(D,E))(((A,B),C),(D,E)) (((A,B),C),(D,E))(((A,B),C),(D,E))(((C,B),A),(D,E))(((E,B),D),(C,A))(((C,B),A),(D,E))(((A,B),C),(D,E))(((A,B),C),(D,E))", new NHXParser());
                SupportCount.count(t0_1, phylogenies_1, true, false);
                Phylogeny t0_2 = factory.create("(((((A,B),C),D),E),(F,G))", new NHXParser())[0];
                Phylogeny[] phylogenies_2 = factory.create("(((((A,B),C),D),E),(F,G))(((((A,B),C),D),E),((F,G),X))(((((A,Y),B),C),D),((F,G),E))(((((A,B),C),D),E),(F,G))(((((A,B),C),D),E),(F,G))(((((A,B),C),D),E),(F,G))(((((A,B),C),D),E),(F,G),Z)(((((A,B),C),D),E),(F,G))((((((A,B),C),D),E),F),G)(((((X,Y),F,G),E),((A,B),C)),D)", new NHXParser());
                SupportCount.count(t0_2, phylogenies_2, true, false);
                PhylogenyNodeIterator it = t0_2.iteratorPostorder();
                do {
                    if (it.hasNext()) continue;
                    t0_3 = factory.create("(((A,B)ab,C)abc,((D,E)de,F)def)", new NHXParser())[0];
                    Phylogeny[] phylogenies_3 = factory.create("(((A,B),C),((D,E),F))(((A,C),B),((D,F),E))(((C,A),B),((F,D),E))(((A,B),F),((D,E),C))(((((A,B),C),D),E),F)", new NHXParser());
                    SupportCount.count(t0_3, phylogenies_3, true, false);
                    t0_3.reRoot(t0_3.getNode("def").getNodeId());
                    if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("ab")) != 3.0) {
                        return false;
                    }
                    break block27;
                } while ((n = it.next()).isExternal() || PhylogenyMethods.getConfidenceValue(n) == 10.0);
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("abc")) != 4.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("def")) != 4.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("de")) != 2.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("A")) != 5.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("B")) != 5.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("C")) != 5.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("D")) != 5.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("E")) != 5.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_3.getNode("F")) != 5.0) {
                return false;
            }
            Phylogeny t0_4 = factory.create("(((((A,B)1,C)2,D)3,E)4,F)", new NHXParser())[0];
            Phylogeny[] phylogenies_4 = factory.create("((((((A,X),C),B),D),E),F) (((A,B,Z),C,Q),(((D,Y),E),F))", new NHXParser());
            SupportCount.count(t0_4, phylogenies_4, true, false);
            t0_4.reRoot(t0_4.getNode("F").getNodeId());
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("1")) != 1.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("2")) != 2.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("3")) != 1.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("4")) != 2.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("A")) != 2.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("B")) != 2.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("C")) != 2.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("D")) != 2.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("E")) != 2.0) {
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(t0_4.getNode("F")) != 2.0) {
                return false;
            }
            Phylogeny a = factory.create("(((((A,B)1,C)2,D)3,E)4,F)", new NHXParser())[0];
            Phylogeny b1 = factory.create("(((((B,A)1,C)2,D)3,E)4,F)", new NHXParser())[0];
            double d = SupportCount.compare(b1, a, true, true, true);
            if (!Test.isEqual(d, 1.0)) {
                return false;
            }
            a = factory.create("(((((A,B)1,C)2,D)3,E)4,F)", new NHXParser())[0];
            Phylogeny b2 = factory.create("(((((C,B)1,A)2,D)3,E)4,F)", new NHXParser())[0];
            d = SupportCount.compare(b2, a, true, true, true);
            if (!Test.isEqual(d, 0.8)) {
                return false;
            }
            a = factory.create("(((((A,B)1,C)2,D)3,E)4,F)", new NHXParser())[0];
            Phylogeny b3 = factory.create("(((((F,C)1,A)2,B)3,D)4,E)", new NHXParser())[0];
            d = SupportCount.compare(b3, a, true, true, true);
            if (!Test.isEqual(d, 0.4)) {
                return false;
            }
            a = factory.create("(((((A,B)1,C)2,D)3,E)4,F)r", new NHXParser())[0];
            Phylogeny b4 = factory.create("(((((F,C)1,A)2,B)3,D)4,E)r", new NHXParser())[0];
            d = SupportCount.compare(b4, a, true, true, false);
            if (Test.isEqual(d, 0.2)) return true;
            return false;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    private static boolean testSupportTransfer() {
        Phylogeny p2;
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    Phylogeny p1;
                                    block12: {
                                        block11: {
                                            try {
                                                PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
                                                p1 = factory.create("(((A,B)ab:97,C)abc:57,((D,E)de:10,(F,G)fg:50,(H,I)hi:64)defghi)", new NHXParser())[0];
                                                p2 = factory.create("(((A:0.1,B:0.3)ab:0.4,C)abc:0.5,((D,E)de,(F,G)fg,(H,I)hi:0.59)defghi)", new NHXParser())[0];
                                                if (!(PhylogenyMethods.getConfidenceValue(p2.getNode("ab")) >= 0.0)) break block11;
                                                return false;
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace(System.out);
                                                return false;
                                            }
                                        }
                                        if (!(PhylogenyMethods.getConfidenceValue(p2.getNode("abc")) >= 0.0)) break block12;
                                        return false;
                                    }
                                    support_transfer.moveBranchLengthsToBootstrap(p1);
                                    support_transfer.transferSupportValues(p1, p2);
                                    if (p2.getNode("ab").getDistanceToParent() == 0.4) break block13;
                                    return false;
                                }
                                if (p2.getNode("abc").getDistanceToParent() == 0.5) break block14;
                                return false;
                            }
                            if (p2.getNode("hi").getDistanceToParent() == 0.59) break block15;
                            return false;
                        }
                        if (PhylogenyMethods.getConfidenceValue(p2.getNode("ab")) == 97.0) break block16;
                        return false;
                    }
                    if (PhylogenyMethods.getConfidenceValue(p2.getNode("abc")) == 57.0) break block17;
                    return false;
                }
                if (PhylogenyMethods.getConfidenceValue(p2.getNode("de")) == 10.0) break block18;
                return false;
            }
            if (PhylogenyMethods.getConfidenceValue(p2.getNode("fg")) == 50.0) break block19;
            return false;
        }
        return PhylogenyMethods.getConfidenceValue(p2.getNode("hi")) == 64.0;
    }

    private static boolean testTaxonomyAssigner() {
        Phylogeny g0;
        block153: {
            Phylogeny s0;
            String g0_str;
            String s0_str;
            block152: {
                block151: {
                    block150: {
                        block149: {
                            block148: {
                                block147: {
                                    block146: {
                                        block145: {
                                            block144: {
                                                block143: {
                                                    block142: {
                                                        block141: {
                                                            block140: {
                                                                block139: {
                                                                    block138: {
                                                                        block137: {
                                                                            block136: {
                                                                                block135: {
                                                                                    block134: {
                                                                                        block133: {
                                                                                            block132: {
                                                                                                block131: {
                                                                                                    block130: {
                                                                                                        block129: {
                                                                                                            block128: {
                                                                                                                block127: {
                                                                                                                    block126: {
                                                                                                                        block125: {
                                                                                                                            block124: {
                                                                                                                                block123: {
                                                                                                                                    block122: {
                                                                                                                                        block121: {
                                                                                                                                            block120: {
                                                                                                                                                block119: {
                                                                                                                                                    block118: {
                                                                                                                                                        block117: {
                                                                                                                                                            block116: {
                                                                                                                                                                block115: {
                                                                                                                                                                    block114: {
                                                                                                                                                                        block113: {
                                                                                                                                                                            block112: {
                                                                                                                                                                                block111: {
                                                                                                                                                                                    block110: {
                                                                                                                                                                                        block109: {
                                                                                                                                                                                            block108: {
                                                                                                                                                                                                block107: {
                                                                                                                                                                                                    block106: {
                                                                                                                                                                                                        block105: {
                                                                                                                                                                                                            block104: {
                                                                                                                                                                                                                block103: {
                                                                                                                                                                                                                    block102: {
                                                                                                                                                                                                                        block101: {
                                                                                                                                                                                                                            block100: {
                                                                                                                                                                                                                                block99: {
                                                                                                                                                                                                                                    block98: {
                                                                                                                                                                                                                                        block97: {
                                                                                                                                                                                                                                            block96: {
                                                                                                                                                                                                                                                block95: {
                                                                                                                                                                                                                                                    block94: {
                                                                                                                                                                                                                                                        block93: {
                                                                                                                                                                                                                                                            block92: {
                                                                                                                                                                                                                                                                block91: {
                                                                                                                                                                                                                                                                    block90: {
                                                                                                                                                                                                                                                                        block89: {
                                                                                                                                                                                                                                                                            block88: {
                                                                                                                                                                                                                                                                                block87: {
                                                                                                                                                                                                                                                                                    block86: {
                                                                                                                                                                                                                                                                                        block85: {
                                                                                                                                                                                                                                                                                            block84: {
                                                                                                                                                                                                                                                                                                block83: {
                                                                                                                                                                                                                                                                                                    block82: {
                                                                                                                                                                                                                                                                                                        block81: {
                                                                                                                                                                                                                                                                                                            block80: {
                                                                                                                                                                                                                                                                                                                block79: {
                                                                                                                                                                                                                                                                                                                    block78: {
                                                                                                                                                                                                                                                                                                                        try {
                                                                                                                                                                                                                                                                                                                            s0_str = "(((([&&NHX:S=A],[&&NHX:S=B])[&&NHX:S=AB],[&&NHX:S=C])[&&NHX:S=ABC],[&&NHX:S=D])[&&NHX:S=ABCD],[&&NHX:S=E])[&&NHX:S=ABCDE]";
                                                                                                                                                                                                                                                                                                                            g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=A])a,[&&NHX:S=B])b,[&&NHX:S=C])c";
                                                                                                                                                                                                                                                                                                                            s0 = ParserBasedPhylogenyFactory.getInstance().create(s0_str, new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                            g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                            s0.setRooted(true);
                                                                                                                                                                                                                                                                                                                            g0.setRooted(true);
                                                                                                                                                                                                                                                                                                                            TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                                                                                                                            if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("A")) break block78;
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        catch (Exception e) {
                                                                                                                                                                                                                                                                                                                            e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("AB")) break block79;
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("ABC")) break block80;
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=A])a,[&&NHX:S=A])b,[&&NHX:S=A])c";
                                                                                                                                                                                                                                                                                                            g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                                                                                                            g0.setRooted(true);
                                                                                                                                                                                                                                                                                                            TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                                                                                                            if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("A")) break block81;
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("A")) break block82;
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("A")) break block83;
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=B])a,[&&NHX:S=A])b,[&&NHX:S=A])c";
                                                                                                                                                                                                                                                                                                g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                                                                                                g0.setRooted(true);
                                                                                                                                                                                                                                                                                                TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                                                                                                if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("AB")) break block84;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("AB")) break block85;
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("AB")) break block86;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=B])a,[&&NHX:S=C])b,[&&NHX:S=A])c";
                                                                                                                                                                                                                                                                                    g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                                                                                    g0.setRooted(true);
                                                                                                                                                                                                                                                                                    TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                                                                                    if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("AB")) break block87;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ABC")) break block88;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("ABC")) break block89;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=B])a,[&&NHX:S=C])b,[&&NHX:S=D])c";
                                                                                                                                                                                                                                                                        g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                                                                        g0.setRooted(true);
                                                                                                                                                                                                                                                                        TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                                                                        if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("AB")) break block90;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ABC")) break block91;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block92;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=E])a,[&&NHX:S=C])b,[&&NHX:S=D])c";
                                                                                                                                                                                                                                                            g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                                                            g0.setRooted(true);
                                                                                                                                                                                                                                                            TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                                                            if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCDE")) break block93;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ABCDE")) break block94;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("ABCDE")) break block95;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=E])a,[&&NHX:S=A])b,[&&NHX:S=A])c";
                                                                                                                                                                                                                                                g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                                                g0.setRooted(true);
                                                                                                                                                                                                                                                TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                                                if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCDE")) break block96;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ABCDE")) break block97;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("ABCDE")) break block98;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    s0_str = "(([&&NHX:S=A],[&&NHX:S=B],[&&NHX:S=C],[&&NHX:S=D])[&&NHX:S=ABCD],([&&NHX:S=E],[&&NHX:S=F],[&&NHX:S=G],[&&NHX:S=H])[&&NHX:S=EFGH],([&&NHX:S=I],[&&NHX:S=J],[&&NHX:S=K],[&&NHX:S=L])[&&NHX:S=IJKL], ([&&NHX:S=M],[&&NHX:S=N],[&&NHX:S=O],[&&NHX:S=P])[&&NHX:S=MNOP])[&&NHX:S=ROOT]";
                                                                                                                                                                                                                                    s0 = ParserBasedPhylogenyFactory.getInstance().create(s0_str, new NHXParser())[0];
                                                                                                                                                                                                                                    s0.setRooted(true);
                                                                                                                                                                                                                                    g0_str = "(([&&NHX:S=A],[&&NHX:S=B],[&&NHX:S=C],[&&NHX:S=D])a,([&&NHX:S=E],[&&NHX:S=F],[&&NHX:S=G],[&&NHX:S=H])b,([&&NHX:S=I],[&&NHX:S=J],[&&NHX:S=K],[&&NHX:S=L])c, ([&&NHX:S=M],[&&NHX:S=N],[&&NHX:S=O],[&&NHX:S=P])d)r";
                                                                                                                                                                                                                                    g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                                    g0.setRooted(true);
                                                                                                                                                                                                                                    TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                                    if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block99;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("EFGH")) break block100;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("IJKL")) break block101;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (g0.getNode("d").getNodeData().getTaxonomy().getScientificName().equals("MNOP")) break block102;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (g0.getNode("r").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block103;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                g0_str = "(([&&NHX:S=A],[&&NHX:S=B],[&&NHX:S=A],[&&NHX:S=B])a,([&&NHX:S=E],[&&NHX:S=F],[&&NHX:S=F],[&&NHX:S=F])b,([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=I])c, ([&&NHX:S=M],[&&NHX:S=N],[&&NHX:S=O],[&&NHX:S=O])d)r";
                                                                                                                                                                                                                g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                                                g0.setRooted(true);
                                                                                                                                                                                                                TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                                                if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block104;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("EFGH")) break block105;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("IJKL")) break block106;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (g0.getNode("d").getNodeData().getTaxonomy().getScientificName().equals("MNOP")) break block107;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (g0.getNode("r").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block108;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            g0_str = "(([&&NHX:S=A],[&&NHX:S=B],[&&NHX:S=A],[&&NHX:S=B])a,([&&NHX:S=E],[&&NHX:S=F],[&&NHX:S=F],[&&NHX:S=F])b,([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])c, ([&&NHX:S=M],[&&NHX:S=N],[&&NHX:S=A],[&&NHX:S=O])d)r";
                                                                                                                                                                                            g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                                            g0.setRooted(true);
                                                                                                                                                                                            TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                                            if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block109;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("EFGH")) break block110;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("L")) break block111;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (g0.getNode("d").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block112;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (g0.getNode("r").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block113;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        g0_str = "(([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])a,([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])b,([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])c, ([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])d)r";
                                                                                                                                                                        g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                                        g0.setRooted(true);
                                                                                                                                                                        TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                                        if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("L")) break block114;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("L")) break block115;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("L")) break block116;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (g0.getNode("d").getNodeData().getTaxonomy().getScientificName().equals("L")) break block117;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (g0.getNode("r").getNodeData().getTaxonomy().getScientificName().equals("L")) break block118;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=A])a,[&&NHX:S=A])b,[&&NHX:S=A])c";
                                                                                                                                                    g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                                    g0.setRooted(true);
                                                                                                                                                    TaxonomyAssigner.execute(g0, s0);
                                                                                                                                                    if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("A")) break block119;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("A")) break block120;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("A")) break block121;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        g0_str = "((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=B])a,[&&NHX:S=I])b,[&&NHX:S=J])c";
                                                                                                                                        g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                                        g0.setRooted(true);
                                                                                                                                        TaxonomyAssigner.execute(g0, s0);
                                                                                                                                        if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block122;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block123;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block124;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            g0_str = "(((([&&NHX:S=A],[&&NHX:S=B],[&&NHX:S=C],[&&NHX:S=D])a,([&&NHX:S=D],[&&NHX:S=C],[&&NHX:S=B],[&&NHX:S=A])b)ab,([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])c)abc, ([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])d)r";
                                                                                                                            g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                                            g0.setRooted(true);
                                                                                                                            TaxonomyAssigner.execute(g0, s0);
                                                                                                                            if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block125;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block126;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (g0.getNode("ab").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block127;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("L")) break block128;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (g0.getNode("abc").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block129;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (g0.getNode("d").getNodeData().getTaxonomy().getScientificName().equals("L")) break block130;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (g0.getNode("r").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block131;
                                                                                                    return false;
                                                                                                }
                                                                                                g0_str = "(((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=C],[&&NHX:S=D])a,([&&NHX:S=D],[&&NHX:S=D],[&&NHX:S=B],[&&NHX:S=A])b)ab,([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])c)abc, ([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])d)r";
                                                                                                g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                                                g0.setRooted(true);
                                                                                                TaxonomyAssigner.execute(g0, s0);
                                                                                                if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block132;
                                                                                                return false;
                                                                                            }
                                                                                            if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block133;
                                                                                            return false;
                                                                                        }
                                                                                        if (g0.getNode("ab").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block134;
                                                                                        return false;
                                                                                    }
                                                                                    if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("L")) break block135;
                                                                                    return false;
                                                                                }
                                                                                if (g0.getNode("abc").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block136;
                                                                                return false;
                                                                            }
                                                                            if (g0.getNode("d").getNodeData().getTaxonomy().getScientificName().equals("L")) break block137;
                                                                            return false;
                                                                        }
                                                                        if (g0.getNode("r").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block138;
                                                                        return false;
                                                                    }
                                                                    g0_str = "(((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=C],[&&NHX:S=D])a,([&&NHX:S=D],[&&NHX:S=D],[&&NHX:S=B],[&&NHX:S=A])b)ab,([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L])c)abc, ([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=A])d)r";
                                                                    g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                                                    g0.setRooted(true);
                                                                    TaxonomyAssigner.execute(g0, s0);
                                                                    if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block139;
                                                                    return false;
                                                                }
                                                                if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block140;
                                                                return false;
                                                            }
                                                            if (g0.getNode("ab").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block141;
                                                            return false;
                                                        }
                                                        if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("L")) break block142;
                                                        return false;
                                                    }
                                                    if (g0.getNode("abc").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block143;
                                                    return false;
                                                }
                                                if (g0.getNode("d").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block144;
                                                return false;
                                            }
                                            if (g0.getNode("r").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block145;
                                            return false;
                                        }
                                        g0_str = "(((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=C],[&&NHX:S=D])a,([&&NHX:S=D],[&&NHX:S=D],[&&NHX:S=B],[&&NHX:S=A])b)ab,([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=A])c)abc, ([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=A])d)r";
                                        g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
                                        g0.setRooted(true);
                                        TaxonomyAssigner.execute(g0, s0);
                                        if (g0.getNode("a").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block146;
                                        return false;
                                    }
                                    if (g0.getNode("b").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block147;
                                    return false;
                                }
                                if (g0.getNode("ab").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block148;
                                return false;
                            }
                            if (g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("A")) break block149;
                            return false;
                        }
                        if (g0.getNode("abc").getNodeData().getTaxonomy().getScientificName().equals("ABCD")) break block150;
                        return false;
                    }
                    if (g0.getNode("d").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block151;
                    return false;
                }
                if (g0.getNode("r").getNodeData().getTaxonomy().getScientificName().equals("ROOT")) break block152;
                return false;
            }
            s0_str = "(([&&NHX:S=A],[&&NHX:S=B],[&&NHX:S=C],[&&NHX:S=D]),([&&NHX:S=E],[&&NHX:S=F],[&&NHX:S=G],[&&NHX:S=H]),([&&NHX:S=I],[&&NHX:S=J],[&&NHX:S=K],[&&NHX:S=L]), ([&&NHX:S=M],[&&NHX:S=N],[&&NHX:S=O],[&&NHX:S=P]))";
            s0 = ParserBasedPhylogenyFactory.getInstance().create(s0_str, new NHXParser())[0];
            s0.setRooted(true);
            g0_str = "(((([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=C],[&&NHX:S=D])a,([&&NHX:S=D],[&&NHX:S=D],[&&NHX:S=B],[&&NHX:S=A])b)ab,([&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=A],[&&NHX:S=A])c)abc, ([&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=L],[&&NHX:S=A])d)r";
            g0 = ParserBasedPhylogenyFactory.getInstance().create(g0_str, new NHXParser())[0];
            g0.setRooted(true);
            TaxonomyAssigner.execute(g0, s0);
            if (!g0.getNode("a").getNodeData().isHasTaxonomy()) break block153;
            return false;
        }
        return g0.getNode("c").getNodeData().getTaxonomy().getScientificName().equals("A");
    }
}

