/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.ForesterUtil;

public final class PhylogenyDecorator {
    private static final String TP_TAXONOMY_CODE = "TAXONOMY_CODE";
    private static final String TP_TAXONOMY_ID = "TAXONOMY_ID";
    private static final String TP_TAXONOMY_ID_PROVIDER = "TAXONOMY_ID_PROVIDER";
    private static final String TP_TAXONOMY_SN = "TAXONOMY_SN";
    private static final String TP_TAXONOMY_CN = "TAXONOMY_CN";
    private static final String TP_TAXONOMY_SYN = "TAXONOMY_SYN";
    private static final String TP_SEQ_SYMBOL = "SEQ_SYMBOL";
    private static final String TP_SEQ_ACCESSION = "SEQ_ACCESSION";
    private static final String TP_SEQ_ACCESSION_SOURCE = "SEQ_ACCESSION_SOURCE";
    private static final String TP_SEQ_ANNOTATION_DESC = "SEQ_ANNOTATION_DESC";
    private static final String TP_SEQ_ANNOTATION_REF = "SEQ_ANNOTATION_REF";
    private static final String TP_SEQ_MOL_SEQ = "SEQ_MOL_SEQ";
    private static final String TP_SEQ_NAME = "SEQ_NAME";
    private static final String TP_NODE_NAME = "NODE_NAME";
    private static final Pattern NODENAME_SEQNUMBER_TAXDOMAINNUMBER = Pattern.compile("^([a-fA-Z0-9]{1,5})_([A-Z0-9]{2,4}[A-Z])(\\d{1,4})$");
    public static final boolean SANITIZE = false;
    public static final boolean VERBOSE = true;

    private PhylogenyDecorator() {
    }

    public static void decorate(Phylogeny phylogeny, Map<String, Map<String, String>> map, boolean picky, int numbers_of_chars_allowed_to_remove_if_not_found_in_map) throws IllegalArgumentException {
        PhylogenyNodeIterator iter = phylogeny.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            String name = node.getNodeName();
            if (ForesterUtil.isEmpty(name)) continue;
            if (map.containsKey(name) || numbers_of_chars_allowed_to_remove_if_not_found_in_map > 0) {
                Annotation ann;
                Map<String, String> new_values = map.get(name);
                int x = 0;
                while (new_values == null && numbers_of_chars_allowed_to_remove_if_not_found_in_map > 0 && x <= numbers_of_chars_allowed_to_remove_if_not_found_in_map) {
                    new_values = map.get(name.substring(0, name.length() - x));
                    ++x;
                }
                if (new_values == null) continue;
                if (new_values.containsKey(TP_TAXONOMY_CODE)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setTaxonomyCode(new_values.get(TP_TAXONOMY_CODE));
                }
                if (new_values.containsKey(TP_TAXONOMY_ID) && new_values.containsKey(TP_TAXONOMY_ID_PROVIDER)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setIdentifier(new Identifier(new_values.get(TP_TAXONOMY_ID), new_values.get(TP_TAXONOMY_ID_PROVIDER)));
                } else if (new_values.containsKey(TP_TAXONOMY_ID)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setIdentifier(new Identifier(new_values.get(TP_TAXONOMY_ID)));
                }
                if (new_values.containsKey(TP_TAXONOMY_SN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setScientificName(new_values.get(TP_TAXONOMY_SN));
                }
                if (new_values.containsKey(TP_TAXONOMY_CN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().setCommonName(new_values.get(TP_TAXONOMY_CN));
                }
                if (new_values.containsKey(TP_TAXONOMY_SYN)) {
                    ForesterUtil.ensurePresenceOfTaxonomy(node);
                    node.getNodeData().getTaxonomy().getSynonyms().add(new_values.get(TP_TAXONOMY_SYN));
                }
                if (new_values.containsKey(TP_SEQ_ACCESSION) && new_values.containsKey(TP_SEQ_ACCESSION_SOURCE)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    node.getNodeData().getSequence().setAccession(new Accession(new_values.get(TP_SEQ_ACCESSION), new_values.get(TP_SEQ_ACCESSION_SOURCE)));
                }
                if (new_values.containsKey(TP_SEQ_ANNOTATION_DESC)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    ann = new Annotation();
                    ann.setDesc(new_values.get(TP_SEQ_ANNOTATION_DESC));
                    node.getNodeData().getSequence().addAnnotation(ann);
                }
                if (new_values.containsKey(TP_SEQ_ANNOTATION_REF)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    ann = new Annotation();
                    ann.setRef(new_values.get(TP_SEQ_ANNOTATION_REF));
                    node.getNodeData().getSequence().addAnnotation(ann);
                }
                if (new_values.containsKey(TP_SEQ_SYMBOL)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    node.getNodeData().getSequence().setSymbol(new_values.get(TP_SEQ_SYMBOL));
                }
                if (new_values.containsKey(TP_SEQ_NAME)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    node.getNodeData().getSequence().setName(new_values.get(TP_SEQ_NAME));
                }
                if (new_values.containsKey(TP_SEQ_MOL_SEQ)) {
                    ForesterUtil.ensurePresenceOfSequence(node);
                    node.getNodeData().getSequence().setMolecularSequence(new_values.get(TP_SEQ_MOL_SEQ));
                }
                if (!new_values.containsKey(TP_NODE_NAME)) continue;
                node.setName(new_values.get(TP_NODE_NAME));
                continue;
            }
            if (!picky) continue;
            throw new IllegalArgumentException("\"" + name + "\" not found in name map");
        }
    }

    public static void decorate(Phylogeny phylogeny, Map<String, String> map, FIELD field, boolean extract_bracketed_scientific_name, boolean picky, boolean cut_name_after_space, boolean process_name_intelligently, boolean process_similar_to, int numbers_of_chars_allowed_to_remove_if_not_found_in_map, boolean move_domain_numbers_at_end_to_middle) throws IllegalArgumentException, NHXFormatException {
        PhylogenyDecorator.decorate(phylogeny, map, field, extract_bracketed_scientific_name, picky, null, cut_name_after_space, process_name_intelligently, process_similar_to, numbers_of_chars_allowed_to_remove_if_not_found_in_map, move_domain_numbers_at_end_to_middle);
    }

    public static void decorate(Phylogeny phylogeny, Map<String, String> map, FIELD field, boolean extract_bracketed_scientific_name, boolean picky, Map<String, String> intermediate_map, boolean cut_name_after_space, boolean process_name_intelligently, boolean process_similar_to, int numbers_of_chars_allowed_to_remove_if_not_found_in_map, boolean move_domain_numbers_at_end_to_middle) throws IllegalArgumentException {
        if (extract_bracketed_scientific_name && field == FIELD.TAXONOMY_SCIENTIFIC_NAME) {
            throw new IllegalArgumentException("Attempt to extract bracketed scientific name together with data field pointing to scientific name");
        }
        PhylogenyNodeIterator iter = phylogeny.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            String name = node.getNodeName();
            if (ForesterUtil.isEmpty(name)) continue;
            if (intermediate_map != null) {
                name = PhylogenyDecorator.extractIntermediate(intermediate_map, name);
            }
            if (map.containsKey(name) || numbers_of_chars_allowed_to_remove_if_not_found_in_map > 0) {
                String new_value = map.get(name);
                int x = 0;
                while (new_value == null && numbers_of_chars_allowed_to_remove_if_not_found_in_map > 0 && x <= numbers_of_chars_allowed_to_remove_if_not_found_in_map) {
                    new_value = map.get(name.substring(0, name.length() - x));
                    ++x;
                }
                if (new_value == null) continue;
                new_value = new_value.trim();
                new_value.replaceAll("/\\s+/", " ");
                if (extract_bracketed_scientific_name && new_value.endsWith("]")) {
                    PhylogenyDecorator.extractBracketedScientificNames(node, new_value);
                }
                switch (field) {
                    case SEQUENCE_ANNOTATION_DESC: {
                        System.out.println(String.valueOf(name) + ": " + new_value);
                        if (!node.getNodeData().isHasSequence()) {
                            node.getNodeData().setSequence(new Sequence());
                        }
                        Annotation annotation = new Annotation();
                        annotation.setDesc(new_value);
                        node.getNodeData().getSequence().addAnnotation(annotation);
                        break;
                    }
                    case DOMAIN_STRUCTURE: {
                        System.out.println(String.valueOf(name) + ": " + new_value);
                        if (!node.getNodeData().isHasSequence()) {
                            node.getNodeData().setSequence(new Sequence());
                        }
                        node.getNodeData().getSequence().setDomainArchitecture(new DomainArchitecture(new_value));
                        break;
                    }
                    case TAXONOMY_CODE: {
                        System.out.println(String.valueOf(name) + ": " + new_value);
                        ForesterUtil.ensurePresenceOfTaxonomy(node);
                        node.getNodeData().getTaxonomy().setTaxonomyCode(new_value);
                        break;
                    }
                    case TAXONOMY_SCIENTIFIC_NAME: {
                        System.out.println(String.valueOf(name) + ": " + new_value);
                        ForesterUtil.ensurePresenceOfTaxonomy(node);
                        node.getNodeData().getTaxonomy().setScientificName(new_value);
                        break;
                    }
                    case SEQUENCE_NAME: {
                        System.out.println(String.valueOf(name) + ": " + new_value);
                        if (!node.getNodeData().isHasSequence()) {
                            node.getNodeData().setSequence(new Sequence());
                        }
                        node.getNodeData().getSequence().setName(new_value);
                        break;
                    }
                    case NODE_NAME: {
                        System.out.print(String.valueOf(name) + " -> ");
                        if (cut_name_after_space) {
                            System.out.print(String.valueOf(new_value) + " -> ");
                            new_value = PhylogenyDecorator.deleteAtFirstSpace(new_value);
                        } else if (process_name_intelligently) {
                            System.out.print(String.valueOf(new_value) + " -> ");
                            new_value = PhylogenyDecorator.processNameIntelligently(new_value);
                        } else if (process_similar_to) {
                            System.out.print(String.valueOf(new_value) + " -> ");
                            new_value = PhylogenyDecorator.processSimilarTo(new_value);
                        }
                        System.out.println(new_value);
                        node.setName(new_value);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown field \"" + (Object)((Object)field) + "\"");
                    }
                }
                if (!move_domain_numbers_at_end_to_middle || field == FIELD.NODE_NAME) continue;
                node.setName(PhylogenyDecorator.moveDomainNumbersAtEnd(node.getNodeName()));
                continue;
            }
            if (!picky) continue;
            throw new IllegalArgumentException("\"" + name + "\" not found in name map");
        }
    }

    public static void decorate(Phylogeny[] phylogenies, Map<String, Map<String, String>> map, boolean picky, int numbers_of_chars_allowed_to_remove_if_not_found_in_map) throws IllegalArgumentException, NHXFormatException {
        int i = 0;
        while (i < phylogenies.length) {
            PhylogenyDecorator.decorate(phylogenies[i], map, picky, numbers_of_chars_allowed_to_remove_if_not_found_in_map);
            ++i;
        }
    }

    public static void decorate(Phylogeny[] phylogenies, Map<String, String> map, FIELD field, boolean extract_bracketed_scientific_name, boolean picky, boolean cut_name_after_space, boolean process_name_intelligently, boolean process_similar_to, int numbers_of_chars_allowed_to_remove_if_not_found_in_map, boolean move_domain_numbers_at_end_to_middle) throws IllegalArgumentException, NHXFormatException {
        int i = 0;
        while (i < phylogenies.length) {
            PhylogenyDecorator.decorate(phylogenies[i], map, field, extract_bracketed_scientific_name, picky, cut_name_after_space, process_name_intelligently, process_similar_to, numbers_of_chars_allowed_to_remove_if_not_found_in_map, move_domain_numbers_at_end_to_middle);
            ++i;
        }
    }

    public static void decorate(Phylogeny[] phylogenies, Map<String, String> map, FIELD field, boolean extract_bracketed_scientific_name, boolean picky, Map<String, String> intermediate_map, boolean cut_name_after_space, boolean process_name_intelligently, boolean process_similar_to, int numbers_of_chars_allowed_to_remove_if_not_found_in_map, boolean move_domain_numbers_at_end_to_middle) throws IllegalArgumentException, NHXFormatException {
        int i = 0;
        while (i < phylogenies.length) {
            PhylogenyDecorator.decorate(phylogenies[i], map, field, extract_bracketed_scientific_name, picky, intermediate_map, cut_name_after_space, process_name_intelligently, process_similar_to, numbers_of_chars_allowed_to_remove_if_not_found_in_map, move_domain_numbers_at_end_to_middle);
            ++i;
        }
    }

    private static String deleteAtFirstSpace(String name) {
        int first_space = name.indexOf(" ");
        if (first_space > 1) {
            return name.substring(0, first_space).trim();
        }
        return name;
    }

    private static void extractBracketedScientificNames(PhylogenyNode node, String new_value) {
        int i = new_value.lastIndexOf("[");
        String scientific_name = new_value.substring(i + 1, new_value.length() - 1);
        ForesterUtil.ensurePresenceOfTaxonomy(node);
        node.getNodeData().getTaxonomy().setScientificName(scientific_name);
    }

    private static String extractIntermediate(Map<String, String> intermediate_map, String name) {
        String new_name = null;
        System.out.print(String.valueOf(name) + " => ");
        if (intermediate_map.containsKey(name)) {
            new_name = intermediate_map.get(name);
            if (ForesterUtil.isEmpty(new_name)) {
                throw new IllegalArgumentException("\"" + name + "\" maps to null or empty string in secondary map");
            }
        } else {
            throw new IllegalArgumentException("\"" + name + "\" not found in name secondary map");
        }
        System.out.println(String.valueOf(new_name) + "  ");
        return new_name;
    }

    private static String moveDomainNumbersAtEnd(String node_name) {
        Matcher m = NODENAME_SEQNUMBER_TAXDOMAINNUMBER.matcher(node_name);
        if (m.matches()) {
            String seq_number = m.group(1);
            String tax = m.group(2);
            String domain_number = m.group(3);
            return String.valueOf(seq_number) + "_[" + domain_number + "]_" + tax;
        }
        return node_name;
    }

    public static Map<String, Map<String, String>> parseMappingTable(File mapping_table_file) throws IOException {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        BasicTable<String> mapping_table = null;
        mapping_table = BasicTableParser.parse(mapping_table_file, "\t", false);
        int row = 0;
        while (row < mapping_table.getNumberOfRows()) {
            HashMap<String, String> row_map = new HashMap<String, String>();
            String name = null;
            int col = 0;
            while (col < mapping_table.getNumberOfColumns()) {
                String table_cell = mapping_table.getValue(col, row);
                if (col == 0) {
                    name = table_cell;
                } else if (table_cell != null) {
                    String key = table_cell.substring(0, table_cell.indexOf(58));
                    String val = table_cell.substring(table_cell.indexOf(58) + 1, table_cell.length());
                    row_map.put(key, val);
                }
                ++col;
            }
            map.put(name, row_map);
            ++row;
        }
        return map;
    }

    private static String processNameIntelligently(String name) {
        String[] s = name.split(" ");
        if (s.length < 2) {
            return name;
        }
        if (s[0].indexOf("_") > 0 && s[0].indexOf("|") > 0) {
            return s[0];
        }
        if (s[1].indexOf("_") > 0 && s[1].indexOf("|") > 0) {
            return s[1];
        }
        if (s[0].indexOf("_") > 0 && s[0].indexOf(".") > 0) {
            return s[0];
        }
        if (s[1].indexOf("_") > 0 && s[1].indexOf(".") > 0) {
            return s[1];
        }
        if (s[0].indexOf("_") > 0) {
            return s[0];
        }
        if (s[1].indexOf("_") > 0) {
            return s[1];
        }
        return s[0];
    }

    private static String processSimilarTo(String name) {
        int i = name.toLowerCase().indexOf("similar to");
        String similar_to = "";
        if (i >= 0) {
            similar_to = " similarity=" + name.substring(i + 10).trim();
        }
        String pi = PhylogenyDecorator.processNameIntelligently(name);
        return String.valueOf(pi) + similar_to;
    }

    private static String sanitize(String s) {
        s = s.replace(' ', '_');
        s = s.replace('(', '{');
        s = s.replace(')', '}');
        s = s.replace('[', '{');
        s = s.replace(']', '}');
        s = s.replace(',', '_');
        return s;
    }

    public static enum FIELD {
        NODE_NAME,
        SEQUENCE_ANNOTATION_DESC,
        DOMAIN_STRUCTURE,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME,
        SEQUENCE_NAME;

    }
}

