/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public final class ForesterUtil {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String JAVA_VENDOR = System.getProperty("java.vendor");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final double ZERO_DIFF = 1.0E-9;
    public static final BigDecimal NULL_BD = new BigDecimal(0);
    public static final NumberFormat FORMATTER_9;
    public static final NumberFormat FORMATTER_6;
    public static final NumberFormat FORMATTER_06;
    public static final NumberFormat FORMATTER_3;

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        FORMATTER_9 = new DecimalFormat("#.#########", dfs);
        FORMATTER_6 = new DecimalFormat("#.######", dfs);
        FORMATTER_06 = new DecimalFormat("0.######", dfs);
        FORMATTER_3 = new DecimalFormat("#.###", dfs);
    }

    private ForesterUtil() {
    }

    public static final void appendSeparatorIfNotEmpty(StringBuffer sb, char separator) {
        if (sb.length() > 0) {
            sb.append(separator);
        }
    }

    public static final Color calcColor(double value, double min, double max, Color minColor, Color maxColor) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        double x = ForesterUtil.calculateColorFactor(value, max, min);
        int red = ForesterUtil.calculateColorComponent(minColor.getRed(), maxColor.getRed(), x);
        int green = ForesterUtil.calculateColorComponent(minColor.getGreen(), maxColor.getGreen(), x);
        int blue = ForesterUtil.calculateColorComponent(minColor.getBlue(), maxColor.getBlue(), x);
        return new Color(red, green, blue);
    }

    public static final Color calcColor(double value, double min, double max, double mean, Color minColor, Color maxColor, Color meanColor) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        if (value < mean) {
            double x = ForesterUtil.calculateColorFactor(value, mean, min);
            int red = ForesterUtil.calculateColorComponent(minColor.getRed(), meanColor.getRed(), x);
            int green = ForesterUtil.calculateColorComponent(minColor.getGreen(), meanColor.getGreen(), x);
            int blue = ForesterUtil.calculateColorComponent(minColor.getBlue(), meanColor.getBlue(), x);
            return new Color(red, green, blue);
        }
        if (value > mean) {
            double x = ForesterUtil.calculateColorFactor(value, max, mean);
            int red = ForesterUtil.calculateColorComponent(meanColor.getRed(), maxColor.getRed(), x);
            int green = ForesterUtil.calculateColorComponent(meanColor.getGreen(), maxColor.getGreen(), x);
            int blue = ForesterUtil.calculateColorComponent(meanColor.getBlue(), maxColor.getBlue(), x);
            return new Color(red, green, blue);
        }
        return meanColor;
    }

    private static final int calculateColorComponent(double smallercolor_component_x, double largercolor_component_x, double x) {
        return (int)(smallercolor_component_x + x * (largercolor_component_x - smallercolor_component_x) / 255.0);
    }

    private static final double calculateColorFactor(double value, double larger, double smaller) {
        return 255.0 * (value - smaller) / (larger - smaller);
    }

    public static final String collapseWhiteSpace(String s) {
        return s.replaceAll("[\\s]+", " ");
    }

    public static final String colorToHex(Color color) {
        String rgb = Integer.toHexString(color.getRGB());
        return rgb.substring(2, rgb.length());
    }

    public static final int countChars(String str, char c) {
        int count = 0;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static final BufferedWriter createBufferedWriter(File file) throws IOException {
        if (file.exists()) {
            throw new IOException("[" + file + "] already exists");
        }
        return new BufferedWriter(new FileWriter(file));
    }

    public static final BufferedWriter createBufferedWriter(String name) throws IOException {
        return new BufferedWriter(new FileWriter(ForesterUtil.createFileForWriting(name)));
    }

    public static final File createFileForWriting(String name) throws IOException {
        File file = new File(name);
        if (file.exists()) {
            throw new IOException("[" + name + "] already exists");
        }
        return file;
    }

    public static final PhylogenyParser createParserDependingFileContents(File file, boolean phyloxml_validate_against_xsd) throws FileNotFoundException, IOException {
        PhylogenyParser parser = null;
        String first_line = ForesterUtil.getFirstLine(file).trim().toLowerCase();
        if (first_line.startsWith("<")) {
            ClassLoader cl;
            URL xsd_url;
            parser = new PhyloXmlParser();
            if (phyloxml_validate_against_xsd && (xsd_url = (cl = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)parser).setValidateAgainstSchema(xsd_url.toString());
            }
        } else {
            parser = first_line.startsWith("nexus") || first_line.startsWith("#nexus") || first_line.startsWith("# nexus") || first_line.startsWith("begin") ? new NexusPhylogeniesParser() : new NHXParser();
        }
        return parser;
    }

    public static final PhylogenyParser createParserDependingOnFileType(File file, boolean phyloxml_validate_against_xsd) throws FileNotFoundException, IOException {
        PhylogenyParser parser = null;
        parser = ForesterUtil.createParserDependingOnSuffix(file.getName(), phyloxml_validate_against_xsd);
        if (parser == null) {
            parser = ForesterUtil.createParserDependingFileContents(file, phyloxml_validate_against_xsd);
        }
        return parser;
    }

    public static final PhylogenyParser createParserDependingOnSuffix(String filename, boolean phyloxml_validate_against_xsd) {
        PhylogenyParser parser = null;
        String filename_lc = filename.toLowerCase();
        if (filename_lc.endsWith(".tol") || filename_lc.endsWith(".tolxml") || filename_lc.endsWith(".tol.zip")) {
            parser = new TolParser();
        } else if (filename_lc.endsWith(".xml") || filename_lc.endsWith(".px") || filename_lc.endsWith("phyloxml") || filename_lc.endsWith(".zip")) {
            ClassLoader cl;
            URL xsd_url;
            parser = new PhyloXmlParser();
            if (phyloxml_validate_against_xsd && (xsd_url = (cl = PhyloXmlParser.class.getClassLoader()).getResource("resources/phyloxml.xsd")) != null) {
                ((PhyloXmlParser)parser).setValidateAgainstSchema(xsd_url.toString());
            }
        } else if (filename_lc.endsWith(".nexus") || filename_lc.endsWith(".nex") || filename_lc.endsWith(".nx")) {
            parser = new NexusPhylogeniesParser();
        } else if (filename_lc.endsWith(".nhx") || filename_lc.endsWith(".nh") || filename_lc.endsWith(".newick")) {
            parser = new NHXParser();
        }
        return parser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PhylogenyParser createParserDependingOnUrlContents(URL url, boolean phyloxml_validate_against_xsd) throws FileNotFoundException, IOException {
        String lc_filename = url.getFile().toString().toLowerCase();
        PhylogenyParser parser = ForesterUtil.createParserDependingOnSuffix(lc_filename, phyloxml_validate_against_xsd);
        if (parser != null && lc_filename.endsWith(".zip")) {
            if (parser instanceof PhyloXmlParser) {
                ((PhyloXmlParser)parser).setZippedInputstream(true);
            } else if (parser instanceof TolParser) {
                ((TolParser)parser).setZippedInputstream(true);
            }
        }
        if (parser != null) return parser;
        String first_line = ForesterUtil.getFirstLine(url).trim().toLowerCase();
        if (!first_line.startsWith("<")) {
            if (first_line.startsWith("nexus")) return new NexusPhylogeniesParser();
            if (first_line.startsWith("#nexus")) return new NexusPhylogeniesParser();
            if (first_line.startsWith("# nexus")) return new NexusPhylogeniesParser();
            if (!first_line.startsWith("begin")) return new NHXParser();
            return new NexusPhylogeniesParser();
        }
        parser = new PhyloXmlParser();
        if (!phyloxml_validate_against_xsd) return parser;
        ClassLoader cl = PhyloXmlParser.class.getClassLoader();
        URL xsd_url = cl.getResource("resources/phyloxml.xsd");
        if (xsd_url == null) throw new IllegalStateException("failed to get URL for phyloXML XSD from jar file from [resources/phyloxml.xsd]");
        ((PhyloXmlParser)parser).setValidateAgainstSchema(xsd_url.toString());
        return parser;
    }

    public static final void ensurePresenceOfDate(PhylogenyNode node) {
        if (!node.getNodeData().isHasDate()) {
            node.getNodeData().setDate(new org.forester.phylogeny.data.Date());
        }
    }

    public static final void ensurePresenceOfDistribution(PhylogenyNode node) {
        if (!node.getNodeData().isHasDistribution()) {
            node.getNodeData().setDistribution(new Distribution(""));
        }
    }

    public static void ensurePresenceOfSequence(PhylogenyNode node) {
        if (!node.getNodeData().isHasSequence()) {
            node.getNodeData().setSequence(new Sequence());
        }
    }

    public static void ensurePresenceOfTaxonomy(PhylogenyNode node) {
        if (!node.getNodeData().isHasTaxonomy()) {
            node.getNodeData().setTaxonomy(new Taxonomy());
        }
    }

    public static void fatalError(String prg_name, String message) {
        System.err.println();
        System.err.println("[" + prg_name + "] > " + message);
        System.err.println();
        System.exit(-1);
    }

    public static String[] file2array(File file) throws IOException {
        List<String> list = ForesterUtil.file2list(file);
        String[] ary = new String[list.size()];
        int i = 0;
        for (String s : list) {
            ary[i++] = s;
        }
        return ary;
    }

    public static final List<String> file2list(File file) throws IOException {
        String str;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if ((str = str.trim()).length() <= 0 || str.startsWith("#")) continue;
            String[] stringArray = ForesterUtil.splitString(str);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                list.add(s);
                ++n2;
            }
        }
        in.close();
        return list;
    }

    public static final SortedSet<String> file2set(File file) throws IOException {
        String str;
        TreeSet<String> set = new TreeSet<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if ((str = str.trim()).length() <= 0 || str.startsWith("#")) continue;
            String[] stringArray = ForesterUtil.splitString(str);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                set.add(s);
                ++n2;
            }
        }
        in.close();
        return set;
    }

    public static final String getCurrentDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return format.format(new Date());
    }

    public static final String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final String getFirstLine(Object source) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = null;
        if (source instanceof File) {
            File f = (File)source;
            if (!f.exists()) {
                throw new IOException("[" + f.getAbsolutePath() + "] does not exist");
            }
            if (!f.isFile()) {
                throw new IOException("[" + f.getAbsolutePath() + "] is not a file");
            }
            if (!f.canRead()) {
                throw new IOException("[" + f.getAbsolutePath() + "] is not a readable");
            }
            reader = new BufferedReader(new FileReader(f));
        } else if (source instanceof InputStream) {
            reader = new BufferedReader(new InputStreamReader((InputStream)source));
        } else if (source instanceof String) {
            reader = new BufferedReader(new StringReader((String)source));
        } else if (source instanceof StringBuffer) {
            reader = new BufferedReader(new StringReader(source.toString()));
        } else {
            if (!(source instanceof URL)) {
                throw new IllegalArgumentException("dont know how to read [" + source.getClass() + "]");
            }
            reader = new BufferedReader(new InputStreamReader(((URL)source).openStream()));
        }
        while ((line = reader.readLine()) != null) {
            if (ForesterUtil.isEmpty(line = line.trim())) continue;
            if (reader != null) {
                reader.close();
            }
            return line;
        }
        if (reader != null) {
            reader.close();
        }
        return line;
    }

    public static final String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static final Hashtable<String, Boolean> getPropertyRefs(Phylogeny phylogeny) {
        Hashtable<String, Boolean> ht = new Hashtable<String, Boolean>();
        if (phylogeny.isEmpty()) {
            return ht;
        }
        PhylogenyNodeIterator iter = phylogeny.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode current_node = iter.next();
            if (!current_node.getNodeData().isHasProperties()) continue;
            String[] tags = current_node.getNodeData().getProperties().getPropertyRefs();
            int i = 0;
            while (i < tags.length) {
                ht.put(tags[i], new Boolean(false));
                ++i;
            }
        }
        return ht;
    }

    public static final void increaseCountingMap(Map<String, Integer> counting_map, String item_name) {
        if (!counting_map.containsKey(item_name)) {
            counting_map.put(item_name, 1);
        } else {
            counting_map.put(item_name, counting_map.get(item_name) + 1);
        }
    }

    public static final boolean isAllNonEmptyInternalLabelsArePositiveNumbers(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isRoot() || n.isExternal() || ForesterUtil.isEmpty(n.getNodeName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(n.getNodeName());
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (!(d < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() < 1;
    }

    public static final boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static final boolean isEven(int n) {
        return n % 2 == 0;
    }

    public static final boolean isHasAtLeastNodeWithEvent(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            if (!it.next().getNodeData().isHasEvent()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchLengthLargerThanZero(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            if (!(it.next().getDistanceToParent() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isHasAtLeastOneBranchWithSupportValues(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            if (!it.next().getBranchData().isHasConfidences()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isIntersecting(String[] a, String[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length < 1 || b.length < 1) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            String ai = a[i];
            int j = 0;
            while (j < b.length) {
                if (ai != null && b[j] != null && ai.equals(b[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static final double isLargerOrEqualToZero(double d) {
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    public static final boolean isNull(BigDecimal s) {
        return s == null || s.compareTo(NULL_BD) == 0;
    }

    public static final String isReadableFile(File f) {
        if (!f.exists()) {
            return "file [" + f + "] does not exist";
        }
        if (f.isDirectory()) {
            return "[" + f + "] is a directory";
        }
        if (!f.isFile()) {
            return "[" + f + "] is not a file";
        }
        if (!f.canRead()) {
            return "file [" + f + "] is not readable";
        }
        if (f.length() < 1L) {
            return "file [" + f + "] is empty";
        }
        return null;
    }

    public static final String isReadableFile(String s) {
        return ForesterUtil.isReadableFile(new File(s));
    }

    public static final String isWritableFile(File f) {
        if (f.isDirectory()) {
            return "[" + f + "] is a directory";
        }
        if (f.exists()) {
            return "[" + f + "] already exists";
        }
        return null;
    }

    public static final String wordWrap(String str, int width) {
        StringBuilder sb = new StringBuilder(str);
        int start = 0;
        int ls = -1;
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == ' ') {
                ls = i;
            }
            if (sb.charAt(i) == '\n') {
                ls = -1;
                start = i + 1;
            }
            if (i > start + width - 1) {
                if (ls != -1) {
                    sb.setCharAt(ls, '\n');
                    start = ls + 1;
                    ls = -1;
                } else {
                    sb.insert(i, '\n');
                    start = i + 1;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static final int limitRangeForColor(int i) {
        if (i > 255) {
            i = 255;
        } else if (i < 0) {
            i = 0;
        }
        return i;
    }

    public static final SortedMap<Object, Integer> listToSortedCountsMap(List list) {
        TreeMap<Object, Integer> map = new TreeMap<Object, Integer>();
        for (Object key : list) {
            if (!map.containsKey(key)) {
                map.put(key, 1);
                continue;
            }
            map.put(key, (Integer)map.get(key) + 1);
        }
        return map;
    }

    public static final StringBuffer mapToStringBuffer(Map map, String key_value_separator) {
        StringBuffer sb = new StringBuffer();
        for (Object key : map.keySet()) {
            sb.append(key.toString());
            sb.append(key_value_separator);
            sb.append(map.get(key).toString());
            sb.append(ForesterUtil.getLineSeparator());
        }
        return sb;
    }

    public static final String normalizeString(String s, int length, boolean left_pad, char pad_char) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        StringBuffer pad = new StringBuffer(length - s.length());
        int i = 0;
        while (i < length - s.length()) {
            pad.append(pad_char);
            ++i;
        }
        if (left_pad) {
            return pad + s;
        }
        return String.valueOf(s) + pad;
    }

    public static final BufferedReader obtainReader(Object source) throws IOException, FileNotFoundException {
        BufferedReader reader = null;
        if (source instanceof File) {
            File f = (File)source;
            if (!f.exists()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" does not exist");
            }
            if (!f.isFile()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" is not a file");
            }
            if (!f.canRead()) {
                throw new IOException("\"" + f.getAbsolutePath() + "\" is not a readable");
            }
            reader = new BufferedReader(new FileReader(f));
        } else if (source instanceof InputStream) {
            reader = new BufferedReader(new InputStreamReader((InputStream)source));
        } else if (source instanceof String) {
            reader = new BufferedReader(new StringReader((String)source));
        } else if (source instanceof StringBuffer) {
            reader = new BufferedReader(new StringReader(source.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + source.getClass() + "] (can only parse objects of type File, InputStream, String, or StringBuffer)");
        }
        return reader;
    }

    public static final StringBuffer pad(double number, int size, char pad, boolean left_pad) {
        return ForesterUtil.pad(new StringBuffer(String.valueOf(number)), size, pad, left_pad);
    }

    public static final StringBuffer pad(String string, int size, char pad, boolean left_pad) {
        return ForesterUtil.pad(new StringBuffer(string), size, pad, left_pad);
    }

    public static final StringBuffer pad(StringBuffer string, int size, char pad, boolean left_pad) {
        StringBuffer padding = new StringBuffer();
        int s = size - string.length();
        if (s < 1) {
            return new StringBuffer(string.substring(0, size));
        }
        int i = 0;
        while (i < s) {
            padding.append(pad);
            ++i;
        }
        if (left_pad) {
            return padding.append(string);
        }
        return string.append(padding);
    }

    public static final double parseDouble(String str) throws ParseException {
        if (ForesterUtil.isEmpty(str)) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public static final int parseInt(String str) throws ParseException {
        if (ForesterUtil.isEmpty(str)) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public static final void postOrderRelabelInternalNodes(Phylogeny phylogeny, int starting_number) {
        int i = starting_number;
        PhylogenyNodeIterator it = phylogeny.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode node = it.next();
            if (node.isExternal()) continue;
            node.setName(String.valueOf(i++));
        }
    }

    public static final void printArray(Object[] a) {
        int i = 0;
        while (i < a.length) {
            System.out.println("[" + i + "]=" + a[i]);
            ++i;
        }
    }

    public static final void printCountingMap(Map<String, Integer> counting_map) {
        for (String key : counting_map.keySet()) {
            System.out.println(String.valueOf(key) + ": " + counting_map.get(key));
        }
    }

    public static final void printErrorMessage(String prg_name, String message) {
        System.out.println("[" + prg_name + "] > error: " + message);
    }

    public static final void printProgramInformation(String prg_name, String prg_version, String date) {
        int l = prg_name.length() + prg_version.length() + date.length() + 4;
        System.out.println();
        System.out.println(String.valueOf(prg_name) + " " + prg_version + " (" + date + ")");
        int i = 0;
        while (i < l) {
            System.out.print("_");
            ++i;
        }
        System.out.println();
    }

    public static final void printProgramInformation(String prg_name, String prg_version, String date, String email, String www) {
        int l = prg_name.length() + prg_version.length() + date.length() + 4;
        System.out.println();
        System.out.println(String.valueOf(prg_name) + " " + prg_version + " (" + date + ")");
        int i = 0;
        while (i < l) {
            System.out.print("_");
            ++i;
        }
        System.out.println();
        System.out.println();
        System.out.println("WWW    : " + www);
        System.out.println("Contact: " + email);
        if (!ForesterUtil.isEmpty(JAVA_VERSION) && !ForesterUtil.isEmpty(JAVA_VENDOR)) {
            System.out.println();
            System.out.println("[running on Java " + JAVA_VERSION + " " + JAVA_VENDOR + "]");
        }
        System.out.println();
    }

    public static final void printWarningMessage(String prg_name, String message) {
        System.out.println("[" + prg_name + "] > warning: " + message);
    }

    public static final void programMessage(String prg_name, String message) {
        System.out.println("[" + prg_name + "] > " + message);
    }

    public static final String removeSuffix(String file_name) {
        int i = file_name.lastIndexOf(46);
        if (i > 1) {
            return file_name.substring(0, i);
        }
        return file_name;
    }

    public static final String removeWhiteSpace(String s) {
        int i = 0;
        while (i <= s.length() - 1) {
            if (s.charAt(i) == ' ' || s.charAt(i) == '\t' || s.charAt(i) == '\n' || s.charAt(i) == '\r') {
                s = String.valueOf(s.substring(0, i)) + s.substring(i + 1);
                --i;
            }
            ++i;
        }
        return s;
    }

    public static final String replaceIllegalNhCharacters(String nh) {
        if (nh == null) {
            return "";
        }
        return nh.trim().replaceAll("[\\[\\](),:;\\s]+", "_");
    }

    public static final String replaceIllegalNhxCharacters(String nhx) {
        if (nhx == null) {
            return "";
        }
        return nhx.trim().replaceAll("[\\[\\](),:;\\s]+", "_");
    }

    public static final double round(double value, int decimal_place) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(decimal_place, 4);
        return bd.doubleValue();
    }

    public static final int roundToInt(double d) {
        return (int)(d + 0.5);
    }

    public static final int roundToInt(float f) {
        return (int)(f + 0.5f);
    }

    public static final String sanitizeString(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    private static final String[] splitString(String str) {
        String regex = "[\\s;,]+";
        return str.split("[\\s;,]+");
    }

    public static final String stringArrayToString(String[] a) {
        StringBuffer sb = new StringBuffer();
        if (a != null && a.length > 0) {
            int i = 0;
            while (i < a.length - 1) {
                sb.append(String.valueOf(a[i]) + ", ");
                ++i;
            }
            sb.append(a[a.length - 1]);
        }
        return sb.toString();
    }

    public static final void transferInternalNamesToBootstrapSupport(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isExternal() || ForesterUtil.isEmpty(n.getNodeName())) continue;
            double value = -1.0;
            try {
                value = Double.parseDouble(n.getNodeName());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse number from [" + n.getNodeName() + "]: " + e.getLocalizedMessage());
            }
            if (!(value >= 0.0)) continue;
            n.getBranchData().addConfidence(new Confidence(value, "bootstrap"));
            n.setName("");
        }
    }

    public static final void transferInternalNodeNamesToConfidence(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isRoot() || n.isExternal() || n.getBranchData().isHasConfidences() || ForesterUtil.isEmpty(n.getNodeName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(n.getNodeName());
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (!(d >= 0.0)) continue;
            n.getBranchData().addConfidence(new Confidence(d, ""));
            n.setName("");
        }
    }

    public static final void transferNodeNameToField(Phylogeny phy, PhylogenyNodeField field) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            String name = n.getNodeName().trim();
            if (ForesterUtil.isEmpty(name)) continue;
            switch (field) {
                case TAXONOMY_CODE: {
                    n.setName("");
                    PhylogenyMethods.setTaxonomyCode(n, name);
                    break;
                }
                case TAXONOMY_SCIENTIFIC_NAME: {
                    n.setName("");
                    if (!n.getNodeData().isHasTaxonomy()) {
                        n.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    n.getNodeData().getTaxonomy().setScientificName(name);
                    break;
                }
                case TAXONOMY_COMMON_NAME: {
                    n.setName("");
                    if (!n.getNodeData().isHasTaxonomy()) {
                        n.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    n.getNodeData().getTaxonomy().setCommonName(name);
                    break;
                }
                case SEQUENCE_SYMBOL: {
                    n.setName("");
                    if (!n.getNodeData().isHasSequence()) {
                        n.getNodeData().setSequence(new Sequence());
                    }
                    n.getNodeData().getSequence().setSymbol(name);
                    break;
                }
                case SEQUENCE_NAME: {
                    n.setName("");
                    if (!n.getNodeData().isHasSequence()) {
                        n.getNodeData().setSequence(new Sequence());
                    }
                    n.getNodeData().getSequence().setName(name);
                }
            }
        }
    }

    public static final void unexpectedFatalError(String prg_name, Exception e) {
        System.err.println();
        System.err.println("[" + prg_name + "] > unexpected error (Should not have occured! Please contact program author(s).)");
        e.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String prg_name, String message) {
        System.err.println();
        System.err.println("[" + prg_name + "] > unexpected error. Should not have occured! Please contact program author(s).");
        System.err.println(message);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String prg_name, String message, Exception e) {
        System.err.println();
        System.err.println("[" + prg_name + "] > unexpected error. Should not have occured! Please contact program author(s).");
        System.err.println(message);
        e.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static enum PhylogenyNodeField {
        CLADE_NAME,
        TAXONOMY_CODE,
        TAXONOMY_SCIENTIFIC_NAME,
        TAXONOMY_COMMON_NAME,
        SEQUENCE_SYMBOL,
        SEQUENCE_NAME;

    }
}

