/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.storage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava3.core.exceptions.CompoundNotFoundError;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.storage.SequenceAsStringHelper;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceProxyView;
import org.biojava3.core.sequence.template.SequenceReader;
import org.biojava3.core.sequence.template.SequenceView;

public class ArrayListSequenceReader<C extends Compound>
implements SequenceReader<C> {
    private CompoundSet<C> compoundSet;
    private List<C> parsedCompounds = new ArrayList<C>();

    public ArrayListSequenceReader() {
    }

    public ArrayListSequenceReader(List<C> compounds, CompoundSet<C> compoundSet) {
        this.setCompoundSet(compoundSet);
        this.setContents(compounds);
    }

    public ArrayListSequenceReader(String sequence, CompoundSet<C> compoundSet) {
        this.setCompoundSet(compoundSet);
        this.setContents(sequence);
    }

    @Override
    public String getSequenceAsString() {
        return this.getSequenceAsString(1, this.getLength(), Strand.POSITIVE);
    }

    public String getSequenceAsString(Integer begin, Integer end, Strand strand) {
        SequenceAsStringHelper<C> sequenceAsStringHelper = new SequenceAsStringHelper<C>();
        return sequenceAsStringHelper.getSequenceAsString(this.parsedCompounds, this.compoundSet, begin, end, strand);
    }

    @Override
    public List<C> getAsList() {
        return this.parsedCompounds;
    }

    @Override
    public C getCompoundAt(int position) {
        return (C)((Compound)this.parsedCompounds.get(position - 1));
    }

    @Override
    public int getIndexOf(C compound) {
        return this.parsedCompounds.indexOf(compound) + 1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        return this.parsedCompounds.lastIndexOf(compound) + 1;
    }

    @Override
    public int getLength() {
        return this.parsedCompounds.size();
    }

    @Override
    public Iterator<C> iterator() {
        return this.parsedCompounds.iterator();
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        this.compoundSet = compoundSet;
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public void setContents(String sequence) {
        String compoundStr;
        this.parsedCompounds.clear();
        int maxCompoundLength = this.compoundSet.getMaxSingleCompoundStringLength();
        int length = sequence.length();
        for (int i = 0; i < length; i += compoundStr.length()) {
            compoundStr = null;
            Object compound = null;
            for (int compoundStrLength = 1; compound == null && compoundStrLength <= maxCompoundLength; ++compoundStrLength) {
                compoundStr = sequence.substring(i, i + compoundStrLength);
                compound = this.compoundSet.getCompoundForString(compoundStr);
            }
            if (compound == null) {
                throw new CompoundNotFoundError((CharSequence)("Cannot find compound for: " + compoundStr));
            }
            this.parsedCompounds.add(compound);
        }
    }

    public void setContents(List<C> list) {
        this.parsedCompounds.clear();
        for (Compound c : list) {
            this.parsedCompounds.add(c);
        }
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioBegin, Integer bioEnd) {
        return new SequenceProxyView(this, bioBegin, bioEnd);
    }

    @Override
    public AccessionID getAccession() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int countCompounds(C ... compounds) {
        return SequenceMixin.countCompounds((Sequence)this, compounds);
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }
}

