/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.svg.AlignmentBaselineFactory;
import org.apache.batik.css.svg.BaselineShiftFactory;
import org.apache.batik.css.svg.ClipPathFactory;
import org.apache.batik.css.svg.ClipRuleFactory;
import org.apache.batik.css.svg.ColorInterpolationFactory;
import org.apache.batik.css.svg.ColorProfileFactory;
import org.apache.batik.css.svg.ColorRenderingFactory;
import org.apache.batik.css.svg.DominantBaselineFactory;
import org.apache.batik.css.svg.EnableBackgroundFactory;
import org.apache.batik.css.svg.FillRuleFactory;
import org.apache.batik.css.svg.FilterFactory;
import org.apache.batik.css.svg.GlyphOrientationHorizontalFactory;
import org.apache.batik.css.svg.GlyphOrientationVerticalFactory;
import org.apache.batik.css.svg.ImageRenderingFactory;
import org.apache.batik.css.svg.MarkerFactory;
import org.apache.batik.css.svg.MarkerShorthandFactory;
import org.apache.batik.css.svg.MaskFactory;
import org.apache.batik.css.svg.OpacityFactory;
import org.apache.batik.css.svg.PaintFactory;
import org.apache.batik.css.svg.PointerEventsFactory;
import org.apache.batik.css.svg.SVGColorFactory;
import org.apache.batik.css.svg.SVGFontSizeFactory;
import org.apache.batik.css.svg.SVGValueConstants;
import org.apache.batik.css.svg.ShapeRenderingFactory;
import org.apache.batik.css.svg.SimpleColorFactory;
import org.apache.batik.css.svg.StrokeDasharrayFactory;
import org.apache.batik.css.svg.StrokeDashoffsetFactory;
import org.apache.batik.css.svg.StrokeLinecapFactory;
import org.apache.batik.css.svg.StrokeLinejoinFactory;
import org.apache.batik.css.svg.StrokeMiterlimitFactory;
import org.apache.batik.css.svg.StrokeWidthFactory;
import org.apache.batik.css.svg.TextAnchorFactory;
import org.apache.batik.css.svg.TextRenderingFactory;
import org.apache.batik.css.svg.WritingModeFactory;
import org.apache.batik.css.value.CommonValueFactoryMap;
import org.apache.batik.css.value.DefaultSystemColorResolver;
import org.apache.batik.css.value.SystemColorResolver;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.css.sac.Parser;

public class SVGValueFactoryMap
extends CommonValueFactoryMap
implements SVGValueConstants {
    public SVGValueFactoryMap(Parser parser) {
        this(parser, (SystemColorResolver)new DefaultSystemColorResolver());
    }

    public SVGValueFactoryMap(Parser parser, SystemColorResolver systemColorResolver) {
        super(parser, systemColorResolver);
        this.put("alignment-baseline", (ValueFactory)new AlignmentBaselineFactory(parser));
        this.put("baseline-shift", (ValueFactory)new BaselineShiftFactory(parser));
        this.put("clip-path", (ValueFactory)new ClipPathFactory(parser));
        this.put("clip-rule", (ValueFactory)new ClipRuleFactory(parser));
        this.put("color-profile", (ValueFactory)new ColorProfileFactory(parser));
        this.put("color", (ValueFactory)new SVGColorFactory(parser, "color", systemColorResolver));
        this.put("color-interpolation", (ValueFactory)new ColorInterpolationFactory(parser, "color-interpolation"));
        this.put("color-interpolation-filters", (ValueFactory)new ColorInterpolationFactory(parser, "color-interpolation-filters"));
        this.put("color-rendering", (ValueFactory)new ColorRenderingFactory(parser));
        this.put("dominant-baseline", (ValueFactory)new DominantBaselineFactory(parser));
        this.put("enable-background", (ValueFactory)new EnableBackgroundFactory(parser));
        this.put("fill", (ValueFactory)new PaintFactory(parser, "fill", systemColorResolver));
        this.put("fill-opacity", (ValueFactory)new OpacityFactory(parser, "fill-opacity"));
        this.put("fill-rule", (ValueFactory)new FillRuleFactory(parser));
        this.put("filter", (ValueFactory)new FilterFactory(parser));
        this.put("flood-color", (ValueFactory)new SimpleColorFactory(parser, "flood-color", systemColorResolver));
        this.put("flood-opacity", (ValueFactory)new OpacityFactory(parser, "flood-opacity"));
        this.put("font-size", (ValueFactory)new SVGFontSizeFactory(parser));
        this.put("glyph-orientation-horizontal", (ValueFactory)new GlyphOrientationHorizontalFactory(parser));
        this.put("glyph-orientation-vertical", (ValueFactory)new GlyphOrientationVerticalFactory(parser));
        this.put("image-rendering", (ValueFactory)new ImageRenderingFactory(parser));
        this.put("lighting-color", (ValueFactory)new SimpleColorFactory(parser, "lighting-color", systemColorResolver));
        this.put("marker", (ValueFactory)new MarkerShorthandFactory(parser));
        this.put("marker-end", (ValueFactory)new MarkerFactory(parser, "marker-end"));
        this.put("marker-mid", (ValueFactory)new MarkerFactory(parser, "marker-mid"));
        this.put("marker-start", (ValueFactory)new MarkerFactory(parser, "marker-start"));
        this.put("mask", (ValueFactory)new MaskFactory(parser));
        this.put("opacity", (ValueFactory)new OpacityFactory(parser, "opacity"));
        this.put("pointer-events", (ValueFactory)new PointerEventsFactory(parser));
        this.put("shape-rendering", (ValueFactory)new ShapeRenderingFactory(parser));
        this.put("stop-color", (ValueFactory)new SimpleColorFactory(parser, "stop-color", systemColorResolver));
        this.put("stop-opacity", (ValueFactory)new OpacityFactory(parser, "stop-opacity"));
        this.put("stroke", (ValueFactory)new PaintFactory(parser, "stroke", systemColorResolver));
        this.put("stroke-dasharray", (ValueFactory)new StrokeDasharrayFactory(parser));
        this.put("stroke-dashoffset", (ValueFactory)new StrokeDashoffsetFactory(parser));
        this.put("stroke-linecap", (ValueFactory)new StrokeLinecapFactory(parser));
        this.put("stroke-linejoin", (ValueFactory)new StrokeLinejoinFactory(parser));
        this.put("stroke-miterlimit", (ValueFactory)new StrokeMiterlimitFactory(parser));
        this.put("stroke-opacity", (ValueFactory)new OpacityFactory(parser, "stroke-opacity"));
        this.put("stroke-width", (ValueFactory)new StrokeWidthFactory(parser));
        this.put("text-anchor", (ValueFactory)new TextAnchorFactory(parser));
        this.put("text-rendering", (ValueFactory)new TextRenderingFactory(parser));
        this.put("writing-mode", (ValueFactory)new WritingModeFactory(parser));
    }
}

