/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.css.CSSOMStyleSheet;
import org.apache.batik.css.ExtendedLinkStyle;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.svg.SVGStyleElement;

public class SVGOMStyleElement
extends SVGOMElement
implements SVGStyleElement,
ExtendedLinkStyle {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(1);
    protected StyleSheet sheet;

    protected SVGOMStyleElement() {
    }

    public SVGOMStyleElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getLocalName() {
        return "style";
    }

    public StyleSheet getSheet() {
        if (this.sheet == null) {
            if (!this.getType().equals("text/css")) {
                return null;
            }
            DOMImplementationCSS dOMImplementationCSS = (DOMImplementationCSS)this.getOwnerDocument().getImplementation();
            CSSOMStyleSheet cSSOMStyleSheet = (CSSOMStyleSheet)dOMImplementationCSS.createCSSStyleSheet(this.getTitle(), this.getMedia());
            StringBuffer stringBuffer = new StringBuffer();
            Node node = this.getFirstChild();
            while (node != null) {
                stringBuffer.append(node.getNodeValue());
                node = node.getNextSibling();
            }
            CSSDocumentHandler.parseRules((CSSOMStyleSheet)cSSOMStyleSheet, (String)stringBuffer.toString());
            this.sheet = cSSOMStyleSheet;
            cSSOMStyleSheet.setOwnerNode((Node)((Object)this));
        }
        return this.sheet;
    }

    public String getStyleSheetURI() {
        return XMLBaseSupport.getCascadedXMLBase((Element)((Object)this));
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace((Element)((Object)this));
    }

    public void setXMLspace(String string) throws DOMException {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    public String getType() {
        return this.getAttributeNS(null, "type");
    }

    public void setType(String string) throws DOMException {
        this.setAttributeNS(null, "type", string);
    }

    public String getMedia() {
        return this.getAttribute("media");
    }

    public void setMedia(String string) throws DOMException {
        this.setAttribute("media", string);
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public void setTitle(String string) throws DOMException {
        this.setAttribute("title", string);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMStyleElement();
    }

    static {
        attributeInitializer.addAttribute(null, null, "xml:space", "preserve");
    }
}

