/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.alignment;

import org.biojava3.alignment.template.AbstractScorer;
import org.biojava3.alignment.template.PairwiseSequenceAligner;
import org.biojava3.alignment.template.PairwiseSequenceScorer;
import org.biojava3.alignment.template.SequencePair;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public class FractionalIdentityScorer<S extends Sequence<C>, C extends Compound>
extends AbstractScorer
implements PairwiseSequenceScorer<S, C> {
    private S query;
    private S target;
    private int max;
    private int score;
    private PairwiseSequenceAligner<S, C> aligner;

    public FractionalIdentityScorer(PairwiseSequenceAligner<S, C> aligner) {
        this.query = aligner.getQuery();
        this.target = aligner.getTarget();
        this.aligner = aligner;
    }

    public FractionalIdentityScorer(SequencePair<S, C> pair) {
        this.query = pair.getQuery().getOriginalSequence();
        this.target = pair.getTarget().getOriginalSequence();
        this.max = pair.getLength();
        this.score = pair.getNumIdenticals();
    }

    @Override
    public S getQuery() {
        return this.query;
    }

    @Override
    public S getTarget() {
        return this.target;
    }

    @Override
    public int getMaxScore() {
        if (this.aligner != null) {
            this.align();
        }
        return this.max;
    }

    @Override
    public int getMinScore() {
        return 0;
    }

    @Override
    public int getScore() {
        if (this.aligner != null) {
            this.align();
        }
        return this.score;
    }

    private void align() {
        this.max = this.aligner.getPair().getLength();
        this.score = this.aligner.getPair().getNumIdenticals();
        this.aligner = null;
    }
}

