/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.alignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.biojava3.alignment.template.AlignedSequence;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.location.SimpleLocation;
import org.biojava3.core.sequence.location.template.Location;
import org.biojava3.core.sequence.location.template.Point;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceView;

public class SimpleAlignedSequence<S extends Sequence<C>, C extends Compound>
implements AlignedSequence<S, C> {
    private static final String gap = "-";
    private AlignedSequence<S, C> prev;
    private S original;
    private int length;
    private int numBefore;
    private int numAfter;
    private Location location;
    private int numGaps = -1;
    private int[] alignmentFromSequence;
    private int[] sequenceFromAlignment;

    public SimpleAlignedSequence(S original, List<AlignedSequence.Step> steps) {
        this(original, steps, 0, 0);
    }

    public SimpleAlignedSequence(S original, List<AlignedSequence.Step> steps, int numBefore, int numAfter) {
        this.original = original;
        this.numBefore = numBefore;
        this.numAfter = numAfter;
        this.length = steps.size();
        this.setLocation(steps);
    }

    public SimpleAlignedSequence(AlignedSequence<S, C> prev, List<AlignedSequence.Step> steps) {
        this(prev, steps, 0, 0);
    }

    public SimpleAlignedSequence(AlignedSequence<S, C> prev, List<AlignedSequence.Step> steps, int numBefore, int numAfter) {
        this.prev = prev;
        this.original = prev.getOriginalSequence();
        this.numBefore = numBefore;
        this.numAfter = numAfter;
        if (prev instanceof SimpleAlignedSequence) {
            SimpleAlignedSequence p = (SimpleAlignedSequence)prev;
            this.numBefore += p.numBefore;
            this.numAfter += p.numAfter;
        }
        this.length = steps.size();
        this.setLocation(steps);
    }

    @Override
    public void clearCache() {
        this.alignmentFromSequence = null;
        this.sequenceFromAlignment = null;
    }

    @Override
    public int getAlignmentIndexAt(int sequenceIndex) {
        if (this.alignmentFromSequence == null) {
            this.alignmentFromSequence = new int[this.original.getLength()];
            int s = 1;
            int a = 1;
            int i = 0;
            while (i < this.numBefore) {
                this.alignmentFromSequence[s - 1] = a;
                ++i;
                ++s;
            }
            while (s <= this.alignmentFromSequence.length && a <= this.length) {
                while (a <= this.length && this.isGap(a)) {
                    ++a;
                }
                this.alignmentFromSequence[s - 1] = a++;
                ++s;
            }
            --a;
            i = 0;
            while (i < this.numAfter) {
                this.alignmentFromSequence[s - 1] = a;
                ++i;
                ++s;
            }
        }
        return this.alignmentFromSequence[sequenceIndex - 1];
    }

    @Override
    public Point getEnd() {
        return this.location.getEnd();
    }

    @Override
    public Location getLocationInAlignment() {
        return this.location;
    }

    @Override
    public int getNumGaps() {
        if (this.numGaps == -1) {
            this.numGaps = 0;
            Compound cGap = this.getCompoundSet().getCompoundForString(gap);
            boolean inGap = false;
            for (Compound compound : this.getAsList()) {
                if (compound == null || compound.equalsIgnoreCase(cGap)) {
                    if (inGap) continue;
                    ++this.numGaps;
                    inGap = true;
                    continue;
                }
                inGap = false;
            }
        }
        return this.numGaps;
    }

    @Override
    public S getOriginalSequence() {
        return this.original;
    }

    @Override
    public int getOverlapCount() {
        return 1;
    }

    @Override
    public int getSequenceIndexAt(int alignmentIndex) {
        if (this.sequenceFromAlignment == null) {
            this.sequenceFromAlignment = new int[this.length];
            int a = 1;
            int s = this.numBefore + 1;
            int i = 0;
            while (i < this.getStart().getPosition()) {
                this.sequenceFromAlignment[a - 1] = s;
                ++i;
                ++a;
            }
            while (a <= this.length) {
                if (!this.isGap(a)) {
                    // empty if block
                }
                this.sequenceFromAlignment[a - 1] = ++s;
                ++a;
            }
        }
        return this.sequenceFromAlignment[alignmentIndex - 1];
    }

    @Override
    public Point getStart() {
        return this.location.getStart();
    }

    @Override
    public boolean isCircular() {
        return this.location.isCircular();
    }

    @Override
    public boolean isGap(int alignmentIndex) {
        if (this.getStart().getPosition() <= alignmentIndex && alignmentIndex <= this.getEnd().getPosition()) {
            if (!this.location.isComplex()) {
                return false;
            }
            for (Location sublocation : this.location) {
                if (sublocation.getStart().getPosition() > alignmentIndex || alignmentIndex > sublocation.getEnd().getPosition()) continue;
                return false;
            }
        }
        return true;
    }

    public int countCompounds(C ... compounds) {
        int count = 0;
        List<C> search = Arrays.asList(compounds);
        for (Compound compound : this.getAsList()) {
            if (!search.contains(compound)) continue;
            ++count;
        }
        return count;
    }

    public AccessionID getAccession() {
        return this.original.getAccession();
    }

    public List<C> getAsList() {
        ArrayList<C> compounds = new ArrayList<C>();
        for (int i = 1; i <= this.length; ++i) {
            compounds.add(this.getCompoundAt(i));
        }
        return compounds;
    }

    public C getCompoundAt(int alignmentIndex) {
        return (C)(alignmentIndex >= 1 && alignmentIndex <= this.length && this.isGap(alignmentIndex) ? this.getCompoundSet().getCompoundForString(gap) : this.original.getCompoundAt(this.getSequenceIndexAt(alignmentIndex)));
    }

    public CompoundSet<C> getCompoundSet() {
        return this.original.getCompoundSet();
    }

    public int getIndexOf(C compound) {
        for (int i = 1; i <= this.length; ++i) {
            if (!compound.equals(this.getCompoundAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int getLastIndexOf(C compound) {
        for (int i = this.length; i >= 1; --i) {
            if (!compound.equals(this.getCompoundAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int getLength() {
        return this.length;
    }

    public String getSequenceAsString() {
        return SequenceMixin.toString((Sequence)this);
    }

    public SequenceView<C> getSubSequence(Integer start, Integer end) {
        return SequenceMixin.createSubSequence((Sequence)this, (int)start, (int)end);
    }

    public Iterator<C> iterator() {
        return this.getAsList().iterator();
    }

    public String toString() {
        return this.getSequenceAsString();
    }

    private void setLocation(List<AlignedSequence.Step> steps) {
        int step;
        ArrayList<SimpleLocation> sublocations = new ArrayList<SimpleLocation>();
        int start = 0;
        int oStep = this.numBefore + this.numAfter;
        int oMax = this.original.getLength();
        int pStep = 0;
        int pMax = this.prev == null ? 0 : this.prev.getLength();
        boolean inGap = true;
        for (step = 0; step < this.length; ++step) {
            boolean isGapPrev;
            boolean isGapStep = steps.get(step) == AlignedSequence.Step.GAP;
            boolean bl = isGapPrev = pStep < pMax && this.prev.isGap(pStep + 1);
            if (!isGapStep && !isGapPrev) {
                ++oStep;
                if (inGap) {
                    inGap = false;
                    start = step + 1;
                }
            } else if (!inGap) {
                inGap = true;
                sublocations.add(new SimpleLocation(start, step, Strand.UNDEFINED));
            }
            if (this.prev == null || isGapStep) continue;
            ++pStep;
        }
        if (!inGap) {
            sublocations.add(new SimpleLocation(start, step, Strand.UNDEFINED));
        }
        Object object = this.location = sublocations.size() == 1 ? (Location)sublocations.get(0) : new SimpleLocation(((Location)sublocations.get(0)).getStart(), ((Location)sublocations.get(sublocations.size() - 1)).getEnd(), Strand.UNDEFINED, false, sublocations);
        if (step != this.length || oStep != oMax || pStep != pMax) {
            throw new IllegalArgumentException("Given sequence does not fit in alignment.");
        }
    }

    public SequenceView<C> getInverse() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

