/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.alignment;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.biojava3.alignment.SimpleSubstitutionMatrix;
import org.biojava3.alignment.template.SubstitutionMatrix;
import org.biojava3.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.compound.NucleotideCompound;

public class SubstitutionMatrixHelper {
    private static Map<String, SubstitutionMatrix<AminoAcidCompound>> aminoAcidMatrices = new HashMap<String, SubstitutionMatrix<AminoAcidCompound>>();
    private static Map<String, SubstitutionMatrix<NucleotideCompound>> nucleotideMatrices = new HashMap<String, SubstitutionMatrix<NucleotideCompound>>();

    private SubstitutionMatrixHelper() {
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum100() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum100");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum30() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum30");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum35() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum35");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum40() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum40");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum45() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum45");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum50() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum50");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum55() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum55");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum60() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum60");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum62() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum62");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum65() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum65");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum70() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum70");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum75() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum75");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum80() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum80");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum85() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum85");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum90() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("blosum90");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getGonnet250() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("gonnet250");
    }

    public static SubstitutionMatrix<NucleotideCompound> getNuc4_2() {
        return SubstitutionMatrixHelper.getNucleotideCompoundSubstitutionMatrix("nuc-4_2");
    }

    public static SubstitutionMatrix<NucleotideCompound> getNuc4_4() {
        return SubstitutionMatrixHelper.getNucleotideCompoundSubstitutionMatrix("nuc-4_4");
    }

    public static SubstitutionMatrix<AminoAcidCompound> getPAM250() {
        return SubstitutionMatrixHelper.getAminoAcidCompoundSubstitutionMatrix("pam250");
    }

    private static SubstitutionMatrix<AminoAcidCompound> getAminoAcidCompoundSubstitutionMatrix(String file) {
        if (!aminoAcidMatrices.containsKey(file)) {
            aminoAcidMatrices.put(file, new SimpleSubstitutionMatrix(AminoAcidCompoundSet.getAminoAcidCompoundSet(), SubstitutionMatrixHelper.getReader(file), file));
        }
        return aminoAcidMatrices.get(file);
    }

    private static SubstitutionMatrix<NucleotideCompound> getNucleotideCompoundSubstitutionMatrix(String file) {
        if (!nucleotideMatrices.containsKey(file)) {
            nucleotideMatrices.put(file, new SimpleSubstitutionMatrix(AmbiguityDNACompoundSet.getDNACompoundSet(), SubstitutionMatrixHelper.getReader(file), file));
        }
        return nucleotideMatrices.get(file);
    }

    private static InputStreamReader getReader(String file) {
        return new InputStreamReader(SubstitutionMatrixHelper.class.getResourceAsStream(String.format("/%s.txt", file)));
    }
}

