/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.alignment.routines;

import java.util.Collections;
import java.util.List;
import org.biojava3.alignment.template.AlignedSequence;

public class AlignerHelper {
    public static short addAnchors(Cut[] cuts, short[] scores, boolean addScore, int[] anchors) {
        int zMax = 0;
        short subscore = scores[0];
        for (int z = 1; z < scores.length; ++z) {
            if (scores[z] <= subscore) continue;
            zMax = z;
            subscore = scores[z];
        }
        for (Cut c : cuts) {
            anchors[c.getQueryIndex()] = c.getTargetIndex(zMax);
        }
        return addScore ? (short)subscore : (short)0;
    }

    public static Cut[] getCuts(int k, int[] subproblem, int[] dim, boolean anchor0) {
        Cut[] cuts;
        int m = subproblem[2] - subproblem[0] - (anchor0 ? 1 : 0);
        if (k < m) {
            cuts = new Cut[k];
            for (int i = 0; i < k; ++i) {
                cuts[i] = new Cut(subproblem[0] + (i + 1) * (m + 1) * k / (k + 1), dim);
            }
        } else {
            cuts = new Cut[m];
            int i = 0;
            int x = subproblem[0] + (anchor0 ? 1 : 0);
            while (i < m) {
                cuts[i] = new Cut(x, dim);
                ++i;
                ++x;
            }
        }
        return cuts;
    }

    public static int[] getNextSubproblem(int[] anchors) {
        int x;
        int[] subproblem = new int[4];
        for (x = 0; x < anchors.length && anchors[x] >= 0; ++x) {
        }
        if (x == anchors.length) {
            return null;
        }
        if (x == 0) {
            subproblem[0] = 0;
            subproblem[1] = 0;
            ++x;
        } else {
            subproblem[0] = x - 1;
            subproblem[1] = anchors[x - 1];
        }
        while (x < anchors.length && anchors[x] < 0) {
            ++x;
        }
        subproblem[2] = x;
        subproblem[3] = anchors[x];
        return subproblem;
    }

    public static void setCuts(int x, int[] subproblem, Last[][] pointers, Cut[] cuts) {
        for (Cut c : cuts) {
            c.update(x, subproblem, pointers);
        }
    }

    public static Last[] setScorePoint(int x, int y, short gop, short gep, short sub, short[][][] scores) {
        Last[] pointers = new Last[3];
        if (scores[x - 1][y - 1][1] >= scores[x - 1][y - 1][0] && scores[x - 1][y - 1][1] >= scores[x - 1][y - 1][2]) {
            scores[x][y][0] = (short)(scores[x - 1][y - 1][1] + sub);
            pointers[0] = Last.DELETION;
        } else if (scores[x - 1][y - 1][0] >= scores[x - 1][y - 1][2]) {
            scores[x][y][0] = (short)(scores[x - 1][y - 1][0] + sub);
            pointers[0] = Last.SUBSTITUTION;
        } else {
            scores[x][y][0] = (short)(scores[x - 1][y - 1][2] + sub);
            pointers[0] = Last.INSERTION;
        }
        if (scores[x - 1][y][1] >= scores[x - 1][y][0] + gop) {
            scores[x][y][1] = (short)(scores[x - 1][y][1] + gep);
            pointers[1] = Last.DELETION;
        } else {
            scores[x][y][1] = (short)(scores[x - 1][y][0] + gop + gep);
            pointers[1] = Last.SUBSTITUTION;
        }
        if (scores[x][y - 1][0] + gop >= scores[x][y - 1][2]) {
            scores[x][y][2] = (short)(scores[x][y - 1][0] + gop + gep);
            pointers[2] = Last.SUBSTITUTION;
        } else {
            scores[x][y][2] = (short)(scores[x][y - 1][2] + gep);
            pointers[2] = Last.INSERTION;
        }
        return pointers;
    }

    public static Last setScorePoint(int x, int y, short gep, short sub, short[][][] scores) {
        int d = scores[x - 1][y][0] + gep;
        int i = scores[x][y - 1][0] + gep;
        int s = scores[x - 1][y - 1][0] + sub;
        if (d >= s && d >= i) {
            scores[x][y][0] = (short)d;
            return Last.DELETION;
        }
        if (s >= i) {
            scores[x][y][0] = (short)s;
            return Last.SUBSTITUTION;
        }
        scores[x][y][0] = (short)i;
        return Last.INSERTION;
    }

    public static Last[][] setScoreVector(int x, short gop, short gep, short[] subs, boolean storing, short[][][] scores) {
        return AlignerHelper.setScoreVector(x, 0, 0, scores[0].length - 1, gop, gep, subs, storing, scores);
    }

    public static Last[][] setScoreVector(int x, int[] subproblem, short gop, short gep, short[] subs, boolean storing, short[][][] scores) {
        return AlignerHelper.setScoreVector(x, subproblem[0], subproblem[1], subproblem[3], gop, gep, subs, storing, scores);
    }

    public static Last[][] setScoreVector(int x, int xb, int yb, int ye, short gop, short gep, short[] subs, boolean storing, short[][][] scores) {
        Last[][] pointers = new Last[ye + 1][];
        short min = (short)(Short.MIN_VALUE - gop - gep);
        if (x == xb) {
            short s = gop;
            scores[xb][yb][2] = s;
            scores[xb][yb][1] = s;
            pointers[yb] = new Last[]{null, null, null};
            Last[] insertion = new Last[]{null, null, Last.INSERTION};
            for (int y = yb + 1; y <= ye; ++y) {
                short s2 = min;
                scores[xb][y][1] = s2;
                scores[xb][y][0] = s2;
                scores[xb][y][2] = (short)(scores[xb][y - 1][2] + gep);
                pointers[y] = insertion;
            }
        } else {
            if (!storing && x > xb + 1) {
                scores[x] = scores[x - 2];
            }
            short s = min;
            scores[x][yb][2] = s;
            scores[x][yb][0] = s;
            scores[x][yb][1] = (short)(scores[x - 1][yb][1] + gep);
            pointers[yb] = new Last[]{null, Last.DELETION, null};
            for (int y = yb + 1; y <= ye; ++y) {
                pointers[y] = AlignerHelper.setScorePoint(x, y, gop, gep, subs[y], scores);
            }
        }
        return pointers;
    }

    public static Last[][] setScoreVector(int x, short gep, short[] subs, boolean storing, short[][][] scores) {
        return AlignerHelper.setScoreVector(x, 0, 0, scores[0].length - 1, gep, subs, storing, scores);
    }

    public static Last[][] setScoreVector(int x, int[] subproblem, short gep, short[] subs, boolean storing, short[][][] scores) {
        return AlignerHelper.setScoreVector(x, subproblem[0], subproblem[1], subproblem[3], gep, subs, storing, scores);
    }

    public static Last[][] setScoreVector(int x, int xb, int yb, int ye, short gep, short[] subs, boolean storing, short[][][] scores) {
        Last[][] pointers = new Last[ye + 1][1];
        if (x == xb) {
            for (int y = yb + 1; y <= ye; ++y) {
                scores[xb][y][0] = (short)(scores[xb][y - 1][0] + gep);
                pointers[y][0] = Last.INSERTION;
            }
        } else {
            if (!storing && x > 1) {
                scores[x] = scores[x - 2];
            }
            scores[x][yb][0] = (short)(scores[x - 1][yb][0] + gep);
            pointers[yb][0] = Last.DELETION;
            for (int y = yb + 1; y <= ye; ++y) {
                pointers[y][0] = AlignerHelper.setScorePoint(x, y, gep, subs[y], scores);
            }
        }
        return pointers;
    }

    public static Last[][] setScoreVector(int x, short gop, short gep, short[] subs, boolean storing, short[][][] scores, int[] xyMax, int score) {
        return AlignerHelper.setScoreVector(x, 0, 0, scores[0].length - 1, gop, gep, subs, storing, scores, xyMax, score);
    }

    public static Last[][] setScoreVector(int x, int xb, int yb, int ye, short gop, short gep, short[] subs, boolean storing, short[][][] scores, int[] xyMax, int score) {
        Last[][] pointers;
        if (x == xb) {
            pointers = new Last[ye + 1][scores[0][0].length];
        } else {
            pointers = new Last[ye + 1][];
            pointers[0] = new Last[scores[0][0].length];
            if (!storing && x > 1) {
                scores[x] = scores[x - 2];
            }
            for (int y = 1; y < scores[0].length; ++y) {
                pointers[y] = AlignerHelper.setScorePoint(x, y, gop, gep, subs[y], scores);
                for (int z = 0; z < scores[0][0].length; ++z) {
                    if (scores[x][y][z] > 0) continue;
                    scores[x][y][z] = 0;
                    pointers[y][z] = null;
                }
                if (scores[x][y][0] <= score) continue;
                xyMax[0] = x;
                xyMax[1] = y;
                score = scores[x][y][0];
            }
        }
        return pointers;
    }

    public static Last[][] setScoreVector(int x, short gep, short[] subs, boolean storing, short[][][] scores, int[] xyMax, int score) {
        return AlignerHelper.setScoreVector(x, 0, 0, scores[0].length - 1, gep, subs, storing, scores, xyMax, score);
    }

    public static Last[][] setScoreVector(int x, int xb, int yb, int ye, short gep, short[] subs, boolean storing, short[][][] scores, int[] xyMax, int score) {
        Last[][] pointers;
        if (x == xb) {
            pointers = new Last[ye + 1][1];
        } else {
            pointers = new Last[ye + 1][];
            pointers[0] = new Last[1];
            if (!storing && x > 1) {
                scores[x] = scores[x - 2];
            }
            for (int y = 1; y < scores[x].length; ++y) {
                pointers[y][0] = AlignerHelper.setScorePoint(x, y, gep, subs[y], scores);
                if (scores[x][y][0] <= 0) {
                    scores[x][y][0] = 0;
                    pointers[y][0] = null;
                    continue;
                }
                if (scores[x][y][0] <= score) continue;
                xyMax[0] = x;
                xyMax[1] = y;
                score = scores[x][y][0];
            }
        }
        return pointers;
    }

    public static int[] setSteps(int[] anchors, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        for (int gap = anchors[0]; gap > 0; --gap) {
            sx.add(AlignedSequence.Step.GAP);
            sy.add(AlignedSequence.Step.COMPOUND);
        }
        for (int x = 1; x < anchors.length; ++x) {
            int change = anchors[x] - anchors[x - 1];
            if (change == 0) {
                sx.add(AlignedSequence.Step.COMPOUND);
                sy.add(AlignedSequence.Step.GAP);
                continue;
            }
            sx.add(AlignedSequence.Step.COMPOUND);
            sy.add(AlignedSequence.Step.COMPOUND);
            --change;
            while (change > 0) {
                sx.add(AlignedSequence.Step.GAP);
                sy.add(AlignedSequence.Step.COMPOUND);
                --change;
            }
        }
        return new int[]{0, 0};
    }

    public static int[] setSteps(Last[][][] traceback, boolean local, int[] xyMax, Last last, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        boolean linear;
        int x = xyMax[0];
        int y = xyMax[1];
        boolean bl = linear = traceback[x][y].length == 1;
        while (local ? (linear ? last : traceback[x][y][last.ordinal()]) != null : x > 0 || y > 0) {
            switch (last) {
                case DELETION: {
                    sx.add(AlignedSequence.Step.COMPOUND);
                    sy.add(AlignedSequence.Step.GAP);
                    last = linear ? traceback[--x][y][0] : traceback[x--][y][1];
                    break;
                }
                case SUBSTITUTION: {
                    sx.add(AlignedSequence.Step.COMPOUND);
                    sy.add(AlignedSequence.Step.COMPOUND);
                    last = linear ? traceback[--x][--y][0] : traceback[x--][y--][0];
                    break;
                }
                case INSERTION: {
                    sx.add(AlignedSequence.Step.GAP);
                    sy.add(AlignedSequence.Step.COMPOUND);
                    last = linear ? traceback[x][--y][0] : traceback[x][y--][2];
                }
            }
        }
        Collections.reverse(sx);
        Collections.reverse(sy);
        return new int[]{x, y};
    }

    public static int[] setSteps(Last[][][] traceback, short[][][] scores, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        boolean linear;
        int xMax = scores.length - 1;
        int yMax = scores[xMax].length - 1;
        boolean bl = linear = traceback[xMax][yMax].length == 1;
        Last last = linear ? traceback[xMax][yMax][0] : (scores[xMax][yMax][1] > scores[xMax][yMax][0] && scores[xMax][yMax][1] > scores[xMax][yMax][2] ? Last.DELETION : (scores[xMax][yMax][0] > scores[xMax][yMax][2] ? Last.SUBSTITUTION : Last.INSERTION));
        return AlignerHelper.setSteps(traceback, false, new int[]{xMax, yMax}, last, sx, sy);
    }

    public static int[] setSteps(Last[][][] traceback, int[] xyMax, List<AlignedSequence.Step> sx, List<AlignedSequence.Step> sy) {
        return AlignerHelper.setSteps(traceback, true, xyMax, Last.SUBSTITUTION, sx, sy);
    }

    public static class Cut {
        private int queryIndex;
        private int[][] targetIndices;
        private int[][] tiLast;
        private int[][] ti1;
        private int[][] ti2;

        public Cut(int queryIndex, int[] dim) {
            this.queryIndex = queryIndex;
            this.ti1 = new int[dim[1]][dim[2]];
            this.targetIndices = this.ti1;
            this.ti2 = new int[dim[1]][dim[2]];
        }

        public int getQueryIndex() {
            return this.queryIndex;
        }

        public int getTargetIndex(int z) {
            return this.targetIndices[this.targetIndices.length - 1][z];
        }

        public void update(int x, int[] subproblem, Last[][] pointers) {
            if (pointers[subproblem[1]].length == 1) {
                if (this.queryIndex == x - 1) {
                    this.updateLinearInitial(subproblem, pointers);
                } else if (this.queryIndex < x) {
                    this.updateLinearAdvance(subproblem, pointers);
                }
            } else if (this.queryIndex == x - 1) {
                this.updateInitial(subproblem, pointers);
            } else if (this.queryIndex < x) {
                this.updateAdvance(subproblem, pointers);
            }
        }

        private void updateAdvance(int[] subproblem, Last[][] pointers) {
            this.tiLast = this.targetIndices;
            this.targetIndices = this.targetIndices == this.ti2 ? this.ti1 : this.ti2;
            for (int y = subproblem[1]; y <= subproblem[3]; ++y) {
                if (pointers[y][0] != null) {
                    this.targetIndices[y][0] = this.tiLast[y - 1][pointers[y][0].ordinal()];
                }
                if (pointers[y][1] != null) {
                    this.targetIndices[y][1] = this.tiLast[y][pointers[y][1].ordinal()];
                }
                if (pointers[y][2] == null) continue;
                this.targetIndices[y][2] = this.targetIndices[y - 1][pointers[y][2].ordinal()];
            }
        }

        private void updateInitial(int[] subproblem, Last[][] pointers) {
            for (int y = subproblem[1]; y <= subproblem[3]; ++y) {
                if (pointers[y][0] != null) {
                    this.targetIndices[y][0] = y - 1;
                }
                if (pointers[y][1] != null) {
                    this.targetIndices[y][1] = y;
                }
                if (pointers[y][2] == null) continue;
                this.targetIndices[y][2] = this.targetIndices[y - 1][2];
            }
        }

        private void updateLinearAdvance(int[] subproblem, Last[][] pointers) {
            this.tiLast = this.targetIndices;
            this.targetIndices = this.targetIndices == this.ti2 ? this.ti1 : this.ti2;
            block5: for (int y = subproblem[1]; y <= subproblem[3]; ++y) {
                switch (pointers[y][0]) {
                    case DELETION: {
                        this.targetIndices[y][0] = this.tiLast[y][0];
                        continue block5;
                    }
                    case SUBSTITUTION: {
                        this.targetIndices[y][0] = this.tiLast[y - 1][0];
                        continue block5;
                    }
                    case INSERTION: {
                        this.targetIndices[y][0] = this.targetIndices[y - 1][0];
                    }
                }
            }
        }

        private void updateLinearInitial(int[] subproblem, Last[][] pointers) {
            block5: for (int y = subproblem[1]; y <= subproblem[3]; ++y) {
                if (pointers[y][0] == null) continue;
                switch (pointers[y][0]) {
                    case DELETION: {
                        this.targetIndices[y][0] = y;
                        continue block5;
                    }
                    case SUBSTITUTION: {
                        this.targetIndices[y][0] = y - 1;
                        continue block5;
                    }
                    case INSERTION: {
                        this.targetIndices[y][0] = this.targetIndices[y - 1][0];
                    }
                }
            }
        }
    }

    public static enum Last {
        SUBSTITUTION,
        DELETION,
        INSERTION;

    }
}

