/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.alignment.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava3.alignment.routines.AlignerHelper;
import org.biojava3.alignment.template.AbstractScorer;
import org.biojava3.alignment.template.AlignedSequence;
import org.biojava3.alignment.template.GapPenalty;
import org.biojava3.alignment.template.MatrixAligner;
import org.biojava3.alignment.template.Profile;
import org.biojava3.alignment.template.SubstitutionMatrix;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;

public abstract class AbstractMatrixAligner<S extends Sequence<C>, C extends Compound>
extends AbstractScorer
implements MatrixAligner<S, C> {
    protected GapPenalty gapPenalty;
    private SubstitutionMatrix<C> subMatrix;
    private boolean local;
    private boolean storingScoreMatrix;
    protected int[] anchors;
    protected int cutsPerSection;
    protected Profile<S, C> profile;
    protected int[] xyMax;
    protected int[] xyStart;
    protected short max;
    protected short min;
    protected short score;
    protected short[][][] scores;
    private String[] types;
    protected long time = -1L;

    protected AbstractMatrixAligner() {
    }

    protected AbstractMatrixAligner(GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        this(gapPenalty, subMatrix, false);
    }

    protected AbstractMatrixAligner(GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix, boolean local) {
        this.gapPenalty = gapPenalty;
        this.subMatrix = subMatrix;
        this.local = local;
        this.reset();
    }

    public GapPenalty getGapPenalty() {
        return this.gapPenalty;
    }

    public SubstitutionMatrix<C> getSubstitutionMatrix() {
        return this.subMatrix;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isStoringScoreMatrix() {
        return this.storingScoreMatrix;
    }

    public void setGapPenalty(GapPenalty gapPenalty) {
        this.gapPenalty = gapPenalty;
        this.reset();
    }

    public void setSubstitutionMatrix(SubstitutionMatrix<C> subMatrix) {
        this.subMatrix = subMatrix;
        this.reset();
    }

    public void setStoringScoreMatrix(boolean storingScoreMatrix) {
        this.storingScoreMatrix = storingScoreMatrix;
        if (!storingScoreMatrix) {
            this.scores = null;
        }
    }

    @Override
    public short[][][] getScoreMatrix() {
        boolean tempStoringScoreMatrix = this.storingScoreMatrix;
        if (this.scores == null) {
            this.storingScoreMatrix = true;
            this.align();
            if (this.scores == null) {
                return null;
            }
        }
        short[][][] copy = this.scores;
        if (tempStoringScoreMatrix) {
            copy = new short[this.scores.length][this.scores[0].length][];
            for (int i = 0; i < copy.length; ++i) {
                for (int j = 0; j < copy[0].length; ++j) {
                    copy[i][j] = Arrays.copyOf(this.scores[i][j], this.scores[i][j].length);
                }
            }
        }
        this.setStoringScoreMatrix(tempStoringScoreMatrix);
        return copy;
    }

    @Override
    public String getScoreMatrixAsString() {
        short[][][] scores = this.getScoreMatrix();
        StringBuilder s = new StringBuilder();
        CompoundSet<C> compoundSet = this.getCompoundSet();
        int lengthCompound = compoundSet.getMaxSingleCompoundStringLength();
        int lengthRest = Math.max(Math.max(Short.toString(this.min).length(), Short.toString(this.max).length()), lengthCompound) + 1;
        String padCompound = "%" + Integer.toString(lengthCompound) + "s";
        String padRest = "%" + Integer.toString(lengthRest);
        List<C> query = this.getCompoundsOfQuery();
        List<C> target = this.getCompoundsOfTarget();
        for (int type = 0; type < scores[0][0].length; ++type) {
            if (type > 0) {
                s.append(String.format("%n", new Object[0]));
            }
            if (this.types[type] != null) {
                s.append(String.format("%s%n", this.types[type]));
            }
            s.append(String.format(padCompound, ""));
            s.append(String.format(padRest + "s", ""));
            for (Compound col : target) {
                s.append(String.format(padRest + "s", compoundSet.getStringForCompound(col)));
            }
            s.append(String.format("%n", new Object[0]));
            for (int x = 0; x < scores.length; ++x) {
                s.append(String.format(padCompound, x == 0 ? "" : compoundSet.getStringForCompound((Compound)query.get(x - 1))));
                for (int y = 0; y < scores[0].length; ++y) {
                    s.append(scores[x][y][type] >= this.min ? String.format(padRest + "d", scores[x][y][type]) : String.format(padRest + "s", "-\u221e"));
                }
                s.append(String.format("%n", new Object[0]));
            }
        }
        return s.toString();
    }

    @Override
    public long getComputationTime() {
        if (this.profile == null) {
            this.align();
        }
        return this.time;
    }

    @Override
    public Profile<S, C> getProfile() {
        if (this.profile == null) {
            this.align();
        }
        return this.profile;
    }

    @Override
    public int getMaxScore() {
        if (this.profile == null) {
            this.align();
        }
        return this.max;
    }

    @Override
    public int getMinScore() {
        if (this.profile == null) {
            this.align();
        }
        return this.min;
    }

    @Override
    public int getScore() {
        if (this.profile == null) {
            this.align();
        }
        return this.score;
    }

    protected void align() {
        if (!this.isReady()) {
            return;
        }
        long timeStart = System.nanoTime();
        int[] dim = this.getScoreMatrixDimensions();
        if (this.storingScoreMatrix) {
            this.scores = new short[dim[0]][dim[1]][dim[2]];
        } else {
            this.scores = new short[dim[0]][][];
            this.scores[0] = new short[dim[1]][dim[2]];
            this.scores[1] = new short[dim[1]][dim[2]];
        }
        boolean linear = this.gapPenalty.getType() == GapPenalty.Type.LINEAR;
        AlignerHelper.Last[][][] traceback = new AlignerHelper.Last[dim[0]][][];
        ArrayList<AlignedSequence.Step> sx = new ArrayList<AlignedSequence.Step>();
        ArrayList<AlignedSequence.Step> sy = new ArrayList<AlignedSequence.Step>();
        if (this.anchors != null) {
            int[] subproblem;
            this.xyMax[0] = dim[0] - 1;
            this.xyMax[1] = dim[1] - 1;
            this.score = 0;
            boolean[] addScore = new boolean[this.anchors.length];
            for (int i = 0; i < this.anchors.length; ++i) {
                addScore[i] = this.anchors[i] >= 0;
            }
            addScore[this.xyMax[0]] = true;
            this.anchors[this.xyMax[0]] = this.xyMax[1];
            while ((subproblem = AlignerHelper.getNextSubproblem(this.anchors)) != null) {
                AlignerHelper.Cut[] cuts = AlignerHelper.getCuts(this.cutsPerSection, subproblem, dim, this.anchors[0] >= 0);
                for (int x = subproblem[0]; x <= subproblem[2]; ++x) {
                    AlignerHelper.Last[][] pointers = linear ? AlignerHelper.setScoreVector(x, subproblem, this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x, subproblem), false, this.scores) : AlignerHelper.setScoreVector(x, subproblem, this.gapPenalty.getOpenPenalty(), this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x, subproblem), false, this.scores);
                    AlignerHelper.setCuts(x, subproblem, pointers, cuts);
                }
                this.score = (short)(this.score + AlignerHelper.addAnchors(cuts, this.scores[subproblem[2]][subproblem[3]], addScore[subproblem[2]], this.anchors));
            }
            this.xyStart = AlignerHelper.setSteps(this.anchors, sx, sy);
        } else {
            for (int x = 0; x < dim[0]; ++x) {
                if (this.local) {
                    AlignerHelper.Last[][] lastArray = traceback[x] = linear ? AlignerHelper.setScoreVector(x, this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x), this.storingScoreMatrix, this.scores, this.xyMax, this.score) : AlignerHelper.setScoreVector(x, this.gapPenalty.getOpenPenalty(), this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x), this.storingScoreMatrix, this.scores, this.xyMax, this.score);
                    if (this.xyMax[0] != x) continue;
                    this.score = this.scores[x][this.xyMax[1]][0];
                    continue;
                }
                traceback[x] = linear ? AlignerHelper.setScoreVector(x, this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x), this.storingScoreMatrix, this.scores) : AlignerHelper.setScoreVector(x, this.gapPenalty.getOpenPenalty(), this.gapPenalty.getExtensionPenalty(), this.getSubstitutionScoreVector(x), this.storingScoreMatrix, this.scores);
            }
            if (!this.local) {
                this.xyMax[0] = dim[0] - 1;
                this.xyMax[1] = dim[1] - 1;
                for (int z = 0; z < this.scores[this.xyMax[0]][this.xyMax[1]].length; ++z) {
                    this.score = (short)Math.max(this.score, this.scores[this.xyMax[0]][this.xyMax[1]][z]);
                }
            }
            this.xyStart = this.local ? AlignerHelper.setSteps(traceback, this.xyMax, sx, sy) : AlignerHelper.setSteps(traceback, this.scores, sx, sy);
        }
        this.setProfile(sx, sy);
        if (!this.storingScoreMatrix) {
            this.scores = null;
        }
        this.time = System.nanoTime() - timeStart;
    }

    protected short[] getSubstitutionScoreVector(int queryColumn) {
        return this.getSubstitutionScoreVector(queryColumn, new int[]{0, 0, this.scores.length - 1, this.scores[0].length - 1});
    }

    protected short[] getSubstitutionScoreVector(int queryColumn, int[] subproblem) {
        short[] subs = new short[subproblem[3] + 1];
        if (queryColumn > 0) {
            for (int y = Math.max(1, subproblem[1]); y <= subproblem[3]; ++y) {
                subs[y] = this.getSubstitutionScore(queryColumn, y);
            }
        }
        return subs;
    }

    protected void reset() {
        String[] stringArray;
        this.xyMax = new int[]{0, 0};
        this.xyStart = new int[]{0, 0};
        this.scores = null;
        if (this.gapPenalty == null || this.gapPenalty.getType() == GapPenalty.Type.LINEAR) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "Substitution";
            stringArray3[1] = "Deletion";
            stringArray = stringArray3;
            stringArray3[2] = "Insertion";
        }
        this.types = stringArray;
        this.time = -1L;
        this.profile = null;
    }

    protected void resetAnchors() {
        block3: {
            int x;
            block2: {
                x = this.getScoreMatrixDimensions()[0];
                if (this.anchors != null) break block2;
                this.anchors = new int[x];
                for (int i = 0; i < x; ++i) {
                    this.anchors[i] = -1;
                }
                break block3;
            }
            if (this.anchors.length == x) break block3;
            int[] old = this.anchors;
            this.anchors = new int[x];
            for (int i = 0; i < x; ++i) {
                this.anchors[i] = i < old.length ? old[i] : -1;
            }
        }
    }

    protected abstract CompoundSet<C> getCompoundSet();

    protected abstract List<C> getCompoundsOfQuery();

    protected abstract List<C> getCompoundsOfTarget();

    protected abstract int[] getScoreMatrixDimensions();

    protected abstract short getSubstitutionScore(int var1, int var2);

    protected abstract boolean isReady();

    protected abstract void setProfile(List<AlignedSequence.Step> var1, List<AlignedSequence.Step> var2);
}

