/*
 * Decompiled with CFR 0.152.
 */
package ext.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class ZStringVector {
    private String[] data = null;
    private int offset = -1;
    private static final double ratio = 0.5;

    public ZStringVector() {
        this.data = new String[0];
    }

    public ZStringVector(int size) {
        this(size, "");
    }

    public ZStringVector(int size, String initValue) {
        this.assign(size, initValue);
    }

    public ZStringVector(String[] o) {
        this.assign(o);
    }

    public ZStringVector(Object[] o, boolean b) {
        if (b) {
            this.copyArray(o);
        } else {
            this.assign(0);
        }
    }

    public void assign(int size) {
        this.data = new String[size];
        this.offset = size - 1;
    }

    public void assign(int size, String initValue) {
        this.data = new String[size];
        this.offset = size - 1;
        Arrays.fill(this.data, 0, this.offset + 1, initValue);
    }

    public void assign(String[] o) {
        this.data = o;
        this.offset = o.length - 1;
    }

    public void copyArray(Object[] o) {
        this.data = new String[o.length];
        this.offset = o.length - 1;
        for (int i = 0; i < o.length; ++i) {
            this.data[i] = o[i].toString();
        }
    }

    public static ZStringVector split(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        int count = st.countTokens();
        ZStringVector ret = new ZStringVector(count);
        ret.offset = count - 1;
        for (int i = 0; i < count; ++i) {
            ret.data[i] = st.nextToken();
        }
        return ret;
    }

    public String get(int index) {
        return this.data[index];
    }

    public int getIndex(String str) {
        for (int i = 0; i <= this.offset; ++i) {
            if (!this.data[i].equals(str)) continue;
            return i;
        }
        return -1;
    }

    public int getSize() {
        return this.offset + 1;
    }

    public int getCapacity() {
        return this.data.length - this.offset - 1;
    }

    public ZStringVector getCopy() {
        ZStringVector ret = new ZStringVector();
        ret.data = new String[this.data.length];
        ret.offset = this.offset;
        System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
        return ret;
    }

    public String[] toArray() {
        if (this.data.length == this.offset) {
            return this.data;
        }
        String[] newData = new String[this.offset + 1];
        System.arraycopy(this.data, 0, newData, 0, this.offset + 1);
        this.data = newData;
        return newData;
    }

    public ArrayList toArrayList() {
        ArrayList<String> ret = new ArrayList<String>(this.offset + 1);
        for (int i = 0; i <= this.offset; ++i) {
            ret.add(i, this.data[i]);
        }
        return ret;
    }

    public TreeSet toTreeSet() {
        TreeSet<String> ret = new TreeSet<String>();
        for (int i = 0; i <= this.offset; ++i) {
            ret.add(this.data[i]);
        }
        return ret;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.offset; ++i) {
            sb.append(String.valueOf(String.valueOf(this.data[i])).concat(String.valueOf(String.valueOf(delim))));
        }
        if (this.offset >= 0) {
            sb.append(this.data[this.offset]);
        }
        return sb.toString();
    }

    public void set(int index, Object value) {
        this.data[index] = value.toString();
    }

    public void pushBack(String value) {
        if (this.data.length == this.offset + 1) {
            this.reserve((int)(0.5 * (double)this.data.length) + 1);
        }
        this.data[++this.offset] = value;
    }

    public String popBack() {
        if (this.data.length - this.offset - 1 > (int)(0.5 * (double)(this.offset + 1))) {
            this.reserve((int)(0.5 * (double)this.data.length) + 1);
        }
        return this.data[this.offset--];
    }

    public void clear() {
        this.data = null;
        this.offset = -1;
    }

    public void trim() {
        for (int i = 0; i <= this.offset; ++i) {
            this.data[i].trim();
        }
    }

    public void reserve(int space) {
        String[] newData = new String[this.offset + 1 + space];
        System.arraycopy(this.data, 0, newData, 0, this.offset + 1);
        this.data = newData;
    }

    public static void main(String[] args) {
        ZStringVector sv = ZStringVector.split(" abc def \n hi gkl ", " \n");
        Object[] str = sv.toArray();
        str[1] = "new";
        System.out.println(sv);
        ZStringVector sv2 = new ZStringVector(str, true);
        sv2.set(1, "newAgain");
        System.out.println(sv);
        ZStringVector sv3 = new ZStringVector((String[])str);
        sv3.set(1, "newFromsv3");
        System.out.println(sv);
        ZStringVector sv4 = sv.getCopy();
        sv.set(1, "newnew");
        System.out.println(sv);
        System.out.println(sv4);
        ArrayList al = sv.toArrayList();
        TreeSet ts = sv.toTreeSet();
        System.out.println(sv.getIndex("newnew"));
        sv.clear();
        System.out.println(sv);
    }

    static {
        ratio = 0.5;
    }
}

