/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import ext.swing.ZImageFactory;
import ext.swing.ZStandardBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class ZButton
extends JButton {
    private Border raisedBorder = new ZStandardBorder(0);
    private Border loweredBorder = new ZStandardBorder(1);
    private Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private Color oldColor = null;
    private Color newColor = Color.black;
    private String name = null;

    public static JButton createSeparator(int height) {
        JButton ret = new JButton(new ZSeparatorIcon(height));
        ret.setBorder(null);
        ret.setBorderPainted(false);
        ret.setEnabled(false);
        ret.setMargin(new Insets(0, 0, 0, 0));
        return ret;
    }

    public static JButton createHeader(int height) {
        JButton ret = new JButton(new ZHeaderIcon(height));
        ret.setBorder(null);
        ret.setBorderPainted(false);
        ret.setEnabled(false);
        ret.setMargin(new Insets(0, 0, 0, 0));
        return ret;
    }

    public ZButton() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ZButton(String name, String label, String tip) {
        try {
            this.jbInit();
            this.set(name, label, tip);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void set(String name, String label, String tip) {
        this.name = name;
        this.setIcon(ZImageFactory.getImageIcon(String.valueOf(String.valueOf(name)).concat(String.valueOf(String.valueOf(0)))));
        this.setRolloverIcon(ZImageFactory.getImageIcon(String.valueOf(String.valueOf(name)).concat(String.valueOf(String.valueOf(1)))));
        if (label != null) {
            this.setText(label);
        } else {
            this.setText(name);
        }
        if (tip != null) {
            this.setToolTipText(tip);
        }
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBorder(this.emptyBorder);
    }

    private void jbInit() throws Exception {
        this.oldColor = this.getForeground();
        this.setBorder(this.emptyBorder);
        this.setFocusPainted(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                ZButton.this.this_mouseEntered(e);
            }

            public void mousePressed(MouseEvent e) {
                ZButton.this.this_mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                ZButton.this.this_mouseReleased(e);
            }

            public void mouseExited(MouseEvent e) {
                ZButton.this.this_mouseExited(e);
            }
        });
    }

    private void this_mouseEntered(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.setForeground(this.newColor);
        this.setBorder(this.raisedBorder);
    }

    private void this_mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.setBorder(this.loweredBorder);
    }

    void this_mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.setBorder(this.raisedBorder);
    }

    private void this_mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.setForeground(this.oldColor);
        this.setBorder(this.emptyBorder);
    }

    private static class ZHeaderIcon
    implements Icon {
        private int width = 3;
        private int height = 0;

        public ZHeaderIcon(int h) {
            this.height = h;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.white);
            g.drawLine(x, y, x + 1, y);
            g.drawLine(x, y, x, y + this.height - 2);
            g.setColor(Color.lightGray);
            g.drawLine(x + 1, y + 1, x + 1, y + this.height - 2);
            g.setColor(Color.gray);
            g.drawLine(x + 2, y, x + 2, y + this.height - 1);
            g.drawLine(x, y + this.height - 1, x + 2, y + this.height - 1);
        }

        public int getIconWidth() {
            return 3;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    private static class ZSeparatorIcon
    implements Icon {
        private int width = 2;
        private int height = 0;

        public ZSeparatorIcon(int h) {
            this.height = h;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.gray);
            g.drawLine(x + this.width / 2, y, x + this.width / 2, y + this.height);
            g.setColor(Color.white);
            g.drawLine(x + this.width / 2 + 1, y, x + this.width / 2 + 1, y + this.height);
        }

        public int getIconWidth() {
            return 2;
        }

        public int getIconHeight() {
            return this.height;
        }
    }
}

