/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import com.borland.jbcl.layout.BoxLayout2;
import ext.swing.ZAbstractDialog;
import ext.swing.ZDialogModel;
import ext.swing.ZFontColorModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ZFontColorDialog
extends ZAbstractDialog {
    private Font[] availableFonts = null;
    private JPanel P_this = new JPanel();
    private JPanel P_upper = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel P_lower = new JPanel();
    private JPanel P_chooser = new JPanel();
    private BoxLayout2 boxLayout21 = new BoxLayout2();
    private JPanel P_combo = new JPanel();
    private JLabel L_sample = new JLabel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JPanel P_text = new JPanel();
    private JPanel P_color = new JPanel();
    private BorderLayout borderLayout4 = new BorderLayout();
    private JPanel P_font = new JPanel();
    private JPanel P_size = new JPanel();
    private TitledBorder titledBorder1;
    private GridLayout gridLayout1 = new GridLayout();
    private JCheckBox CB_italic = new JCheckBox();
    private JCheckBox CB_bold = new JCheckBox();
    private TitledBorder titledBorder2;
    private TitledBorder titledBorder3;
    private GridLayout gridLayout3 = new GridLayout();
    private JLabel L_size = new JLabel();
    private JComboBox CB_size = new JComboBox();
    private JLabel L_font = new JLabel();
    private JComboBox CB_font = new JComboBox();
    private FlowLayout flowLayout1 = new FlowLayout();
    private TitledBorder titledBorder4;
    private JButton B_bColor = new JButton();
    private JButton B_fColor = new JButton();

    public static ZDialogModel createFontColorModel(Font font, Color bColor, Color fColor) {
        return new ZFontColorModel(font, bColor, fColor);
    }

    protected void fetchAllData() {
        String fontName = ((Font)this.model.getData("font")).getFontName();
        this.CB_font.setSelectedItem(fontName);
        int size = ((Font)this.model.getData("font")).getSize();
        if (size > 24) {
            this.CB_size.addItem(String.valueOf(size));
        }
        this.CB_size.setSelectedItem(String.valueOf(size));
        this.L_sample.setBackground((Color)this.model.getData("backgroundColor"));
        this.L_sample.setForeground((Color)this.model.getData("foregroundColor"));
        int style = ((Font)this.model.getData("font")).getStyle();
        if ((style & 1) == 0) {
            this.CB_bold.setSelected(false);
        } else {
            this.CB_bold.setSelected(true);
        }
        if ((style & 2) == 0) {
            this.CB_italic.setSelected(false);
        } else {
            this.CB_italic.setSelected(true);
        }
    }

    protected void changeAllData() {
        this.model.setData("font", this.L_sample.getFont());
        this.model.setData("backgroundColor", this.L_sample.getBackground());
        this.model.setData("foregroundColor", this.L_sample.getForeground());
    }

    public ZFontColorDialog(ZDialogModel model) {
        super(model, "Font and color");
        this.availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int i;
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.titledBorder3 = new TitledBorder("");
        this.titledBorder4 = new TitledBorder("");
        this.P_this.setLayout(this.borderLayout1);
        this.P_upper.setLayout((LayoutManager)this.boxLayout21);
        this.boxLayout21.setAxis(1);
        this.L_sample.setOpaque(true);
        this.L_sample.setHorizontalAlignment(0);
        this.L_sample.setHorizontalTextPosition(0);
        this.L_sample.setText("Sample text & SAMPLE TEXT");
        this.P_lower.setLayout(this.borderLayout2);
        this.P_chooser.setLayout(this.borderLayout3);
        this.P_combo.setLayout(this.borderLayout4);
        this.P_text.setBorder(this.titledBorder1);
        this.P_text.setMinimumSize(new Dimension(100, 80));
        this.P_text.setPreferredSize(new Dimension(100, 80));
        this.P_text.setLayout(this.gridLayout1);
        this.titledBorder1.setTitle("Text attribute");
        this.gridLayout1.setRows(2);
        this.CB_italic.setText("Italic");
        this.CB_italic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZFontColorDialog.this.CB_italic_actionPerformed(e);
            }
        });
        this.CB_bold.setText("Bold");
        this.CB_bold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZFontColorDialog.this.CB_bold_actionPerformed(e);
            }
        });
        this.P_color.setBorder(this.titledBorder2);
        this.P_color.setLayout(this.gridLayout3);
        this.titledBorder3.setTitle("Color for");
        this.titledBorder2.setTitle("Color");
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(2);
        this.gridLayout3.setVgap(3);
        this.L_size.setText("  Size  ");
        this.CB_size.setMinimumSize(new Dimension(50, 24));
        this.CB_size.setPreferredSize(new Dimension(50, 24));
        this.CB_size.setEditable(true);
        this.CB_size.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZFontColorDialog.this.CB_size_actionPerformed(e);
            }
        });
        this.L_font.setText("  Font  ");
        this.P_font.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.CB_font.setMaximumSize(new Dimension(240, 24));
        this.CB_font.setMinimumSize(new Dimension(128, 24));
        this.CB_font.setPreferredSize(new Dimension(200, 24));
        this.CB_font.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZFontColorDialog.this.CB_font_actionPerformed(e);
            }
        });
        this.P_lower.setBorder(this.titledBorder4);
        this.titledBorder4.setTitle("Sample");
        this.B_bColor.setText("Set background color");
        this.B_bColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZFontColorDialog.this.B_bColor_actionPerformed(e);
            }
        });
        this.B_fColor.setText("Set foreground color");
        this.B_fColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZFontColorDialog.this.B_fColor_actionPerformed(e);
            }
        });
        this.setPanel(this.P_this);
        this.P_this.add((Component)this.P_upper, "North");
        this.P_upper.add((Component)this.P_chooser, null);
        this.P_chooser.add((Component)this.P_text, "West");
        this.P_text.add((Component)this.CB_bold, null);
        this.P_text.add((Component)this.CB_italic, null);
        this.P_chooser.add((Component)this.P_color, "Center");
        this.P_color.add((Component)this.B_bColor, null);
        this.P_color.add((Component)this.B_fColor, null);
        this.P_upper.add((Component)this.P_combo, null);
        this.P_combo.add((Component)this.P_font, "Center");
        this.P_font.add((Component)this.L_font, null);
        this.P_font.add((Component)this.CB_font, null);
        this.P_combo.add((Component)this.P_size, "East");
        this.P_size.add((Component)this.L_size, null);
        this.P_size.add((Component)this.CB_size, null);
        this.P_this.add((Component)this.P_lower, "Center");
        this.P_lower.add((Component)this.L_sample, "Center");
        for (i = 0; i < this.availableFonts.length; ++i) {
            this.CB_font.addItem(this.availableFonts[i].getName());
        }
        for (i = 2; i <= 24; ++i) {
            this.CB_size.addItem(String.valueOf(i));
        }
        this.fetchAllData();
    }

    private void setSample() {
        Font font = Font.decode((String)this.CB_font.getSelectedItem());
        int style = 0;
        if (this.CB_bold.isSelected()) {
            style |= 1;
        }
        if (this.CB_italic.isSelected()) {
            style |= 2;
        }
        int size = Integer.valueOf((String)this.CB_size.getSelectedItem());
        Font newFont = font.deriveFont(style, size);
        this.L_sample.setFont(newFont);
    }

    private void CB_bold_actionPerformed(ActionEvent e) {
        this.setSample();
    }

    private void CB_italic_actionPerformed(ActionEvent e) {
        this.setSample();
    }

    private void B_bColor_actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(this, "Choose background color", this.L_sample.getBackground());
        this.L_sample.setBackground(newColor);
    }

    private void B_fColor_actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(this, "Choose foreground color", this.L_sample.getForeground());
        this.L_sample.setForeground(newColor);
    }

    private void CB_font_actionPerformed(ActionEvent e) {
        if (this.CB_font.getItemCount() != this.availableFonts.length) {
            return;
        }
        this.setSample();
    }

    private void CB_size_actionPerformed(ActionEvent e) {
        try {
            String sizeString = (String)this.CB_size.getSelectedItem();
            int size = Integer.valueOf(sizeString);
            if (size < 0 || size > 100) {
                return;
            }
            this.setSample();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        ((Component)frame).setVisible(true);
        JLabel label = new JLabel();
        ZFontColorDialog zDialog = new ZFontColorDialog(new ZFontColorModel(label.getFont(), Color.blue, Color.red));
        zDialog.showAtCenter();
    }
}

