/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ZStandardBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int bevelType;
    protected Color highlightOuter = Color.white;
    protected Color shadowOuter = Color.gray;

    public ZStandardBorder(int bevelType) {
        this.bevelType = bevelType;
    }

    public ZStandardBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType);
        this.highlightOuter = highlight;
        this.shadowOuter = shadow;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.bevelType == 0) {
            this.paintRaisedBevel(c, g, x, y, width, height);
        } else if (this.bevelType == 1) {
            this.paintLoweredBevel(c, g, x, y, width, height);
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 1;
        insets.right = 1;
        insets.top = 1;
        insets.left = 1;
        return insets;
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    protected void paintRaisedBevel(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(this.highlightOuter);
        g.drawLine(0, 0, 0, h - 1);
        g.drawLine(1, 0, w - 1, 0);
        g.setColor(this.shadowOuter);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLoweredBevel(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        int h = height;
        int w = width;
        g.translate(x, y);
        g.setColor(this.shadowOuter);
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(2, 1, w - 2, 1);
        g.setColor(this.highlightOuter);
        g.drawLine(1, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 1, w - 1, h - 2);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    static {
        RAISED = 0;
        LOWERED = 1;
    }
}

