/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import com.borland.jbcl.layout.BoxLayout2;
import ext.lang.ZIllegalDataException;
import ext.swing.ZImageUtil;
import ext.swing.ZToolBar;
import ext.util.ZDoubleUtil;
import ext.util.ZFileUtil;
import ext.util.ZJIMIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import jclass.chart.SimpleChart;

public class ZTable1DPlot
extends JDialog
implements Printable {
    private double[][] rowData = null;
    private double[][] columnData = null;
    private String[] rowHeader = null;
    private String[] columnHeader = null;
    private double[] source = null;
    private int curXSize = 0;
    private JFileChooser fc = new JFileChooser();
    private JPanel panel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel P_chart = new JPanel();
    private JLabel statusBar = new JLabel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private SimpleChart chart = new SimpleChart();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JPanel P_toolBar = new JPanel();
    private ZToolBar toolBar = new ZToolBar();
    private JComboBox CB_axis = new JComboBox();
    private JComboBox CB_chartType = new JComboBox();
    private JRadioButton RB_row = new JRadioButton();
    private JComboBox CB_source = new JComboBox();
    private BoxLayout2 boxLayout21 = new BoxLayout2();
    private ZToolBar sourceBar = new ZToolBar();
    private JLabel L_source = new JLabel();
    private JLabel L_chartType = new JLabel();
    private JLabel L_axis = new JLabel();
    private JColorChooser cc = new JColorChooser();
    private Border border1;
    private JRadioButton RB_column = new JRadioButton();

    public ZTable1DPlot() {
        try {
            this.jbInit();
            this.setModal(true);
            ((Component)this).setSize(new Dimension(400, 450));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    private boolean isValidData(String[] header, Object[][] data) {
        int i;
        if (header.length <= 1) {
            return false;
        }
        if (data.length < 1) {
            return false;
        }
        for (i = 0; i < data.length; ++i) {
            if (data[i].length == header.length) continue;
            return false;
        }
        this.columnHeader = new String[header.length - 1];
        this.rowHeader = new String[data.length];
        this.columnData = new double[this.columnHeader.length][this.rowHeader.length];
        this.rowData = new double[this.rowHeader.length][this.columnHeader.length];
        try {
            for (i = 0; i < this.rowHeader.length; ++i) {
                this.rowHeader[i] = data[i][0].toString();
                for (int j = 1; j <= this.columnHeader.length; ++j) {
                    double d;
                    this.columnHeader[j - 1] = header[j];
                    this.columnData[j - 1][i] = d = Double.valueOf(data[i][j].toString()).doubleValue();
                    this.rowData[i][j - 1] = d;
                }
            }
        }
        catch (NumberFormatException ex) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public void setData(String[] header, Object[][] data) throws ZIllegalDataException {
        if (!this.isValidData(header, data)) {
            throw new ZIllegalDataException("Invalid data for 1-D plotting");
        }
        this.RB_column.doClick();
    }

    private void changeSource() {
        Vector<Integer> obj = new Vector<Integer>();
        for (int size = this.source.length; size >= 1; size /= 2) {
            obj.add(new Integer(size));
        }
        this.CB_axis.setModel(new DefaultComboBoxModel(obj));
        this.curXSize = this.source.length;
        this.CB_axis.setSelectedIndex(0);
        this.setChartData();
        this.setStatusBar();
    }

    private void setChartData() {
        int i;
        int[] xCountArray = new int[this.curXSize];
        for (int i2 = 0; i2 < this.curXSize; ++i2) {
            xCountArray[i2] = 0;
        }
        double minimum = ZDoubleUtil.min(this.source);
        double maximum = ZDoubleUtil.max(this.source);
        double interval = (maximum - minimum) / (double)this.curXSize;
        double start = minimum;
        for (int i3 = 0; i3 < this.source.length; ++i3) {
            int index = (int)((this.source[i3] - minimum) / interval);
            if (index >= this.curXSize) {
                // empty if block
            }
            int n = --index;
            xCountArray[n] = xCountArray[n] + 1;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Array 'Chart' 1 ");
        int effectiveSize = this.curXSize;
        for (i = 0; i < this.curXSize; ++i) {
            if (xCountArray[i] != 0) continue;
            --effectiveSize;
        }
        sb.append(String.valueOf(String.valueOf(effectiveSize)).concat(" "));
        for (i = 0; i < this.curXSize; ++i) {
            if (xCountArray[i] == 0) {
                start += interval;
                continue;
            }
            sb.append(String.valueOf(String.valueOf(start)).concat(" "));
            start += interval;
        }
        for (i = 0; i < this.curXSize; ++i) {
            if (xCountArray[i] == 0) continue;
            sb.append(String.valueOf(String.valueOf(xCountArray[i])).concat(" "));
        }
        this.chart.setData(sb.toString());
    }

    private void setStatusBar() {
        float minimum = (float)ZDoubleUtil.min(this.source);
        float maximum = (float)ZDoubleUtil.max(this.source);
        float mean = (float)ZDoubleUtil.mean(this.source);
        float sd = (float)ZDoubleUtil.sd(this.source);
        this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer("Statistics - Min: ").append(minimum).append("  Max: ").append(maximum).append("  Mean: ").append(mean).append(" SD: ").append(sd))));
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        ZImageUtil.printImage(g, pf, ZImageUtil.getComponentImage((Component)this.chart));
        return 0;
    }

    private void printGraph() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        book.append(this, printJob.defaultPage());
        printJob.setPageable(book);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void save() {
        this.fc.resetChoosableFileFilters();
        this.fc.addChoosableFileFilter(ZFileUtil.createFileFilter("JPG", "JPEG file(.jpg)"));
        int returnVal = this.fc.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        try {
            File file = this.fc.getSelectedFile();
            String fileName = file.getPath();
            fileName = String.valueOf(String.valueOf(ZFileUtil.getFileNameNoExt(file.getPath()))).concat(".jpg");
            ZJIMIUtil.saveAsJPG(ZImageUtil.getComponentImage((Component)this.chart), fileName);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    private void chooseBackground() {
        Color c = JColorChooser.showDialog(this, "Choose backgroud", this.chart.getBackground());
        if (c == null) {
            return;
        }
        if (!c.equals(this.chart.getBackground())) {
            this.chart.setBackground(c);
        }
    }

    private void chooseForeground() {
        Color c = JColorChooser.showDialog(this, "Choose foregroud", this.chart.getForeground());
        if (c == null) {
            return;
        }
        if (!c.equals(this.chart.getForeground())) {
            this.chart.setForeground(c);
        }
    }

    private void setChartType() {
        switch (this.CB_chartType.getSelectedIndex()) {
            case 0: {
                this.chart.setChartType(0);
                break;
            }
            case 1: {
                this.chart.setChartType(9);
                this.chart.setView3D("0,0,0");
                break;
            }
            case 2: {
                this.chart.setChartType(8);
                break;
            }
            case 3: {
                this.chart.setChartType(9);
                this.chart.setView3D("30,5,5");
                break;
            }
            case 4: {
                this.chart.setChartType(1);
            }
        }
    }

    public void showAtCenter() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        if (thisSize.height > screenSize.height) {
            thisSize.height = screenSize.height;
        }
        if (thisSize.width > screenSize.width) {
            thisSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
        ((Component)this).setVisible(true);
        this.RB_column.doClick();
    }

    private void jbInit() throws Exception {
        this.setTitle("1-D chart");
        this.panel.setLayout(this.borderLayout1);
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setToolTipText("");
        this.statusBar.setText("    Statistics - ");
        this.P_chart.setLayout(this.borderLayout2);
        this.RB_row.setText("row");
        this.RB_row.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.RB_row_actionPerformed(e);
            }
        });
        this.P_toolBar.setLayout((LayoutManager)this.boxLayout21);
        this.boxLayout21.setAxis(1);
        this.L_source.setToolTipText("");
        this.L_source.setText(" Choose source  ");
        this.toolBar.setAlignmentX(0.0f);
        this.sourceBar.setAlignmentX(0.0f);
        this.L_chartType.setToolTipText("");
        this.L_chartType.setText(" Chart type  ");
        this.L_axis.setText(" X-axis  ");
        this.L_axis.setToolTipText("");
        this.RB_column.setSelected(true);
        this.RB_column.setText("column");
        this.RB_column.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.RB_column_actionPerformed(e);
            }
        });
        this.chart.setBackground(Color.white);
        this.chart.setXAxisTitleText("Value");
        this.chart.setYAxisTitleText("Frequency");
        this.CB_source.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.CB_source_actionPerformed(e);
            }
        });
        this.CB_axis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.CB_axis_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.panel, "Center");
        this.panel.add((Component)this.P_chart, "Center");
        this.P_chart.add((Component)this.chart, "Center");
        this.panel.add((Component)this.statusBar, "South");
        this.panel.add((Component)this.P_toolBar, "North");
        this.P_toolBar.add((Component)this.toolBar, null);
        this.P_toolBar.add((Component)this.sourceBar, null);
        this.toolBar.addButton("exit", "", "exit");
        this.toolBar.getButton("exit").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.dispose();
            }
        });
        this.toolBar.addButton("print", "", "print the graph");
        this.toolBar.getButton("print").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.printGraph();
            }
        });
        this.toolBar.addButton("save", "", "save as JPG image");
        this.toolBar.getButton("save").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.save();
            }
        });
        this.toolBar.addButton("foreground", "", "choose foreground");
        this.toolBar.getButton("foreground").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.chooseForeground();
            }
        });
        this.toolBar.addButton("background", "", "choose background");
        this.toolBar.getButton("background").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.chooseBackground();
            }
        });
        this.toolBar.addSep();
        this.toolBar.add((Component)this.L_chartType, null);
        this.CB_chartType.addItem("Plot");
        this.CB_chartType.addItem("2D Bar");
        this.CB_chartType.addItem("Area");
        this.CB_chartType.addItem("3D Bar");
        this.CB_chartType.addItem("Scatter plot");
        this.CB_chartType.setPreferredSize(new Dimension(100, 21));
        this.CB_chartType.setMinimumSize(new Dimension(100, 21));
        this.CB_chartType.setMaximumSize(new Dimension(100, 21));
        this.CB_chartType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable1DPlot.this.setChartType();
            }
        });
        this.toolBar.add(this.CB_chartType);
        this.toolBar.add((Component)this.L_axis, null);
        this.CB_axis.setMinimumSize(new Dimension(63, 21));
        this.toolBar.add(this.CB_axis);
        this.buttonGroup.add(this.RB_row);
        this.buttonGroup.add(this.RB_column);
        this.sourceBar.add((Component)this.L_source, null);
        this.sourceBar.add((Component)this.RB_column, null);
        this.sourceBar.add((Component)this.RB_row, null);
        this.sourceBar.add((Component)this.CB_source, null);
    }

    private void RB_column_actionPerformed(ActionEvent e) {
        this.CB_source.setEnabled(false);
        this.CB_source.removeAllItems();
        for (int i = 0; i < this.columnHeader.length; ++i) {
            this.CB_source.addItem(this.columnHeader[i]);
        }
        this.CB_source.setEnabled(true);
        this.CB_source.setSelectedIndex(0);
    }

    private void RB_row_actionPerformed(ActionEvent e) {
        this.CB_source.setEnabled(false);
        this.CB_source.removeAllItems();
        for (int i = 0; i < this.rowHeader.length; ++i) {
            this.CB_source.addItem(this.rowHeader[i]);
        }
        this.CB_source.setEnabled(true);
        this.CB_source.setSelectedIndex(0);
    }

    private void CB_source_actionPerformed(ActionEvent e) {
        if (this.CB_source.getSelectedIndex() == -1) {
            return;
        }
        this.source = this.RB_column.isSelected() ? this.columnData[this.CB_source.getSelectedIndex()] : this.rowData[this.CB_source.getSelectedIndex()];
        this.changeSource();
    }

    private void CB_axis_actionPerformed(ActionEvent e) {
        if (this.CB_axis.getSelectedItem() == null) {
            return;
        }
        this.curXSize = (Integer)this.CB_axis.getSelectedItem();
        this.setChartData();
    }

    public static String[] getDemoHeader(int length) {
        String[] ret = new String[length];
        ret[0] = "";
        for (int i = 1; i < ret.length; ++i) {
            ret[i] = "header".concat(String.valueOf(String.valueOf(i)));
        }
        return ret;
    }

    public static String[][] getDemoData(int length) {
        String[][] ret = new String[length][length + 1];
        Random r = new Random();
        for (int i = 0; i < ret.length; ++i) {
            ret[i][0] = "Label".concat(String.valueOf(String.valueOf(i)));
            for (int j = 1; j < length + 1; ++j) {
                ret[i][j] = String.valueOf(r.nextInt(10));
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            ZTable1DPlot ZTable1DPlot1 = new ZTable1DPlot();
            ZTable1DPlot1.setData(ZTable1DPlot.getDemoHeader(101), ZTable1DPlot.getDemoData(100));
            ZTable1DPlot1.showAtCenter();
        }
        catch (ZIllegalDataException ex) {
            ex.printStackTrace();
        }
    }
}

