/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import com.borland.jbcl.layout.BoxLayout2;
import ext.lang.ZIllegalDataException;
import ext.swing.ZDialog;
import ext.swing.ZImageUtil;
import ext.swing.ZTableModel;
import ext.swing.ZToolBar;
import ext.util.ZDoubleUtil;
import ext.util.ZFileUtil;
import ext.util.ZJIMIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ZTable2DPlot
extends JDialog
implements Printable {
    private double[][] matrix = null;
    private String[][] modelMatrix = null;
    private String[] rowHeader = null;
    private String[] columnHeader = null;
    private int curCellSize = 20;
    private Color fgColor = new Color(255, 255, 204);
    private Color bgColor = Color.blue;
    private Color color1 = new Color(0, 0, 0);
    private Color color2 = new Color(128, 128, 128);
    private Color color3 = new Color(196, 196, 196);
    private Color color4 = new Color(255, 255, 255);
    private float min = 0.0f;
    private float max = 0.0f;
    private float range = 0.0f;
    private float cutoff = 0.0f;
    private MyRenderer rdr = new MyRenderer();
    private JPanel pHelp = new pValueHelp(this);
    private JFileChooser fc = new JFileChooser();
    private JPanel panel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane LP_chart = new JScrollPane();
    private JLabel statusBar = new JLabel();
    private JTable chart = new JTable();
    private JPanel P_toolBar = new JPanel();
    private ZToolBar toolBar = new ZToolBar();
    private JComboBox CB_cellSize = new JComboBox();
    private BoxLayout2 boxLayout21 = new BoxLayout2();
    private JPanel cutoffBar = new JPanel();
    private JLabel L_cutoff = new JLabel();
    private JLabel L_cellSize = new JLabel();
    private JColorChooser cc = new JColorChooser();
    private Border cellBorder;
    private BoxLayout2 boxLayout22 = new BoxLayout2();
    private JTextField TF_cutoff = new JTextField();
    private JSlider S_cutoff = new JSlider();
    private JCheckBox C_pValueData = new JCheckBox();
    private JCheckBox C_upperTriangle = new JCheckBox();

    public ZTable2DPlot() {
        try {
            this.jbInit();
            this.setModal(true);
            ((Component)this).setSize(new Dimension(460, 510));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValidData(String[] header, Object[][] data) {
        int i;
        if (header.length <= 1) {
            return false;
        }
        if (data.length < 1) {
            return false;
        }
        for (i = 0; i < data.length; ++i) {
            if (data[i].length == header.length) continue;
            return false;
        }
        this.columnHeader = new String[header.length - 1];
        this.rowHeader = new String[data.length];
        this.matrix = new double[this.rowHeader.length][this.columnHeader.length];
        this.modelMatrix = new String[this.rowHeader.length][this.columnHeader.length];
        try {
            for (i = 0; i < this.rowHeader.length; ++i) {
                this.rowHeader[i] = data[i][0].toString();
                for (int j = 1; j <= this.columnHeader.length; ++j) {
                    double d;
                    this.columnHeader[j - 1] = header[j];
                    this.matrix[i][j - 1] = d = Double.valueOf(data[i][j].toString()).doubleValue();
                    this.modelMatrix[i][j - 1] = data[i][j].toString();
                }
            }
        }
        catch (NumberFormatException ex) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public void setData(String[] header, Object[][] data) throws ZIllegalDataException {
        if (!this.isValidData(header, data)) {
            throw new ZIllegalDataException("Invalid data for 2-D plotting");
        }
        this.min = (float)ZDoubleUtil.min(this.matrix);
        this.max = (float)ZDoubleUtil.max(this.matrix);
        this.range = this.max - this.min;
        this.S_cutoff.setValue(5000);
        this.chart.setModel(new ZTableModel(this.modelMatrix, this.columnHeader));
        TableColumnModel cm = this.chart.getColumnModel();
        for (int i = 0; i < this.columnHeader.length; ++i) {
            TableColumn c = cm.getColumn(i);
            c.setCellRenderer(this.rdr);
            c.setResizable(false);
            c.setMinWidth(1);
        }
        this.CB_cellSize.setSelectedIndex(5);
        this.setStatusBar();
    }

    private void setCellSize(int cSize) {
        this.curCellSize = cSize;
        this.redraw();
    }

    private void redraw() {
        try {
            this.chart.setRowHeight(this.curCellSize);
            this.cutoff = Float.valueOf(this.TF_cutoff.getText()).floatValue();
            TableColumnModel cm = this.chart.getColumnModel();
            for (int i = 0; i < this.columnHeader.length; ++i) {
                TableColumn c = cm.getColumn(i);
                c.setPreferredWidth(this.curCellSize);
            }
            this.chart.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setStatusBar() {
        float minimum = (float)ZDoubleUtil.min(this.matrix);
        float maximum = (float)ZDoubleUtil.max(this.matrix);
        float mean = (float)ZDoubleUtil.mean(this.matrix);
        float sd = (float)ZDoubleUtil.sd(this.matrix);
        this.statusBar.setText(String.valueOf(String.valueOf(new StringBuffer("Statistics - Min: ").append(minimum).append("  Max: ").append(maximum).append("  Mean: ").append(mean).append(" SD: ").append(sd))));
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        ZImageUtil.printImage(g, pf, ZImageUtil.getComponentImage(this.chart));
        return 0;
    }

    private void printGraph() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        book.append(this, printJob.defaultPage());
        printJob.setPageable(book);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean isJIMILoaded() {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("com/sun/jimi/core/Jimi");
        }
        catch (ClassNotFoundException ex) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private void save() {
        this.fc.resetChoosableFileFilters();
        this.fc.addChoosableFileFilter(ZFileUtil.createFileFilter("JPG", "JPEG file(.jpg)"));
        int returnVal = this.fc.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        try {
            File file = this.fc.getSelectedFile();
            String fileName = file.getPath();
            fileName = String.valueOf(String.valueOf(ZFileUtil.getFileNameNoExt(file.getPath()))).concat(".jpg");
            ZJIMIUtil.saveAsJPG(ZImageUtil.getComponentImage(this.chart), fileName);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    private void chooseBackground() {
        Color c = JColorChooser.showDialog(this, "Choose backgroud", this.chart.getBackground());
        if (c == null) {
            return;
        }
        if (!c.equals(this.chart.getBackground())) {
            this.bgColor = c;
            this.redraw();
        }
    }

    private void chooseForeground() {
        Color c = JColorChooser.showDialog(this, "Choose foregroud", this.chart.getForeground());
        if (c == null) {
            return;
        }
        if (!c.equals(this.chart.getForeground())) {
            this.fgColor = c;
            this.redraw();
        }
    }

    public void showAtCenter() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        if (thisSize.height > screenSize.height) {
            thisSize.height = screenSize.height;
        }
        if (thisSize.width > screenSize.width) {
            thisSize.width = screenSize.width;
        }
        ((Component)this).setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
        ((Component)this).setVisible(true);
        this.redraw();
    }

    private void jbInit() throws Exception {
        this.setTitle("2-D chart");
        this.cellBorder = BorderFactory.createEmptyBorder(15, 15, 15, 15);
        this.panel.setLayout(this.borderLayout1);
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setToolTipText("");
        this.statusBar.setText("    Statistics - ");
        this.P_toolBar.setLayout((LayoutManager)this.boxLayout21);
        this.boxLayout21.setAxis(1);
        this.toolBar.setAlignmentX(0.0f);
        this.cutoffBar.setAlignmentX(0.0f);
        this.cutoffBar.setLayout((LayoutManager)this.boxLayout22);
        this.L_cutoff.setText(" Cutoff  ");
        this.L_cellSize.setText(" Cell size  ");
        this.chart.setBackground(Color.white);
        this.chart.setToolTipText("");
        this.chart.setAutoResizeMode(0);
        this.chart.setIntercellSpacing(new Dimension(0, 0));
        this.chart.setTableHeader(null);
        this.TF_cutoff.setMaximumSize(new Dimension(80, 21));
        this.TF_cutoff.setMinimumSize(new Dimension(80, 21));
        this.TF_cutoff.setPreferredSize(new Dimension(80, 21));
        this.TF_cutoff.setToolTipText("");
        this.TF_cutoff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable2DPlot.this.TF_cutoff_actionPerformed(e);
            }
        });
        this.S_cutoff.setMinorTickSpacing(2000);
        this.S_cutoff.setMajorTickSpacing(10000);
        this.S_cutoff.setPaintTicks(true);
        this.S_cutoff.setMaximum(100000);
        this.S_cutoff.setToolTipText("Drag the slide to set cutoff!");
        this.S_cutoff.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ZTable2DPlot.this.S_cutoff_stateChanged(e);
            }
        });
        this.C_pValueData.setText("P-Value");
        this.C_pValueData.setToolTipText("");
        this.C_pValueData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable2DPlot.this.C_pValueData_actionPerformed(e);
            }
        });
        this.C_upperTriangle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable2DPlot.this.C_upperTriangle_actionPerformed(e);
            }
        });
        this.C_upperTriangle.setToolTipText("");
        this.C_upperTriangle.setText("only upper triangle");
        this.getContentPane().add((Component)this.panel, "Center");
        this.panel.add((Component)this.LP_chart, "Center");
        this.LP_chart.getViewport().add(this.chart);
        this.panel.add((Component)this.statusBar, "South");
        this.panel.add((Component)this.P_toolBar, "North");
        this.P_toolBar.add((Component)this.toolBar, null);
        this.P_toolBar.add((Component)this.cutoffBar, null);
        this.toolBar.addButton("exit", "", "exit");
        this.toolBar.getButton("exit").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable2DPlot.this.dispose();
            }
        });
        this.toolBar.addButton("print", "", "print the graph");
        this.toolBar.getButton("print").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable2DPlot.this.printGraph();
            }
        });
        this.toolBar.addButton("save", "", "save as JPG image");
        this.toolBar.getButton("save").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ZTable2DPlot.isJIMILoaded()) {
                    ZTable2DPlot.this.save();
                } else {
                    JOptionPane.showMessageDialog(null, "This function was disabled in foundation version.");
                }
            }
        });
        this.toolBar.addButton("foreground", "", "choose foreground");
        this.toolBar.getButton("foreground").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable2DPlot.this.chooseForeground();
            }
        });
        this.toolBar.addButton("background", "", "choose background");
        this.toolBar.getButton("background").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable2DPlot.this.chooseBackground();
            }
        });
        this.toolBar.addSep();
        this.toolBar.add((Component)this.L_cellSize, null);
        for (int i = 2; i < 20; ++i) {
            this.CB_cellSize.addItem(new Integer(i * 2));
        }
        this.CB_cellSize.setPreferredSize(new Dimension(40, 21));
        this.CB_cellSize.setMinimumSize(new Dimension(40, 21));
        this.CB_cellSize.setMaximumSize(new Dimension(40, 21));
        this.CB_cellSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object obj = ZTable2DPlot.this.CB_cellSize.getSelectedItem();
                if (obj == null) {
                    return;
                }
                Integer iobj = (Integer)obj;
                ZTable2DPlot.this.setCellSize(iobj);
            }
        });
        this.toolBar.addSep();
        this.toolBar.add(this.CB_cellSize);
        this.toolBar.add((Component)this.C_upperTriangle, null);
        this.toolBar.addSep();
        this.toolBar.add((Component)this.C_pValueData, null);
        this.toolBar.addButton("help", "", "cutoff for pValue data");
        this.toolBar.getButton("help").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZTable2DPlot.this.showHelp();
            }
        });
        this.toolBar.getButton("help").setEnabled(false);
        this.cutoffBar.add((Component)this.L_cutoff, null);
        this.cutoffBar.add((Component)this.TF_cutoff, null);
        this.cutoffBar.add((Component)this.S_cutoff, null);
    }

    private void S_cutoff_stateChanged(ChangeEvent e) {
        this.redraw();
        float currentValue = this.S_cutoff.getValue();
        String str = String.valueOf(this.min + currentValue * this.range / (float)100000);
        this.TF_cutoff.setText(str);
    }

    private void TF_cutoff_actionPerformed(ActionEvent e) {
        String currentValue = this.TF_cutoff.getText();
        try {
            float f = Float.valueOf(currentValue).floatValue();
            if (f < this.min) {
                f = this.min;
            }
            if (f > this.max) {
                f = this.max;
            }
            this.S_cutoff.setValue((int)((f - this.min) * (float)100000 / this.range));
        }
        catch (NumberFormatException ex) {
            float c = this.S_cutoff.getValue();
            this.TF_cutoff.setText(String.valueOf(this.min + c * this.range / (float)100000));
        }
    }

    private void C_pValueData_actionPerformed(ActionEvent e) {
        if (this.C_pValueData.isSelected()) {
            this.S_cutoff.setEnabled(false);
            this.TF_cutoff.setEnabled(false);
            this.toolBar.getButton("help").setEnabled(true);
        } else {
            this.S_cutoff.setEnabled(true);
            this.TF_cutoff.setEnabled(true);
            this.toolBar.getButton("help").setEnabled(false);
        }
        this.redraw();
    }

    private void C_upperTriangle_actionPerformed(ActionEvent e) {
        this.redraw();
    }

    private void showHelp() {
        ZDialog d = new ZDialog();
        d.getContentPane().add(this.pHelp);
        d.pack();
        d.showAtCenter();
    }

    public static String[] getDemoHeader(int length) {
        String[] ret = new String[length];
        ret[0] = "";
        for (int i = 1; i < ret.length; ++i) {
            ret[i] = "header".concat(String.valueOf(String.valueOf(i)));
        }
        return ret;
    }

    public static String[][] getDemoData(int length) {
        String[][] ret = new String[length][length + 1];
        Random r = new Random();
        for (int i = 0; i < ret.length; ++i) {
            ret[i][0] = "Label".concat(String.valueOf(String.valueOf(i)));
            for (int j = 1; j < length + 1; ++j) {
                ret[i][j] = String.valueOf(r.nextInt(10));
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            ZTable2DPlot ZTable2DPlot1 = new ZTable2DPlot();
            ZTable2DPlot1.setData(ZTable2DPlot.getDemoHeader(21), ZTable2DPlot.getDemoData(20));
            ZTable2DPlot1.showAtCenter();
        }
        catch (ZIllegalDataException ex) {
            ex.printStackTrace();
        }
    }

    private class MyRenderer
    extends DefaultTableCellRenderer {
        private Border border1 = new LineBorder(new Color(214, 214, 214), 1);
        private Border border2 = new LineBorder(Color.white, 1);

        private MyRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(this.border1);
            this.setToolTipText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(ZTable2DPlot.this.rowHeader[row]))).append(":").append(ZTable2DPlot.this.columnHeader[column]).append("(").append(value.toString()).append(")"))));
            if (ZTable2DPlot.this.C_upperTriangle.isSelected() && row > column) {
                this.setBorder(this.border2);
                this.setBackground(Color.white);
                return this;
            }
            if (!ZTable2DPlot.this.C_pValueData.isSelected()) {
                if (ZTable2DPlot.this.matrix[row][column] >= (double)ZTable2DPlot.this.cutoff) {
                    this.setBackground(ZTable2DPlot.this.fgColor);
                } else {
                    this.setBackground(ZTable2DPlot.this.bgColor);
                }
            } else if (ZTable2DPlot.this.matrix[row][column] <= 0.001) {
                this.setBackground(ZTable2DPlot.this.color1);
            } else if (ZTable2DPlot.this.matrix[row][column] <= 0.01) {
                this.setBackground(ZTable2DPlot.this.color2);
            } else if (ZTable2DPlot.this.matrix[row][column] <= 0.05) {
                this.setBackground(ZTable2DPlot.this.color3);
            } else {
                this.setBackground(ZTable2DPlot.this.color4);
            }
            return this;
        }
    }

    private class pValueHelp
    extends JPanel {
        public pValueHelp(ZTable2DPlot this$0) {
            this.setLayout(new GridLayout(4, 1));
            JPanel p1 = new JPanel();
            DefaultTableCellRenderer label1 = new DefaultTableCellRenderer();
            label1.setPreferredSize(new Dimension(18, 18));
            ((JComponent)label1).setBackground(this$0.color1);
            p1.add(label1);
            p1.add(new JLabel(" < 0.001"));
            p1.setLayout(new FlowLayout(0));
            this.add(p1);
            JPanel p2 = new JPanel();
            DefaultTableCellRenderer label2 = new DefaultTableCellRenderer();
            label2.setPreferredSize(new Dimension(18, 18));
            ((JComponent)label2).setBackground(this$0.color2);
            p2.add(label2);
            p2.add(new JLabel(" 0.001 - 0.01"));
            p2.setLayout(new FlowLayout(0));
            this.add(p2);
            JPanel p3 = new JPanel();
            DefaultTableCellRenderer label3 = new DefaultTableCellRenderer();
            label3.setPreferredSize(new Dimension(18, 18));
            ((JComponent)label3).setBackground(this$0.color3);
            p3.add(label3);
            p3.add(new JLabel(" 0.01 - 0.05"));
            p3.setLayout(new FlowLayout(0));
            this.add(p3);
            JPanel p4 = new JPanel();
            DefaultTableCellRenderer label4 = new DefaultTableCellRenderer();
            label4.setPreferredSize(new Dimension(18, 18));
            ((JComponent)label4).setBackground(this$0.color4);
            p4.add(label4);
            p4.add(new JLabel(" > 0.05"));
            p4.setLayout(new FlowLayout(0));
            this.add(p4);
        }
    }
}

