/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import ext.swing.ZActionListener;
import ext.swing.ZImageFactory;
import ext.swing.ZStandardBorder;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class ZToggleButton
extends JToggleButton {
    private Border raisedBorder = new ZStandardBorder(0);
    private Border loweredBorder = new ZStandardBorder(1);
    private Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private Color oldColor = null;
    private Color newColor = Color.black;
    private String name = null;
    private ZActionListener listener = new ZActionListener(this){

        public void action(Object o) {
        }
    };

    public ZToggleButton() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ZToggleButton(String name, String label, String tip) {
        try {
            this.jbInit();
            this.set(name, label, tip);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public ZActionListener getListener() {
        return this.listener;
    }

    public void set(String name, String label, String tip) {
        this.name = name;
        this.setIcon(ZImageFactory.getImageIcon(String.valueOf(String.valueOf(name)).concat(String.valueOf(String.valueOf(0)))));
        this.setRolloverIcon(ZImageFactory.getImageIcon(String.valueOf(String.valueOf(name)).concat(String.valueOf(String.valueOf(1)))));
        if (label != null) {
            this.setText(label);
        } else {
            this.setText(name);
        }
        if (tip != null) {
            this.setToolTipText(tip);
        }
    }

    public void setSelected(boolean b) {
        super.setSelected(b);
        if (b) {
            this.setForeground(this.newColor);
            this.setBorder(this.loweredBorder);
        } else {
            this.setForeground(this.oldColor);
            this.setBorder(this.emptyBorder);
        }
    }

    public void addAction(ZActionListener l) {
        this.listener = l;
    }

    private void jbInit() throws Exception {
        this.oldColor = this.getForeground();
        this.setBorder(this.emptyBorder);
        this.setFocusPainted(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                ZToggleButton.this.this_mouseEntered(e);
            }

            public void mousePressed(MouseEvent e) {
                ZToggleButton.this.this_mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                ZToggleButton.this.this_mouseReleased(e);
            }

            public void mouseExited(MouseEvent e) {
                ZToggleButton.this.this_mouseExited(e);
            }
        });
    }

    private void this_mouseEntered(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isSelected()) {
            return;
        }
        this.setForeground(this.newColor);
        this.setBorder(this.raisedBorder);
    }

    private void this_mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isSelected()) {
            return;
        }
        this.setBorder(this.loweredBorder);
    }

    private void this_mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isSelected()) {
            return;
        }
        this.setBorder(this.raisedBorder);
    }

    private void this_mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isSelected()) {
            return;
        }
        this.setForeground(this.oldColor);
        this.setBorder(this.emptyBorder);
    }
}

