/*
 * Decompiled with CFR 0.152.
 */
package ext.swing;

import ext.lang.ZStringVector;
import ext.swing.ZActionListener;
import ext.swing.ZButton;
import ext.swing.ZIntField;
import ext.swing.ZToggleButton;
import ext.swing.ZTypeField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ZToolBar
extends JToolBar {
    private HashMap buttonMap = new HashMap();
    private HashMap toggleButtonMap = new HashMap();

    public ZToolBar() {
        this.setFloatable(false);
    }

    public ZButton getButton(String name) {
        return (ZButton)this.buttonMap.get(name);
    }

    public ZToggleButton getToggleButton(String name) {
        return (ZToggleButton)this.toggleButtonMap.get(name);
    }

    public void addButton(String name, String label, String tip) {
        ZButton b = new ZButton(name, label, tip);
        this.buttonMap.put(name, b);
        this.add(b);
    }

    public void addToggleButton(String name, String label, String tip) {
        final ZToggleButton b = new ZToggleButton(name, label, tip);
        this.toggleButtonMap.put(name, b);
        this.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (b.isSelected()) {
                    ZToolBar.this.setToggleButton(b.getName());
                }
                b.getListener().action(b);
            }
        });
    }

    public void setAllButtonsEnabled(boolean b) {
        Iterator iter = this.buttonMap.values().iterator();
        while (iter.hasNext()) {
            ZButton button = (ZButton)iter.next();
            button.setEnabled(b);
        }
    }

    public void setAllToggleButtonsEnabled(boolean b) {
        Iterator iter = this.toggleButtonMap.values().iterator();
        while (iter.hasNext()) {
            ZToggleButton button = (ZToggleButton)iter.next();
            button.setEnabled(b);
        }
    }

    public void setToggleButton(String name) {
        Iterator iter = this.toggleButtonMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ZToggleButton b = (ZToggleButton)entry.getValue();
            if (entry.getKey().equals(name)) {
                b.setSelected(true);
                continue;
            }
            b.setSelected(false);
        }
    }

    public void addHeader() {
        this.add(ZButton.createHeader(21));
    }

    public void addHeader(int height) {
        this.add(ZButton.createHeader(height));
    }

    public void addSep() {
        this.add(ZButton.createSeparator(21));
    }

    public void addSep(int height) {
        this.add(ZButton.createSeparator(height));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        final ZToolBar t = new ZToolBar();
        frame.getContentPane().add(t);
        t.addHeader();
        t.addButton("open", "open", null);
        t.addButton("refresh", "", "new something");
        t.addButton("get", "get", "get something");
        t.addSep();
        t.addToggleButton("option", null, null);
        t.addToggleButton("copyto", null, null);
        t.addToggleButton("expand", null, null);
        t.getToggleButton("copyto").addAction(new ZActionListener(){

            public void action(Object obj) {
                ZToggleButton b = (ZToggleButton)obj;
                if (b.isSelected()) {
                    t.getButton("open").setBackground(Color.blue);
                } else {
                    t.getButton("open").setBackground(Color.red);
                }
            }
        });
        final JPanel p = new JPanel();
        final ZIntField f1 = new ZIntField(0, 32);
        ZStringVector sv = new ZStringVector();
        sv.pushBack("liukj");
        sv.pushBack("liukj2");
        sv.pushBack("liukj3");
        ZTypeField f2 = new ZTypeField(sv.toArray());
        f1.setPreferredSize(new Dimension(100, 20));
        f1.setBorder(BorderFactory.createEmptyBorder());
        f1.setBackground(Color.yellow);
        f1.setForeground(Color.black);
        f1.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                f1.setPreferredSize(new Dimension(f1.getText().length() * 8 + 20, 20));
                p.revalidate();
            }
        });
        p.add(f1);
        p.add(f2);
        t.getToggleButton("expand").addAction(new ZActionListener(){

            public void action(Object obj) {
                if (!f1.verify()) {
                    JOptionPane.showMessageDialog(f1, String.valueOf(String.valueOf(f1.getText())).concat("is not good!"));
                } else {
                    JOptionPane.showMessageDialog(f1, String.valueOf(String.valueOf(f1.getText())).concat("is good!"));
                }
            }
        });
        frame.getContentPane().add((Component)p, "South");
        ((Component)frame).setVisible(true);
    }
}

