/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.font.FontFamilyResolver;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;
import org.apache.batik.gvt.renderer.BasicTextPainter;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.BidiAttributedCharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class StrokingTextPainter
extends BasicTextPainter {
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    public static final AttributedCharacterIterator.Attribute GVT_FONT_FAMILIES = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES;
    public static final AttributedCharacterIterator.Attribute BIDI_LEVEL = GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL;
    public static final AttributedCharacterIterator.Attribute XPOS = GVTAttributedCharacterIterator.TextAttribute.X;
    public static final AttributedCharacterIterator.Attribute YPOS = GVTAttributedCharacterIterator.TextAttribute.Y;
    public static final AttributedCharacterIterator.Attribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    public static final AttributedCharacterIterator.Attribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    static Set extendedAtts = new HashSet();
    protected static TextPainter singleton;

    public static TextPainter getInstance() {
        return singleton;
    }

    public void paint(TextNode textNode, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        this.paintDecorations(list, graphics2D, 1);
        this.paintDecorations(list, graphics2D, 4);
        this.paintTextRuns(list, graphics2D);
        this.paintDecorations(list, graphics2D, 2);
    }

    private void printAttrs(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        int n = attributedCharacterIterator.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (attributedCharacterIterator.current() != '\uffff') {
            int n2 = attributedCharacterIterator.getRunLimit();
            System.out.print("" + (n2 - n) + ", ");
            attributedCharacterIterator.setIndex(n2);
            n = n2;
        }
        System.out.println("");
    }

    public List getTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        Object object;
        ArrayList arrayList = textNode.getTextRuns();
        if (arrayList != null) {
            return arrayList;
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = this.getTextChunkACIs(attributedCharacterIterator);
        int[][] nArrayArray = new int[attributedCharacterIteratorArray.length][];
        int n = attributedCharacterIterator.getBeginIndex();
        int n2 = 0;
        while (n2 < attributedCharacterIteratorArray.length) {
            object = new BidiAttributedCharacterIterator(attributedCharacterIteratorArray[n2], this.fontRenderContext, n);
            attributedCharacterIteratorArray[n2] = object;
            nArrayArray[n2] = ((BidiAttributedCharacterIterator)object).getCharMap();
            attributedCharacterIteratorArray[n2] = this.createModifiedACIForFontMatching(textNode, attributedCharacterIteratorArray[n2]);
            n += attributedCharacterIteratorArray[n2].getEndIndex() - attributedCharacterIteratorArray[n2].getBeginIndex();
            ++n2;
        }
        arrayList = new ArrayList();
        Object object2 = null;
        int n3 = 0;
        int n4 = 0;
        do {
            attributedCharacterIteratorArray[n4].first();
            object = this.getTextChunk(textNode, attributedCharacterIteratorArray[n4], nArrayArray[n4], arrayList, n3, (TextChunk)object2);
            attributedCharacterIteratorArray[n4].first();
            if (object != null) {
                this.adjustChunkOffsets(arrayList, ((TextChunk)object).advance, ((TextChunk)object).begin, ((TextChunk)object).end);
                n3 = ((TextChunk)object).end;
            }
            object2 = object;
        } while (object != null && ++n4 < attributedCharacterIteratorArray.length);
        textNode.setTextRuns(arrayList);
        return arrayList;
    }

    private AttributedCharacterIterator[] getTextChunkACIs(AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        Object object;
        ArrayList<AttributedCharacterSpanIterator> arrayList = new ArrayList<AttributedCharacterSpanIterator>();
        int n2 = attributedCharacterIterator.getBeginIndex();
        while (attributedCharacterIterator.setIndex(n2) != '\uffff') {
            object = null;
            int n3 = n2;
            n = 0;
            while (attributedCharacterIterator.setIndex(n3) != '\uffff') {
                Float f;
                Serializable serializable;
                TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
                if (n3 != n2) {
                    serializable = (Float)attributedCharacterIterator.getAttribute(XPOS);
                    f = (Float)attributedCharacterIterator.getAttribute(YPOS);
                    if (serializable != null && !serializable.isNaN() || f != null && !f.isNaN() || object == null && textPath != null) break;
                }
                object = textPath;
                n = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_DELIMITER);
                if (n3 == n2 && (serializable = (TextNode.Anchor)attributedCharacterIterator.getAttribute(ANCHOR_TYPE)) != TextNode.Anchor.START) {
                    f = (Float)attributedCharacterIterator.getAttribute(XPOS);
                    Float f2 = (Float)attributedCharacterIterator.getAttribute(YPOS);
                    if (f != null && !f.isNaN() || f2 != null && !f2.isNaN()) {
                        int n4 = n3 + 1;
                        while (n4 < n) {
                            attributedCharacterIterator.setIndex(n4);
                            f = (Float)attributedCharacterIterator.getAttribute(XPOS);
                            f2 = (Float)attributedCharacterIterator.getAttribute(YPOS);
                            if (!(f != null && !f.isNaN() || f2 != null && !f2.isNaN())) break;
                            arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n4 - 1, n4));
                            n2 = n4++;
                        }
                    }
                }
                n3 = n;
            }
            int n5 = attributedCharacterIterator.getIndex();
            arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n2, n5));
            n2 = n5;
        }
        object = new AttributedCharacterIterator[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n = 0;
        while (iterator.hasNext()) {
            object[n] = (AttributedCharacterIterator)iterator.next();
            ++n;
        }
        return object;
    }

    private TextChunk getTextChunk(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, int[] nArray, List list, int n, TextChunk textChunk) {
        int n2 = n;
        int n3 = attributedCharacterIterator.getIndex();
        if (attributedCharacterIterator.current() == '\uffff') {
            return null;
        }
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        Point2D point2D = textChunk == null ? textNode.getLocation() : new Point2D.Float((float)(textChunk.absLoc.getX() + textChunk.advance.getX()), (float)(textChunk.absLoc.getY() + textChunk.advance.getY()));
        boolean bl = true;
        TextPath textPath = null;
        Point2D point2D2 = null;
        while (true) {
            int n4 = attributedCharacterIterator.getRunStart(extendedAtts);
            int n5 = attributedCharacterIterator.getRunLimit(extendedAtts);
            AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n4, n5);
            attributedCharacterSpanIterator.first();
            Float f = (Float)attributedCharacterSpanIterator.getAttribute(XPOS);
            Float f2 = (Float)attributedCharacterSpanIterator.getAttribute(YPOS);
            TextPath textPath2 = (TextPath)attributedCharacterSpanIterator.getAttribute(TEXTPATH);
            Point2D.Float float_2 = textPath2 == null ? (textPath != null && point2D2 != null ? new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY()) : new Point2D.Float((float)(point2D.getX() + ((Point2D)float_).getX()), (float)(point2D.getY() + ((Point2D)float_).getY()))) : new Point2D.Float((float)((Point2D)float_).getX(), (float)((Point2D)float_).getY());
            int[] nArray2 = new int[n5 - n4];
            int n6 = 0;
            while (n6 < nArray2.length) {
                nArray2[n6] = nArray[n6 + n4 - n3];
                ++n6;
            }
            TextSpanLayout textSpanLayout = this.getTextLayoutFactory().createTextLayout(attributedCharacterSpanIterator, nArray2, float_2, this.fontRenderContext);
            TextRun textRun = new TextRun(textSpanLayout, attributedCharacterSpanIterator, bl);
            list.add(textRun);
            Point2D point2D3 = textSpanLayout.getAdvance2D();
            if (bl) {
                point2D = textSpanLayout.getOffset();
            }
            float_ = new Point2D.Float((float)(((Point2D)float_).getX() + point2D3.getX()), (float)(((Point2D)float_).getY() + point2D3.getY()));
            ++n2;
            textPath = textPath2;
            point2D2 = textSpanLayout.getTextPathAdvance();
            if (attributedCharacterIterator.setIndex(n5) == '\uffff') break;
            bl = false;
        }
        return new TextChunk(n, n2, point2D, float_);
    }

    private AttributedCharacterIterator createModifiedACIForFontMatching(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        AttributedString attributedString = null;
        int n = 0;
        int n2 = attributedCharacterIterator.getBeginIndex();
        boolean bl = true;
        while (bl) {
            int n3;
            int n4;
            GVTFont gVTFont;
            GVTFontFamily gVTFontFamily;
            int n5;
            int n6 = attributedCharacterIterator.getRunStart(TEXT_COMPOUND_DELIMITER);
            int n7 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_DELIMITER);
            int n8 = n7 - n6;
            Vector vector = (Vector)attributedCharacterIterator.getAttributes().get(GVT_FONT_FAMILIES);
            if (vector == null) {
                n += n8;
                bl = attributedCharacterIterator.setIndex(n7) != '\uffff';
                continue;
            }
            Vector<GVTFontFamily> vector2 = new Vector<GVTFontFamily>();
            int n9 = 0;
            while (n9 < vector.size()) {
                GVTFontFamily gVTFontFamily2 = (GVTFontFamily)vector.get(n9);
                if (gVTFontFamily2 instanceof UnresolvedFontFamily) {
                    gVTFontFamily2 = FontFamilyResolver.resolve((UnresolvedFontFamily)gVTFontFamily2);
                }
                if (gVTFontFamily2 != null) {
                    vector2.add(gVTFontFamily2);
                }
                ++n9;
            }
            if (vector2.size() == 0) {
                vector2.add(FontFamilyResolver.defaultFont);
            }
            float f = 12.0f;
            Float f2 = (Float)attributedCharacterIterator.getAttributes().get(TextAttribute.SIZE);
            if (f2 != null) {
                f = f2.floatValue();
            }
            boolean[] blArray = new boolean[n8];
            int n10 = 0;
            while (n10 < n8) {
                blArray[n10] = false;
                ++n10;
            }
            if (attributedString == null) {
                attributedString = new AttributedString(attributedCharacterIterator);
            }
            GVTFont gVTFont2 = null;
            int n11 = 0;
            int n12 = n6;
            int n13 = 0;
            while (n13 < vector2.size()) {
                n5 = n12;
                boolean bl2 = false;
                attributedCharacterIterator.setIndex(n5);
                gVTFontFamily = (GVTFontFamily)vector2.get(n13);
                gVTFont = gVTFontFamily.deriveFont(f, attributedCharacterIterator);
                if (gVTFont2 == null) {
                    gVTFont2 = gVTFont;
                }
                while (n5 < n7) {
                    n4 = gVTFont.canDisplayUpTo(attributedCharacterIterator, n5, n7);
                    if (n4 == -1) {
                        n4 = n7;
                    }
                    if (n4 <= n5) {
                        if (!bl2) {
                            n12 = n5;
                            bl2 = true;
                        }
                        ++n5;
                        continue;
                    }
                    n3 = -1;
                    int n14 = n5;
                    while (n14 < n4) {
                        if (blArray[n14 - n6]) {
                            if (n3 != -1) {
                                attributedString.addAttribute(GVT_FONT, gVTFont, n3 - n2, n14 - n2);
                                n3 = -1;
                            }
                        } else if (n3 == -1) {
                            n3 = n14;
                        }
                        blArray[n14 - n6] = true;
                        ++n11;
                        ++n14;
                    }
                    if (n3 != -1) {
                        attributedString.addAttribute(GVT_FONT, gVTFont, n3 - n2, n4 - n2);
                    }
                    n5 = n4 + 1;
                }
                if (n11 == n8) break;
                ++n13;
            }
            n5 = -1;
            gVTFontFamily = null;
            gVTFont = gVTFont2;
            n4 = 0;
            while (n4 < n8) {
                if (blArray[n4]) {
                    if (n5 != -1) {
                        attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n4 + n);
                        n5 = -1;
                        gVTFont = null;
                        gVTFontFamily = null;
                    }
                } else {
                    n3 = attributedCharacterIterator.setIndex(n6 + n4);
                    GVTFontFamily gVTFontFamily3 = FontFamilyResolver.getFamilyThatCanDisplay((char)n3);
                    if (n5 == -1) {
                        n5 = n4;
                        gVTFontFamily = gVTFontFamily3;
                        gVTFont = gVTFontFamily == null ? gVTFont2 : gVTFontFamily3.deriveFont(f, attributedCharacterIterator);
                    } else if (gVTFontFamily != gVTFontFamily3) {
                        attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n4 + n);
                        n5 = n4;
                        gVTFontFamily = gVTFontFamily3;
                        gVTFont = gVTFontFamily == null ? gVTFont2 : gVTFontFamily3.deriveFont(f, attributedCharacterIterator);
                    }
                }
                ++n4;
            }
            if (n5 != -1) {
                attributedString.addAttribute(GVT_FONT, gVTFont, n5 + n, n8 + n);
            }
            n += n8;
            if (attributedCharacterIterator.setIndex(n7) != '\uffff') continue;
            bl = false;
        }
        if (attributedString != null) {
            return attributedString.getIterator();
        }
        return attributedCharacterIterator;
    }

    private void adjustChunkOffsets(List list, Point2D point2D, int n, int n2) {
        TextRun textRun = (TextRun)list.get(n);
        int n3 = textRun.getAnchorType();
        float f = 0.0f;
        float f2 = 0.0f;
        switch (n3) {
            case 1: {
                f = (float)(-point2D.getX() / 2.0);
                f2 = (float)(-point2D.getY() / 2.0);
                break;
            }
            case 2: {
                f = (float)(-point2D.getX());
                f2 = (float)(-point2D.getY());
                break;
            }
        }
        int n4 = n;
        while (n4 < n2) {
            textRun = (TextRun)list.get(n4);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            Point2D point2D2 = textSpanLayout.getOffset();
            point2D2 = textSpanLayout.isVertical() ? new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY() + f2) : new Point2D.Float((float)point2D2.getX() + f, (float)point2D2.getY());
            textSpanLayout.setOffset(point2D2);
            ++n4;
        }
    }

    private void paintDecorations(List list, Graphics2D graphics2D, int n) {
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Composite composite = (Composite)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null) {
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(rectangle2D);
                }
                if (stroke != null && paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(rectangle2D);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null) {
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(rectangle2D);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.setStroke(stroke);
                graphics2D.draw(rectangle2D);
            }
        }
    }

    private void paintTextRuns(List list, Graphics2D graphics2D) {
        int n = 0;
        while (n < list.size()) {
            TextRun textRun = (TextRun)list.get(n);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Composite composite = (Composite)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY);
            if (composite != null) {
                graphics2D.setComposite(composite);
            }
            textRun.getLayout().draw(graphics2D);
            ++n;
        }
    }

    protected Rectangle2D getBounds(TextNode textNode, boolean bl, boolean bl2) {
        Shape shape;
        Rectangle2D rectangle2D = this.getOutline(textNode, bl).getBounds2D();
        if (bl2 && (shape = this.getStrokeOutline(textNode, bl)) != null) {
            rectangle2D = rectangle2D.createUnion(shape.getBounds2D());
        }
        return rectangle2D;
    }

    protected Shape getOutline(TextNode textNode, boolean bl) {
        Shape shape;
        Object object;
        Object object2;
        Shape shape2 = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = 0;
        while (n < list.size()) {
            object2 = (TextRun)list.get(n);
            object = ((TextRun)object2).getLayout();
            shape = new GeneralPath(object.getOutline());
            if (shape2 == null) {
                shape2 = shape;
            } else {
                ((Path2D)shape2).setWindingRule(1);
                ((Path2D)shape2).append(shape, false);
            }
            ++n;
        }
        if (bl) {
            object2 = this.getDecorationOutline(list, 1);
            object = this.getDecorationOutline(list, 2);
            shape = this.getDecorationOutline(list, 4);
            if (object2 != null) {
                if (shape2 == null) {
                    shape2 = new GeneralPath((Shape)object2);
                } else {
                    ((Path2D)shape2).setWindingRule(1);
                    ((Path2D)shape2).append((Shape)object2, false);
                }
            }
            if (object != null) {
                if (shape2 == null) {
                    shape2 = new GeneralPath((Shape)object);
                } else {
                    ((Path2D)shape2).setWindingRule(1);
                    ((Path2D)shape2).append((Shape)object, false);
                }
            }
            if (shape != null) {
                if (shape2 == null) {
                    shape2 = new GeneralPath(shape);
                } else {
                    ((Path2D)shape2).setWindingRule(1);
                    ((Path2D)shape2).append(shape, false);
                }
            }
        }
        return shape2;
    }

    protected Shape getStrokeOutline(TextNode textNode, boolean bl) {
        Object object;
        Object object2;
        Shape shape;
        Path2D path2D = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = 0;
        while (n < list.size()) {
            shape = null;
            object2 = (TextRun)list.get(n);
            object = ((TextRun)object2).getACI();
            object.first();
            TextSpanLayout textSpanLayout = ((TextRun)object2).getLayout();
            Stroke stroke = (Stroke)object.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
            Paint paint = (Paint)object.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
            if (stroke != null && paint != null) {
                Shape shape2 = textSpanLayout.getOutline();
                shape = stroke.createStrokedShape(shape2);
            }
            if (shape != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(shape);
                } else {
                    path2D.setWindingRule(1);
                    path2D.append(shape, false);
                }
            }
            ++n;
        }
        if (bl) {
            shape = this.getDecorationStrokeOutline(list, 1);
            object2 = this.getDecorationStrokeOutline(list, 2);
            object = this.getDecorationStrokeOutline(list, 4);
            if (shape != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(shape);
                } else {
                    path2D.setWindingRule(1);
                    path2D.append(shape, false);
                }
            }
            if (object2 != null) {
                if (path2D == null) {
                    path2D = new GeneralPath((Shape)object2);
                } else {
                    path2D.setWindingRule(1);
                    path2D.append((Shape)object2, false);
                }
            }
            if (object != null) {
                if (path2D == null) {
                    path2D = new GeneralPath((Shape)object);
                } else {
                    path2D.setWindingRule(1);
                    path2D.append((Shape)object, false);
                }
            }
        }
        return path2D;
    }

    private Shape getDecorationOutline(List list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(rectangle2D);
                } else {
                    path2D.append(rectangle2D, false);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null) {
            if (path2D == null) {
                path2D = new GeneralPath(rectangle2D);
            } else {
                path2D.append(rectangle2D, false);
            }
        }
        return path2D;
    }

    private Shape getDecorationStrokeOutline(List list, int n) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            switch (n) {
                case 1: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
                    break;
                }
                case 4: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
                    break;
                }
                case 2: {
                    paint3 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
                    stroke2 = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
                    paint4 = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangle2D != null && stroke != null && paint2 != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(stroke.createStrokedShape(rectangle2D));
                } else {
                    path2D.append(stroke.createStrokedShape(rectangle2D), false);
                }
                rectangle2D = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                Shape shape = textRun.getLayout().getDecorationOutline(n);
                if (rectangle2D == null) {
                    rectangle2D = shape.getBounds2D();
                } else {
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D.setRect(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMaxX() - rectangle2D.getMinX(), rectangle2D.getHeight());
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            ++n2;
        }
        if (rectangle2D != null && stroke != null && paint2 != null) {
            if (path2D == null) {
                path2D = new GeneralPath(stroke.createStrokedShape(rectangle2D));
            } else {
                path2D.append(stroke.createStrokedShape(rectangle2D), false);
            }
        }
        return path2D;
    }

    public Mark getMark(TextNode textNode, int n, boolean bl) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (n < attributedCharacterIterator.getBeginIndex() || n > attributedCharacterIterator.getEndIndex()) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n2 = 0;
        while (n2 < list.size()) {
            TextRun textRun = (TextRun)list.get(n2);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            int n3 = textSpanLayout.getGlyphIndex(n);
            if (n3 != -1) {
                TextHit textHit = new TextHit(n, bl);
                return new BasicTextPainter.BasicMark(textNode, textSpanLayout, textHit);
            }
            ++n2;
        }
        return null;
    }

    protected Mark hitTest(double d, double d2, TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        int n = 0;
        while (n < list.size()) {
            TextRun textRun = (TextRun)list.get(n);
            TextSpanLayout textSpanLayout = textRun.getLayout();
            TextHit textHit = textSpanLayout.hitTestChar((float)d, (float)d2);
            if (textHit != null && textSpanLayout.getBounds().contains(d, d2)) {
                return new BasicTextPainter.BasicMark(textNode, textSpanLayout, textHit);
            }
            ++n;
        }
        return null;
    }

    public Mark selectFirst(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        TextHit textHit = new TextHit(attributedCharacterIterator.getBeginIndex(), false);
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        return new BasicTextPainter.BasicMark(textNode, ((TextRun)list.get(0)).getLayout(), textHit);
    }

    public Mark selectLast(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        TextHit textHit = new TextHit(attributedCharacterIterator.getEndIndex(), false);
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        return new BasicTextPainter.BasicMark(textNode, ((TextRun)list.get(list.size() - 1)).getLayout(), textHit);
    }

    public int[] getSelected(Mark mark, Mark mark2) {
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode != basicMark.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        int[] nArray = new int[]{basicMark2.getHit().getCharIndex(), basicMark.getHit().getCharIndex()};
        TextSpanLayout textSpanLayout = basicMark2.getLayout();
        TextSpanLayout textSpanLayout2 = basicMark.getLayout();
        int n = textSpanLayout.getGlyphIndex(nArray[0]);
        int n2 = textSpanLayout2.getGlyphIndex(nArray[1]);
        int n3 = textSpanLayout.getCharacterCount(n, n);
        int n4 = textSpanLayout2.getCharacterCount(n2, n2);
        if (n3 > 1) {
            if (nArray[0] > nArray[1] && textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] + (n3 - 1);
            } else if (nArray[1] > nArray[0] && !textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] - (n3 - 1);
            }
        }
        if (n4 > 1) {
            if (nArray[1] > nArray[0] && textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] + (n4 - 1);
            } else if (nArray[0] > nArray[1] && !textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] - (n4 - 1);
            }
        }
        return nArray;
    }

    public Shape getHighlightShape(Mark mark, Mark mark2) {
        Object object;
        int n;
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new Error("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode != basicMark.getTextNode()) {
            throw new Error("Markers are from different TextNodes!");
        }
        int n2 = basicMark2.getHit().getCharIndex();
        if (n2 > (n = basicMark.getHit().getCharIndex())) {
            object = basicMark2;
            basicMark2 = basicMark;
            basicMark = object;
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        object = null;
        TextSpanLayout textSpanLayout = null;
        if (basicMark2 != null && basicMark != null) {
            object = basicMark2.getLayout();
            textSpanLayout = basicMark.getLayout();
        }
        if (object == null || textSpanLayout == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, textNode.getAttributedCharacterIterator());
        GeneralPath generalPath = new GeneralPath();
        int n4 = 0;
        while (n4 < list.size()) {
            TextRun textRun = (TextRun)list.get(n4);
            TextSpanLayout textSpanLayout2 = textRun.getLayout();
            Shape shape = textSpanLayout2.getHighlightShape(n2, n);
            if (shape != null && !shape.getBounds().isEmpty()) {
                generalPath.append(shape, false);
            }
            ++n4;
        }
        return generalPath;
    }

    static {
        extendedAtts.add(TEXT_COMPOUND_DELIMITER);
        extendedAtts.add(GVT_FONT);
        extendedAtts.add(BIDI_LEVEL);
        singleton = new StrokingTextPainter();
    }

    public class TextRun {
        private AttributedCharacterIterator aci;
        private TextSpanLayout layout;
        private int anchorType;
        private boolean firstRunInChunk;

        public TextRun(TextSpanLayout textSpanLayout, AttributedCharacterIterator attributedCharacterIterator, boolean bl) {
            this.layout = textSpanLayout;
            this.aci = attributedCharacterIterator;
            this.aci.first();
            this.firstRunInChunk = bl;
            TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            this.anchorType = 0;
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
            if (attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE) == GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL) {
                if (this.anchorType == 0) {
                    this.anchorType = 2;
                } else if (this.anchorType == 2) {
                    this.anchorType = 0;
                }
            }
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }

        public boolean isFirstRunInChunk() {
            return this.firstRunInChunk;
        }
    }

    class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;
        public Point2D absLoc;

        public TextChunk(int n, int n2, Point2D point2D, Point2D point2D2) {
            this.begin = n;
            this.end = n2;
            this.absLoc = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
            this.advance = new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY());
        }
    }
}

