/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;

public final class BumpMap {
    private RenderedImage texture;
    private double surfaceScale;
    private double surfaceScaleX;
    private double surfaceScaleY;
    private double scaleX;
    private double scaleY;

    public BumpMap(RenderedImage renderedImage, double d, double d2, double d3) {
        this.texture = renderedImage;
        this.surfaceScaleX = d * d2;
        this.surfaceScaleY = d * d3;
        this.surfaceScale = d;
        this.scaleX = d2;
        this.scaleY = d3;
    }

    public final double getSurfaceScale() {
        return this.surfaceScale;
    }

    public final double[][][] getNormalArray(int n, int n2, int n3, int n4) {
        double d;
        double[] dArray;
        int n5;
        int n6;
        double[][] dArray2;
        double[][][] dArray3 = new double[n4][n3][4];
        Rectangle rectangle = new Rectangle(n - 1, n2 - 1, n3 + 2, n4 + 2);
        Rectangle rectangle2 = new Rectangle(this.texture.getMinX(), this.texture.getMinY(), this.texture.getWidth(), this.texture.getHeight());
        if (!rectangle.intersects(rectangle2)) {
            return dArray3;
        }
        rectangle = rectangle.intersection(rectangle2);
        Raster raster = this.texture.getData(rectangle);
        rectangle = raster.getBounds();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = n7 + 1;
        int n9 = n7 - 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = this.surfaceScaleX / 4.0;
        double d12 = this.surfaceScaleY / 4.0;
        double d13 = this.surfaceScaleX / 2.0;
        double d14 = this.surfaceScaleY / 2.0;
        double d15 = this.surfaceScaleX / 3.0;
        double d16 = this.surfaceScaleY / 3.0;
        double d17 = this.surfaceScaleX * 2.0 / 3.0;
        double d18 = this.surfaceScaleY * 2.0 / 3.0;
        if (n3 <= 0) {
            return dArray3;
        }
        if (n4 <= 0) {
            return dArray3;
        }
        int n10 = Math.min(rectangle.x + rectangle.width - 1, n + n3);
        int n11 = Math.min(rectangle.y + rectangle.height - 1, n2 + n4);
        int n12 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(rectangle.x - raster.getSampleModelTranslateX(), rectangle.y - raster.getSampleModelTranslateY());
        int n13 = n2;
        if (n13 < rectangle.y) {
            n13 = rectangle.y;
        }
        if (n13 == rectangle.y) {
            dArray2 = dArray3[n13 - n2];
            n6 = n12 + n7 * (n13 - rectangle.y);
            n5 = n;
            if (n5 < rectangle.x) {
                n5 = rectangle.x;
            }
            d6 = (double)(nArray[n6 += n5 - rectangle.x] >>> 24) * 0.00392156862745098;
            d9 = (double)(nArray[n6 + n7] >>> 24) * 0.00392156862745098;
            if (n5 != rectangle.x) {
                d5 = (double)(nArray[n6 - 1] >>> 24) * 0.00392156862745098;
                d8 = (double)(nArray[n6 + n9] >>> 24) * 0.00392156862745098;
            } else if (n5 < n10) {
                d7 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d10 = (double)(nArray[n6 + n8] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d17 * (2.0 * d7 + d10 - 2.0 * d6 - d9);
                dArray[1] = -d18 * (2.0 * d9 + d10 - 2.0 * d6 - d7);
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
                ++n6;
                ++n5;
                d5 = d6;
                d8 = d9;
                d6 = d7;
                d9 = d10;
            }
            while (n5 < n10) {
                d7 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d10 = (double)(nArray[n6 + n8] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d15 * (2.0 * d7 + d10 - (2.0 * d5 + d8));
                dArray[1] = -d14 * (d8 + 2.0 * d9 + d10 - (d5 + 2.0 * d6 + d7));
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
                ++n6;
                d5 = d6;
                d8 = d9;
                d6 = d7;
                d9 = d10;
                ++n5;
            }
            if (n5 < n + n3 && n5 == rectangle.x + rectangle.width - 1) {
                dArray = dArray2[n5 - n];
                dArray[0] = -d17 * (2.0 * d6 + d9 - (2.0 * d5 + d8));
                dArray[1] = -d18 * (2.0 * d9 + d8 - (2.0 * d6 + d5));
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
            }
            ++n13;
        }
        while (n13 < n11) {
            dArray2 = dArray3[n13 - n2];
            n6 = n12 + n7 * (n13 - rectangle.y);
            n5 = n;
            if (n5 < rectangle.x) {
                n5 = rectangle.x;
            }
            d3 = (double)(nArray[(n6 += n5 - rectangle.x) - n7] >>> 24) * 0.00392156862745098;
            d6 = (double)(nArray[n6] >>> 24) * 0.00392156862745098;
            d9 = (double)(nArray[n6 + n7] >>> 24) * 0.00392156862745098;
            if (n5 != rectangle.x) {
                d2 = (double)(nArray[n6 - n8] >>> 24) * 0.00392156862745098;
                d5 = (double)(nArray[n6 - 1] >>> 24) * 0.00392156862745098;
                d8 = (double)(nArray[n6 + n9] >>> 24) * 0.00392156862745098;
            } else if (n5 < n10) {
                d7 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d4 = (double)(nArray[n6 - n9] >>> 24) * 0.00392156862745098;
                d10 = (double)(nArray[n6 + n8] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d13 * (d4 + 2.0 * d7 + d10 - (d3 + 2.0 * d6 + d9));
                dArray[1] = -d16 * (2.0 * d3 + d4 - (2.0 * d6 + d7));
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
                ++n6;
                ++n5;
                d2 = d3;
                d5 = d6;
                d8 = d9;
                d3 = d4;
                d6 = d7;
                d9 = d10;
            }
            while (n5 < n10) {
                d4 = (double)(nArray[n6 - n9] >>> 24) * 0.00392156862745098;
                d7 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d10 = (double)(nArray[n6 + n8] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d11 * (d4 + 2.0 * d7 + d10 - (d2 + 2.0 * d5 + d8));
                dArray[1] = -d12 * (d8 + 2.0 * d9 + d10 - (d2 + 2.0 * d3 + d4));
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
                ++n6;
                d2 = d3;
                d5 = d6;
                d8 = d9;
                d3 = d4;
                d6 = d7;
                d9 = d10;
                ++n5;
            }
            if (n5 < n + n3 && n5 == rectangle.x + rectangle.width - 1) {
                dArray = dArray2[n5 - n];
                dArray[0] = -d13 * (d3 + 2.0 * d6 + d9 - (d2 + 2.0 * d5 + d8));
                dArray[1] = -d16 * (d8 + 2.0 * d9 - (d2 + 2.0 * d3));
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
            }
            ++n13;
        }
        if (n13 < n2 + n4 && n13 == rectangle.y + rectangle.height - 1) {
            dArray2 = dArray3[n13 - n2];
            n6 = n12 + n7 * (n13 - rectangle.y);
            n5 = n;
            if (n5 < rectangle.x) {
                n5 = rectangle.x;
            }
            d6 = (double)(nArray[n6 += n5 - rectangle.x] >>> 24) * 0.00392156862745098;
            d3 = (double)(nArray[n6 - n7] >>> 24) * 0.00392156862745098;
            if (n5 != rectangle.x) {
                d2 = (double)(nArray[n6 - n8] >>> 24) * 0.00392156862745098;
                d5 = (double)(nArray[n6 - 1] >>> 24) * 0.00392156862745098;
            } else if (n5 < n10) {
                d7 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d4 = (double)(nArray[n6 - n9] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d17 * (2.0 * d7 + d4 - 2.0 * d6 - d3);
                dArray[1] = -d18 * (2.0 * d6 + d7 - 2.0 * d3 - d4);
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
                ++n6;
                ++n5;
                d5 = d6;
                d2 = d3;
                d6 = d7;
                d3 = d4;
            }
            while (n5 < n10) {
                d7 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d4 = (double)(nArray[n6 - n9] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d15 * (2.0 * d7 + d4 - (2.0 * d5 + d2));
                dArray[1] = -d14 * (d5 + 2.0 * d6 + d7 - (d2 + 2.0 * d3 + d4));
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
                ++n6;
                d5 = d6;
                d2 = d3;
                d6 = d7;
                d3 = d4;
                ++n5;
            }
            if (n5 < n + n3 && n5 == rectangle.x + rectangle.width - 1) {
                dArray = dArray2[n5 - n];
                dArray[0] = -d17 * (2.0 * d6 + d3 - (2.0 * d5 + d2));
                dArray[1] = -d18 * (2.0 * d6 + d5 - (2.0 * d3 + d2));
                d = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d;
                dArray[1] = dArray[1] * d;
                dArray[2] = d;
                dArray[3] = d6 * this.surfaceScale;
            }
        }
        return dArray3;
    }
}

