/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.awt.image.renderable.RenderableImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.URLImageCache;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.ProfileRable;
import org.apache.batik.ext.awt.image.spi.BrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.DefaultBrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.ErrorConstants;
import org.apache.batik.ext.awt.image.spi.JDKRegistryEntry;
import org.apache.batik.ext.awt.image.spi.JPEGRegistryEntry;
import org.apache.batik.ext.awt.image.spi.PNGRegistryEntry;
import org.apache.batik.ext.awt.image.spi.RegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;
import org.apache.batik.ext.awt.image.spi.TIFFRegistryEntry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Service;

public class ImageTagRegistry
implements ErrorConstants {
    List entries = new LinkedList();
    List extensions = null;
    List mimeTypes = null;
    URLImageCache rawCache;
    URLImageCache imgCache;
    static ImageTagRegistry registry = null;
    static BrokenLinkProvider defaultProvider = new DefaultBrokenLinkProvider();
    static BrokenLinkProvider brokenLinkProvider = null;
    static /* synthetic */ Class class$org$apache$batik$ext$awt$image$spi$RegistryEntry;

    public ImageTagRegistry() {
        this(null, null);
    }

    public ImageTagRegistry(URLImageCache uRLImageCache, URLImageCache uRLImageCache2) {
        if (uRLImageCache == null) {
            uRLImageCache = new URLImageCache();
        }
        if (uRLImageCache2 == null) {
            uRLImageCache2 = new URLImageCache();
        }
        this.rawCache = uRLImageCache;
        this.imgCache = uRLImageCache2;
    }

    public void flushCache() {
        this.rawCache.flush();
        this.imgCache.flush();
    }

    public Filter readURL(ParsedURL parsedURL) {
        return this.readURL(parsedURL, null);
    }

    public Filter readURL(ParsedURL parsedURL, ICCColorSpaceExt iCCColorSpaceExt) {
        boolean bl = iCCColorSpaceExt != null;
        Filter filter = null;
        URLImageCache uRLImageCache = bl ? this.rawCache : this.imgCache;
        filter = uRLImageCache.request(parsedURL);
        if (filter != null) {
            if (iCCColorSpaceExt != null) {
                filter = new ProfileRable(filter, iCCColorSpaceExt);
            }
            return filter;
        }
        InputStream inputStream = null;
        boolean bl2 = false;
        List list = this.getRegisteredMimeTypes();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RegistryEntry registryEntry;
            RegistryEntry registryEntry2 = (RegistryEntry)iterator.next();
            if (registryEntry2 instanceof URLRegistryEntry) {
                registryEntry = (URLRegistryEntry)registryEntry2;
                if (!registryEntry.isCompatibleURL(parsedURL) || (filter = registryEntry.handleURL(parsedURL, bl)) == null) continue;
                break;
            }
            if (!(registryEntry2 instanceof StreamRegistryEntry)) continue;
            registryEntry = (StreamRegistryEntry)registryEntry2;
            if (bl2) continue;
            try {
                if (inputStream == null) {
                    try {
                        inputStream = parsedURL.openStream(list.iterator());
                    }
                    catch (IOException iOException) {
                        bl2 = true;
                        continue;
                    }
                    if (!inputStream.markSupported()) {
                        inputStream = new BufferedInputStream(inputStream);
                    }
                }
                if (!registryEntry.isCompatibleStream(inputStream) || (filter = registryEntry.handleStream(inputStream, parsedURL, bl)) == null) continue;
                break;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                inputStream = null;
            }
        }
        if (filter == null) {
            filter = bl2 ? ImageTagRegistry.getBrokenLinkImage(this, "url.unreachable", new Object[]{parsedURL}) : ImageTagRegistry.getBrokenLinkImage(this, "url.uninterpretable", new Object[]{parsedURL});
        }
        uRLImageCache.put(parsedURL, filter);
        if (iCCColorSpaceExt != null && filter.getProperty("org.apache.batik.BrokenLinkImage") == null) {
            filter = new ProfileRable(filter, iCCColorSpaceExt);
        }
        return filter;
    }

    public Filter readStream(InputStream inputStream) {
        return this.readStream(inputStream, null);
    }

    public Filter readStream(InputStream inputStream, ICCColorSpaceExt iCCColorSpaceExt) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        boolean bl = iCCColorSpaceExt != null;
        RenderableImage renderableImage = null;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            if (!(registryEntry instanceof StreamRegistryEntry)) continue;
            StreamRegistryEntry streamRegistryEntry = (StreamRegistryEntry)registryEntry;
            try {
                if (!streamRegistryEntry.isCompatibleStream(inputStream) || (renderableImage = streamRegistryEntry.handleStream(inputStream, null, bl)) == null) continue;
            }
            catch (StreamCorruptedException streamCorruptedException) {}
            break;
        }
        if (renderableImage == null) {
            return ImageTagRegistry.getBrokenLinkImage(this, "stream.unreadable", null);
        }
        if (iCCColorSpaceExt != null && renderableImage.getProperty("org.apache.batik.BrokenLinkImage") == null) {
            renderableImage = new ProfileRable((Filter)renderableImage, iCCColorSpaceExt);
        }
        return renderableImage;
    }

    public synchronized void register(RegistryEntry registryEntry) {
        float f = registryEntry.getPriority();
        ListIterator<RegistryEntry> listIterator = this.entries.listIterator();
        while (listIterator.hasNext()) {
            RegistryEntry registryEntry2 = (RegistryEntry)listIterator.next();
            if (!(registryEntry2.getPriority() > f)) continue;
            listIterator.previous();
            listIterator.add(registryEntry);
            return;
        }
        listIterator.add(registryEntry);
        this.extensions = null;
        this.mimeTypes = null;
    }

    public synchronized List getRegisteredExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        this.extensions = new LinkedList();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            this.extensions.addAll(registryEntry.getStandardExtensions());
        }
        this.extensions = Collections.unmodifiableList(this.extensions);
        return this.extensions;
    }

    public synchronized List getRegisteredMimeTypes() {
        if (this.mimeTypes != null) {
            return this.mimeTypes;
        }
        this.mimeTypes = new LinkedList();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            this.mimeTypes.addAll(registryEntry.getMimeTypes());
        }
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
        return this.mimeTypes;
    }

    public static synchronized ImageTagRegistry getRegistry() {
        if (registry != null) {
            return registry;
        }
        registry = new ImageTagRegistry();
        registry.register(new PNGRegistryEntry());
        registry.register(new TIFFRegistryEntry());
        registry.register(new JPEGRegistryEntry());
        registry.register(new JDKRegistryEntry());
        Iterator iterator = Service.providers((Class)(class$org$apache$batik$ext$awt$image$spi$RegistryEntry == null ? (class$org$apache$batik$ext$awt$image$spi$RegistryEntry = ImageTagRegistry.class$("org.apache.batik.ext.awt.image.spi.RegistryEntry")) : class$org$apache$batik$ext$awt$image$spi$RegistryEntry));
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            registry.register(registryEntry);
        }
        return registry;
    }

    public static synchronized Filter getBrokenLinkImage(Object object, String string, Object[] objectArray) {
        Filter filter = null;
        if (brokenLinkProvider != null) {
            filter = brokenLinkProvider.getBrokenLinkImage(object, string, objectArray);
        }
        if (filter == null) {
            filter = defaultProvider.getBrokenLinkImage(object, string, objectArray);
        }
        return filter;
    }

    public static synchronized void setBrokenLinkProvider(BrokenLinkProvider brokenLinkProvider) {
        ImageTagRegistry.brokenLinkProvider = brokenLinkProvider;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

