/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ListPlugins
extends AbstractPlugin {
    private PluginParameter<Boolean> myFull = new PluginParameter.Builder<Boolean>("full", Boolean.valueOf(false), Boolean.class).build();

    public ListPlugins(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
        Logger.getLogger((String)"net.maizegenetics").setLevel(Level.OFF);
        Logger.getLogger((String)"net.maizegenetics.plugindef").setLevel(Level.INFO);
    }

    @Override
    public DataSet processData(DataSet input) {
        Set<String> classes = ListPlugins.getTasselClasses();
        ArrayList<String> temp = new ArrayList<String>();
        for (String current : classes) {
            if (!ListPlugins.isPlugin(current)) continue;
            if (this.full()) {
                temp.add(current);
                continue;
            }
            temp.add(Utils.getBasename(current));
        }
        Collections.sort(temp);
        for (String current : temp) {
            System.out.println(current);
        }
        return null;
    }

    private static Set<String> getTasselClasses() {
        File file;
        String path;
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(File.pathSeparator);
        String tasselPath = null;
        String[] arr$ = paths;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (path = arr$[i$]).trim().length() != 0 && (file = new File(path)).exists() && (tasselPath = file.getAbsolutePath()).endsWith("sTASSEL.jar")); ++i$) {
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        try {
            ZipFile zFile = new ZipFile(tasselPath);
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(name = entry.getName().replace(File.separator, ".")).endsWith(".class") || name.contains("$")) continue;
                name = name.substring(0, name.lastIndexOf(".class"));
                classes.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static boolean isPlugin(String className) {
        try {
            Class<?> currentMatch = Class.forName(className);
            return !currentMatch.isInterface() && Plugin.class.isAssignableFrom(currentMatch);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean full() {
        return this.myFull.value();
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "List Plugins";
    }

    @Override
    public String getToolTipText() {
        return "List Plugins";
    }
}

