/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.EMMA.EMMAforDoubleMatrix;

public class RegRidgeEmmaDoubleMatrix {
    private double[] GEBVs;
    private double[] mrkEsts;
    private DoubleMatrix GEBVsDM;
    private DoubleMatrix mrkEstsDM;
    private DoubleMatrix pheno;
    private boolean[] phenoMissing;
    private DoubleMatrix fixed;
    private DoubleMatrix geno;
    private int nLines;
    private int nObs;
    private DoubleMatrix kin = null;

    public RegRidgeEmmaDoubleMatrix(double[] phenotype, double[][] fixedEffects, double[][] genotypes, DoubleMatrixFactory.FactoryType type) {
        DoubleMatrixFactory MF = new DoubleMatrixFactory(type);
        this.pheno = MF.make(phenotype.length, 1, phenotype);
        this.fixed = MF.make(fixedEffects);
        this.geno = MF.make(genotypes);
        this.phenoMissing = this.determineMissingPhenotypes();
    }

    public RegRidgeEmmaDoubleMatrix(DoubleMatrix phenotype, DoubleMatrix fixedEffects, DoubleMatrix genotypes) {
        this.pheno = phenotype;
        this.fixed = fixedEffects;
        this.geno = genotypes;
        this.phenoMissing = this.determineMissingPhenotypes();
    }

    public RegRidgeEmmaDoubleMatrix(DoubleMatrix phenotype, DoubleMatrix fixedEffects, DoubleMatrix genotypes, DoubleMatrix kinship) {
        this.pheno = phenotype;
        this.fixed = fixedEffects;
        this.geno = genotypes;
        this.kin = kinship;
        this.phenoMissing = this.determineMissingPhenotypes();
    }

    public void solve() {
        int i;
        double start = System.currentTimeMillis() / 1000L;
        int notMissing = 0;
        for (boolean b : this.phenoMissing) {
            if (b) continue;
            ++notMissing;
        }
        int[] nmIndex = new int[notMissing];
        int count = 0;
        for (int i2 = 0; i2 < this.phenoMissing.length; ++i2) {
            if (this.phenoMissing[i2]) continue;
            nmIndex[count] = i2;
            ++count;
        }
        DoubleMatrix nmPheno = this.pheno.getSelection(nmIndex, null);
        DoubleMatrix nmFixed = this.fixed.getSelection(nmIndex, null);
        this.nLines = this.pheno.numberOfRows();
        this.nObs = nmPheno.numberOfRows();
        this.replaceNaNwithMean();
        DoubleMatrix nmGeno = this.geno.getSelection(nmIndex, null);
        if (this.kin == null) {
            this.kin = this.geno.mult(this.geno, false, true);
        }
        DoubleMatrix nmKin = this.kin.getSelection(nmIndex, nmIndex);
        EMMAforDoubleMatrix lm = new EMMAforDoubleMatrix(nmPheno, nmFixed, nmKin, 0);
        lm.solve();
        double delta = lm.getDelta();
        System.out.println("Delta: " + delta);
        DoubleMatrix aXZ = nmFixed.concatenate(nmGeno, false);
        int nFixed = nmFixed.numberOfColumns();
        int nRandom = nmGeno.numberOfColumns();
        DoubleMatrix aCoefMat = aXZ.crossproduct();
        for (int i3 = nFixed; i3 < nFixed + nRandom; ++i3) {
            aCoefMat.set(i3, i3, aCoefMat.get(i3, i3) + delta);
        }
        DoubleMatrix aXZty = aXZ.mult(nmPheno, true, false);
        int[] idx = new int[nRandom];
        for (i = 0; i < nRandom; ++i) {
            idx[i] = i + nFixed;
        }
        this.mrkEstsDM = aCoefMat.inverse().mult(aXZty, false, false).getSelection(idx, null);
        this.GEBVsDM = this.geno.mult(this.mrkEstsDM, false, false);
        this.mrkEsts = new double[nRandom];
        this.GEBVs = new double[this.nLines];
        for (i = 0; i < nRandom; ++i) {
            this.mrkEsts[i] = this.mrkEstsDM.get(i, 0);
        }
        for (i = 0; i < this.nLines; ++i) {
            this.GEBVs[i] = this.GEBVsDM.get(i, 0);
        }
        double time = (double)(System.currentTimeMillis() / 1000L) - start;
        System.out.println("Ran rrEMMA in " + time + " seconds");
        System.out.println();
    }

    public double[] getBlups() {
        return this.GEBVs;
    }

    public double[] getMrkBlups() {
        return this.mrkEsts;
    }

    public DoubleMatrix getGEBVsAsDoubleMatrix() {
        return this.GEBVsDM;
    }

    public DoubleMatrix getMrkEstsAsDoubleMatrix() {
        return this.mrkEstsDM;
    }

    private void replaceNaNwithMean() {
        for (int c = 0; c < this.geno.numberOfColumns(); ++c) {
            int r;
            int nm = 0;
            double sum = 0.0;
            for (r = 0; r < this.nLines; ++r) {
                double val = this.geno.get(r, c);
                if (Double.isNaN(val)) continue;
                ++nm;
                sum += val;
            }
            double mean = sum / (double)nm;
            for (r = 0; r < this.nLines; ++r) {
                if (!Double.isNaN(this.geno.get(r, c))) continue;
                this.geno.set(r, c, mean);
            }
        }
    }

    private boolean[] determineMissingPhenotypes() {
        boolean[] tmp = new boolean[this.pheno.numberOfRows()];
        for (int i = 0; i < this.pheno.numberOfRows(); ++i) {
            tmp[i] = Double.isNaN(this.pheno.get(i, 0));
        }
        return tmp;
    }
}

