/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.trait.MarkerPhenotype;
import net.maizegenetics.trait.Phenotype;
import org.apache.log4j.Logger;

public class SeparatePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SeparatePlugin.class);
    private String[] myChromosomesToSeparate = null;

    public SeparatePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List inputs = input.getDataSet();
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            for (Datum current : inputs) {
                List<Datum> alignments;
                Object currentValue = current.getData();
                if (currentValue instanceof MarkerPhenotype) {
                    MarkerPhenotype mp = (MarkerPhenotype)currentValue;
                    Phenotype pheno = mp.getPhenotype();
                    String phenoName = current.getName() + "_pheno";
                    Datum phenoDatum = new Datum(phenoName, pheno, null);
                    GenotypeTable align = mp.getAlignment();
                    String alignName = current.getName() + "_align";
                    Datum alignDatum = new Datum(alignName, align, null);
                    DataSet tds = new DataSet(new Datum[]{phenoDatum, alignDatum}, (Plugin)this);
                    result.add(tds);
                    continue;
                }
                if (!(currentValue instanceof GenotypeTable) || (alignments = SeparatePlugin.separateAlignmentIntoLoci((GenotypeTable)currentValue, current.getName(), this.myChromosomesToSeparate)).size() <= 0) continue;
                DataSet tds = new DataSet(alignments, (Plugin)this);
                result.add(tds);
            }
            if (result.isEmpty()) {
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Nothing to Separate");
                } else {
                    myLogger.warn((Object)"performFunction: Nothing to Separate.");
                }
                Iterator i$ = null;
                return i$;
            }
            DataSet resultDataSet = DataSet.getDataSet(result, this);
            this.fireDataSetReturned(new PluginEvent(resultDataSet, SeparatePlugin.class));
            DataSet dataSet = resultDataSet;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public static List<Datum> separateAlignmentIntoLoci(GenotypeTable alignment, String dataSetName) {
        return SeparatePlugin.separateAlignmentIntoLoci(alignment, dataSetName, null);
    }

    public static List<Datum> separateAlignmentIntoLoci(GenotypeTable alignment, String dataSetName, String[] chromosomesToSeparate) {
        ArrayList<Datum> result = new ArrayList<Datum>();
        GenotypeTable[] alignments = alignment.compositeAlignments();
        for (int i = 0; i < alignments.length; ++i) {
            int[] offsets = alignments[i].chromosomesOffsets();
            if (offsets.length > 1) {
                Chromosome[] loci = alignments[i].chromosomes();
                for (int j = 0; j < offsets.length; ++j) {
                    int endSite;
                    if (!SeparatePlugin.alignmentInList(loci[j], chromosomesToSeparate)) continue;
                    String name = dataSetName == null ? "Alignment_chrom" + loci[j] : dataSetName + "_chrom" + loci[j];
                    try {
                        endSite = offsets[j + 1] - 1;
                    }
                    catch (Exception e) {
                        endSite = alignments[i].numberOfSites() - 1;
                    }
                    Datum td = new Datum(name, FilterGenotypeTable.getInstance(alignments[i], offsets[j], endSite), null);
                    result.add(td);
                }
                continue;
            }
            if (alignments.length <= 1 || !SeparatePlugin.alignmentInList(alignments[i].chromosomes()[0], chromosomesToSeparate)) continue;
            String name = dataSetName == null ? "Alignment_chrom" + alignments[i].chromosome(0) : dataSetName + "_chrom" + alignments[i].chromosome(0);
            Datum td = new Datum(name, alignments[i], null);
            result.add(td);
        }
        return result;
    }

    private static boolean alignmentInList(Chromosome locus, String[] chromosomesToSeparate) {
        if (chromosomesToSeparate == null) {
            return true;
        }
        String currentChr = locus.getName();
        for (int i = 0; i < chromosomesToSeparate.length; ++i) {
            if (!currentChr.equalsIgnoreCase(chromosomesToSeparate[i])) continue;
            return true;
        }
        return false;
    }

    public void setChromosomesToSeparate(String[] chrs) {
        this.myChromosomesToSeparate = new String[chrs.length];
        for (int i = 0; i < chrs.length; ++i) {
            this.myChromosomesToSeparate[i] = chrs[i].trim();
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SeparatePlugin.class.getResource("/net/maizegenetics/analysis/images/Separate.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Separate";
    }

    @Override
    public String getToolTipText() {
        return "Separate Data (i.e. into Chromosomes)";
    }
}

