/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class SplitHDF5ByChromosomePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SplitHDF5ByChromosomePlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String inHDF5FileName = null;
    private boolean keepDepth = true;

    public SplitHDF5ByChromosomePlugin() {
        super(null, false);
    }

    public SplitHDF5ByChromosomePlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        myLogger.info((Object)"\n\nThe options for the TASSEL5 SplitHDF5ByChromosomePlugin are as follows:\n  -i   Input HDF5 genotype (*.h5) file to be split by chromosome. The\n       output files will be named *_chr#.h5 (where # = chromosome number).\n\n  -iD  Ignore depth. If genotypic depth information is present in the input\n       input files, ignore it (i.e., do not write depth information to the \n       output files).  Default: keep depth.\n\n\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args == null || args.length == 0) {
            this.printUsage();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-file", true);
            this.myArgsEngine.add("-iD", "--ignore-depth", false);
        }
        this.myArgsEngine.parse(args);
        this.inHDF5FileName = this.myArgsEngine.getString("-i");
        File inFile = null;
        if (this.inHDF5FileName != null) {
            inFile = new File(this.inHDF5FileName);
            if (!inFile.exists()) {
                this.printUsage();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                String errMessage = "\nThe input HDF5 genotype (*.h5) file name you supplied does not exist:\n" + this.inHDF5FileName + "\n\n";
                myLogger.error((Object)errMessage);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                throw new IllegalArgumentException(errMessage);
            }
        } else {
            this.printUsage();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String errMessage = "\nPlease specify an input HDF5 genotype (*.h5) file to be split by chromosome (-i option)\n\n";
            myLogger.error((Object)errMessage);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw new IllegalArgumentException(errMessage);
        }
        if (this.myArgsEngine.getBoolean("-iD")) {
            this.keepDepth = false;
        }
    }

    @Override
    public DataSet performFunction(DataSet input) {
        String message = this.splitHDF5GenoTableByChr();
        if (message != null) {
            myLogger.error((Object)message);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException(message);
        }
        this.fireProgress(100);
        return null;
    }

    private String splitHDF5GenoTableByChr() {
        Chromosome[] chrs;
        System.out.println("\n\nSplitHDF5ByChromosomePlugin:\nSplitting the following input file by chromosome:");
        System.out.println("  " + this.inHDF5FileName + "\n\n");
        GenotypeTable inGenos = ImportUtils.readGuessFormat(this.inHDF5FileName);
        for (Chromosome chr : chrs = inGenos.chromosomes()) {
            FilterGenotypeTable genosForChr = FilterGenotypeTable.getInstance(inGenos, chr);
            String outFileName = this.keepDepth ? this.inHDF5FileName.replaceFirst("\\.h5$", "_chr" + chr.getChromosomeNumber() + ".h5") : this.inHDF5FileName.replaceFirst("\\.h5$", "_noDepth_chr" + chr.getChromosomeNumber() + ".h5");
            ExportUtils.writeGenotypeHDF5(genosForChr, outFileName, this.keepDepth);
            System.out.println("    Genotypes from chromosome " + chr.getChromosomeNumber() + " written to file");
            System.out.println("        " + outFileName);
        }
        System.out.println("\n\nSplitHDF5ByChromosomePlugin: Finished splitting chromosomes.\n\n");
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Split chromosomes from HDF5 genotype file";
    }

    @Override
    public String getToolTipText() {
        return "Split chromosomes from HDF5 genotype file";
    }
}

