/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.distance;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.distance.DistanceMatrix;
import net.maizegenetics.util.ProgressListener;
import org.apache.log4j.Logger;

public class DistanceMatrixPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(DistanceMatrixPlugin.class);

    public DistanceMatrixPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() < 1) {
                String message = "Invalid selection.  Please select sequence alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    myLogger.error((Object)message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            for (Datum current : alignInList) {
                DataSet tds = this.processDatum(current);
                result.add(tds);
                if (tds == null) continue;
                this.fireDataSetReturned(new PluginEvent(tds, DistanceMatrixPlugin.class));
            }
            DataSet dataSet = DataSet.getDataSet(result, this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public DataSet processDatum(Datum input) {
        GenotypeTable aa = (GenotypeTable)input.getData();
        DistanceMatrix adm = DistanceMatrixPlugin.getDistanceMatrix(aa, this);
        return new DataSet(new Datum("Matrix:" + input.getName(), adm, "Distance Matrix"), (Plugin)this);
    }

    public static DistanceMatrix getDistanceMatrix(GenotypeTable alignment) {
        return new IBSDistanceMatrix(alignment);
    }

    public static DistanceMatrix getDistanceMatrix(GenotypeTable alignment, ProgressListener listener) {
        return new IBSDistanceMatrix(alignment, listener);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Distance Matrix";
    }

    @Override
    public String getToolTipText() {
        return "Create a distance matrix";
    }
}

