/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.list.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import net.maizegenetics.analysis.gbs.SNPLogging;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.taxa.IdGroupUtils;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import org.apache.poi.util.IntList;

@Deprecated
public class AlignmentFilterByGBSUtils {
    public static final byte refAllele = 0;
    public static final byte altAllele = 17;
    public static final byte hetAllele = 1;

    private AlignmentFilterByGBSUtils() {
    }

    public static TaxaList getFilteredIdGroupByName(TaxaList orig, String[] filter, boolean keepTaxaMatchFilter) {
        ArrayList keepTaxa = new ArrayList();
        for (int i = 0; i < orig.numberOfTaxa(); ++i) {
            boolean matchFlag = false;
            for (String s : filter) {
                if (!orig.taxaName(i).contains(s)) continue;
                matchFlag = true;
            }
            if (matchFlag != keepTaxaMatchFilter) continue;
            keepTaxa.add(orig.get(i));
        }
        Taxon[] ids = new Taxon[keepTaxa.size()];
        keepTaxa.toArray(ids);
        TaxaList newGroup = new TaxaListBuilder().addAll(ids).build();
        return newGroup;
    }

    public static int[][] hetsByLine(GenotypeTable a, boolean isRefAltCoded, boolean printToScreen) {
        int[][] counts = new int[2][a.numberOfTaxa()];
        int totalScored = 0;
        int totalHets = 0;
        for (int j = 0; j < a.numberOfTaxa(); ++j) {
            for (int i = 0; i < a.numberOfSites(); ++i) {
                if (a.genotype(j, i) == -1) continue;
                int[] nArray = counts[0];
                int n = j;
                nArray[n] = nArray[n] + 1;
                if (isRefAltCoded) {
                    if (a.genotype(j, i) != 1) continue;
                    int[] nArray2 = counts[1];
                    int n2 = j;
                    nArray2[n2] = nArray2[n2] + 1;
                    continue;
                }
                if (!GenotypeTableUtils.isHeterozygous(a.genotype(j, i))) continue;
                int[] nArray3 = counts[1];
                int n3 = j;
                nArray3[n3] = nArray3[n3] + 1;
            }
        }
        for (int c : counts[0]) {
            totalScored += c;
        }
        for (int c : counts[1]) {
            totalHets += c;
        }
        if (printToScreen) {
            System.out.println("Total Alleles:" + totalScored + " TotalHets:" + totalHets);
        }
        return counts;
    }

    public static TaxaList getLowHetIdGroup(GenotypeTable a, boolean isRefAltCoded, double maxHets, int minCount) {
        int[][] hetCnt = AlignmentFilterByGBSUtils.hetsByLine(a, isRefAltCoded, false);
        boolean[] include = new boolean[a.numberOfTaxa()];
        for (int i = 0; i < hetCnt[0].length; ++i) {
            include[i] = !((double)hetCnt[1][i] / (double)hetCnt[0][i] > maxHets) && hetCnt[0][i] >= minCount;
        }
        return IdGroupUtils.idGroupSubset(a.taxa(), include);
    }

    public static int[][] genotypicCountsBySite(GenotypeTable a, boolean isRefAltCoded, boolean printToScreen) {
        int[][] counts = new int[5][a.numberOfSites()];
        if (printToScreen) {
            System.out.println("Locus\tMAF\tTaxaWKnown\tHetNum\tHetRate\tMajorAllele\tMajorCnt\tMinorAllele\tMinorCnt\tGapCnt");
        }
        for (int i = 0; i < a.numberOfSites(); ++i) {
            byte majorAllele = a.majorAllele(i);
            majorAllele = (byte)(majorAllele << 4 | majorAllele);
            byte minorAllele = a.minorAllele(i);
            minorAllele = (byte)(minorAllele << 4 | minorAllele);
            for (int j = 0; j < a.numberOfTaxa(); ++j) {
                byte currentBase = a.genotype(j, i);
                if (currentBase == -1) continue;
                int[] nArray = counts[0];
                int n = i;
                nArray[n] = nArray[n] + 1;
                if (isRefAltCoded) {
                    if (GenotypeTableUtils.isEqual(currentBase, (byte)1)) {
                        int[] nArray2 = counts[1];
                        int n2 = i;
                        nArray2[n2] = nArray2[n2] + 1;
                    }
                } else if (GenotypeTableUtils.isHeterozygous(currentBase)) {
                    int[] nArray3 = counts[1];
                    int n3 = i;
                    nArray3[n3] = nArray3[n3] + 1;
                }
                if (GenotypeTableUtils.isEqual(currentBase, majorAllele)) {
                    int[] nArray4 = counts[2];
                    int n4 = i;
                    nArray4[n4] = nArray4[n4] + 1;
                }
                if (GenotypeTableUtils.isEqual(currentBase, minorAllele)) {
                    int[] nArray5 = counts[3];
                    int n5 = i;
                    nArray5[n5] = nArray5[n5] + 1;
                }
                if (!GenotypeTableUtils.isEqual(currentBase, (byte)85)) continue;
                int[] nArray6 = counts[4];
                int n6 = i;
                nArray6[n6] = nArray6[n6] + 1;
            }
            if (!printToScreen) continue;
            System.out.println(a.siteName(i) + "\t" + a.minorAlleleFrequency(i) + "\t" + counts[0][i] + "\t" + counts[1][i] + "\t" + (double)counts[1][i] / (double)counts[0][i] + "\t" + (char)majorAllele + "\t" + counts[2][i] + "\t" + (char)minorAllele + "\t" + counts[3][i] + "\t" + counts[4][i]);
        }
        return counts;
    }

    public static int[] getLowHetSNPs(GenotypeTable a, boolean isRefAltCoded, double minF, int minCount, double minMAF, double maxMAF) {
        return AlignmentFilterByGBSUtils.getLowHetSNPs(a, isRefAltCoded, minF, minCount, minMAF, maxMAF, null, null);
    }

    public static int[] getLowHetSNPs(GenotypeTable a, boolean isRefAltCoded, double minF, int minCount, double minMAF, double maxMAF, SNPLogging snpLogging, String logTest) {
        String REMOVED_STATUS = "Removed";
        int[][] hetCnt = AlignmentFilterByGBSUtils.genotypicCountsBySite(a, isRefAltCoded, false);
        IntArrayList goodSites = new IntArrayList();
        for (int i = 0; i < hetCnt[0].length; ++i) {
            double obsF;
            double propHets = hetCnt[0][i] > 0 ? (double)hetCnt[1][i] / (double)hetCnt[0][i] : 0.0;
            double theMAF = hetCnt[0][i] > 0 ? ((double)hetCnt[3][i] + (double)hetCnt[1][i] / 2.0) / (double)hetCnt[0][i] : 0.0;
            double expHets = 2.0 * theMAF * (1.0 - theMAF);
            double d = obsF = expHets > 0.0 ? 1.0 - propHets / expHets : 1.0;
            if (obsF > minF && hetCnt[0][i] >= minCount && theMAF >= minMAF && theMAF <= maxMAF) {
                goodSites.add(i);
                continue;
            }
            if (snpLogging == null) continue;
            String cutoff = "isRefAltCoded: " + isRefAltCoded + " minF: " + minF + " minCount: " + minCount + " minMAF: " + minMAF + " maxMAF: " + maxMAF;
            String value = "obsF: " + obsF + " obsMinCount: " + hetCnt[0][i] + " MAF: " + theMAF;
            snpLogging.writeEntry(a, i, null, null, logTest, REMOVED_STATUS, value, cutoff);
        }
        goodSites.trimToSize();
        return goodSites.elements();
    }

    public static void getCoverage_MAF_F_Dist(GenotypeTable a, boolean isRefAltCoded) {
        int i;
        if (a.numberOfSites() == 0) {
            return;
        }
        int[][] hetCnt = AlignmentFilterByGBSUtils.genotypicCountsBySite(a, isRefAltCoded, false);
        double[] coverageD = new double[a.numberOfSites()];
        double[] mafD = new double[a.numberOfSites()];
        double[] fD = new double[a.numberOfSites()];
        double[] gapD = new double[a.numberOfSites()];
        for (i = 0; i < hetCnt[0].length; ++i) {
            double propHets = (double)hetCnt[1][i] / (double)hetCnt[0][i];
            double theMAF = mafD[i] = ((double)hetCnt[3][i] + (double)hetCnt[1][i] / 2.0) / (double)hetCnt[0][i];
            double expHets = 2.0 * theMAF * (1.0 - theMAF);
            fD[i] = 1.0 - propHets / expHets;
            coverageD[i] = (double)hetCnt[0][i] / (double)a.numberOfTaxa();
            gapD[i] = (double)hetCnt[4][i] / (double)a.numberOfTaxa();
        }
        Arrays.sort(mafD);
        Arrays.sort(fD);
        Arrays.sort(coverageD);
        Arrays.sort(gapD);
        System.out.println("Percentile\tCoverage\tMAF\tF(inbreeding)\tGapProp");
        if (coverageD.length >= 20) {
            for (i = 0; i < coverageD.length; i += coverageD.length / 20) {
                System.out.printf("%.2g\t%.3g\t%.3g\t%.3g\t%.3g%n", (double)i / (double)coverageD.length, coverageD[i], mafD[i], fD[i], gapD[i]);
            }
        } else {
            System.out.printf("%.2g\t%.3g\t%.3g\t%.3g\t%.3g%n", 1.0, coverageD[coverageD.length - 1], mafD[coverageD.length - 1], fD[coverageD.length - 1], gapD[coverageD.length - 1]);
        }
    }

    public static double getErrorRateForDuplicatedTaxa(GenotypeTable a, boolean ignoreHets, boolean random, boolean printToScreen) {
        TaxaList idg = a.taxa();
        TreeMap<String, Integer> sortedIds = new TreeMap<String, Integer>();
        for (int i = 0; i < idg.numberOfTaxa(); ++i) {
            sortedIds.put(((Taxon)idg.get(i)).getName().toUpperCase(), i);
        }
        long cntDiff = 0L;
        long cntTotal = 0L;
        Map.Entry priorEntry = sortedIds.lastEntry();
        if (printToScreen) {
            System.out.println("Entry1 Entry2 SNPDiff SNPsCompared PropDiff");
        }
        for (Map.Entry entry : sortedIds.entrySet()) {
            if (((String)priorEntry.getKey()).split(":")[0].equals(((String)entry.getKey()).split(":")[0])) {
                int cntDiffTaxa = 0;
                int cntTotalTaxa = 0;
                for (int i = 0; i < a.numberOfSites(); ++i) {
                    byte pB = -1;
                    if (random) {
                        int t = (int)Math.round(Math.random() * (double)(a.numberOfTaxa() - 1));
                        pB = a.genotype(t, i);
                    } else {
                        pB = a.genotype((Integer)priorEntry.getValue(), i);
                    }
                    byte cB = a.genotype((Integer)entry.getValue(), i);
                    if (ignoreHets && GenotypeTableUtils.isHeterozygous(pB) || ignoreHets && GenotypeTableUtils.isHeterozygous(cB) || pB == -1 || cB == -1) continue;
                    ++cntTotalTaxa;
                    if (GenotypeTableUtils.isEqual(pB, cB)) continue;
                    ++cntDiffTaxa;
                }
                if (printToScreen) {
                    System.out.printf("%s %s %d %d %g %n", priorEntry.getKey(), entry.getKey(), cntDiffTaxa, cntTotalTaxa, (double)cntDiffTaxa / (double)cntTotalTaxa);
                }
                cntDiff += (long)cntDiffTaxa;
                cntTotal += (long)cntTotalTaxa;
            }
            priorEntry = entry;
        }
        double totalER = (double)cntDiff / (double)cntTotal;
        if (random) {
            System.out.print("RandomDups ");
        } else {
            System.out.print("RealDups ");
        }
        if (ignoreHets) {
            System.out.print("ignoreHets ");
        } else {
            System.out.print("testHets ");
        }
        System.out.printf("ALL %d %d %g %n", cntDiff, cntTotal, (double)cntDiff / (double)cntTotal);
        return totalER;
    }

    public static int[] getGoodSitesByLD(GenotypeTable a, double minR2, double minBonferroniP, int minPosDist, int windowSize, int minCnt, boolean keepUnproven) {
        IntArrayList goodSites = new IntArrayList();
        LinkageDisequilibrium theLD = new LinkageDisequilibrium(a, windowSize, LinkageDisequilibrium.testDesign.SlidingWindow, -1, null, false, -1, null, LinkageDisequilibrium.HetTreatment.Homozygous);
        theLD.run();
        for (int i = 0; i < a.numberOfSites(); ++i) {
            double bonP;
            int cntInformative = 0;
            double obsMaxR2 = -1.0;
            double obsMinP = 1.0;
            for (int j = i - windowSize / 2; j < i + windowSize / 2; ++j) {
                double rValue = theLD.getRSqr(i, j);
                if (Double.isNaN(rValue) || Math.abs(a.chromosomalPosition(i) - a.chromosomalPosition(j)) < minPosDist) continue;
                ++cntInformative;
                if (rValue > obsMaxR2) {
                    obsMaxR2 = rValue;
                }
                if (!(rValue < obsMinP)) continue;
                obsMinP = rValue;
            }
            double d = bonP = cntInformative > 0 ? obsMinP * (double)cntInformative : 1.0;
            if (i % 1000 == 0) {
                System.out.printf(a.siteName(i) + " %d %g %g %g %n", cntInformative, obsMaxR2, obsMinP, bonP);
            }
            if (!(obsMaxR2 >= minR2 && bonP <= minBonferroniP) && (!keepUnproven || cntInformative != 0)) continue;
            goodSites.add(i);
        }
        goodSites.trimToSize();
        return goodSites.elements();
    }

    public static int[][] countCrossoversByLine(GenotypeTable a) {
        int[][] cos = new int[2][a.numberOfTaxa()];
        int sumGood = 0;
        int sumCO = 0;
        for (int t = 0; t < a.numberOfTaxa(); ++t) {
            byte lastHomozygous = -1;
            for (int i = 0; i < a.numberOfSites(); ++i) {
                byte currBase = a.genotype(t, i);
                if (currBase != 0 && currBase != 17) continue;
                int[] nArray = cos[0];
                int n = t;
                nArray[n] = nArray[n] + 1;
                if (currBase != lastHomozygous) {
                    int[] nArray2 = cos[1];
                    int n2 = t;
                    nArray2[n2] = nArray2[n2] + 1;
                }
                lastHomozygous = currBase;
            }
            sumCO += cos[1][t];
            sumGood += cos[0][t];
        }
        System.out.println("TotalHomoMarkers:" + sumGood + " TotalCrossover:" + sumCO);
        return cos;
    }

    public static int[][] countDCO(GenotypeTable a, boolean byTaxa) {
        int[][] cos = byTaxa ? new int[2][a.numberOfTaxa()] : new int[2][a.numberOfSites()];
        int sumGood = 0;
        int sumDCO = 0;
        for (int t = 0; t < a.numberOfTaxa(); ++t) {
            byte[] base = new byte[]{-1, -1, -1};
            int[] site = new int[]{-1, -1, -1};
            for (int s = 0; s < a.numberOfSites(); ++s) {
                if (a.genotype(t, s) != 0 && a.genotype(t, s) != 17) continue;
                base[0] = base[1];
                base[1] = base[2];
                base[2] = a.genotype(t, s);
                site[0] = site[1];
                site[1] = site[2];
                site[2] = s;
                if (base[0] == -1) continue;
                ++sumGood;
                if (byTaxa) {
                    int[] nArray = cos[0];
                    int n = t;
                    nArray[n] = nArray[n] + 1;
                } else {
                    int[] nArray = cos[0];
                    int n = site[1];
                    nArray[n] = nArray[n] + 1;
                }
                if (base[0] != base[2] || base[0] == base[1]) continue;
                ++sumDCO;
                if (byTaxa) {
                    int[] nArray = cos[1];
                    int n = t;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = cos[1];
                int n = site[1];
                nArray[n] = nArray[n] + 1;
            }
        }
        if (byTaxa) {
            System.out.print("ByTaxa:");
        } else {
            System.out.print("BySite:");
        }
        System.out.println("TotalHomoMarkers:" + sumGood + " TotalDoubleCrossover:" + sumDCO);
        return cos;
    }

    public static int[] getLowDCOSNPs(GenotypeTable a, double maxDCOrate, int minCount) {
        int[][] dcoCnt = AlignmentFilterByGBSUtils.countDCO(a, false);
        IntList goodSites = new IntList();
        for (int i = 0; i < dcoCnt[0].length; ++i) {
            if (!((double)dcoCnt[1][i] / (double)dcoCnt[0][i] < maxDCOrate) || dcoCnt[0][i] < minCount) continue;
            goodSites.add(i);
        }
        return goodSites.toArray();
    }

    public static TaxaList getLowDCOIdGroup(GenotypeTable a, boolean isRefAltCoded, double maxDCO, int minCount) {
        int[][] dcoCnt = AlignmentFilterByGBSUtils.hetsByLine(a, isRefAltCoded, false);
        boolean[] include = new boolean[a.numberOfTaxa()];
        for (int i = 0; i < dcoCnt[0].length; ++i) {
            include[i] = !((double)dcoCnt[1][i] / (double)dcoCnt[0][i] > maxDCO) && dcoCnt[0][i] >= minCount;
        }
        return IdGroupUtils.idGroupSubset(a.taxa(), include);
    }
}

