/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ProductionSNPCallerPlugin;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.LoggingUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ProductionPipeline
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ProductionPipeline.class);
    private static final SimpleDateFormat LOGGING_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
    protected PluginParameter<String> myInputDirectory = new PluginParameter.Builder<String>(PARAMETERS.inputDirectory, null, String.class).required(true).inDir().description("Input directory containing fastq AND/OR qseq files").build();
    protected PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>(PARAMETERS.keyFile, null, String.class).required(true).inFile().description("Barcode Key File").build();
    protected PluginParameter<String> myEnzyme = new PluginParameter.Builder<String>(PARAMETERS.enzyme, null, String.class).required(true).description("Enzyme used to create the GBS library").build();
    protected PluginParameter<String> myProductionTOPM = new PluginParameter.Builder<String>(PARAMETERS.productionTOPM, null, String.class).required(true).inFile().description("Physical map file containing tags and corresponding variants (production TOPM)").build();
    protected PluginParameter<String> myOutputGenotypeFile = new PluginParameter.Builder<String>(PARAMETERS.outputGenotypeFile, null, String.class).required(true).outFile().description("Output (target) HDF5 genotypes file to add new genotypes to (new file created if it doesn't exist)").build();
    protected PluginParameter<String> myArchiveDirectory = new PluginParameter.Builder<String>(PARAMETERS.archiveDirectory, null, String.class).required(true).outDir().description("Archive directory where to move processed files").build();
    private String myOutputDirectory;

    public ProductionPipeline(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        if (this.myOutputGenotypeFile.value() != null) {
            this.myOutputDirectory = Utils.getDirectory(this.myOutputGenotypeFile.value());
            this.setupLogfile();
        }
        myLogger.info((Object)ProductionPipeline.getTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet processData(DataSet input) {
        try {
            Object[] rawSeqFileNames = DirectoryCrawler.listFileNames("(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$|.*_qseq\\.txt$|.*_qseq\\.txt\\.gz$", this.myInputDirectory.value());
            if (rawSeqFileNames == null || rawSeqFileNames.length == 0) {
                DataSet dataSet = null;
                return dataSet;
            }
            myLogger.info((Object)("Raw Sequence Files: " + Arrays.deepToString(rawSeqFileNames)));
            myLogger.info((Object)("Parameters Passed to ProductionSNPCallerPlugin: " + Arrays.deepToString(this.getPluginArgs())));
            ProductionSNPCallerPlugin plugin = new ProductionSNPCallerPlugin();
            plugin.setParameters(this.getPluginArgs());
            this.printParameterValues();
            plugin.performFunction(null);
            for (int i = 0; i < rawSeqFileNames.length; ++i) {
                File currentLocation = new File((String)rawSeqFileNames[i]);
                File newLocation = new File(this.myArchiveDirectory.value() + Utils.getFilename((String)rawSeqFileNames[i]));
                currentLocation.renameTo(newLocation);
                myLogger.info((Object)("Moved : " + currentLocation.getAbsolutePath() + " to: " + newLocation.getAbsolutePath()));
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            LoggingUtils.closeLogfile();
        }
    }

    private String[] getPluginArgs() {
        String[] args = new String[]{"-i", this.myInputDirectory.value(), "-k", this.myKeyFile.value(), "-e", this.myEnzyme.value(), "-o", this.myOutputGenotypeFile.value(), "-m", this.myProductionTOPM.value()};
        return args;
    }

    private void setupLogfile() {
        String todayDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String logFileName = todayDate + "_" + "ProductionPipeline" + ".log";
        logFileName = this.myOutputDirectory + "/" + logFileName;
        myLogger.info((Object)("Log File: " + logFileName));
        try {
            LoggingUtils.setupLogfile(logFileName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ProductionPipeline: setupLogfile: " + logFileName + " doesn't exist.");
        }
    }

    private static String getTimeStamp() {
        return "Timestamp: " + LOGGING_DATE_FORMAT.format(new Date()) + ": ";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Production Pipeline";
    }

    @Override
    public String getToolTipText() {
        return "Production Pipeline";
    }

    public String inputDirectory() {
        return this.myInputDirectory.value();
    }

    public ProductionPipeline inputDirectory(String value) {
        this.myInputDirectory = new PluginParameter<String>(this.myInputDirectory, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public ProductionPipeline keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public String enzyme() {
        return this.myEnzyme.value();
    }

    public ProductionPipeline enzyme(String value) {
        this.myEnzyme = new PluginParameter<String>(this.myEnzyme, value);
        return this;
    }

    public String productionTOPM() {
        return this.myProductionTOPM.value();
    }

    public ProductionPipeline productionTOPM(String value) {
        this.myProductionTOPM = new PluginParameter<String>(this.myProductionTOPM, value);
        return this;
    }

    public String outputGenotypeFile() {
        return this.myOutputGenotypeFile.value();
    }

    public ProductionPipeline outputGenotypeFile(String value) {
        this.myOutputGenotypeFile = new PluginParameter<String>(this.myOutputGenotypeFile, value);
        return this;
    }

    public String archiveDirectory() {
        return this.myArchiveDirectory.value();
    }

    public ProductionPipeline archiveDirectory(String value) {
        this.myArchiveDirectory = new PluginParameter<String>(this.myArchiveDirectory, value);
        return this;
    }

    public static enum PARAMETERS {
        inputDirectory,
        keyFile,
        enzyme,
        productionTOPM,
        outputGenotypeFile,
        archiveDirectory;

    }
}

