/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.HelperTags;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.UTagPairs;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class UTagPairToTOPMPlugin
extends AbstractPlugin {
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(UTagPairToTOPMPlugin.class);
    private UTagPairs tp;
    byte myStrand = 1;
    byte myMultimaps = 1;
    byte myDcoP = (byte)-128;
    byte myMapP = (byte)-128;
    private PluginParameter<Integer> chrom = new PluginParameter.Builder<Integer>("chrom", Integer.valueOf(1), Integer.class).description("Chromosome to start numbering at").guiName("Start chromosome").build();
    private PluginParameter<Integer> distance = new PluginParameter.Builder<Integer>("distance", Integer.valueOf(1000), Integer.class).description("Distance to pad between each tag pair").guiName("Pad distance").units("base pairs").build();
    private PluginParameter<String> infile = new PluginParameter.Builder<String>("input", null, String.class).description("Input file of matched tag pairs").required(true).inFile().build();
    private PluginParameter<String> textOutputFile = new PluginParameter.Builder<String>("toText", null, String.class).description("File to output TOPM in text format").required(false).outFile().build();
    private PluginParameter<String> binaryOutputFile = new PluginParameter.Builder<String>("toBinary", null, String.class).description("File to output TOPM in binary format").required(false).outFile().build();

    public UTagPairToTOPMPlugin() {
        super(null, false);
    }

    public UTagPairToTOPMPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        this.tp = new UTagPairs(this.inputFile());
        TagsOnPhysicalMap myTopm = this.makeTopmFromTagPairs(this.tp);
        if (this.textOutputFile() != null) {
            this.logger.info((Object)("Outputting TOPM in text format to " + this.textOutputFile()));
            myTopm.writeTextFile(new File(this.textOutputFile()));
        }
        if (this.binaryOutputFile() != null) {
            this.logger.info((Object)("Outputting TOPM in binary format to " + this.binaryOutputFile()));
            myTopm.writeBinaryFile(new File(this.binaryOutputFile()));
        }
        return null;
    }

    private TagsOnPhysicalMap makeTopmFromTagPairs(UTagPairs tp) {
        HelperTags tempTags = new HelperTags(tp.getTagNum(), tp.getTag(0).length);
        for (int i = 0; i < tp.getTagNum(); ++i) {
            tempTags.setTag(i, tp.getTag(i), tp.getTagLength(i));
        }
        TagsOnPhysicalMap myTopm = new TagsOnPhysicalMap(tempTags);
        int currPos = 1;
        int currChrom = this.startChrom();
        for (int i = 0; i < tp.getTagNum(); ++i) {
            myTopm.setChromoPosition(i, currChrom, this.myStrand, currPos, currPos + tp.getTagLength(i) - 1);
            myTopm.setDivergence(i, (byte)0);
            myTopm.setDcoP(i, (byte)-128);
            myTopm.setMapP(i, (byte)-128);
            myTopm.setMultimaps(i, (byte)1);
            if (i % 2 == 1) {
                currPos += this.padDistance().intValue();
            }
            if (currPos < Integer.MAX_VALUE) continue;
            ++currChrom;
            currPos = 1;
        }
        return myTopm;
    }

    @Override
    protected void postProcessParameters() {
        if (this.binaryOutputFile() == null && this.textOutputFile() == null) {
            throw new IllegalArgumentException("\n\nMust specify at least one output file (text or binary).\n\n");
        }
    }

    @Override
    public String pluginDescription() {
        return "This plugin takes a tag-pair file (from UTagCountToTagPairPlugin) and converts it into a TOPM (tags on physical map) file for use in the GBS pipeline. The resulting chromosome coordinates and other data are just filler to comply with the TOPM file specifications.";
    }

    public UTagPairToTOPMPlugin inputFile(String filename) {
        this.setParameter(this.infile.cmdLineName(), filename);
        return this;
    }

    public UTagPairToTOPMPlugin textOutfile(String filename) {
        this.setParameter(this.textOutputFile.cmdLineName(), filename);
        return this;
    }

    public UTagPairToTOPMPlugin binaryOutfile(String filename) {
        this.setParameter(this.binaryOutputFile.cmdLineName(), filename);
        return this;
    }

    public UTagPairToTOPMPlugin startChrom(Integer value) {
        this.setParameter(this.chrom.cmdLineName(), (Comparable)value);
        return this;
    }

    public UTagPairToTOPMPlugin padDistance(Integer value) {
        this.setParameter(this.distance.cmdLineName(), (Comparable)value);
        return this;
    }

    public String inputFile() {
        return this.infile.value();
    }

    public String textOutputFile() {
        return this.textOutputFile.value();
    }

    public String binaryOutputFile() {
        return this.binaryOutputFile.value();
    }

    public Integer startChrom() {
        return this.chrom.value();
    }

    public Integer padDistance() {
        return this.distance.value();
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Tag Pairs to TOPM";
    }

    @Override
    public String getToolTipText() {
        return "Tag Pairs to TOPM";
    }
}

