/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.imputation.GenotypeImputationPluginDialog;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.DialogUtils;
import net.maizegenetics.gui.GenotypeTableMask;
import net.maizegenetics.gui.GenotypeTableMaskBoolean;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GenotypeImputationPlugin
extends AbstractDisplayPlugin {
    private static final Logger myLogger = Logger.getLogger(GenotypeImputationPlugin.class);
    private int minLength = 30;
    private int maxMismatch = 1;
    private double minProb = 0.001;
    private ImpMethod currMethod = ImpMethod.Length;

    public GenotypeImputationPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nThere are many possible algorithms for Imputation.\n");
        builder.append("After consideration, we may make one or more available\n");
        builder.append("via TASSEL.  But currently, please impute your data by\n");
        builder.append("another software package.");
        if (this.isInteractive()) {
            JOptionPane.showMessageDialog(this.getParentFrame(), builder.toString(), "Info", 1);
        } else {
            myLogger.info((Object)("GenotypeImputationPlugin: performFunction: " + builder.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet performFunctionOLD(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        ArrayList<Datum> result = new ArrayList<Datum>();
        try {
            if (alignInList.size() == 0) {
                throw new IllegalArgumentException("Invalid selection.  Please select 1 or more alignments.");
            }
            if (this.isInteractive()) {
                GenotypeImputationPluginDialog myDialog = new GenotypeImputationPluginDialog(null);
                myDialog.setLocationRelativeTo(this.getParentFrame());
                myDialog.setVisible(true);
                if (myDialog.isRunAnalysis()) {
                    this.minLength = myDialog.getMinLength();
                    this.maxMismatch = myDialog.getMaxMismatch();
                    this.minProb = myDialog.getMinProb();
                    this.currMethod = myDialog.getChosenImpMethod();
                } else {
                    DataSet dataSet = null;
                    return dataSet;
                }
            }
            for (Datum d : alignInList) {
                DataSet ds = this.processDatum(d);
                if (ds == null) continue;
                result.addAll(ds.getDataSet());
                this.fireDataSetReturned(new PluginEvent(ds, GenotypeImputationPlugin.class));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append(Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(e), 50));
            String str = builder.toString();
            if (this.isInteractive()) {
                DialogUtils.showError(str, (Component)this.getParentFrame());
            } else {
                myLogger.error((Object)str);
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
        DataSet resultSet = new DataSet(result, (Plugin)this);
        return resultSet;
    }

    public DataSet processDatum(Datum inDatum) {
        GenotypeTable align = (GenotypeTable)inDatum.getData();
        GenotypeTable impP1A = null;
        String theName = inDatum.getName() + "_Imp";
        String theComment = "Imputed Data Of\n" + inDatum.getComment();
        Datum outDatum = new Datum(theName, impP1A, theComment);
        GenotypeTableMaskBoolean mask = GenotypeTableMaskBoolean.getInstanceCompareAlignments(impP1A, align, "Imputed", GenotypeTableMask.MaskType.imputed);
        Datum maskDatum = new Datum(((Object)mask).toString(), mask, null);
        DataSet result = new DataSet(new Datum[]{outDatum, maskDatum}, (Plugin)this);
        return result;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = GenotypeImputationPlugin.class.getResource("/net/maizegenetics/analysis/images/ImputeSNP.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Impute SNPs";
    }

    @Override
    public String getToolTipText() {
        return "Impute genotypic data";
    }

    public void setMinLength(int length) {
        this.minLength = length;
    }

    public void setMaxMisMatch(int max) {
        this.maxMismatch = max;
    }

    public void setMinProb(double num) {
        this.minProb = num;
    }

    public void setMethod(ImpMethod method) {
        this.currMethod = method;
    }

    public static enum ImpMethod {
        Length,
        MajorAllele,
        SimilarWindow,
        IBDProb;

    }
}

