/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import com.google.common.base.Joiner;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Ints;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.FormattedOutput;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Utils;
import net.maizegenetics.util.VCFUtil;
import org.apache.log4j.Logger;

public class ExportUtils {
    private static final Logger myLogger = Logger.getLogger(ExportUtils.class);
    private static FormattedOutput format = FormattedOutput.getInstance();

    private ExportUtils() {
    }

    public static String writeGenotypeHDF5(GenotypeTable a, String newHDF5file) {
        return ExportUtils.writeGenotypeHDF5(a, newHDF5file, null, true);
    }

    public static String writeGenotypeHDF5(GenotypeTable a, String newHDF5file, boolean keepDepth) {
        return ExportUtils.writeGenotypeHDF5(a, newHDF5file, null, keepDepth);
    }

    public static String writeGenotypeHDF5(GenotypeTable a, String newHDF5file, TaxaList exportTaxa, boolean keepDepth) {
        GenotypeTableBuilder aB = GenotypeTableBuilder.getTaxaIncremental(a.positions(), newHDF5file);
        if (exportTaxa != null && exportTaxa.numberOfTaxa() == 0) {
            aB.build();
            return newHDF5file;
        }
        for (int t = 0; t < a.numberOfTaxa(); ++t) {
            if (exportTaxa != null && !exportTaxa.contains(a.taxa().get(t))) continue;
            byte[] bases = a.genotypeAllSites(t);
            if (!a.hasDepth() || !keepDepth) {
                aB.addTaxon((Taxon)a.taxa().get(t), bases, (byte[][])null);
                continue;
            }
            aB.addTaxon((Taxon)a.taxa().get(t), bases, a.depth().depthAllSitesByte(t));
        }
        aB.build();
        return newHDF5file;
    }

    public static String writeToHapmap(GenotypeTable alignment, String filename) {
        return ExportUtils.writeToHapmap(alignment, false, filename, '\t', null);
    }

    public static String writeToHapmap(GenotypeTable alignment, boolean diploid, String filename, char delimChar, ProgressListener listener) {
        if (delimChar != ' ' && delimChar != '\t') {
            throw new IllegalArgumentException("Delimiter charater must be either a blank space or a tab.");
        }
        BufferedWriter bw = null;
        try {
            String fullFileName = Utils.addSuffixIfNeeded(filename, ".hmp.txt", new String[]{".hmp.txt", ".hmp.txt.gz"});
            bw = Utils.getBufferedWriter(fullFileName);
            for (Taxon taxon : alignment.taxa()) {
                if (taxon.getAllAnnotationEntries().length == 0) continue;
                bw.write("##SAMPLE=" + taxon.toStringWithVCFAnnotation() + "\n");
            }
            bw.write(Joiner.on((char)delimChar).join((Object)"rs#", (Object)"alleles", new Object[]{"chrom", "pos", "strand", "assembly#", "center", "protLSID", "assayLSID", "panelLSID", "QCcode"}));
            bw.write(delimChar);
            int numTaxa = alignment.numberOfTaxa();
            for (int taxa = 0; taxa < numTaxa; ++taxa) {
                String sequenceID = alignment.taxaName(taxa).trim();
                bw.write(sequenceID);
                if (taxa == numTaxa - 1) continue;
                bw.write(delimChar);
            }
            bw.write("\n");
            int numSites = alignment.numberOfSites();
            for (int site = 0; site < numSites; ++site) {
                bw.write(alignment.siteName(site));
                bw.write(delimChar);
                int[][] sortedAlleles = alignment.allelesSortedByFrequency(site);
                int numAlleles = sortedAlleles[0].length;
                if (numAlleles == 0) {
                    bw.write("NA");
                } else if (numAlleles == 1) {
                    bw.write(alignment.genotypeAsString(site, (byte)sortedAlleles[0][0]));
                } else {
                    bw.write(alignment.genotypeAsString(site, (byte)sortedAlleles[0][0]));
                    for (int allele = 1; allele < sortedAlleles[0].length; ++allele) {
                        if (sortedAlleles[0][allele] == 15) continue;
                        bw.write(47);
                        bw.write(alignment.genotypeAsString(site, (byte)sortedAlleles[0][allele]));
                    }
                }
                bw.write(delimChar);
                bw.write(Joiner.on((char)delimChar).join((Object)alignment.chromosomeName(site), (Object)String.valueOf(alignment.chromosomalPosition(site)), new Object[]{"+", "NA", "NA", "NA", "NA", "NA", "NA"}));
                bw.write(delimChar);
                for (int taxa = 0; taxa < numTaxa; ++taxa) {
                    if (!diploid) {
                        String baseIUPAC = null;
                        try {
                            baseIUPAC = alignment.genotypeAsString(taxa, site);
                        }
                        catch (Exception e) {
                            String[] b = alignment.genotypeAsStringArray(taxa, site);
                            bw.close();
                            throw new IllegalArgumentException("There is no String representation for diploid values: " + b[0] + ":" + b[1] + " getBase(): 0x" + Integer.toHexString(alignment.genotype(taxa, site)) + "\nTry Exporting as Diploid Values.");
                        }
                        if (baseIUPAC == null || baseIUPAC.equals("?")) {
                            String[] b = alignment.genotypeAsStringArray(taxa, site);
                            bw.close();
                            throw new IllegalArgumentException("There is no String representation for diploid values: " + b[0] + ":" + b[1] + " getBase(): 0x" + Integer.toHexString(alignment.genotype(taxa, site)) + "\nTry Exporting as Diploid Values.");
                        }
                        bw.write(baseIUPAC);
                    } else {
                        String[] b = alignment.genotypeAsStringArray(taxa, site);
                        if (b.length == 1) {
                            bw.write(b[0]);
                            bw.write(b[0]);
                        } else {
                            bw.write(b[0]);
                            bw.write(b[1]);
                        }
                    }
                    if (taxa == numTaxa - 1) continue;
                    bw.write(delimChar);
                }
                bw.write("\n");
                if (listener == null) continue;
                listener.progress((int)((double)(site + 1) / (double)numSites * 100.0), null);
            }
            String string = fullFileName;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error writing Hapmap file: " + filename + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                bw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String writeToVCF(GenotypeTable gt, String filename, boolean keepDepth) {
        int delimChar = 9;
        boolean hasDepth = gt.hasDepth() && keepDepth;
        try {
            filename = Utils.addSuffixIfNeeded(filename, ".vcf", new String[]{".vcf", ".vcf.gz"});
            BufferedWriter bw = Utils.getBufferedWriter(filename);
            bw.write("##fileformat=VCFv4.0");
            bw.newLine();
            if (!gt.hasReference()) {
                bw.write("##Tassel=<ID=GenotypeTable,Version=5,Description=\"Reference allele is not known. The major allele was used as reference allele\">");
                bw.newLine();
            }
            bw.write("##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">");
            bw.newLine();
            bw.write("##FORMAT=<ID=AD,Number=.,Type=Integer,Description=\"Allelic depths for the reference and alternate alleles in the order listed\">");
            bw.newLine();
            bw.write("##FORMAT=<ID=DP,Number=1,Type=Integer,Description=\"Read Depth (only filtered reads used for calling)\">");
            bw.newLine();
            bw.write("##FORMAT=<ID=GQ,Number=1,Type=Float,Description=\"Genotype Quality\">");
            bw.newLine();
            bw.write("##FORMAT=<ID=PL,Number=3,Type=Float,Description=\"Normalized, Phred-scaled likelihoods for AA,AB,BB genotypes where A=ref and B=alt; not applicable if site is not biallelic\">");
            bw.newLine();
            bw.write("##INFO=<ID=NS,Number=1,Type=Integer,Description=\"Number of Samples With Data\">");
            bw.newLine();
            bw.write("##INFO=<ID=DP,Number=1,Type=Integer,Description=\"Total Depth\">");
            bw.newLine();
            bw.write("##INFO=<ID=AF,Number=.,Type=Float,Description=\"Allele Frequency\">");
            bw.newLine();
            ExportUtils.writeVCFSampleAnnotationToWriter(gt, bw);
            bw.write("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT");
            for (int taxa = 0; taxa < gt.numberOfTaxa(); ++taxa) {
                String taxonName = gt.taxaName(taxa).trim();
                bw.write('\t' + taxonName);
            }
            bw.newLine();
            int noAlleles = 0;
            for (int site = 0; site < gt.numberOfSites(); ++site) {
                Position p = (Position)gt.positions().get(site);
                byte refAllele = p.getAllele(WHICH_ALLELE.Reference);
                int[] sortedAlleles = gt.allelesSortedByFrequency(site)[0];
                int indexOfRefAllele = Ints.indexOf((int[])sortedAlleles, (int)refAllele);
                if (indexOfRefAllele < 0) {
                    indexOfRefAllele = 0;
                }
                if (indexOfRefAllele != 0) {
                    int t = sortedAlleles[0];
                    sortedAlleles[0] = sortedAlleles[indexOfRefAllele];
                    sortedAlleles[indexOfRefAllele] = t;
                }
                int nAlleles = sortedAlleles.length;
                Object[] alleleRedirect = new String[16];
                Arrays.fill(alleleRedirect, ".");
                for (int i = 0; i < sortedAlleles.length; ++i) {
                    alleleRedirect[sortedAlleles[i]] = "" + i;
                }
                bw.write(gt.chromosomeName(site));
                bw.write(9);
                bw.write(gt.chromosomalPosition(site) + "");
                bw.write(9);
                bw.write(gt.siteName(site));
                bw.write(9);
                if (nAlleles == 0) {
                    ++noAlleles;
                    bw.write(".\t.\t.\tPASS\t.\tGT");
                    for (int taxa = 0; taxa < gt.numberOfTaxa(); ++taxa) {
                        bw.write("\t./.");
                    }
                    bw.newLine();
                    continue;
                }
                bw.write(NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[0]));
                bw.write(9);
                StringBuilder altAllelesBuilder = new StringBuilder("");
                for (int aa = 1; aa < sortedAlleles.length; ++aa) {
                    altAllelesBuilder.append(NucleotideAlignmentConstants.getHaplotypeNucleotide((byte)sortedAlleles[aa]) + ",");
                }
                if (altAllelesBuilder.length() == 0) {
                    altAllelesBuilder.append(".");
                } else {
                    altAllelesBuilder.deleteCharAt(altAllelesBuilder.length() - 1);
                }
                bw.write(altAllelesBuilder.toString());
                bw.write(9);
                bw.write(".");
                bw.write(9);
                bw.write("PASS");
                bw.write(9);
                if (hasDepth) {
                    bw.write("DP=" + gt.depth().depthForSite(site));
                } else {
                    bw.write(".");
                }
                bw.write(9);
                if (hasDepth) {
                    bw.write("GT:AD:DP:GQ:PL");
                } else {
                    bw.write("GT");
                }
                for (int taxa = 0; taxa < gt.numberOfTaxa(); ++taxa) {
                    bw.write(9);
                    byte[] values = gt.genotypeArray(taxa, site);
                    bw.write((String)alleleRedirect[values[0]]);
                    bw.write("/");
                    bw.write((String)alleleRedirect[values[1]]);
                    if (!hasDepth) continue;
                    bw.write(":");
                    int[] siteAlleleDepths = gt.depthForAlleles(taxa, site);
                    int siteTotalDepth = 0;
                    for (int ss = 0; ss < sortedAlleles.length; ++ss) {
                        bw.write("" + siteAlleleDepths[sortedAlleles[ss]]);
                        if (ss < sortedAlleles.length - 1) {
                            bw.write(44);
                        }
                        siteTotalDepth += siteAlleleDepths[sortedAlleles[ss]];
                    }
                    bw.write(":");
                    bw.write(siteTotalDepth + "");
                    bw.write(":");
                    int[] scores = new int[]{-1, -1, -1, -1};
                    if (values[0] != 15) {
                        int altDepth = sortedAlleles.length < 2 ? 0 : siteAlleleDepths[sortedAlleles[1]];
                        scores = VCFUtil.getScore(siteAlleleDepths[sortedAlleles[0]], altDepth);
                    }
                    bw.write(scores[3] + "");
                    bw.write(":");
                    bw.write(scores[0] + "," + scores[1] + "," + scores[2]);
                }
                bw.newLine();
            }
            if (noAlleles > 0) {
                myLogger.warn((Object)("Warning: " + noAlleles + " sites have no alleles."));
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error writing VCF file: " + filename + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        return filename;
    }

    private static void writeVCFSampleAnnotationToWriter(GenotypeTable gt, BufferedWriter bw) throws IOException {
        for (Taxon taxon : gt.taxa()) {
            SetMultimap<String, String> annoMap = taxon.getAnnotationAsMap();
            if (annoMap.size() == 0) continue;
            String annoString = Joiner.on((char)',').withKeyValueSeparator("=").join((Iterable)annoMap.entries());
            bw.write("##SAMPLE=<ID=" + taxon.getName() + "," + annoString + ">");
            bw.newLine();
        }
    }

    public static String writeToPlink(GenotypeTable alignment, String filename, char delimChar) {
        if (delimChar != ' ' && delimChar != '\t') {
            throw new IllegalArgumentException("Delimiter charater must be either a blank space or a tab.");
        }
        BufferedWriter MAPbw = null;
        BufferedWriter PEDbw = null;
        String mapFileName = Utils.addSuffixIfNeeded(filename, ".plk.map");
        String pedFileName = Utils.addSuffixIfNeeded(filename, ".plk.ped");
        try {
            MAPbw = new BufferedWriter(new FileWriter(mapFileName), 1000000);
            int numSites = alignment.numberOfSites();
            for (int site = 0; site < numSites; ++site) {
                MAPbw.write(alignment.chromosomeName(site));
                MAPbw.write(delimChar);
                MAPbw.write(alignment.siteName(site));
                MAPbw.write(delimChar);
                MAPbw.write("-9");
                MAPbw.write(delimChar);
                MAPbw.write(Integer.toString(alignment.chromosomalPosition(site)));
                MAPbw.write("\n");
            }
            MAPbw.close();
            PEDbw = new BufferedWriter(new FileWriter(pedFileName), 1000000);
            Pattern splitter = Pattern.compile(":");
            int numTaxa = alignment.numberOfTaxa();
            for (int taxa = 0; taxa < numTaxa; ++taxa) {
                String[] name = splitter.split(alignment.taxaName(taxa).trim());
                if (name.length != 1) {
                    PEDbw.write(name[1]);
                } else {
                    PEDbw.write("-9");
                }
                PEDbw.write(delimChar);
                PEDbw.write(alignment.taxaName(taxa).trim());
                PEDbw.write(delimChar);
                PEDbw.write("-9");
                PEDbw.write(delimChar);
                PEDbw.write("-9");
                PEDbw.write(delimChar);
                PEDbw.write("-9");
                PEDbw.write(delimChar);
                PEDbw.write("-9");
                PEDbw.write(delimChar);
                for (int site = 0; site < numSites; ++site) {
                    String[] b = ExportUtils.getSNPValueForPlink(alignment.genotypeAsStringArray(taxa, site));
                    PEDbw.write(b[0]);
                    PEDbw.write(delimChar);
                    PEDbw.write(b[b.length - 1]);
                    if (site == numSites - 1) continue;
                    PEDbw.write(delimChar);
                }
                PEDbw.write("\n");
            }
            PEDbw.close();
            String string = mapFileName + " and " + pedFileName;
            return string;
        }
        catch (Exception e) {
            myLogger.error((Object)("Error writing Plink files: " + mapFileName + " and " + pedFileName + ": " + ExceptionUtils.getExceptionCauses(e)));
            throw new IllegalArgumentException("Error writing Plink files: " + mapFileName + " and " + pedFileName + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                PEDbw.close();
            }
            catch (Exception e) {}
            try {
                MAPbw.close();
            }
            catch (Exception e) {}
        }
    }

    private static String[] getSNPValueForPlink(String[] base) {
        for (int i = 0; i < base.length; ++i) {
            if (base[i].equals("N")) {
                base[i] = "0";
                continue;
            }
            if (!base[i].equals("0")) continue;
            base[i] = "D";
        }
        return base;
    }

    public static String saveDelimitedAlignment(GenotypeTable theAlignment, String delimit, String saveFile) {
        if (saveFile == null || saveFile.length() == 0) {
            return null;
        }
        saveFile = Utils.addSuffixIfNeeded(saveFile, ".txt");
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(new File(saveFile));
            bw = new BufferedWriter(fw);
            bw.write("Taxa");
            int numSites = theAlignment.numberOfSites();
            for (int j = 0; j < numSites; ++j) {
                bw.write(delimit);
                bw.write(String.valueOf(theAlignment.chromosomalPosition(j)));
            }
            bw.write("\n");
            int n = theAlignment.numberOfTaxa();
            for (int r = 0; r < n; ++r) {
                bw.write(theAlignment.taxaName(r));
                for (int i = 0; i < numSites; ++i) {
                    bw.write(delimit);
                    bw.write(theAlignment.genotypeAsString(r, i));
                }
                bw.write("\n");
            }
            String string = saveFile;
            return string;
        }
        catch (Exception e) {
            myLogger.error((Object)("Error writing Delimited Alignment: " + saveFile + ": " + ExceptionUtils.getExceptionCauses(e)));
            throw new IllegalArgumentException("Error writing Delimited Alignment: " + saveFile + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                bw.close();
                fw.close();
            }
            catch (Exception e) {}
        }
    }

    public static void printSequential(GenotypeTable a, PrintWriter out) {
        out.println("  " + a.numberOfTaxa() + " " + a.numberOfSites() + "  S");
        for (int s = 0; s < a.numberOfTaxa(); ++s) {
            for (int n = 0; n < a.numberOfSites(); n += 50) {
                if (n == 0) {
                    format.displayLabel(out, a.taxaName(s), 10);
                    out.print("     ");
                } else {
                    out.print("               ");
                }
                ExportUtils.printNextSites(a, out, false, s, n, 50);
                out.println();
            }
        }
    }

    public static void printInterleaved(GenotypeTable a, PrintWriter out) {
        out.println("  " + a.numberOfTaxa() + " " + a.numberOfSites());
        for (int n = 0; n < a.numberOfSites(); n += 50) {
            for (int s = 0; s < a.numberOfTaxa(); ++s) {
                if (n == 0) {
                    format.displayLabel(out, a.taxaName(s), 10);
                    out.print("     ");
                } else {
                    out.print("               ");
                }
                ExportUtils.printNextSites(a, out, true, s, n, 50);
                out.println();
            }
            out.println();
        }
    }

    public static void printCLUSTALW(GenotypeTable a, PrintWriter out) {
        out.println("CLUSTAL W multiple sequence alignment");
        out.println();
        for (int n = 0; n < a.numberOfSites(); n += 50) {
            out.println();
            for (int s = 0; s < a.numberOfTaxa(); ++s) {
                format.displayLabel(out, a.taxaName(s), 10);
                out.print("     ");
                ExportUtils.printNextSites(a, out, false, s, n, 50);
                out.println();
            }
            out.println("               ");
        }
    }

    private static void printNextSites(GenotypeTable a, PrintWriter out, boolean chunked, int seq, int start, int num) {
        for (int i = 0; i < num && start + i < a.numberOfSites(); ++i) {
            if (i % 10 == 0 && i != 0 && chunked) {
                out.print(' ');
            }
            out.print(a.genotypeAsString(seq, start + i));
        }
    }

    public static String writeAlignmentToSerialGZ(GenotypeTable sba, String outFile) {
        long time = System.currentTimeMillis();
        File theFile = null;
        FileOutputStream fos = null;
        DeflaterOutputStream gz = null;
        ObjectOutputStream oos = null;
        try {
            theFile = new File(Utils.addSuffixIfNeeded(outFile, ".serial.gz"));
            fos = new FileOutputStream(theFile);
            gz = new GZIPOutputStream(fos);
            oos = new ObjectOutputStream(gz);
            oos.writeObject(sba);
            String string = theFile.getName();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            myLogger.error((Object)("Error writing Serial GZ: " + theFile.getName() + ": " + ExceptionUtils.getExceptionCauses(e)));
            throw new IllegalArgumentException("Error writing Serial GZ: " + theFile.getName() + ": " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                oos.flush();
                oos.close();
                gz.close();
                fos.close();
            }
            catch (Exception e) {}
            myLogger.info((Object)("writeAlignmentToSerialGZ: " + theFile.toString() + "  Time: " + (System.currentTimeMillis() - time)));
        }
    }
}

