/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.CoreGenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.depth.AlleleDepth;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;

public class NucleotideGenotypeTable
extends CoreGenotypeTable {
    public NucleotideGenotypeTable(GenotypeCallTable genotype, PositionList positionList, TaxaList taxaList, SiteScore siteScore, AlleleDepth alleleDepth) {
        super(genotype, positionList, taxaList, siteScore, alleleDepth);
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        StringBuilder builder = new StringBuilder();
        for (int i = startSite; i < endSite; ++i) {
            builder.append(this.genotypeAsString(taxon, i));
        }
        return builder.toString();
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(this.genotype(taxon, site));
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(value);
    }

    @Override
    public boolean isIndel(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        int numAlleles = Math.min(alleles[0].length, 2);
        for (int i = 0; i < numAlleles; ++i) {
            if (alleles[0][i] != 4 && alleles[0][i] != 5) continue;
            return true;
        }
        return false;
    }
}

