/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Random;
import net.maizegenetics.dna.tag.AbstractTagsByTaxa;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class TagsByTaxaByteFileMap
extends AbstractTagsByTaxa {
    private RandomAccessFile theRAF;
    private long dataStartPos = -1L;
    private long distStartPos = -1L;
    private long bufferedTagIndex = Integer.MIN_VALUE;
    private byte[] bufferedTagDist = null;
    private long byteLenRow = -1L;
    private boolean rowSetMethod = false;
    private boolean bufferChanged = false;

    public TagsByTaxaByteFileMap(String infile) {
        this.readDistFile(new File(infile), TagsByTaxa.FilePacking.Byte);
        this.bufferedTagDist = new byte[this.taxaNum];
        this.getReadCountForTagTaxon(0, 0);
    }

    public TagsByTaxaByteFileMap(String outFile, String[] taxaNames, Tags theTags) {
        int hapsOutput = 0;
        int tN = taxaNames.length;
        this.tagLengthInLong = theTags.getTagSizeInLong();
        byte[] obs = new byte[tN];
        try {
            DataOutputStream fw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile), 65536));
            fw.writeInt(theTags.getTagCount());
            fw.writeInt(theTags.getTagSizeInLong());
            fw.writeInt(tN);
            for (int t = 0; t < tN; ++t) {
                fw.writeUTF(taxaNames[t]);
            }
            for (int i = 0; i < theTags.getTagCount(); ++i) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    fw.writeLong(theTags.getTag(i)[j]);
                }
                fw.writeByte(theTags.getTagLength(i));
                fw.write(obs);
                ++hapsOutput;
            }
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Catch in writeTextDistFile writing output file e=" + e);
            e.printStackTrace();
        }
        this.readDistFile(new File(outFile), TagsByTaxa.FilePacking.Byte);
        this.bufferedTagDist = new byte[this.taxaNum];
        this.getReadCountForTagTaxon(0, 0);
    }

    @Override
    public void readDistFile(File inFile, TagsByTaxa.FilePacking binary) {
        int hapsOutput = 0;
        try {
            this.theRAF = new RandomAccessFile(inFile, "rw");
            int tagNum = this.theRAF.readInt();
            this.tagLengthInLong = this.theRAF.readInt();
            this.taxaNum = this.theRAF.readInt();
            this.initMatrices(this.taxaNum, tagNum);
            for (int t = 0; t < this.taxaNum; ++t) {
                this.taxaNames[t] = this.theRAF.readUTF();
            }
            this.dataStartPos = this.theRAF.getFilePointer();
            System.out.printf("nBytes to end of taxa names: %d %n", this.dataStartPos);
            this.distStartPos = this.dataStartPos + (long)this.tagLengthInLong * 8L + 1L;
            this.byteLenRow = 1 + this.taxaNum + 8 * this.tagLengthInLong;
            byte[] b = new byte[(int)this.byteLenRow];
            for (int i = 0; i < tagNum; ++i) {
                if (i % 1000000 == 0) {
                    System.out.println("Read tag" + i);
                }
                this.theRAF.read(b);
                ByteBuffer bb = ByteBuffer.wrap(b);
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[j][i] = bb.getLong();
                }
                this.tagLength[i] = bb.get();
                ++hapsOutput;
            }
        }
        catch (Exception e) {
            System.out.println("Catch in reading input file: " + e);
            e.printStackTrace();
        }
        System.out.println("Number of Taxa in file:" + this.taxaNum);
        System.out.println("Number of Haplotypes in file:" + hapsOutput);
    }

    @Override
    public void setReadCountForTagTaxon(int tagIndex, int taxaIndex, int value) {
        if (value == this.getReadCountForTagTaxon(tagIndex, taxaIndex)) {
            return;
        }
        if (this.rowSetMethod) {
            this.setReadCountForTagTaxonRow(tagIndex, taxaIndex, value);
        } else {
            this.setReadCountForTagTaxonPoint(tagIndex, taxaIndex, value);
        }
    }

    public void setFastPointReadCountForTagTaxon(int tagIndex, int taxaIndex, int value) {
        this.setReadCountForTagTaxonPoint(tagIndex, taxaIndex, value);
    }

    public void setFastReadCountForAdjacentTagTaxonSet(int tagIndex, int firstTaxaIndex, byte[] values) {
        try {
            long pos = this.byteLenRow * (long)tagIndex + this.distStartPos + (long)firstTaxaIndex;
            this.theRAF.seek(pos);
            this.theRAF.write(values);
        }
        catch (IOException e) {
            System.out.println("Catch in reading bufferTagDist: " + e);
            e.printStackTrace();
        }
    }

    private void setReadCountForTagTaxonRow(int tagIndex, int taxaIndex, int value) {
        if ((long)tagIndex != this.bufferedTagIndex) {
            this.bufferTagDist(tagIndex);
        }
        this.bufferedTagDist[taxaIndex] = value > 127 ? 127 : (value < 0 ? 0 : (int)value);
        this.bufferChanged = true;
    }

    private void setReadCountForTagTaxonPoint(int tagIndex, int taxaIndex, int value) {
        try {
            long pos = this.byteLenRow * (long)tagIndex + this.distStartPos + (long)taxaIndex;
            this.theRAF.seek(pos);
            this.theRAF.write(value);
        }
        catch (IOException e) {
            System.out.println("Catch in reading bufferTagDist: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void setMethodByRows(boolean rowSetMethod) {
        this.rowSetMethod = rowSetMethod;
    }

    @Override
    public void getFileReadyForClosing() {
        this.saveCurrentBufferTagDist();
    }

    @Override
    public int getReadCountForTagTaxon(int tagIndex, int taxaIndex) {
        if ((long)tagIndex != this.bufferedTagIndex) {
            this.bufferTagDist(tagIndex);
        }
        return this.bufferedTagDist[taxaIndex];
    }

    private synchronized void saveCurrentBufferTagDist() {
        try {
            long oldpos = this.byteLenRow * this.bufferedTagIndex + this.distStartPos;
            this.theRAF.seek(oldpos);
            this.theRAF.write(this.bufferedTagDist);
            this.bufferChanged = false;
        }
        catch (IOException e) {
            System.out.println("Catch in reading saveCurrentBufferTagDist: " + e);
            e.printStackTrace();
        }
    }

    private synchronized void bufferTagDist(int tagIndex) {
        try {
            if (this.bufferChanged) {
                this.saveCurrentBufferTagDist();
            }
            long pos = this.byteLenRow * (long)tagIndex + this.distStartPos;
            this.theRAF.seek(pos);
            this.theRAF.read(this.bufferedTagDist);
            this.bufferedTagIndex = tagIndex;
            this.bufferChanged = false;
        }
        catch (IOException e) {
            System.out.println("Catch in reading bufferTagDist: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void initMatrices(int taxaNum, int tagNum) {
        this.taxaNames = new String[taxaNum];
        this.tags = new long[this.tagLengthInLong][tagNum];
        this.tagLength = new byte[tagNum];
    }

    @Override
    public void addTaxa(String[] addTaxaNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        System.out.println("Running main method in TagsByTaxaBitFileMap");
        String infile = "/media/jvh053111/all_zea_tbt_110411/10243151_81N4HABXX_s_6.tbt.bin";
        String outfile2 = "/media/Cache/chunk1.tbt.byte";
        TagsByTaxaByteFileMap tbtb2 = new TagsByTaxaByteFileMap(infile);
        long currTime = System.currentTimeMillis();
        int count = 0;
        TagsByTaxaByteFileMap tbtb3 = new TagsByTaxaByteFileMap(outfile2, tbtb2.getTaxaNames(), tbtb2);
        tbtb3.setMethodByRows(true);
        Random rnd = new Random();
        int rows = 10000;
        int currRow = 10;
        for (int i = 0; i < tbtb2.getTagCount(); ++i) {
            for (int j = 0; j < tbtb3.getTaxaCount(); ++j) {
                tbtb3.setReadCountForTagTaxon(i, j, tbtb2.getReadCountForTagTaxon(i, j));
            }
        }
        tbtb3.getFileReadyForClosing();
        tbtb2.writeDistFile(new File("/media/Cache/tbtb2.tbt.txt"), TagsByTaxa.FilePacking.Text, 0);
        tbtb3.writeDistFile(new File("/media/Cache/tbtb3.tbt.txt"), TagsByTaxa.FilePacking.Text, 0);
        long totTime = System.currentTimeMillis() - currTime;
        double rate = (double)rows / (double)totTime;
        System.out.printf("Total time: %d   Count:%d Rate: %g %n", totTime, count, rate);
    }
}

