/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.analysis.distance.IBSDistanceMatrix;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.AbstractGenotypeTableMask;
import net.maizegenetics.gui.GenotypeTableMask;
import net.maizegenetics.taxa.Taxon;

public class GenotypeTableMaskGeneticDistance
extends AbstractGenotypeTableMask {
    private static final long serialVersionUID = -5197800047652332969L;
    private Map<Integer, Byte> myCache = new LinkedHashMap<Integer, Byte>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Byte> eldest) {
            return this.size() > 100;
        }
    };
    private final int myTaxonReference;
    private final GenotypeTable myAlignment;

    private GenotypeTableMaskGeneticDistance(GenotypeTable align, int taxonReference, String name, Color color) {
        super(align, name, color, GenotypeTableMask.MaskType.reference);
        this.myTaxonReference = taxonReference;
        this.myAlignment = align;
    }

    public static GenotypeTableMaskGeneticDistance getInstanceCompareReference(GenotypeTable align, Taxon id) {
        int index = align.taxa().indexOf(id);
        if (index < 0) {
            throw new IllegalArgumentException("GenotypeTableMaskGeneticDistance: getInstanceCompareReference: unknown id: " + id);
        }
        return GenotypeTableMaskGeneticDistance.getInstanceCompareReference(align, index);
    }

    public static GenotypeTableMaskGeneticDistance getInstanceCompareReference(GenotypeTable align, String id) {
        int index = align.taxa().indexOf(id);
        if (index < 0) {
            throw new IllegalArgumentException("GenotypeTableMaskGeneticDistance: getInstanceCompareReference: unknown id: " + id);
        }
        return GenotypeTableMaskGeneticDistance.getInstanceCompareReference(align, index);
    }

    public static GenotypeTableMaskGeneticDistance getInstanceCompareReference(GenotypeTable align, int index) {
        if (index < 0 || index >= align.numberOfTaxa()) {
            throw new IllegalArgumentException("GenotypeTableMaskGeneticDistance: getInstanceCompareReference: unknown index: " + index);
        }
        String name = align.taxaName(index) + " Genetic Distance";
        return new GenotypeTableMaskGeneticDistance(align, index, name, null);
    }

    @Override
    public byte getMask(int taxon, int site) {
        Byte result = this.myCache.get(taxon);
        if (result != null) {
            return result;
        }
        result = (byte)(IBSDistanceMatrix.computeHetBitDistances(this.myAlignment, taxon, this.myTaxonReference)[0] * 255.0);
        this.myCache.put(taxon, result);
        return result;
    }
}

