/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;
import net.maizegenetics.util.Utils;

public class ReadPhenotypeUtils {
    public static final String missing = "\\?|nan|-999";
    private static Pattern missingPattern = Pattern.compile("\\?|nan|-999", 2);

    private ReadPhenotypeUtils() {
    }

    public static Trait makeCharacterTrait(String[] original, double[] tonumber, String name, String type) {
        TreeSet<String> dataset = new TreeSet<String>();
        for (String str : original) {
            if (missingPattern.matcher(str).matches() || str.contains("?")) continue;
            dataset.add(str);
        }
        Object[] levelNames = new String[dataset.size()];
        dataset.toArray(levelNames);
        int n = original.length;
        for (int i = 0; i < n; ++i) {
            tonumber[i] = Arrays.binarySearch(levelNames, original[i]);
            if (!(tonumber[i] < -0.1)) continue;
            tonumber[i] = Double.NaN;
        }
        Trait trait = new Trait(name, true, type);
        trait.setLevelLabels((String[])levelNames);
        return trait;
    }

    public static double[] doubleFromCharacterTrait(Trait trait, String[] textdata) {
        TreeSet<String> dataset = new TreeSet<String>();
        int n = textdata.length;
        double[] dbldata = new double[n];
        for (String str : textdata) {
            if (missingPattern.matcher(str).matches() || str.contains("?")) continue;
            dataset.add(str);
        }
        Object[] levelNames = new String[dataset.size()];
        dataset.toArray(levelNames);
        for (int i = 0; i < n; ++i) {
            dbldata[i] = Arrays.binarySearch(levelNames, textdata[i]);
            if (!(dbldata[i] < -0.1)) continue;
            dbldata[i] = Double.NaN;
        }
        trait.setProperty("level_labels", levelNames);
        return dbldata;
    }

    public static Phenotype readPolymorphismAlignment(String inputFile) throws IOException {
        int i;
        BufferedReader br = Utils.getBufferedReader(inputFile);
        String sep = "[\\s]+";
        String[] parsedline = br.readLine().split("[:\\s]+");
        int taxaNumber = Integer.parseInt(parsedline[0]);
        int locusNumber = Integer.parseInt(parsedline[1]);
        String[] taxaNames = new String[taxaNumber];
        String[] locusNames = new String[locusNumber];
        LinkedList<Trait> traitList = new LinkedList<Trait>();
        DoubleMatrix2D genotypes = DoubleFactory2D.dense.make(taxaNumber, locusNumber);
        parsedline = br.readLine().split(sep);
        int firstLocus = 0;
        int n = parsedline.length;
        if (n != locusNumber) {
            if (n == locusNumber + 1) {
                firstLocus = 1;
            } else {
                throw new IllegalArgumentException("Number of loci in header not equal to number of locus names in " + inputFile + ". Data not imported.");
            }
        }
        for (int i2 = 0; i2 < locusNumber; ++i2) {
            locusNames[i2] = parsedline[i2 + firstLocus];
        }
        String[][] locusText = new String[locusNumber][taxaNumber];
        for (i = 0; i < taxaNumber; ++i) {
            parsedline = br.readLine().split(sep);
            taxaNames[i] = parsedline[0].toUpperCase();
            for (int j = 0; j < locusNumber; ++j) {
                locusText[j][i] = parsedline[j + 1];
            }
        }
        for (i = 0; i < locusNumber; ++i) {
            double[] dblval = new double[taxaNumber];
            traitList.add(ReadPhenotypeUtils.makeCharacterTrait(locusText[i], dblval, locusNames[i], "marker"));
            genotypes.viewColumn(i).assign(dblval);
        }
        TaxaList tL = new TaxaListBuilder().addAll(taxaNames).build();
        return new SimplePhenotype(tL, traitList, genotypes);
    }

    public static Phenotype readNumericalAlignment(String inputFile) throws IOException {
        int i;
        BufferedReader br = Utils.getBufferedReader(inputFile);
        String sep = "\\s+";
        String[] parsedline = br.readLine().trim().split(sep);
        if (parsedline.length != 3) {
            throw new IllegalArgumentException("Improper header in " + inputFile + ". Data not imported.");
        }
        int taxaNumber = Integer.parseInt(parsedline[0]);
        int traitNumber = Integer.parseInt(parsedline[1]);
        int headerNumber = Integer.parseInt(parsedline[2]);
        if (headerNumber < 1 || headerNumber > 2) {
            throw new IllegalArgumentException("Numerical format only allows 1 or 2 headers in " + inputFile + ". Data not imported.");
        }
        parsedline = br.readLine().split(sep);
        ArrayList<Trait> traitList = new ArrayList<Trait>();
        if (parsedline.length != traitNumber) {
            throw new IllegalArgumentException("Incorrect number of trait names in " + inputFile + ". Data not imported.");
        }
        for (i = 0; i < traitNumber; ++i) {
            Trait trait = new Trait(parsedline[i], false, "data");
            traitList.add(trait);
        }
        if (headerNumber > 1) {
            parsedline = br.readLine().split(sep);
            if (parsedline.length != traitNumber) {
                throw new IllegalArgumentException("Incorrect number of environment names in " + inputFile + ". Data not imported.");
            }
            for (i = 0; i < traitNumber; ++i) {
                ((Trait)traitList.get(i)).addFactor("env", parsedline[i]);
            }
        }
        DoubleMatrix2D phenotypes = DoubleFactory2D.dense.make(taxaNumber, traitNumber);
        String[] taxaNames = new String[taxaNumber];
        for (int i2 = 0; i2 < taxaNumber; ++i2) {
            parsedline = br.readLine().split(sep);
            taxaNames[i2] = parsedline[0];
            for (int j = 0; j < traitNumber; ++j) {
                String strval = parsedline[j + 1];
                if (strval.toLowerCase().matches(missing)) {
                    phenotypes.setQuick(i2, j, Double.NaN);
                    continue;
                }
                phenotypes.setQuick(i2, j, Double.parseDouble(strval));
            }
        }
        TaxaList tL = new TaxaListBuilder().addAll(taxaNames).build();
        return new SimplePhenotype(tL, traitList, phenotypes);
    }

    /*
     * WARNING - void declaration
     */
    public static Phenotype readGenericFile(String inputFile) throws IOException {
        BufferedReader br = Utils.getBufferedReader(inputFile);
        String inputline = br.readLine();
        Pattern sep = Pattern.compile("\\s+");
        String[] traitName = null;
        String[] markerName = null;
        ArrayList<String[]> headerList = new ArrayList<String[]>();
        String[] format = null;
        String[] use = null;
        String[] chromosome = null;
        String[] chrpos = null;
        String[] locus = null;
        String[] locuspos = null;
        boolean isNumeric = false;
        boolean isCharacter = false;
        boolean isData = false;
        boolean isFactor = false;
        boolean isCovariate = false;
        int numberOfColumns = 0;
        int numberOfDataLines = 0;
        while (inputline != null) {
            String[] parsedline = sep.split(inputline = inputline.trim());
            if (parsedline.length > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                ++numberOfDataLines;
            } else if (parsedline[0].toUpperCase().equals("<TRAIT>")) {
                traitName = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                numberOfColumns = traitName.length;
            } else if (parsedline[0].toUpperCase().equals("<MARKER>")) {
                markerName = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                numberOfColumns = markerName.length;
            } else if (parsedline[0].toUpperCase().equals("<HEADER")) {
                String[] parsedHeader = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                headerList.add(parsedHeader);
                numberOfColumns = parsedHeader.length - 1;
            } else if (parsedline[0].toUpperCase().equals("<FORMAT>")) {
                format = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                numberOfColumns = format.length;
            } else if (parsedline[0].toUpperCase().equals("<USE>")) {
                use = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                numberOfColumns = use.length;
            } else if (parsedline[0].toUpperCase().equals("<CHROMOSOME>")) {
                chromosome = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                numberOfColumns = chromosome.length;
            } else if (parsedline[0].toUpperCase().equals("<CHROMOSOME_POSITION>")) {
                chrpos = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                numberOfColumns = chrpos.length;
            } else if (parsedline[0].toUpperCase().equals("<LOCUS>")) {
                locus = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                numberOfColumns = locus.length;
            } else if (parsedline[0].toUpperCase().equals("<LOCUS_POSITION>")) {
                locuspos = ReadPhenotypeUtils.processHeader(numberOfColumns, parsedline, inputFile);
                numberOfColumns = locuspos.length;
            } else if (parsedline[0].toUpperCase().equals("<NUMERIC>")) {
                isNumeric = true;
            } else if (parsedline[0].toUpperCase().equals("<CHARACTER>")) {
                isCharacter = true;
            } else if (parsedline[0].toUpperCase().equals("<DATA>")) {
                isData = true;
            } else if (parsedline[0].toUpperCase().equals("<COVARIATE>")) {
                isCovariate = true;
            } else if (parsedline[0].toUpperCase().equals("<FACTOR>")) {
                isFactor = true;
            }
            inputline = br.readLine();
        }
        br.close();
        ArrayList<Trait> traitList = new ArrayList<Trait>(numberOfColumns);
        for (int c = 0; c < numberOfColumns; ++c) {
            boolean discrete;
            String type;
            void name;
            if (traitName == null) {
                if (markerName == null) {
                    throw new IllegalArgumentException("Error in " + inputFile + ": neither trait nor marker names are defined.");
                }
                name = markerName[c];
                type = "marker";
                discrete = isCharacter ? true : (isNumeric ? false : (format == null ? true : !format[c].toUpperCase().startsWith("N")));
            } else {
                name = traitName[c];
                if (isData) {
                    type = "data";
                    discrete = false;
                } else if (isFactor) {
                    type = "factor";
                    discrete = true;
                } else if (isCovariate) {
                    type = "covariate";
                    discrete = false;
                } else if (use == null) {
                    type = "data";
                    discrete = false;
                } else if (use[c].toUpperCase().startsWith("D")) {
                    type = "data";
                    discrete = false;
                } else if (use[c].toUpperCase().startsWith("C")) {
                    type = "covariate";
                    discrete = false;
                } else if (use[c].toUpperCase().startsWith("F")) {
                    type = "factor";
                    discrete = true;
                } else if (use[c].toUpperCase().startsWith("M")) {
                    type = "marker";
                    discrete = isCharacter ? true : (isNumeric ? false : (format == null ? true : !format[c].toUpperCase().startsWith("N")));
                } else {
                    type = "data";
                    discrete = false;
                }
            }
            Trait trait = new Trait((String)name, discrete, type);
            traitList.add(trait);
            for (String[] header : headerList) {
                trait.addFactor(header[0], header[c + 1]);
            }
            if (chromosome != null) {
                trait.setProperty("chromosome", chromosome[c]);
            }
            if (chrpos != null) {
                trait.setProperty("position", Double.parseDouble((String)chrpos[c]));
            }
            if (locus != null) {
                trait.setProperty("locus", locus[c]);
            }
            if (locuspos == null) continue;
            trait.setProperty("locusposition", Integer.parseInt((String)locuspos[c]));
        }
        String[][] textdata = new String[numberOfColumns][numberOfDataLines];
        String[] taxanames = new String[numberOfDataLines];
        br = Utils.getBufferedReader(inputFile);
        inputline = br.readLine();
        int totallines = 0;
        int linecount = 0;
        while (inputline != null) {
            ++totallines;
            String[] parsedline = sep.split(inputline = inputline.trim());
            if (parsedline.length > 1 && !inputline.startsWith("<") && !inputline.startsWith("#")) {
                if (parsedline.length != numberOfColumns + 1) {
                    StringBuilder msg = new StringBuilder("Error in ");
                    msg.append(inputFile);
                    msg.append(" line ").append(totallines);
                    msg.append(": Incorrect number of data values.");
                    throw new IllegalArgumentException(msg.toString());
                }
                taxanames[linecount] = parsedline[0];
                for (int c = 0; c < numberOfColumns; ++c) {
                    textdata[c][linecount] = parsedline[c + 1];
                }
                ++linecount;
            }
            inputline = br.readLine();
        }
        br.close();
        DoubleMatrix2D data = DoubleFactory2D.dense.make(numberOfDataLines, numberOfColumns);
        for (int c = 0; c < numberOfColumns; ++c) {
            if (((Trait)traitList.get((int)c)).isDiscrete) {
                data.viewColumn(c).assign(ReadPhenotypeUtils.doubleFromCharacterTrait((Trait)traitList.get(c), textdata[c]));
                continue;
            }
            for (int r = 0; r < numberOfDataLines; ++r) {
                String textval = textdata[c][r];
                if (textval.equals("-999")) {
                    data.setQuick(r, c, Double.NaN);
                    continue;
                }
                try {
                    data.setQuick(r, c, Double.parseDouble(textdata[c][r]));
                    continue;
                }
                catch (Exception e) {
                    data.setQuick(r, c, Double.NaN);
                }
            }
        }
        TaxaList tL = new TaxaListBuilder().addAll(taxanames).build();
        return new SimplePhenotype(tL, traitList, data);
    }

    private static String[] processHeader(int numberOfColumns, String[] parsedline, String filename) {
        if (parsedline[0].equalsIgnoreCase("<Header")) {
            String headername = parsedline[1].split("[=>\\s]")[1];
            if (!parsedline[1].contains("name=") || headername.length() == 0) {
                StringBuilder msg = new StringBuilder("Error in ");
                msg.append(filename);
                msg.append(": Improperly formatted <Header name=> line.");
                throw new IllegalArgumentException(msg.toString());
            }
            int finalBracketPosition = 0;
            while (!parsedline[finalBracketPosition].contains(">")) {
                ++finalBracketPosition;
            }
            if (numberOfColumns == 0) {
                numberOfColumns = parsedline.length - finalBracketPosition - 1;
            } else if (numberOfColumns != parsedline.length - finalBracketPosition - 1) {
                StringBuilder msg = new StringBuilder("Error in ");
                msg.append(filename);
                msg.append(": The number of ");
                msg.append(parsedline[0]).append(" ").append(parsedline[1]);
                msg.append(" columns does not match the number of columns in previous header rows");
                throw new IllegalArgumentException(msg.toString());
            }
            String[] contents = new String[numberOfColumns + 1];
            contents[0] = headername;
            for (int i = 0; i < numberOfColumns; ++i) {
                contents[i + 1] = parsedline[i + finalBracketPosition + 1];
            }
            return contents;
        }
        if (numberOfColumns == 0) {
            numberOfColumns = parsedline.length - 1;
        } else if (numberOfColumns != parsedline.length - 1) {
            StringBuilder msg = new StringBuilder("Error in ");
            msg.append(filename);
            msg.append(": The number of ");
            msg.append(parsedline[0]);
            msg.append(" columns does not match the number of columns in previous header rows");
            throw new IllegalArgumentException(msg.toString());
        }
        String[] contents = new String[numberOfColumns];
        for (int i = 0; i < numberOfColumns; ++i) {
            contents[i] = parsedline[i + 1];
        }
        return contents;
    }
}

