/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.namedthread;

import ch.systemsx.cisd.base.namedthread.IRunnableNameProvider;
import ch.systemsx.cisd.base.namedthread.NamedFutureTask;
import ch.systemsx.cisd.base.namedthread.NamingThreadFactory;
import ch.systemsx.cisd.base.namedthread.PoolNameThread;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingThreadPoolExecutor
extends ThreadPoolExecutor {
    public static final long DEFAULT_KEEP_ALIVE_TIME_MILLIS = 10000L;

    public NamingThreadPoolExecutor(String poolName) {
        this(poolName, 0);
    }

    public NamingThreadPoolExecutor(String poolName, int workQueueSize) {
        super(1, Integer.MAX_VALUE, 10000L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)(workQueueSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(workQueueSize))), new NamingThreadFactory(poolName));
    }

    public NamingThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new NamingThreadFactory(poolName), handler);
    }

    public NamingThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new NamingThreadFactory(poolName));
    }

    public NamingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamingThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public NamingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, NamingThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public NamingThreadPoolExecutor daemonize() {
        this.getThreadFactory().setCreateDaemonThreads(true);
        return this;
    }

    public NamingThreadPoolExecutor corePoolSize(int corePoolSize) {
        this.setCorePoolSize(corePoolSize);
        return this;
    }

    public NamingThreadPoolExecutor maximumPoolSize(int maximumPoolSize) {
        this.setMaximumPoolSize(maximumPoolSize);
        return this;
    }

    public NamingThreadPoolExecutor keepAliveTime(long keepAliveTimeMillis) {
        this.setKeepAliveTime(keepAliveTimeMillis, TimeUnit.MILLISECONDS);
        return this;
    }

    public NamingThreadPoolExecutor addPoolName(boolean addPoolName) {
        this.getThreadFactory().setAddPoolName(addPoolName);
        return this;
    }

    @Override
    public NamingThreadFactory getThreadFactory() {
        return (NamingThreadFactory)super.getThreadFactory();
    }

    public void setThreadFactory(NamingThreadFactory threadFactory) {
        super.setThreadFactory(threadFactory);
    }

    @Override
    @Deprecated
    public void setThreadFactory(ThreadFactory threadFactory) {
        if (!(threadFactory instanceof NamingThreadFactory)) {
            throw new IllegalArgumentException("thread factory is of type '" + threadFactory.getClass().getCanonicalName() + ", but needs to be of type " + NamingThreadFactory.class.getCanonicalName());
        }
        super.setThreadFactory(threadFactory);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (!(r instanceof IRunnableNameProvider)) {
            return;
        }
        String runnableName = ((IRunnableNameProvider)((Object)r)).getRunnableName();
        if (runnableName == null) {
            return;
        }
        if (r instanceof NamedFutureTask) {
            ((NamedFutureTask)r).setThread(t);
        }
        if (t instanceof PoolNameThread) {
            ((PoolNameThread)t).setRunnableName(runnableName);
        } else {
            t.setName(runnableName);
        }
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (r instanceof NamedFutureTask) {
            ((NamedFutureTask)r).restoreThreadName();
        }
        super.afterExecute(r, t);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        NamedFutureTask<Object> ftask = new NamedFutureTask<Object>(task, null);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        NamedFutureTask<T> ftask = new NamedFutureTask<T>(task, result);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        NamedFutureTask<T> ftask = new NamedFutureTask<T>(task);
        this.execute(ftask);
        return ftask;
    }
}

