/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

abstract class HDF5AbstractStorageFeatures {
    public static final byte NO_DEFLATION_LEVEL = 0;
    public static final byte DEFAULT_DEFLATION_LEVEL = 6;
    public static final byte MAX_DEFLATION_LEVEL = 9;
    static final byte NO_SCALING_FACTOR = -1;
    private final byte deflateLevel;
    private final byte scalingFactor;
    private final HDF5StorageLayout proposedLayoutOrNull;
    private final boolean keepDataSetIfExists;
    private final boolean deleteDataSetIfExists;

    static byte toByte(int i) {
        byte b = (byte)i;
        if (b != i) {
            throw new HDF5JavaException("Value " + i + " cannot be casted to type byte");
        }
        return b;
    }

    HDF5AbstractStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, boolean keepDataSetIfExists, boolean deleteDataSetIfExists, byte deflateLevel, byte scalingFactor) {
        assert (deflateLevel >= 0);
        assert (!keepDataSetIfExists || !deleteDataSetIfExists);
        this.proposedLayoutOrNull = proposedLayoutOrNull;
        this.keepDataSetIfExists = keepDataSetIfExists;
        this.deleteDataSetIfExists = deleteDataSetIfExists;
        this.deflateLevel = deflateLevel;
        this.scalingFactor = scalingFactor;
    }

    abstract boolean isCompatibleWithDataClass(int var1);

    public HDF5StorageLayout tryGetProposedLayout() {
        return this.proposedLayoutOrNull;
    }

    boolean requiresChunking() {
        return this.isDeflating() || this.isScaling() || this.proposedLayoutOrNull == HDF5StorageLayout.CHUNKED;
    }

    boolean allowsCompact() {
        return this.proposedLayoutOrNull == null || this.proposedLayoutOrNull == HDF5StorageLayout.COMPACT;
    }

    public boolean isDeflating() {
        return this.deflateLevel != 0;
    }

    public boolean isScaling() {
        return this.scalingFactor >= 0;
    }

    boolean isKeepDataSetIfExists() {
        return this.keepDataSetIfExists;
    }

    boolean isDeleteDataSetIfExists() {
        return this.deleteDataSetIfExists;
    }

    void checkScalingOK(IHDF5WriterConfigurator.FileFormat fileFormat) throws IllegalStateException {
        if (!fileFormat.isHDF5_1_8_OK()) {
            throw new IllegalStateException("Scaling compression is not allowed in strict HDF5 1.6.x compatibility mode.");
        }
    }

    byte getDeflateLevel() {
        return this.deflateLevel;
    }

    byte getScalingFactor() {
        return this.scalingFactor;
    }
}

