/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HDF5DataTypeVariant {
    TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH(Long.TYPE, Long.class, Date.class),
    TIME_DURATION_MICROSECONDS(HDF5Utils.allTimeDurationTypes),
    TIME_DURATION_MILLISECONDS(HDF5Utils.allTimeDurationTypes),
    TIME_DURATION_SECONDS(HDF5Utils.allTimeDurationTypes),
    TIME_DURATION_MINUTES(HDF5Utils.allTimeDurationTypes),
    TIME_DURATION_HOURS(HDF5Utils.allTimeDurationTypes),
    TIME_DURATION_DAYS(HDF5Utils.allTimeDurationTypes),
    ENUM(HDF5EnumerationValue.class, HDF5EnumerationValueArray.class),
    NONE(new Class[0]);

    private Set<Class<?>> compatibleTypes;

    private HDF5DataTypeVariant(Class<?> ... compatibleTypes) {
        this.compatibleTypes = new HashSet(Arrays.asList(compatibleTypes));
    }

    public static boolean isTypeVariant(HDF5DataTypeVariant typeVariantOrNull) {
        return typeVariantOrNull != null && typeVariantOrNull.isTypeVariant();
    }

    public static boolean isTypeVariant(int typeVariantOrdinal) {
        return typeVariantOrdinal != NONE.ordinal();
    }

    public static HDF5DataTypeVariant maskNull(HDF5DataTypeVariant typeVariantOrNull) {
        return typeVariantOrNull != null ? typeVariantOrNull : NONE;
    }

    public static HDF5DataTypeVariant unmaskNone(HDF5DataTypeVariant typeVariantOrNull) {
        return typeVariantOrNull != NONE ? typeVariantOrNull : null;
    }

    public boolean isTypeVariant() {
        return this != NONE;
    }

    public static boolean isTimeDuration(int typeVariantOrdinal) {
        return typeVariantOrdinal >= TIME_DURATION_MICROSECONDS.ordinal() && typeVariantOrdinal <= TIME_DURATION_DAYS.ordinal();
    }

    public boolean isCompatible(Class<?> type) {
        return this.compatibleTypes.contains(type);
    }

    public static HDF5TimeUnit getTimeUnit(HDF5DataTypeVariant typeVariant) {
        return HDF5TimeUnit.values()[typeVariant.ordinal() - TIME_DURATION_MICROSECONDS.ordinal()];
    }

    public static HDF5TimeUnit getTimeUnit(int typeVariantOrdinal) {
        return HDF5TimeUnit.values()[typeVariantOrdinal - TIME_DURATION_MICROSECONDS.ordinal()];
    }

    public boolean isTimeStamp() {
        return this == TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH;
    }

    public boolean isTimeDuration() {
        return HDF5DataTypeVariant.isTimeDuration(this.ordinal());
    }

    public HDF5TimeUnit tryGetTimeUnit() {
        int ordinal = this.ordinal();
        return HDF5DataTypeVariant.isTimeDuration(ordinal) ? HDF5DataTypeVariant.getTimeUnit(ordinal) : null;
    }
}

