/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5DateTimeReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Date;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HDF5DateTimeReader
implements IHDF5DateTimeReader {
    private final HDF5BaseReader baseReader;

    HDF5DateTimeReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public long getTimeStampAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Long> getAttributeRunnable = new ICallableWithCleanUp<Long>(){

            @Override
            public Long call(ICleanUpRegistry registry) {
                int objectId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openObject(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, attributeName, objectId, registry);
                long[] data = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, HDF5Constants.H5T_NATIVE_INT64, 1);
                return data[0];
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public Date getDateAttribute(String objectPath, String attributeName) {
        return new Date(this.getTimeStampAttribute(objectPath, attributeName));
    }

    @Override
    public long[] getTimeStampArrayAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> getAttributeRunnable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int memoryTypeId;
                int len;
                Object[] arrayDimensions;
                int objectId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openObject(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, attributeName, objectId, registry);
                int attributeTypeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                if (((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                    arrayDimensions = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.getArrayDimensions(attributeTypeId);
                    if (arrayDimensions.length != 1) {
                        throw new HDF5JavaException("Array needs to be of rank 1, but is of rank " + arrayDimensions.length);
                    }
                    len = arrayDimensions[0];
                    memoryTypeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, len, registry);
                } else {
                    arrayDimensions = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
                    memoryTypeId = HDF5Constants.H5T_NATIVE_INT64;
                    len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
                }
                long[] data = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, memoryTypeId, len);
                return data;
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public Date[] getDateArrayAttribute(String objectPath, String attributeName) {
        long[] timeStampArray = this.getTimeStampArrayAttribute(objectPath, attributeName);
        return HDF5DateTimeReader.timeStampsToDates(timeStampArray);
    }

    @Override
    public boolean isTimeStamp(String objectPath, String attributeName) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath, attributeName);
        return typeVariantOrNull != null && typeVariantOrNull.isTimeStamp();
    }

    @Override
    public boolean isTimeStamp(String objectPath) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath);
        return typeVariantOrNull != null && typeVariantOrNull.isTimeStamp();
    }

    @Override
    public HDF5TimeDuration getTimeDurationAttribute(final String objectPath, final String attributeName) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDuration> getAttributeRunnable = new ICallableWithCleanUp<HDF5TimeDuration>(){

            @Override
            public HDF5TimeDuration call(ICleanUpRegistry registry) {
                int objectId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openObject(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                HDF5TimeUnit unit = HDF5DateTimeReader.this.baseReader.checkIsTimeDuration(objectPath, attributeName, objectId, registry);
                long[] data = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, HDF5Constants.H5T_NATIVE_INT64, 1);
                return new HDF5TimeDuration(data[0], unit);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public boolean isTimeDuration(String objectPath, String attributeName) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath, attributeName);
        return typeVariantOrNull != null && typeVariantOrNull.isTimeDuration();
    }

    @Override
    public HDF5TimeUnit tryGetTimeUnit(String objectPath, String attributeName) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath, attributeName);
        return typeVariantOrNull != null ? typeVariantOrNull.tryGetTimeUnit() : null;
    }

    @Override
    public HDF5TimeDurationArray getTimeDurationArrayAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationArray> getAttributeRunnable = new ICallableWithCleanUp<HDF5TimeDurationArray>(){

            @Override
            public HDF5TimeDurationArray call(ICleanUpRegistry registry) {
                int memoryTypeId;
                int len;
                Object[] arrayDimensions;
                int objectId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openObject(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                HDF5TimeUnit storedUnit = HDF5DateTimeReader.this.baseReader.checkIsTimeDuration(objectPath, attributeName, objectId, registry);
                int attributeTypeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                if (((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                    arrayDimensions = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.getArrayDimensions(attributeTypeId);
                    if (arrayDimensions.length != 1) {
                        throw new HDF5JavaException("Array needs to be of rank 1, but is of rank " + arrayDimensions.length);
                    }
                    len = arrayDimensions[0];
                    memoryTypeId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_INT64, len, registry);
                } else {
                    arrayDimensions = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
                    memoryTypeId = HDF5Constants.H5T_NATIVE_INT64;
                    len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
                }
                long[] data = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, memoryTypeId, len);
                return new HDF5TimeDurationArray(data, storedUnit);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public boolean isTimeDuration(String objectPath) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath);
        return typeVariantOrNull != null && typeVariantOrNull.isTimeDuration();
    }

    @Override
    public HDF5TimeUnit tryGetTimeUnit(String objectPath) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath);
        return typeVariantOrNull != null ? typeVariantOrNull.tryGetTimeUnit() : null;
    }

    @Override
    public long readTimeStamp(final String objectPath) throws HDF5JavaException {
        this.baseReader.checkOpen();
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Long> readCallable = new ICallableWithCleanUp<Long>(){

            @Override
            public Long call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                long[] data = new long[1];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, data);
                return data[0];
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readTimeStampArray(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readTimeStampArrayBlock(final String objectPath, final int blockSize, final long blockNumber) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, blockNumber * (long)blockSize, blockSize, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readTimeStampArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<long[]> readCallable = new ICallableWithCleanUp<long[]>(){

            @Override
            public long[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5DateTimeReader.this.baseReader.checkIsTimeStamp(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Iterable<HDF5DataBlock<long[]>> getTimeStampArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<long[]>>(){

            @Override
            public Iterator<HDF5DataBlock<long[]>> iterator() {
                return new Iterator<HDF5DataBlock<long[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<long[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        long[] block = HDF5DateTimeReader.this.readTimeStampArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<long[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Date readDate(String objectPath) throws HDF5JavaException {
        return new Date(this.readTimeStamp(objectPath));
    }

    @Override
    public Date[] readDateArray(String objectPath) throws HDF5JavaException {
        long[] timeStampArray = this.readTimeStampArray(objectPath);
        return HDF5DateTimeReader.timeStampsToDates(timeStampArray);
    }

    private static Date[] timeStampsToDates(long[] timeStampArray) {
        assert (timeStampArray != null);
        Date[] dateArray = new Date[timeStampArray.length];
        int i = 0;
        while (i < dateArray.length) {
            dateArray[i] = new Date(timeStampArray[i]);
            ++i;
        }
        return dateArray;
    }

    @Override
    public HDF5TimeDuration readTimeDuration(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDuration> readCallable = new ICallableWithCleanUp<HDF5TimeDuration>(){

            @Override
            public HDF5TimeDuration call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5DateTimeReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                long[] data = new long[1];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, data);
                return new HDF5TimeDuration(data[0], storedUnit);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long readTimeDuration(String objectPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return timeUnit.convert(this.readTimeDuration(objectPath));
    }

    @Override
    public HDF5TimeDuration readTimeDurationAndUnit(String objectPath) throws HDF5JavaException {
        return this.readTimeDuration(objectPath);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArray(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationArray> readCallable = new ICallableWithCleanUp<HDF5TimeDurationArray>(){

            @Override
            public HDF5TimeDurationArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5DateTimeReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return new HDF5TimeDurationArray(data, storedUnit);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readTimeDurationArray(String objectPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return timeUnit.convert(this.readTimeDurationArray(objectPath));
    }

    @Override
    public HDF5TimeDuration[] readTimeDurationAndUnitArray(String objectPath) throws HDF5JavaException {
        HDF5TimeDurationArray durations = this.readTimeDurationArray(objectPath);
        return HDF5DateTimeReader.convertTimeDurations(durations.timeUnit, durations.timeDurations);
    }

    @Override
    public long[] readTimeDurationArrayBlock(String objectPath, int blockSize, long blockNumber, HDF5TimeUnit timeUnit) {
        return timeUnit.convert(this.readTimeDurationArrayBlock(objectPath, blockSize, blockNumber));
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readTimeDurationArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public HDF5TimeDurationArray readTimeDurationArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationArray> readCallable = new ICallableWithCleanUp<HDF5TimeDurationArray>(){

            @Override
            public HDF5TimeDurationArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.openDataSet(((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5DateTimeReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5DateTimeReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5DateTimeReader)HDF5DateTimeReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return new HDF5TimeDurationArray(data, storedUnit);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public long[] readTimeDurationArrayBlockWithOffset(String objectPath, int blockSize, long offset, HDF5TimeUnit timeUnit) {
        return timeUnit.convert(this.readTimeDurationArrayBlockWithOffset(objectPath, blockSize, offset));
    }

    @Override
    public HDF5TimeDuration[] readTimeDurationAndUnitArrayBlock(String objectPath, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.readTimeDurationAndUnitArrayBlockWithOffset(objectPath, blockSize, (long)blockSize * blockNumber);
    }

    @Override
    public HDF5TimeDuration[] readTimeDurationAndUnitArrayBlockWithOffset(String objectPath, int blockSize, long offset) throws HDF5JavaException {
        HDF5TimeDurationArray durations = this.readTimeDurationArrayBlockWithOffset(objectPath, blockSize, offset);
        return HDF5DateTimeReader.convertTimeDurations(durations.timeUnit, durations.timeDurations);
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5TimeDuration[]>> getTimeDurationAndUnitArrayNaturalBlocks(final String objectPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5DataBlock<HDF5TimeDuration[]>>(){

            @Override
            public Iterator<HDF5DataBlock<HDF5TimeDuration[]>> iterator() {
                return new Iterator<HDF5DataBlock<HDF5TimeDuration[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<HDF5TimeDuration[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        HDF5TimeDuration[] block = HDF5DateTimeReader.this.readTimeDurationAndUnitArrayBlockWithOffset(objectPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<HDF5TimeDuration[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5TimeDurationArray>> getTimeDurationArrayNaturalBlocks(final String objectPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5DataBlock<HDF5TimeDurationArray>>(){

            @Override
            public Iterator<HDF5DataBlock<HDF5TimeDurationArray>> iterator() {
                return new Iterator<HDF5DataBlock<HDF5TimeDurationArray>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<HDF5TimeDurationArray> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        HDF5TimeDurationArray block = HDF5DateTimeReader.this.readTimeDurationArrayBlockWithOffset(objectPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<HDF5TimeDurationArray>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5DataBlock<long[]>> getTimeDurationArrayNaturalBlocks(final String objectPath, final HDF5TimeUnit timeUnit) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5DataBlock<long[]>>(){

            @Override
            public Iterator<HDF5DataBlock<long[]>> iterator() {
                return new Iterator<HDF5DataBlock<long[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<long[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        long[] block = HDF5DateTimeReader.this.readTimeDurationArrayBlockWithOffset(objectPath, this.index.getBlockSize(), offset, timeUnit);
                        return new HDF5DataBlock<long[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static void convertTimeDurations(HDF5TimeUnit toTimeUnit, HDF5TimeUnit fromTimeUnit, long[] data) {
        if (toTimeUnit != fromTimeUnit) {
            int i = 0;
            while (i < data.length) {
                data[i] = toTimeUnit.convert(data[i], fromTimeUnit);
                ++i;
            }
        }
    }

    static HDF5TimeDuration[] convertTimeDurations(HDF5TimeUnit timeUnit, long[] data) {
        HDF5TimeDuration[] durations = new HDF5TimeDuration[data.length];
        int i = 0;
        while (i < data.length) {
            durations[i] = new HDF5TimeDuration(data[i], timeUnit);
            ++i;
        }
        return durations;
    }
}

