/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5StringReader;
import ch.systemsx.cisd.hdf5.StringUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDF5StringReader
implements IHDF5StringReader {
    private final HDF5BaseReader baseReader;

    HDF5StringReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public String getStringAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> readRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int objectId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openObject(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                return HDF5StringReader.this.baseReader.getStringAttribute(objectId, objectPath, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public String[] getStringArrayAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> readRunnable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                int objectId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openObject(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                return HDF5StringReader.this.baseReader.getStringArrayAttribute(objectId, objectPath, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public MDArray<String> getStringMDArrayAttribute(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> readRunnable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                int objectId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openObject(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                return HDF5StringReader.this.baseReader.getStringMDArrayAttribute(objectId, objectPath, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public String readString(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> writeRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                boolean isString;
                int dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                if (!isString) {
                    throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                }
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    String[] data = new String[1];
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, data);
                    return data[0];
                }
                int size = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getDataTypeSize(dataTypeId);
                byte[] data = new byte[size];
                ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetNonNumeric(dataSetId, dataTypeId, data);
                return StringUtils.fromBytes0Term(data, ((HDF5StringReader)HDF5StringReader.this).baseReader.encoding);
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public String[] readStringArray(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> writeRunnable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                long[] dimensions = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getDataDimensions(dataSetId, registry);
                String[] data = new String[HDF5Utils.getOneDimensionalArraySize(dimensions)];
                int dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, data);
                } else {
                    boolean isString;
                    boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                    if (!isString) {
                        throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                    }
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetString(dataSetId, dataTypeId, data);
                }
                return data;
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public String[] readStringArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readStringArrayBlockWithOffset(objectPath, blockSize, (long)blockSize * blockNumber);
    }

    @Override
    public String[] readStringArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> readCallable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5StringReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                String[] data = new String[spaceParams.blockSize];
                int dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                } else {
                    boolean isString;
                    boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                    if (!isString) {
                        throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                    }
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetString(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                }
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public MDArray<String> readStringMDArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> readCallable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5StringReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                String[] dataBlock = new String[spaceParams.blockSize];
                int dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                } else {
                    boolean isString;
                    boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                    if (!isString) {
                        throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                    }
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetString(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                }
                return new MDArray<String>(dataBlock, spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public MDArray<String> readStringMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> readCallable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.openDataSet(((HDF5StringReader)HDF5StringReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5StringReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                String[] dataBlock = new String[spaceParams.blockSize];
                int dataTypeId = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getNativeDataTypeForDataSet(dataSetId, registry);
                if (((HDF5StringReader)HDF5StringReader.this).baseReader.h5.isVariableLengthString(dataTypeId)) {
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetVL(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                } else {
                    boolean isString;
                    boolean bl = isString = ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_STRING;
                    if (!isString) {
                        throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be a String.");
                    }
                    ((HDF5StringReader)HDF5StringReader.this).baseReader.h5.readDataSetString(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                }
                return new MDArray<String>((T[])dataBlock, blockDimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public MDArray<String> readStringMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readStringMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getStringArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<String[]>>(){

            @Override
            public Iterator<HDF5DataBlock<String[]>> iterator() {
                return new Iterator<HDF5DataBlock<String[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<String[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        String[] block = HDF5StringReader.this.readStringArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<String[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getStringMDArrayNaturalBlocks(final String objectPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5MDDataBlock<MDArray<String>>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDArray<String>>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDArray<String>>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDArray<String>> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDArray<String> data = HDF5StringReader.this.readStringMDArrayBlockWithOffset(objectPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDArray<String>>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

