/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HDF5TimeUnit {
    MICROSECONDS,
    MILLISECONDS,
    SECONDS,
    MINUTES,
    HOURS,
    DAYS;

    private static final HDF5DataTypeVariant[] typeVariants;
    private static final long[][] multipliers;
    private static final double[][] divisors;
    private static final long[][] overflows;

    static {
        typeVariants = new HDF5DataTypeVariant[]{HDF5DataTypeVariant.TIME_DURATION_MICROSECONDS, HDF5DataTypeVariant.TIME_DURATION_MILLISECONDS, HDF5DataTypeVariant.TIME_DURATION_SECONDS, HDF5DataTypeVariant.TIME_DURATION_MINUTES, HDF5DataTypeVariant.TIME_DURATION_HOURS, HDF5DataTypeVariant.TIME_DURATION_DAYS};
        multipliers = new long[][]{{1L}, {1L, 1000L}, {1L, 1000L, 1000000L}, {1L, 60L, 60000L, 60000000L}, {1L, 60L, 3600L, 3600000L, 3600000000L}, {1L, 24L, 1440L, 86400L, 86400000L, 86400000000L}};
        divisors = new double[][]{{1.0, 1000.0, 1000000.0, 6.0E7, 3.6E9, 8.64E10}, {1.0, 1000.0, 60000.0, 3600000.0, 8.64E7}, {1.0, 60.0, 3600.0, 86400.0}, {1.0, 60.0, 1440.0}, {1.0, 24.0}, {1.0}};
        overflows = new long[][]{{-1L}, {-1L, 9223372036854775L}, {-1L, 9223372036854775L, 9223372036854L}, {-1L, 0x222222222222222L, 153722867280912L, 153722867280L}, {-1L, 0x222222222222222L, 2562047788015215L, 2562047788015L, 2562047788L}, {-1L, 0x555555555555555L, 0x16C16C16C16C16L, 106751991167300L, 106751991167L, 106751991L}};
    }

    private static long doConvert(int ordinal, int delta, long duration) {
        if (delta == 0) {
            return duration;
        }
        if (delta < 0) {
            return Math.round((double)duration / divisors[ordinal][-delta]);
        }
        long overflow = overflows[ordinal][delta];
        if (duration > overflow) {
            return Long.MAX_VALUE;
        }
        if (duration < -overflow) {
            return Long.MIN_VALUE;
        }
        return duration * multipliers[ordinal][delta];
    }

    public HDF5DataTypeVariant getTypeVariant() {
        return typeVariants[this.ordinal()];
    }

    public long convert(long duration, HDF5TimeUnit unit) {
        int currentUnitOrdinal = unit.ordinal();
        return HDF5TimeUnit.doConvert(currentUnitOrdinal, currentUnitOrdinal - this.ordinal(), duration);
    }

    public long[] convert(HDF5TimeDurationArray durations) {
        if (this != durations.timeUnit) {
            long[] convertedData = new long[durations.timeDurations.length];
            int i = 0;
            while (i < durations.timeDurations.length) {
                convertedData[i] = this.convert(durations.timeDurations[i], durations.timeUnit);
                ++i;
            }
            return convertedData;
        }
        return durations.timeDurations;
    }

    public long[] convert(long[] durations, HDF5TimeUnit unit) {
        if (this != unit) {
            long[] convertedData = new long[durations.length];
            int i = 0;
            while (i < durations.length) {
                convertedData[i] = this.convert(durations[i], unit);
                ++i;
            }
            return convertedData;
        }
        return durations;
    }

    public long convert(HDF5TimeDuration duration) {
        return this.convert(duration.getValue(), duration.getUnit());
    }

    public long[] convert(HDF5TimeDuration[] durations) {
        long[] convertedData = new long[durations.length];
        int i = 0;
        while (i < durations.length) {
            convertedData[i] = this.convert(durations[i]);
            ++i;
        }
        return convertedData;
    }
}

