/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.phylogeny.data;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.SortedMap;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.util.ForesterUtil;

public final class RenderableDomainArchitecture
extends DomainArchitecture
implements RenderablePhylogenyData {
    private static Map<String, Color> Domain_colors;
    private static final int BRIGHTEN_COLOR_BY = 200;
    private static final int E_VALUE_THRESHOLD_EXP_DEFAULT = 0;
    private static int _Next_default_domain_color;
    private static final String[] DEFAULT_DOMAINS_COLORS;
    private int _e_value_threshold_exp = 0;
    private boolean _display_domain_names = true;
    private double _rendering_factor_width = 1.0;
    private double _rendering_height = 0.0;
    private final DomainArchitecture _domain_structure;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();

    static {
        _Next_default_domain_color = 0;
        DEFAULT_DOMAINS_COLORS = new String[]{"0xFF0000", "0x0000FF", "0xAAAA00", "0xFF00FF", "0x00FFFF", "0x800000", "0x000080", "0x808000", "0x800080", "0x008080", "0xE1B694"};
    }

    public RenderableDomainArchitecture(DomainArchitecture domain_structure) {
        this._domain_structure = domain_structure;
    }

    @Override
    public StringBuffer asSimpleText() {
        return this._domain_structure.asSimpleText();
    }

    @Override
    public StringBuffer asText() {
        return this._domain_structure.asText();
    }

    @Override
    public PhylogenyData copy() {
        return this._domain_structure.copy();
    }

    private final void drawDomain(double x, double y, double width, double heigth, String name, Graphics2D g, boolean to_pdf) {
        double h2 = heigth / 2.0;
        Color color_one = this.getColorOne(name);
        Color color_two = this.getColorTwo(color_one);
        double step = 1.0;
        if (to_pdf) {
            step = 0.1;
        }
        double i = 0.0;
        while (i < heigth) {
            g.setColor(ForesterUtil.calcColor(i >= h2 ? heigth - i : i, 0.0, h2, color_one, color_two));
            this._rectangle.setFrame(x, i + y, width, step);
            g.fill(this._rectangle);
            i += step;
        }
    }

    private Color getColorOne(String name) {
        Color c = Constants.DOMAIN_STRUCTURE_COLOR_1;
        if (Domain_colors != null && (c = Domain_colors.get(name)) == null) {
            if (_Next_default_domain_color < DEFAULT_DOMAINS_COLORS.length) {
                c = Color.decode(DEFAULT_DOMAINS_COLORS[_Next_default_domain_color++]);
                Domain_colors.put(name, c);
            } else {
                c = Constants.DOMAIN_STRUCTURE_COLOR_1;
            }
        }
        return c;
    }

    private Color getColorTwo(Color color_one) {
        int red = color_one.getRed() + 200;
        int green = color_one.getGreen() + 200;
        int blue = color_one.getBlue() + 200;
        return new Color(red > 255 ? 255 : red, green > 255 ? 255 : green, blue > 255 ? 255 : blue);
    }

    @Override
    public ProteinDomain getDomain(int i) {
        return this._domain_structure.getDomain(i);
    }

    @Override
    public SortedMap<Double, ProteinDomain> getDomains() {
        return this._domain_structure.getDomains();
    }

    @Override
    public int getNumberOfDomains() {
        return this._domain_structure.getNumberOfDomains();
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this._domain_structure.getTotalLength(), ForesterUtil.roundToInt(this._rendering_height));
    }

    @Override
    public Object getParameter() {
        return new Integer(this._e_value_threshold_exp);
    }

    public double getRenderingFactorWidth() {
        return this._rendering_factor_width;
    }

    @Override
    public Dimension getRenderingSize() {
        return new Dimension(ForesterUtil.roundToInt((double)this._domain_structure.getTotalLength() * this._rendering_factor_width), ForesterUtil.roundToInt(this._rendering_height));
    }

    @Override
    public int getTotalLength() {
        return this._domain_structure.getTotalLength();
    }

    public boolean isDisplayDomainNames() {
        return this._display_domain_names;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        return this._domain_structure.isEqual(data);
    }

    @Override
    public void render(double x1, double y1, Graphics2D g, TreePanel tree_panel, boolean to_pdf) {
        double f = this.getRenderingFactorWidth();
        double y = y1 + this._rendering_height / 2.0;
        double start = x1 + 20.0;
        g.setColor(Constants.DOMAIN_STRUCTURE_FONT_COLOR);
        this._rectangle.setFrame(start, y - 0.5, (double)this._domain_structure.getTotalLength() * f, 1.0);
        g.fill(this._rectangle);
        int i = 0;
        while (i < this._domain_structure.getDomains().size()) {
            ProteinDomain d = this._domain_structure.getDomain(i);
            if (d.getConfidence() <= Math.pow(10.0, this._e_value_threshold_exp)) {
                double xa = start + (double)d.getFrom() * f;
                double xb = xa + (double)d.getLength() * f;
                if (this.isDisplayDomainNames()) {
                    g.setFont(tree_panel.getMainPanel().getTreeFontSet().getSmallFont());
                    g.setColor(Constants.DOMAIN_STRUCTURE_FONT_COLOR);
                    PhylogenyDataUtil.drawString(d.getName(), xa, y1 + (double)tree_panel.getMainPanel().getTreeFontSet()._fm_small.getAscent() + 6.0, g);
                }
                this.drawDomain(xa, y1, xb - xa, this._rendering_height, d.getName(), g, to_pdf);
            }
            ++i;
        }
    }

    public void setDisplayDomainNames(boolean display_domain_names) {
        this._display_domain_names = display_domain_names;
    }

    @Override
    public void setParameter(double e_value_threshold_exp) {
        this._e_value_threshold_exp = (int)e_value_threshold_exp;
    }

    public void setRenderingFactorWidth(double rendering_factor_width) {
        this._rendering_factor_width = rendering_factor_width;
    }

    @Override
    public void setRenderingHeight(double rendering_height) {
        this._rendering_height = rendering_height;
    }

    @Override
    public StringBuffer toNHX() {
        return this._domain_structure.toNHX();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        this._domain_structure.toPhyloXML(writer, level, indentation);
    }

    public static void setColorMap(Map<String, Color> domain_colors) {
        Domain_colors = domain_colors;
    }
}

