/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import org.forester.go.GoSubset;

public class BasicGoSubset
implements GoSubset {
    final GoSubset.Type _type;

    public BasicGoSubset(String s) {
        String my_s = s.trim().toLowerCase();
        if (my_s.equals("goslim_generic")) {
            this._type = GoSubset.Type.GOSLIM_GENERIC;
        } else if (my_s.equals("goslim_goa")) {
            this._type = GoSubset.Type.GOSLIM_GOA;
        } else if (my_s.equals("goslim_pir")) {
            this._type = GoSubset.Type.GOSLIM_PIR;
        } else if (my_s.equals("gosubset_prok")) {
            this._type = GoSubset.Type.GOSUBSET_PROK;
        } else if (my_s.equals("goslim_candida")) {
            this._type = GoSubset.Type.GOSLIM_CANDIDA;
        } else if (my_s.equals("goslim_plant")) {
            this._type = GoSubset.Type.GOSLIM_PLANT;
        } else if (my_s.equals("goslim_yeast")) {
            this._type = GoSubset.Type.GOSLIM_YEAST;
        } else if (my_s.equals("goslim_pombe")) {
            this._type = GoSubset.Type.GOSLIM_POMBE;
        } else {
            throw new IllegalArgumentException("unknown GO subset type: " + my_s);
        }
    }

    public BasicGoSubset(GoSubset.Type type) {
        this._type = type;
    }

    @Override
    public int compareTo(GoSubset sub) {
        return this.getType().compareTo(sub.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check go subset equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go subset equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getType() == ((GoSubset)o).getType();
    }

    @Override
    public GoSubset.Type getType() {
        return this._type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.getType()) {
            case GOSLIM_CANDIDA: {
                sb.append("goslim_candida");
                break;
            }
            case GOSLIM_GENERIC: {
                sb.append("goslim_generic");
                break;
            }
            case GOSLIM_GOA: {
                sb.append("goslim_goa");
                break;
            }
            case GOSLIM_PIR: {
                sb.append("goslim_pir");
                break;
            }
            case GOSLIM_PLANT: {
                sb.append("goslim_plant");
                break;
            }
            case GOSLIM_YEAST: {
                sb.append("goslim_yeast");
                break;
            }
            case GOSUBSET_PROK: {
                sb.append("gosubset_prok");
                break;
            }
            case GOSLIM_POMBE: {
                sb.append("goslim_pombe");
                break;
            }
            default: {
                new AssertionError((Object)("unknown type: " + (Object)((Object)this.getType())));
            }
        }
        return sb.toString();
    }
}

