/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoId
implements Comparable<GoId> {
    private static final int SIZE = 10;
    private static final String GO_PREFIX = "GO:";
    private static final String GO_FORMAT = "GO:\\d{7}";
    private static final Pattern GO_PATTERN = Pattern.compile("GO:\\d{7}");
    private final String _id;

    public GoId(String id) {
        if (id.length() != 10) {
            throw new IllegalArgumentException("unexpected format for GO id: " + id);
        }
        Matcher m = GO_PATTERN.matcher(id);
        if (!m.matches()) {
            throw new IllegalArgumentException("unexpected format for GO id: " + id);
        }
        this._id = id.substring(3);
    }

    @Override
    public int compareTo(GoId id) {
        return this.getId().compareTo(id.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check go id equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go id equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getId().equals(((GoId)o).getId());
    }

    public String getId() {
        return GO_PREFIX + this._id;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }
}

