/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.ProteinDomain;

public class ProteinDomainParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    static {
        try {
            _instance = new ProteinDomainParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private ProteinDomainParser() {
    }

    @Override
    public ProteinDomain parse(XmlElement element) throws PhylogenyParserException {
        String name = "";
        int f = -1;
        int t = -1;
        double conf = 0.0;
        String id = "";
        try {
            f = Integer.parseInt(element.getAttribute("from"));
            t = Integer.parseInt(element.getAttribute("to"));
            conf = Double.parseDouble(element.getAttribute("confidence"));
            if (element.isHasAttribute("id")) {
                id = element.getAttribute("id");
            }
        }
        catch (Exception e) {
            throw new PhylogenyParserException("failed to parse element [" + element + "]: " + e.getMessage());
        }
        name = element.getValueAsString();
        if (f == -1 || t == -1 || conf == 0.0) {
            throw new PhylogenyParserException("from, to, or confidence attribute not set in: " + element);
        }
        return new ProteinDomain(name, f, t, id, conf);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

