/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Date
implements PhylogenyData {
    private String _desc;
    private BigDecimal _value;
    private BigDecimal _min;
    private BigDecimal _max;
    private String _unit;

    public Date() {
        this._desc = "";
        this._value = null;
        this._min = null;
        this._max = null;
        this._unit = "";
    }

    public Date(String desc) {
        if (desc == null) {
            throw new IllegalArgumentException("illegaly empty of null fields in constructor");
        }
        this._desc = desc;
        this._value = null;
        this._min = null;
        this._max = null;
        this._unit = "";
    }

    public Date(String desc, BigDecimal value, BigDecimal min, BigDecimal max, String unit) {
        if (desc == null || unit == null) {
            throw new IllegalArgumentException("illegaly empty of null fields in constructor");
        }
        this._desc = desc;
        this._value = value;
        this._min = min;
        this._max = max;
        this._unit = unit;
    }

    @Override
    public StringBuffer asSimpleText() {
        if (this.getValue() != null) {
            return new StringBuffer(String.valueOf(this.getDesc()) + " [" + this.getValue().toPlainString() + " " + this.getUnit() + "]");
        }
        return new StringBuffer(this.getDesc());
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        return new Date(new String(this.getDesc()), this.getValue() == null ? null : new BigDecimal(this.getValue().toPlainString()), this.getMin() == null ? null : new BigDecimal(this.getMin().toPlainString()), this.getMax() == null ? null : new BigDecimal(this.getMax().toPlainString()), new String(this.getUnit()));
    }

    public String getDesc() {
        return this._desc;
    }

    public BigDecimal getMax() {
        return this._max;
    }

    public BigDecimal getMin() {
        return this._min;
    }

    public String getUnit() {
        return this._unit;
    }

    public BigDecimal getValue() {
        return this._value;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    public void setDesc(String desc) {
        this._desc = desc;
    }

    public void setMax(BigDecimal max) {
        this._max = max;
    }

    public void setMin(BigDecimal min) {
        this._min = min;
    }

    public void setUnit(String unit) {
        this._unit = unit;
    }

    public void setValue(BigDecimal value) {
        this._value = value;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "date", "unit", this.getUnit());
        if (!ForesterUtil.isEmpty(this.getDesc())) {
            PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), indentation);
        }
        if (this.getValue() != null) {
            PhylogenyDataUtil.appendElement(writer, "value", this.getValue().toPlainString(), indentation);
        }
        if (this.getMin() != null) {
            PhylogenyDataUtil.appendElement(writer, "minimum", this.getMin().toPlainString(), indentation);
        }
        if (this.getMax() != null) {
            PhylogenyDataUtil.appendElement(writer, "maximum", this.getMax().toPlainString(), indentation);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "date");
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

