/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenyinference;

import java.io.IOException;
import java.io.Writer;

public interface CharacterStateMatrix<S> {
    public boolean containsCharacter(String var1);

    public boolean containsIdentifier(String var1);

    public CharacterStateMatrix<S> copy();

    public String getCharacter(int var1);

    public int getCharacterIndex(String var1);

    public String getIdentifier(int var1);

    public int getIdentifierIndex(String var1);

    public int getNumberOfCharacters();

    public int getNumberOfIdentifiers();

    public S getState(int var1, int var2);

    public S getState(String var1, int var2);

    public S getState(String var1, String var2);

    public boolean isEmpty();

    public CharacterStateMatrix<S> pivot();

    public void setCharacter(int var1, String var2);

    public void setIdentifier(int var1, String var2);

    public void setState(int var1, int var2, S var3);

    public void setState(String var1, int var2, S var3);

    public void setState(String var1, String var2, S var3);

    public void toWriter(Writer var1) throws IOException;

    public void toWriter(Writer var1, Format var2) throws IOException;

    public static enum BinaryStates {
        ABSENT,
        UNKNOWN,
        PRESENT;


        public char toChar() {
            switch (this) {
                case PRESENT: {
                    return '1';
                }
                case ABSENT: {
                    return '0';
                }
                case UNKNOWN: {
                    return '?';
                }
            }
            throw new IllegalStateException("unknown state: " + (Object)((Object)this));
        }

        public String toString() {
            switch (this) {
                case PRESENT: {
                    return "1";
                }
                case ABSENT: {
                    return "0";
                }
                case UNKNOWN: {
                    return "?";
                }
            }
            throw new IllegalStateException("unknown state: " + (Object)((Object)this));
        }
    }

    public static enum Format {
        PHYLIP,
        FORESTER,
        NEXUS_BINARY;

    }

    public static enum GainLossStates {
        GAIN,
        LOSS,
        UNCHANGED_PRESENT,
        UNCHANGED_ABSENT,
        UNKNOWN;


        public String toString() {
            switch (this) {
                case GAIN: {
                    return "+";
                }
                case LOSS: {
                    return "-";
                }
                case UNCHANGED_PRESENT: {
                    return "X";
                }
                case UNCHANGED_ABSENT: {
                    return ".";
                }
                case UNKNOWN: {
                    return "?";
                }
            }
            throw new AssertionError((Object)("unknown state: " + (Object)((Object)this)));
        }
    }

    public static enum NucleotideStates {
        A,
        C,
        G,
        T,
        UNKNOWN;

    }
}

